<?php
/**
* @version  1.0
* @package  logistik
* @author   Logistik <support@angfuzsoft.com>
*
* Websites: http://www.angfuzsoft.com
*
*/

/**************************************
* Creating Social Media Widget
***************************************/

class logistik_social_media_widget extends WP_Widget {

        function __construct() {

            parent::__construct(
                // Base ID of your widget
                'logistik_social_media_widget',

                // Widget name will appear in UI
                esc_html__( 'Logistik :: Social Media Widget', 'logistik' ),

                // Widget description
                array(
                    'customize_selective_refresh'   => true,
                    'description'                   => esc_html__( 'Social Media Widget', 'logistik' ),
                    'classname'                     => 'no-class',
                )
            );

        }

        // This is where the action happens
        public function widget( $args, $instance ) {
        	
        	if ( isset( $instance[ 'title' ] ) ) {
                $title = $instance[ 'title' ];
            }else {
                $title = '';
            }


            //before and after widget arguments are defined by themes
            echo $args['before_widget'];
            	 if( !empty( $title ) ){
               		echo '<h3 class="widget_title">'.esc_html($title).'</h3>';
               	}
                    echo '<div class="as-social widget-social">';
                        logistik_social_icon();
                    echo '</div>';
                    
            echo $args['after_widget'];
        }

        // Widget Backend
        public function form( $instance ) {

            if ( isset( $instance[ 'title' ] ) ) {
                $title = $instance[ 'title' ];
            }else {
                $title = '';
            }

           
            $social_icon = isset( $instance['social_icon'] ) ? (bool) $instance['social_icon'] : false;
            
            // Widget admin form
            ?>
            
            <p>
                <label for="<?php echo $this->get_field_id( 'title' ); ?>">
                    <?php
                        _e( 'Social:' ,'logistik');
                    ?>
                </label>
                 <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" placeholder="<?php echo esc_attr__('Title', 'logistik'); ?>" value="<?php echo esc_attr( $title ); ?>" />
            </p>

            <?php
        }


         // Updating widget replacing old instances with new
         public function update( $new_instance, $old_instance ) {

            $instance = array();

            $instance['title']           = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
            return $instance;
        }
    } // Class logistik_social_media_widget ends here


    // Register and load the widget
    function logistik_social_media_load_widget() {
        register_widget( 'logistik_social_media_widget' );
    }
    add_action( 'widgets_init', 'logistik_social_media_load_widget' );