<?php
    /**
     * Class For Builder
     */
    class LogistikBuilder{

        function __construct(){
            // register admin menus
        	add_action( 'admin_menu', [$this, 'register_settings_menus'] );

            // Custom Footer Builder With Post Type
			add_action( 'init',[ $this,'post_type' ],0 );

 		    add_action( 'elementor/frontend/after_enqueue_scripts', [ $this,'widget_scripts'] );

			add_filter( 'single_template', [ $this, 'load_canvas_template' ] );

            add_action( 'elementor/element/wp-page/document_settings/after_section_end', [ $this,'logistik_add_elementor_page_settings_controls' ],10,2 );

		}

		public function widget_scripts( ) {
			wp_enqueue_script( 'logistik-core',LOGISTIK_PLUGDIRURI.'assets/js/logistik-core.js',array( 'jquery' ),'1.0',true );
		}


        public function logistik_add_elementor_page_settings_controls( \Elementor\Core\DocumentTypes\Page $page ){

			$page->start_controls_section(
                'logistik_header_option',
                [
                    'label'     => __( 'Header Option', 'logistik' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );


            $page->add_control(
                'logistik_header_style',
                [
                    'label'     => __( 'Header Option', 'logistik' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'logistik' ),
    					'header_builder'       => __( 'Header Builder', 'logistik' ),
    				],
                    'default'   => 'prebuilt',
                ]
			);

            $page->add_control(
                'logistik_header_builder_option',
                [
                    'label'     => __( 'Header Name', 'logistik' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->logistik_header_choose_option(),
                    'condition' => [ 'logistik_header_style' => 'header_builder'],
                    'default'	=> ''
                ]
            );

            $page->end_controls_section();

            $page->start_controls_section(
                'logistik_footer_option',
                [
                    'label'     => __( 'Footer Option', 'logistik' ),
                    'tab'       => \Elementor\Controls_Manager::TAB_SETTINGS,
                ]
            );
            $page->add_control(
    			'logistik_footer_choice',
    			[
    				'label'         => __( 'Enable Footer?', 'logistik' ),
    				'type'          => \Elementor\Controls_Manager::SWITCHER,
    				'label_on'      => __( 'Yes', 'logistik' ),
    				'label_off'     => __( 'No', 'logistik' ),
    				'return_value'  => 'yes',
    				'default'       => 'yes',
    			]
    		);
            $page->add_control(
                'logistik_footer_style',
                [
                    'label'     => __( 'Footer Style', 'logistik' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => [
    					'prebuilt'             => __( 'Pre Built', 'logistik' ),
    					'footer_builder'       => __( 'Footer Builder', 'logistik' ),
    				],
                    'default'   => 'prebuilt',
                    'condition' => [ 'logistik_footer_choice' => 'yes' ],
                ]
            );
            $page->add_control(
                'logistik_footer_builder_option',
                [
                    'label'     => __( 'Footer Name', 'logistik' ),
                    'type'      => \Elementor\Controls_Manager::SELECT,
                    'options'   => $this->logistik_footer_build_choose_option(),
                    'condition' => [ 'logistik_footer_style' => 'footer_builder','logistik_footer_choice' => 'yes' ],
                    'default'	=> ''
                ]
            );

			$page->end_controls_section();

        }

		public function register_settings_menus(){
			add_menu_page(
				esc_html__( 'Logistik Builder', 'logistik' ),
            	esc_html__( 'Logistik Builder', 'logistik' ),
				'manage_options',
				'logistik',
				[$this,'register_settings_contents__settings'],
				'dashicons-admin-site',
				2
			);

			add_submenu_page('logistik', esc_html__('Footer Builder', 'logistik'), esc_html__('Footer Builder', 'logistik'), 'manage_options', 'edit.php?post_type=logistik_footerbuild');
			add_submenu_page('logistik', esc_html__('Header Builder', 'logistik'), esc_html__('Header Builder', 'logistik'), 'manage_options', 'edit.php?post_type=logistik_header');
			add_submenu_page('logistik', esc_html__('Tab Builder', 'logistik'), esc_html__('Tab Builder', 'logistik'), 'manage_options', 'edit.php?post_type=logistik_tab_builder');
		}

		// Callback Function
		public function register_settings_contents__settings(){
            echo '<h2>';
			    echo esc_html__( 'Welcome To Header And Footer Builder Of This Theme','logistik' );
            echo '</h2>';
		}

		public function post_type() {

			$labels = array(
				'name'               => __( 'Footer', 'logistik' ),
				'singular_name'      => __( 'Footer', 'logistik' ),
				'menu_name'          => __( 'Logistik Footer Builder', 'logistik' ),
				'name_admin_bar'     => __( 'Footer', 'logistik' ),
				'add_new'            => __( 'Add New', 'logistik' ),
				'add_new_item'       => __( 'Add New Footer', 'logistik' ),
				'new_item'           => __( 'New Footer', 'logistik' ),
				'edit_item'          => __( 'Edit Footer', 'logistik' ),
				'view_item'          => __( 'View Footer', 'logistik' ),
				'all_items'          => __( 'All Footer', 'logistik' ),
				'search_items'       => __( 'Search Footer', 'logistik' ),
				'parent_item_colon'  => __( 'Parent Footer:', 'logistik' ),
				'not_found'          => __( 'No Footer found.', 'logistik' ),
				'not_found_in_trash' => __( 'No Footer found in Trash.', 'logistik' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'logistik_footerbuild', $args );

			$labels = array(
				'name'               => __( 'Header', 'logistik' ),
				'singular_name'      => __( 'Header', 'logistik' ),
				'menu_name'          => __( 'Logistik Header Builder', 'logistik' ),
				'name_admin_bar'     => __( 'Header', 'logistik' ),
				'add_new'            => __( 'Add New', 'logistik' ),
				'add_new_item'       => __( 'Add New Header', 'logistik' ),
				'new_item'           => __( 'New Header', 'logistik' ),
				'edit_item'          => __( 'Edit Header', 'logistik' ),
				'view_item'          => __( 'View Header', 'logistik' ),
				'all_items'          => __( 'All Header', 'logistik' ),
				'search_items'       => __( 'Search Header', 'logistik' ),
				'parent_item_colon'  => __( 'Parent Header:', 'logistik' ),
				'not_found'          => __( 'No Header found.', 'logistik' ),
				'not_found_in_trash' => __( 'No Header found in Trash.', 'logistik' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'logistik_header', $args );

			$labels = array(
				'name'               => __( 'Tab Builder', 'logistik' ),
				'singular_name'      => __( 'Tab Builder', 'logistik' ),
				'menu_name'          => __( 'Gesund Tab Builder', 'logistik' ),
				'name_admin_bar'     => __( 'Tab Builder', 'logistik' ),
				'add_new'            => __( 'Add New', 'logistik' ),
				'add_new_item'       => __( 'Add New Tab Builder', 'logistik' ),
				'new_item'           => __( 'New Tab Builder', 'logistik' ),
				'edit_item'          => __( 'Edit Tab Builder', 'logistik' ),
				'view_item'          => __( 'View Tab Builder', 'logistik' ),
				'all_items'          => __( 'All Tab Builder', 'logistik' ),
				'search_items'       => __( 'Search Tab Builder', 'logistik' ),
				'parent_item_colon'  => __( 'Parent Tab Builder:', 'logistik' ),
				'not_found'          => __( 'No Tab Builder found.', 'logistik' ),
				'not_found_in_trash' => __( 'No Tab Builder found in Trash.', 'logistik' ),
			);

			$args = array(
				'labels'              => $labels,
				'public'              => true,
				'rewrite'             => false,
				'show_ui'             => true,
				'show_in_menu'        => false,
				'show_in_nav_menus'   => false,
				'exclude_from_search' => true,
				'capability_type'     => 'post',
				'hierarchical'        => false,
				'supports'            => array( 'title', 'elementor' ),
			);

			register_post_type( 'logistik_tab_builder', $args );
		}

		function load_canvas_template( $single_template ) {

			global $post;

			if ( 'logistik_footerbuild' == $post->post_type || 'logistik_header' == $post->post_type || 'logistik_tab_build' == $post->post_type ) {

				$elementor_2_0_canvas = ELEMENTOR_PATH . '/modules/page-templates/templates/canvas.php';

				if ( file_exists( $elementor_2_0_canvas ) ) {
					return $elementor_2_0_canvas;
				} else {
					return ELEMENTOR_PATH . '/includes/page-templates/canvas.php';
				}
			}

			return $single_template;
		}

        public function logistik_footer_build_choose_option(){

			$logistik_post_query = new WP_Query( array(
				'post_type'			=> 'logistik_footerbuild',
				'posts_per_page'	    => -1,
			) );

			$logistik_builder_post_title = array();
			$logistik_builder_post_title[''] = __('Select a Footer','logistik');

			while( $logistik_post_query->have_posts() ) {
				$logistik_post_query->the_post();
				$logistik_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $logistik_builder_post_title;

		}

		public function logistik_header_choose_option(){

			$logistik_post_query = new WP_Query( array(
				'post_type'			=> 'logistik_header',
				'posts_per_page'	    => -1,
			) );

			$logistik_builder_post_title = array();
			$logistik_builder_post_title[''] = __('Select a Header','logistik');

			while( $logistik_post_query->have_posts() ) {
				$logistik_post_query->the_post();
				$logistik_builder_post_title[ get_the_ID() ] =  get_the_title();
			}
			wp_reset_postdata();

			return $logistik_builder_post_title;

        }

    }

    $builder_execute = new LogistikBuilder();