<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Video Widget .
 *
 */
class logistik_Video extends Widget_Base {

	public function get_name() {
		return 'logistikvideo';
	}

	public function get_title() {
		return __( 'Video Box', 'logistik' );
	}


	public function get_icon() {
		return 'themeholy-icon';
    }


	public function get_categories() {
		return [ 'logistik' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'video_section',
			[
				'label' 	=> __( 'video Box', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Layout Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2' 		=> __( 'Style Two', 'logistik' ),
					'3' 		=> __( 'Style Three', 'logistik' ),
					'4' 		=> __( 'Style Four', 'logistik' ),
				],
			]
		);  

		$this->add_control(
            'image',
            [
                'label'     => __( 'Image', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );

		$this->add_control(
			'video_link',
			[
				'label' 		=> esc_html__( 'Video URL', 'acadu' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'acadu' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'title',
			[
				'label' 	=> __( 'Title', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Title', 'logistik' ),
				'condition'	=> [
					'layout_style' => ['2', '3', '4'],
				]
			]
        );
       
        $this->add_control(
			'features', [
				'label' 		=> __( 'Features', 'acadu' ),
				'type' 			=> Controls_Manager::WYSIWYG,
				'default' 		=> __( '12 Hour Session' , 'acadu' ),
				'label_block' 	=> true,
				'condition'	=> [
					'layout_style' => ['1'],
				]
			]
        );

		$this->end_controls_section();

         //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------------------------------------General styling-------------------------------------//
		$this->start_controls_section(
			'style',
			[
				'label' => __( 'Style', 'logistik' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'general_bg',
			[
				'label' 		=> __( 'Background Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-bg' => 'background-color: {{VALUE}}!important',
				],
			]
		);

		$this->add_responsive_control(
			'general_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-bg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'general_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-bg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'contact_box_shadow',
				'label' => esc_html__( 'Box Shadow', 'logistik' ),
				'selector' => '{{WRAPPER}} .th-bg',
			]
		);
		
		$this->end_controls_section();

		//---------------------------------------Title Style---------------------------------------//
		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'tayde' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'layout_style' => ['2', '3'],
				]
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Color', 'tayde' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Typography', 'tayde' ),
				'selector' 	=> '{{WRAPPER}} .th-title',
			]
		);
		$this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Margin', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Padding', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->end_controls_section();


	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        ?>
        <?php if( $settings['layout_style'] == '2' ): ?>
		<div class="video-area-2 th-bg space" data-bg-src="<?php echo esc_url( $settings['image']['url'] ); ?>">
			<div class="container-fluid">
				<div class="video-content-box text-center">
					<a href="<?php echo esc_url( $settings['video_link']['url'] ); ?>" class="white-play-btn popup-video mb-40"><i class="fa-sharp fa-solid fa-play"></i></a>
					<h3 class="video-title th-title"><?php echo esc_html($settings['title']); ?></h3>

				</div>
			</div>
		</div>

		<?php elseif( $settings['layout_style'] == '3' ): ?>
		<div class="video-area-3 th-bg space" data-bg-src="<?php echo esc_url( $settings['image']['url'] ); ?>">
			<div class="container-fluid">
				<div class="video-content-box style2 text-center">
					<a href="<?php echo esc_url( $settings['video_link']['url'] ); ?>" class="white-play-btn popup-video mb-40"><i class="fa-sharp fa-solid fa-play"></i></a>
					<h3 class="text-white th-title"><?php echo esc_html($settings['title']); ?></h3>

				</div>
			</div>
		</div>

		<?php elseif( $settings['layout_style'] == '4' ): ?>
			<div class="video-image">
				<?php echo logistik_img_tag( array(
					'url'   => esc_url( $settings['image']['url']  ),
				)); ?>
				<div class="video-5 th-bg">
					<h3 class="video-title"><?php echo esc_html($settings['title']); ?></h3>
					<a href="<?php echo esc_url( $settings['video_link']['url'] ); ?>" class="white-play-btn popup-video mb-40"><i class="fa-sharp fa-solid fa-play"></i></a>

				</div>
			</div>

        <?php else: ?>
		<div class="about-wrapper th-bg">
			<div class="about-image">
				<?php echo logistik_img_tag( array(
					'url'   => esc_url( $settings['image']['url']  ),
				)); ?>
				<a href="<?php echo esc_url( $settings['video_link']['url'] ); ?>" class="white-play-btn popup-video"><i class="fa-sharp fa-solid fa-play"></i></a>
			</div>
			<div class="checklist th-title">
				<?php echo wp_kses_post($settings['features']); ?>
			</div>
		</div>

        <?php endif;

	}

}