<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;

/**
 *
 * Testimonial Slider Widget .
 *
 */

class logistik_Testimonial extends Widget_Base{

	public function get_name() {
		return 'logistiktestimonialslider';
	}

	public function get_title() {
		return __( 'Testimonial Slider', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'testimonial_slider_section',
			[
				'label' 	=> __( 'Testimonial Slider', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Layout Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2' 		=> __( 'Style Two', 'logistik' ),
					'3' 		=> __( 'Style Three', 'logistik' ),
					'4' 		=> __( 'Style Four', 'logistik' ),
				],
			]
		);

		$this->add_control(
			'sub_image',
			[
				'label' 		=> __( 'Subtitle Shape', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition'	=> [
					'layout_style' => ['2'],
				]
			]
		);  

		$this->add_control(
			'section_subtitle',
			[
				'label' 	=> __( 'Section Subtitle', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Subtitle', 'logistik' ),
                'rows' => '2',
				'condition'	=> [
					'layout_style' => ['2'],
				]
			]
        );

		$this->add_control(
			'section_title',
			[
				'label' 	=> __( 'Section Title', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Title', 'logistik' ),
				'condition'	=> [
					'layout_style' => ['2'],
				]
			]
        );

		$this->add_control(
			'image',
			[
				'label' 		=> __( 'Image', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition'	=> [
					'layout_style' => ['2'],
				]
			]
		);


		$repeater = new Repeater();

		$repeater->add_control(
			'client_image',
			[
				'label' 		=> __( 'Client Image', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'default' 		=> [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);
		$repeater->add_control(
			'shape_image',
			[
				'label' 		=> __( 'Shape/Pattan', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
			]
		);
		$repeater->add_control(
			'quote_image',
			[
				'label' 		=> __( 'Quote Image', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'description'  => __( 'This option for only style 1', 'logistik' ),
			]
		);
		$repeater->add_control(
			'client_service', [
				'label' 		=> __( 'Feedback Title', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Good Services' , 'logistik' ),
				'label_block' 	=> true,
			]
        );
		$repeater->add_control(
			'client_name', [
				'label' 		=> __( 'Client Name', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Vlademir Hilto' , 'logistik' ),
				'label_block' 	=> true,
			]
        );
		$repeater->add_control(
			'client_desig', [
				'label' 		=> __( 'Client Designation', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'IT Student' , 'logistik' ),
				'label_block' 	=> true,
			]
        );

        $repeater->add_control(
			'client_feedback', [
				'label' 		=> __( 'Client Feedback', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( '“Quickly maximize visionary solutions after mission critical action items productivate premium portals for impactful -services stinctively negotiate enabled niche markets via growth strategies”' , 'logistik' ),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'client_rating',
			[
				'label' 	=> __( 'Client Rating', 'advoker' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '5',
				'options' 	=> [
					'one'  		=> __( 'One Star', 'advoker' ),
					'two' 		=> __( 'Two Star', 'advoker' ),
					'three' 	=> __( 'Three Star', 'advoker' ),
					'four' 		=> __( 'Four Star', 'advoker' ),
					'five' 	 	=> __( 'Five Star', 'advoker' ),
				],
			]
		);

		$this->add_control(
			'slides',
			[
				'label' 		=> __( 'Slides', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_image' 		=> Utils::get_placeholder_image_src(),
					],
				],
				'title_field' 	=> '{{{ client_name }}}',
			]
		);

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------------------------------------subtitle styling-------------------------------------//
		$this->start_controls_section(
			'section_subtitle_style_section',
			[
				'label' => __( 'Subtitle Style', 'logistik' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'layout_style' => ['2'],
				]
			]
		);

		$this->add_control(
			'section_subtitle_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'color: {{VALUE}}!important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_subtitle_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
				'selector' 	=> '{{WRAPPER}} .th-sub',
			]
		);

		$this->add_responsive_control(
			'section_subtitle_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],

			]
		);

		$this->add_responsive_control(
			'section_subtitle_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		
		$this->end_controls_section();

		//-------------------------------------Title styling-------------------------------------//
		$this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Title Style', 'logistik' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'layout_style' => ['2'],
				]
			]
		);

		$this->add_control(
			'section_title_color',
			[
				'label' 	=> __( 'Color', 'logistik' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .th-title' => 'color: {{VALUE}}!important;',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_title_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
				'selector' 	=> '{{WRAPPER}} .th-title',
			]
		);

		$this->add_responsive_control(
			'section_title_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'section_title_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		/*-----------------------------------------Feedback styling------------------------------------*/
		$this->start_controls_section(
			'overview_con_styling',
			[
				'label' 	=> __( 'Feedback Styling', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->start_controls_tabs(
			'style_tabs2'
		);

		$this->start_controls_tab(
			'style_normal_tab2',
			[
				'label' => esc_html__( 'Nmae', 'logistik' ),
			]
		);
        $this->add_control(
			'overview_title_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-name'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'overview_title_typography',
		 		'label' 		=> __( 'Typography', 'logistik' ),
		 		'selector' 	=> '{{WRAPPER}} .th-name',
			]
		);

        $this->add_responsive_control(
			'overview_title_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'overview_title_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		$this->end_controls_tab();

		//--------------------secound--------------------//
		$this->start_controls_tab(
			'style_hover_tab2',
			[
				'label' => esc_html__( 'Desig', 'logistik' ),
			]
		);
		$this->add_control(
			'overview_content_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-desig'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'overview_content_typography',
		 		'label' 		=> __( 'Typography', 'logistik' ),
		 		'selector' 	=> '{{WRAPPER}} .th-desig',
			]
		);

        $this->add_responsive_control(
			'overview_content_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-desig' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'overview_content_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-desig' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

		$this->end_controls_tab();

		//--------------------threth--------------------//
		$this->start_controls_tab(
			'style_hover_tab3',
			[
				'label' => esc_html__( 'Feedback', 'logistik' ),
			]
		);
		$this->add_control(
			'testi_feedback_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-text'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'testi_feedback_typography',
		 		'label' 		=> __( 'Typography', 'logistik' ),
		 		'selector' 	=> '{{WRAPPER}} .th-text',
			]
		);

        $this->add_responsive_control(
			'testi_feedback_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'testi_feedback_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

		$this->end_controls_tab();

		//--------------------four--------------------//
		$this->start_controls_tab(
			'style_normal_tab4',
			[
				'label' => esc_html__( 'Title', 'logistik' ),
			]
		);
        $this->add_control(
			'overview_title_color2',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .testi-ratting'	=> 'color: {{VALUE}}!important;',
				],
			]
        );
        $this->add_group_control(
		Group_Control_Typography::get_type(),
		 	[
				'name' 			=> 'overview_title_typography2',
		 		'label' 		=> __( 'Typography', 'logistik' ),
		 		'selector' 	=> '{{WRAPPER}} .testi-ratting',
			]
		);

        $this->add_responsive_control(
			'overview_title_margin2',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-ratting' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'overview_title_padding2',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .testi-ratting' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		$this->end_controls_tab();

		$this->end_controls_tabs();
		$this->end_controls_section();


	}

	protected function render() {

		$settings = $this->get_settings_for_display();
	?>
		<?php if( $settings['layout_style'] == '2' ): ?>
		<div class="testi-box-wrapper">
			<div class="testi-box-img">
				<?php  echo logistik_img_tag( array(
					'url'	=> esc_url( $settings['image']['url'] ),
				) ); ?>
			</div>
			<div class="testi-box-slider">
				<div class="title-area">
					<span class="sub-title th-sub">
						<?php 
							if(!empty($settings['sub_image']['url'])){
								echo logistik_img_tag( array(
									'url'   => esc_url( $settings['sub_image']['url']  ),
								));
							} 
							echo wp_kses_post( $settings['section_subtitle' ] ); 
						?>
					</span>
					<h2 class="sec-title th-title"><?php echo wp_kses_post( $settings['section_title' ] ); ?></h2>
				</div>
				<div class="row testi-slider themeholy-carousel" data-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-xs-slide-show="1" data-arrows="true">
					<?php foreach( $settings['slides'] as $data ) : ?>
					<div class="col-md-6 col-lg-4">
						<div class="testi-grid">
							<div class="testi-overlay" data-bg-src="<?php echo esc_url( $data['shape_image']['url'] ); ?>"></div>
							<div class="testi-grid_wrapper">
								<h3 class="testi-ratting"><?php echo esc_html( $data['client_service'] ); ?></h3>
								<div class="star-icon">
								<?php 
									if( $data['client_rating'] == 'one' ){
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									}elseif( $data['client_rating'] == 'two' ){
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									}elseif( $data['client_rating'] == 'three' ){
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									}elseif( $data['client_rating'] == 'four' ){
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									}else{
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									}
								?>
								</div>
							</div>
							<p class="testi-grid_text th-text"><?php echo wp_kses_post( $data['client_feedback'] ); ?></p>
							<div class="testi-grid_profile">
								<div class="testi-grid_img">
									<?php  echo logistik_img_tag( array(
										'url'	=> esc_url( $data['client_image']['url'] ),
									) ); ?>
									<div class="testi-grid_icon">
										<i class="fas fa-quote-right"></i>
									</div>
								</div>
								<div class="testi-grid_info">
									<h3 class="testi-grid_name th-name"><?php echo esc_html( $data['client_name'] ); ?></h3>
									<span class="testi-grid_desig th-desig"><?php echo esc_html( $data['client_desig'] ); ?></span>
								</div>
							</div>
						</div>
					</div>
					<?php endforeach; ?>
				</div>
			</div>
		</div>
           
		<?php elseif( $settings['layout_style'] == '3' ): ?>
			<div class="row slider-shadow themeholy-carousel"  id="testiSlide6" data-slide-show="2" data-lg-slide-show="2" data-sm-slide-show="1" data-xs-slide-show="1">
				<?php foreach( $settings['slides'] as $data ) : ?>
				<div class="col-md-6 col-lg-4">
					<div class="testi-card style2">
						<div class="testi-card_wrapper">
							<div class="testi-quote">
								<?php  echo logistik_img_tag( array(
									'url'	=> esc_url( $data['quote_image']['url'] ),
								) ); ?>
							</div>
							<div class="testi-icon">
								<h3 class="testi-ratting"><?php echo esc_html( $data['client_service'] ); ?></h3>
								<div class="star-icon">
								<?php 
									if( $data['client_rating'] == 'one' ){
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									}elseif( $data['client_rating'] == 'two' ){
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									}elseif( $data['client_rating'] == 'three' ){
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									}elseif( $data['client_rating'] == 'four' ){
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									}else{
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									}
								?>
								</div>
							</div>
						</div>
						<p class="testi-card_text"><?php echo wp_kses_post( $data['client_feedback'] ); ?></p>
						<div class="testi-card_profile">
							<div class="testi-card_img">
								<?php  echo logistik_img_tag( array(
										'url'	=> esc_url( $data['client_image']['url'] ),
								) ); ?>
							</div>
							<div class="testi-card_info">
								<h3 class="testi-card_name"><?php echo esc_html( $data['client_name'] ); ?></h3>
								<span class="testi-card_desig"><?php echo esc_html( $data['client_desig'] ); ?></span>
							</div>
						</div>
					</div>
				</div>
				<?php endforeach; ?>
			</div>

		<?php elseif( $settings['layout_style'] == '4' ): ?>
			<div class="row slider-shadow themeholy-carousel" data-slide-show="2" data-lg-slide-show="2" data-md-slide-show="1" data-sm-slide-show="1" data-xs-slide-show="1" data-dots="true" data-xl-dots="true" data-ml-dots="true" data-lg-dots="true" data-md-dots="true">
				<?php foreach( $settings['slides'] as $data ) : ?>
                <div class="col-md-6 col-lg-4">
                    <div class="testi-item">
                        <div class="testi-item_img">
							<?php  echo logistik_img_tag( array(
									'url'	=> esc_url( $data['client_image']['url'] ),
							) ); ?>
                        </div>
                        <div class="testi-item_content">
                            <div class="star-icon">
								<?php 
									if( $data['client_rating'] == 'one' ){
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									}elseif( $data['client_rating'] == 'two' ){
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									}elseif( $data['client_rating'] == 'three' ){
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									}elseif( $data['client_rating'] == 'four' ){
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									}else{
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
										echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									}
								?>
                            </div>
							<p class="testi-item_text th-text"><?php echo wp_kses_post( $data['client_feedback'] ); ?></p>
                            <div class="testi-item_profile">
                                <div class="testi-item_info">
									<h3 class="testi-item_name th-name"><?php echo esc_html( $data['client_name'] ); ?></h3>
									<span class="testi-item_desig th-desig"><?php echo esc_html( $data['client_desig'] ); ?></span>
                                </div>
                                <div class="testi-quote">
									<?php  echo logistik_img_tag( array(
										'url'	=> esc_url( $data['quote_image']['url'] ),
									) ); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
				<?php endforeach; ?>
            </div>

		<?php else: ?>
		<div class="row testi-slide slider-shadow themeholy-carousel" data-slide-show="2" data-lg-slide-show="2" data-sm-slide-show="1" data-xs-slide-show="1">
			<?php foreach( $settings['slides'] as $data ) : ?>
			<div class="ol-md-6 col-lg-4">
				<div class="testi-card">
					<div class="testi-card_overlay" data-bg-src="<?php echo esc_url( $data['shape_image']['url'] ); ?>"></div>
					<div class="testi-card_wrapper">
						<div class="testi-icon">
							<h3 class="testi-ratting"><?php echo esc_html( $data['client_service'] ); ?></h3>
							<div class="star-icon">
							<?php 
								if( $data['client_rating'] == 'one' ){
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
								}elseif( $data['client_rating'] == 'two' ){
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
								}elseif( $data['client_rating'] == 'three' ){
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
									echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
								}elseif( $data['client_rating'] == 'four' ){
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									echo '<a href="#"><i class="fa-regular fa-star"></i></a>';
								}else{
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
									echo '<a href="#"><i class="fa-solid fa-star"></i></a>';
								}
							?>
							</div>
						</div>
						<div class="testi-quote">
							<?php  echo logistik_img_tag( array(
								'url'	=> esc_url( $data['quote_image']['url'] ),
							) ); ?>
						</div>
					</div>
					<p class="testi-card_text th-text"><?php echo wp_kses_post( $data['client_feedback'] ); ?></p>
					<div class="testi-card_profile">
						<div class="testi-card_img">
							<?php  echo logistik_img_tag( array(
									'url'	=> esc_url( $data['client_image']['url'] ),
							) ); ?>
						</div>
						<div class="testi-card_info">
							<h3 class="testi-card_name th-name"><?php echo esc_html( $data['client_name'] ); ?></h3>
							<span class="testi-card_desig th-desig"><?php echo esc_html( $data['client_desig'] ); ?></span>
						</div>
					</div>
				</div>
			</div>
			<?php endforeach; ?>
		</div>

		<?php endif;

	}

}