<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Service Widget .
 *
 */
class logistik_Service extends Widget_Base {

	public function get_name() {
		return 'logistikservice';
	}

	public function get_title() {
		return __( 'Services', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik' ];
	}


	protected function register_controls() {

		 $this->start_controls_section(
			'service_section',
			[
				'label'     => __( 'Services', 'logistik' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Services Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2'  		=> __( 'Style Two', 'logistik' ),
					'3'  		=> __( 'Style Three', 'logistik' ),
					'4'  		=> __( 'Style Four', 'logistik' ),
					'5'  		=> __( 'Style Five', 'logistik' ),
					'6'  		=> __( 'Style Six', 'logistik' ),
				],
			]
		);

		$this->add_control(
			'make_it_slider',
			[
				'label' 		=> __( 'Make It Slider?', 'logistik' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Yes', 'logistik' ),
				'label_off' 	=> __( 'No', 'logistik' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		$this->add_control(
			'overlay_shape',
			[
				'label'     => __( 'Overlay Shape', 'logistik' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'condition'	=> [
					'layout_style' => ['1', '2','6']
				]
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'service_img',
			[
				'label'     => __( 'Image', 'logistik' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'service_icon',
			[
				'label'     => __( 'Icon', 'logistik' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater->add_control(
			'service_title',
            [
				'label'         => __( 'Title', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Title' , 'logistik' ),
				'label_block'   => true,
				'rows' => '2'
			]
		);

        $repeater->add_control(
			'service_content',
            [
				'label'         => __( 'Content', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Content' , 'logistik' ),
				'label_block'   => true,
				'rows' => '4'
			]
		);

		$repeater->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'logistik' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block' => true,
                'default'  	=> __( 'Read More', 'logistik' )
			]
        );

        $repeater->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'service_list',
			[
				'label' 		=> __( 'Service Lists', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'service_title' 		=> __( 'Personalized Learning', 'logistik' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1', '2', '3', '5','6']
				]
			]
		);

		$repeater2 = new Repeater();

		$repeater2->add_control(
			'service_icon',
			[
				'label'     => __( 'Icon', 'logistik' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
			]
		);

        $repeater2->add_control(
			'service_title',
            [
				'label'         => __( 'Title', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Title' , 'logistik' ),
				'label_block'   => true,
				'rows' => '2'
			]
		);

        $repeater2->add_control(
			'service_content',
            [
				'label'         => __( 'Content', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Content' , 'logistik' ),
				'label_block'   => true,
				'rows' => '4'
			]
		);

		$this->add_control(
			'service_list2',
			[
				'label' 		=> __( 'Service Lists', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater2->get_controls(),
				'default' 		=> [
					[
						'service_title' 		=> __( 'Personalized Learning', 'logistik' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['4']
				]
			]
		);


		
        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------------------------------------Genearl styling-------------------------------------//
        $this->start_controls_section(
			'general_section',
			[
				'label' => __( ' General Style', 'logistik' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'general_bg',
			[
				'label' 	=> __( 'Background', 'logistik' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .th-wrap:before, {{WRAPPER}} .th-wrap' => 'background-color: {{VALUE}}!important;',
                ],
				'condition'	=> [
					'layout_style' => ['3', '4']
				]
			]
        );	

		$this->add_control(
			'general_bg2',
			[
				'label' 	=> __( 'Background', 'logistik' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .th-box:before' => 'background-color: {{VALUE}}!important;',
                ],
				'condition'	=> [
					'layout_style' => ['1', '2']
				]
			]
        );	

		$this->add_control(
			'general_h_bg',
			[
				'label' 	=> __( 'Hover Background', 'logistik' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .th-wrap:hover .th-box' => 'background-color: {{VALUE}}!important;',
                ],
				'condition'	=> [
					'layout_style' => ['1', '2']
				]
			]
        );

		$this->add_control(
			'general_h_bg2',
			[
				'label' 	=> __( 'Hover Background', 'logistik' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .th-wrap' => 'background-color: {{VALUE}}!important;',
                ],
				'condition'	=> [
					'layout_style' => ['3']
				]
			]
        );

        $this->add_control(
			'general_b_color',
			[
				'label' 	=> __( 'Border Color', 'logistik' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .th-wrap' => 'border-color: {{VALUE}}!important;',
                ],
				'condition'	=> [
					'layout_style' => ['3']
				]
			]
        );

		$this->add_responsive_control(
			'general_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);

		$this->end_controls_section();

		//---------------------------------------Title Style---------------------------------------//
		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'tayde' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Color', 'tayde' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'title_color2',
			[
				'label' 		=> __( 'Hover Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-wrap:hover .th-title' => 'color: {{VALUE}} !important',
				],
				'condition'	=> [
					'layout_style' => ['1', '2', '3']
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Typography', 'tayde' ),
				'selector' 	=> '{{WRAPPER}} .th-title',
			]
		);
		$this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Margin', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Padding', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->end_controls_section();

		//---------------------------------------Description Style---------------------------------------//
		$this->start_controls_section(
			'desc_style',
			[
				'label' 	=> __( 'Description Style', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'desc_color2',
			[
				'label' 		=> __( 'Hover Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-wrap:hover .th-desc' => 'color: {{VALUE}}',
				],
				'condition'	=> [
					'layout_style' => ['1', '2', '3']
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'desc_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
				'selector' 	=> '{{WRAPPER}} .th-desc',
			]
		);

		$this->add_responsive_control(
			'desc_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'desc_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();


	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        ?>

        <?php if( $settings['layout_style'] == '2' ): ?>
			<div class="row slider-shadow themeholy-carousel arrow-wrap" data-slide-show="4" data-xl-slide-show="3" data-lg-slide-show="3" data-md-slide-show="2" data-sm-slide-show="1" data-xs-slide-show="1" data-arrows="true">
				<?php foreach( $settings['service_list'] as $data ): ?>
				<div class="col-md-6 col-lg-4 col-xl-4">
					<div class="service-card th-wrap">
						<div class="service-card_img">
							<?php echo logistik_img_tag( array(
									'url'   => esc_url( $data['service_img']['url']  ),
								)); ?>
						</div>
						<div class="service-card_wrapper">
							<div class="service-card_content th-box" data-bg-src="<?php echo esc_url( $settings['overlay_shape']['url']  ); ?>">
								<div class="service-card_icon">
									<?php echo logistik_img_tag( array(
										'url'   => esc_url( $data['service_icon']['url']  ),
									)); ?>
								</div>
								<h3 class="service-card_title th-title"><a href="<?php echo esc_url( $data['button_link']['url'] ); ?>"><?php echo esc_html( $data['service_title'] ); ?></a></h3>
								<p class="service-card_desc th-desc"><?php echo esc_html( $data['service_content'] );  ?></p>
							</div>
							<div class="share-option">
								<div class="share-link">
									<i class="fa-sharp fa-regular fa-arrow-up"></i>
								</div>
								<div class="team-social2">
									<div class="icon-team-list">
										<a href="<?php echo esc_url( $data['button_link']['url'] ); ?>" class="ser-icon"><?php echo wp_kses_post($data['button_text']); ?></p>
										</a>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
				<?php endforeach; ?>
			</div>

		<?php elseif( $settings['layout_style'] == '3' ): ?>
			<div class="row slider-shadow themeholy-carousel arrow-wrap" id="serviceSlide1" data-slide-show="4" data-lg-slide-show="3" data-md-slide-show="2" data-sm-slide-show="1" data-arrows="true">
				<?php foreach( $settings['service_list'] as $data ): ?>
                <div class="col-md-6 col-lg-6 col-xl-4">
                    <div class="service-box style3 th-wrap">
                        <div class="service-box_shape moving_X">
							<?php echo logistik_img_tag( array(
								'url'   => esc_url( $data['service_img']['url']  ),
							)); ?>
                        </div>
                        <div class="service-box-content">
                            <div class="service-box_icon">
								<?php echo logistik_img_tag( array(
									'url'   => esc_url( $data['service_icon']['url']  ),
								)); ?>
							</div>
                            <h3 class="service-box_title th-title"><a href="<?php echo esc_url( $data['button_link']['url'] ); ?>"><?php echo esc_html( $data['service_title'] ); ?></a></h3>
                            <p class="service-box_text th-desc"><?php echo esc_html( $data['service_content'] );  ?></p>
                            <a href="<?php echo esc_url( $data['button_link']['url'] ); ?>" class="line-btn"><?php echo wp_kses_post($data['button_text']); ?></a>
                        </div>
                    </div>
                </div>
				<?php endforeach; ?>
            </div>

		<?php elseif( $settings['layout_style'] == '4' ): ?>
			<div class="feature-grid-wrap">
				<?php foreach( $settings['service_list2'] as $data ): ?>
                <div class="feature-grid th-wrap">
                    <div class="feature-grid_icon">
						<?php echo logistik_img_tag( array(
							'url'   => esc_url( $data['service_icon']['url']  ),
						)); ?>
                    </div>
                    <div>
                        <h3 class="feature-grid_title th-title"><?php echo esc_html( $data['service_title'] ); ?></h3>
                        <p class="feature-grid_text th-desc"><?php echo esc_html( $data['service_content'] );  ?></p>
                    </div>
                </div>
				<?php endforeach; ?>
            </div>

		<?php elseif( $settings['layout_style'] == '5' ): ?>
			<div class="row slider-shadow themeholy-carousel arrow-wrap" id="serviceSlide5" data-slide-show="4" data-lg-slide-show="3" data-md-slide-show="2" data-sm-slide-show="1" data-arrows="true">
				<?php foreach( $settings['service_list'] as $key => $data ): ?>
				<div class="col-md-6 col-lg-6 col-xl-4">
					<div class="service-box style4">
						<div class="service-box_wrapp">
							<div class="service-box_icons">
								<?php echo logistik_img_tag( array(
									'url'   => esc_url( $data['service_icon']['url']  ),
								)); ?>
							</div>
							<h3 class="service-box_number"><?php echo esc_html__('0', 'logistik'); echo esc_html($key + 1); ?></h3>
						</div>
						<div class="service-box-content">
							<h3 class="service-box_title th-title"><a href="<?php echo esc_url( $data['button_link']['url'] ); ?>"><?php echo esc_html( $data['service_title'] ); ?></a></h3>
							<p class="service-box_text th-desc"><?php echo esc_html( $data['service_content'] );  ?></p>
							<a href="<?php echo esc_url( $data['button_link']['url'] ); ?>" class="line-btn"><?php echo wp_kses_post($data['button_text']); ?></a>
						</div>
					</div>
				</div>
				<?php endforeach; ?>
			</div>

		<?php elseif( $settings['layout_style'] == '6' ): ?>
			<div class="row slider-shadow themeholy-carousel arrow-wrap" data-slide-show="4" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-xs-slide-show="1" data-arrows="true">
				<?php foreach( $settings['service_list'] as $data ): ?>
                <div class="col-md-6 col-lg-6 col-xl-4">
                    <div class="service-item">
                        <div class="service-item_img" data-mask-src="<?php echo esc_url( $settings['overlay_shape']['url']  ); ?>">
							<?php echo logistik_img_tag( array(
								'url'   => esc_url( $data['service_img']['url']  ),
							)); ?>
                        </div>
                        <div class="service-item_content">
                            <div class="service-item_icon">
								<?php echo logistik_img_tag( array(
									'url'   => esc_url( $data['service_icon']['url']  ),
								)); ?>
							</div>
							<h3 class="box-title th-title"><a href="<?php echo esc_url( $data['button_link']['url'] ); ?>"><?php echo esc_html( $data['service_title'] ); ?></a></h3>
							<p class="service-item_text th-desc"><?php echo esc_html( $data['service_content'] );  ?></p>
                        </div>
                    </div>
                </div>
				<?php endforeach; ?>
            </div>

    	<?php else: ?>
			<?php if($settings['make_it_slider'] == 'yes'): ?>
			<div class="row slider-shadow themeholy-carousel arrow-wrap" data-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-xs-slide-show="1" data-arrows="true">
			<?php else: ?>
				<div class="row ser-gy-4">
			<?php endif; ?>
				<?php foreach( $settings['service_list'] as $data ): ?>
				<div class="col-md-6 col-lg-6 col-xl-4">
					<div class="service-box th-wrap">
						<div class="service-box_img">
							<?php echo logistik_img_tag( array(
								'url'   => esc_url( $data['service_img']['url']  ),
							)); ?>
						</div>
						<div class="service-box_content th-box" data-bg-src="<?php echo esc_url( $settings['overlay_shape']['url']  ); ?>">
							<div class="service-box_icon">
								<?php echo logistik_img_tag( array(
									'url'   => esc_url( $data['service_icon']['url']  ),
								)); ?>
							</div>
							<h3 class="box-title th-title"><a href="<?php echo esc_url( $data['button_link']['url'] ); ?>"><?php echo esc_html( $data['service_title'] ); ?></a></h3>
							<p class="service-box_text th-desc"><?php echo esc_html( $data['service_content'] );  ?></p>
							<a href="<?php echo esc_url( $data['button_link']['url'] ); ?>" class="line-btn"><?php echo wp_kses_post($data['button_text']); ?></a>
						</div>
					</div>
				</div>
				<?php endforeach; ?>
			</div>

      <?php endif; 

	}

}