<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Schedule Widget .
 *
 */
class logistik_Schedule extends Widget_Base {

	public function get_name() {
		return 'logistikschedule';
	}

	public function get_title() {
		return __( 'Schedule', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'arrow_section',
			[
				'label'     => __( 'Schedule', 'logistik' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Layout Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2' 		=> __( 'Style Two', 'logistik' ),
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label' 		=> __( 'Background Image', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition' => [
					'layout_style' => ['2']
				]
			]
		); 

        $repeater = new Repeater();

        $repeater->add_control(
			'time',
            [
				'label'         => __( 'Time', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( '10:00' , 'logistik' ),
				'label_block'   => true,
				'rows' => '2'
			]
		);

        $repeater->add_control(
			'title',
            [
				'label'         => __( 'Title', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Classic Ballet' , 'logistik' ),
				'label_block'   => true,
				'rows' => '2'
			]
		);

        $repeater->add_control(
			'author',
            [
				'label'         => __( 'Author', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'By: Michel' , 'logistik' ),
				'label_block'   => true,
				'rows' => '2'
			]
		);

        $repeater->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'logistik' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block' => true,
                'default'  	=> __( 'Join Now', 'logistik' )
			]
        );

        $repeater->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'schedule_list',
			[
				'label' 		=> __( 'Schedule List', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'tab_title' 		=> __( 'Monday', 'logistik' ),
					],
				],
                'condition'	=> [
					'layout_style' => ['1'],
				]
			]
		);

        $repeater2 = new Repeater();

        $repeater2->add_control(
			'title',
            [
				'label'         => __( 'Title Name', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( '' , 'logistik' ),
				'label_block'   => true,
				'rows' => '1'
			]
		);

		$this->add_control(
			'schedule_list_22',
			[
				'label' 		=> __( 'Schedule Title', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater2->get_controls(),
				'default' 		=> [
					[
						'title' 		=> __( 'Day', 'logistik' ),
					],
				],
                'condition'	=> [
					'layout_style' => ['2'],
				]
			]
		);

        $repeater2 = new Repeater();

        $repeater2->add_control(
			'time',
            [
				'label'         => __( 'Time', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( '10:00 AM' , 'logistik' ),
				'label_block'   => true,
				'rows' => '2'
			]
		);

        $repeater2->add_control(
			'content1',
            [
				'label'         => __( 'Content 1', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Content' , 'logistik' ),
				'label_block'   => true,
				'rows' => '3'
			]
		);
        $repeater2->add_control(
			'content2',
            [
				'label'         => __( 'Content 2', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Content' , 'logistik' ),
				'label_block'   => true,
				'rows' => '3'
			]
		);
        $repeater2->add_control(
			'content3',
            [
				'label'         => __( 'Content 3', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Content' , 'logistik' ),
				'label_block'   => true,
				'rows' => '3'
			]
		);
        $repeater2->add_control(
			'content4',
            [
				'label'         => __( 'Content 4', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Content' , 'logistik' ),
				'label_block'   => true,
				'rows' => '3'
			]
		);
        $repeater2->add_control(
			'content5',
            [
				'label'         => __( 'Content 5', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Content' , 'logistik' ),
				'label_block'   => true,
				'rows' => '3'
			]
		);
        $repeater2->add_control(
			'content6',
            [
				'label'         => __( 'Content 6', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Content' , 'logistik' ),
				'label_block'   => true,
				'rows' => '3'
			]
		);
        $repeater2->add_control(
			'content7',
            [
				'label'         => __( 'Content 7', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Content' , 'logistik' ),
				'label_block'   => true,
				'rows' => '3'
			]
		);

		$this->add_control(
			'schedule_list_2',
			[
				'label' 		=> __( 'Schedule List', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater2->get_controls(),
				'default' 		=> [
					[
						'time' 		=> __( '', 'logistik' ),
					],
				],
                'condition'	=> [
					'layout_style' => ['2'],
				]
			]
		);

        $this->end_controls_section();


        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------------------------------------Genearl styling-------------------------------------//
        $this->start_controls_section(
			'general_section',
			[
				'label' => __( ' General Style', 'logistik' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'layout_style' => ['2'],
				]
			]
		);

		$this->add_control(
			'general_color',
			[
				'label' 	=> __( 'Background', 'logistik' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .class-schedule-table:before' => 'background-color: {{VALUE}}!important;',
                ],
			]
        );	

		$this->add_responsive_control(
			'general_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}}  .class-schedule-table' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);

		$this->add_responsive_control(
			'general_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}}  .class-schedule-table' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);

		$this->end_controls_section();

        //-------------------------------------title styling-------------------------------------//
        $this->start_controls_section(
            'schedule_title_style_section',
            [
                'label' => __( 'Title Style', 'logistik' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'layout_style' => ['2'],
				]
            ]
        );

        $this->add_control(
            'schedule_title_color',
            [
                'label' 	=> __( 'Color', 'logistik' ),
                'type' 		=> Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .schedule-day td' => 'color: {{VALUE}}!important;',
                ],
            ]
        );

        $this->add_control(
            'schedule_title_bg',
            [
                'label' 	=> __( 'Background', 'logistik' ),
                'type' 		=> Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .schedule-day td:before' => 'background-color: {{VALUE}}!important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' 		=> 'schedule_title_typography',
                'label' 	=> __( 'Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .schedule-day td',
            ]
        );

        $this->add_responsive_control(
            'schedule_title_margin',
            [
                'label' 		=> __( 'Margin', 'logistik' ),
                'type' 			=> Controls_Manager::DIMENSIONS,
                'size_units' 	=> [ 'px', '%', 'em' ],
                'selectors' 	=> [
                    '{{WRAPPER}} .schedule-day td' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'schedule_title_padding',
            [
                'label' 		=> __( 'Padding', 'logistik' ),
                'type' 			=> Controls_Manager::DIMENSIONS,
                'size_units' 	=> [ 'px', '%', 'em' ],
                'selectors' 	=> [
                    '{{WRAPPER}} .schedule-day td' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();	

		  //-------------------------------------Content styling-------------------------------------//
		  $this->start_controls_section(
            'schedule_content_style_section',
            [
                'label' => __( 'Content Style', 'logistik' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'layout_style' => ['1'],
				]
            ]
        );

        $this->add_control(
            'schedule_content_color',
            [
                'label' 	=> __( 'Color', 'logistik' ),
                'type' 		=> Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .schedule-details ul li p, .schedule-details ul li a' => '--body-color: {{VALUE}}!important;',
                ],
            ]
        );

        $this->add_control(
            'schedule_content_bg',
            [
                'label' 	=> __( 'Hover Color', 'logistik' ),
                'type' 		=> Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .schedule-details ul li .line-btn:hover' => '--theme-color: {{VALUE}}!important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' 		=> 'schedule_content_typography',
                'label' 	=> __( 'Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .schedule-details ul li, {{WRAPPER}} .schedule-details ul li a',
            ]
        );

        $this->end_controls_section();	

	}

	protected function render() {

    $settings = $this->get_settings_for_display();
    ?>
        <?php if( $settings['layout_style'] == '2' ): ?>
            <table class="class-schedule-table table" data-bg-src="<?php echo esc_url( $settings['image']['url'] ); ?>">
                <tr class="schedule-day">
                    <?php foreach( $settings['schedule_list_22'] as $data ): ?>
                    <td><?php echo wp_kses_post( $data['title'] ); ?></td>
                    <?php endforeach; ?>
                </tr>

                <?php foreach( $settings['schedule_list_2'] as $data ): ?>
                <tr>
                    <th scope="row" class="time"><?php echo wp_kses_post( $data['time'] ); ?></th>
                    <td class="<?php echo (!empty($data['content1'])) ? 'schedule-title': ''; ?>"><?php echo wp_kses_post( $data['content1'] ); ?></td>
                    <td class="<?php echo (!empty($data['content2'])) ? 'schedule-title': ''; ?>"><?php echo wp_kses_post( $data['content2'] ); ?></td>
                    <td class="<?php echo (!empty($data['content3'])) ? 'schedule-title': ''; ?>"><?php echo wp_kses_post( $data['content3'] ); ?></td>
                    <td class="<?php echo (!empty($data['content4'])) ? 'schedule-title': ''; ?>"><?php echo wp_kses_post( $data['content4'] ); ?></td>
                    <td class="<?php echo (!empty($data['content5'])) ? 'schedule-title': ''; ?>"><?php echo wp_kses_post( $data['content5'] ); ?></td>
                    <td class="<?php echo (!empty($data['content6'])) ? 'schedule-title': ''; ?>"><?php echo wp_kses_post( $data['content6'] ); ?></td>
                    <td class="<?php echo (!empty($data['content7'])) ? 'schedule-title': ''; ?>"><?php echo wp_kses_post( $data['content7'] ); ?></td>
                </tr>
                <?php endforeach; ?>
            </table>

        <?php else: ?>
            <div class="schedule-details">
                <?php foreach( $settings['schedule_list'] as $key => $data ): ?>
                <div class="schedule-content">
                    <ul>
                        <li>
                            <p class="time mb-0"><?php echo esc_html( $data['time'] ); ?></p>
                        </li>
                        <li>
                            <p class="title mb-0"><?php echo esc_html( $data['title'] ); ?></p>
                        </li>
                        <li>
                            <p class="author mb-0"><?php echo esc_html( $data['author'] ); ?></p>
                        </li>
                        <li><a href="<?php echo esc_url( $data['button_link']['url'] ); ?>" class="line-btn"><?php echo esc_html( $data['button_text'] ); ?></a></li>
                    </ul>
                </div>
                <?php endforeach; ?>
            </div>
        

        <?php endif;
			
	}
}