<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Request Quote Widget .
 *
 */
class logistik_Request_Quote extends Widget_Base {

	public function get_name() {
		return 'logistikrequestquote';
	}

	public function get_title() {
		return __( 'Request Quote', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik' ];
	}

	public function get_as_contact_form(){
        if ( ! class_exists( 'WPCF7' ) ) {
            return;
        }
        $as_cfa         = array();
        $as_cf_args     = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
        $as_forms       = get_posts( $as_cf_args );
        $as_cfa         = ['0' => esc_html__( 'Select Form', 'logistik' ) ];
        if( $as_forms ){
            foreach ( $as_forms as $as_form ){
                $as_cfa[$as_form->ID] = $as_form->post_title;
            }
        }else{
            $as_cfa[ esc_html__( 'No contact form found', 'logistik' ) ] = 0;
        }
        return $as_cfa;
    }

	protected function register_controls() {

		$this->start_controls_section(
			'contact_form_section',
			[
				'label' 	=> __( 'Request Quote', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Layout Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2' 		=> __( 'Style Two', 'logistik' ),
					'3' 		=> __( 'Style Three', 'logistik' ),
					'4' 		=> __( 'Style Four', 'logistik' ),
				],
			]
		);    
        
        $this->add_control(
			'sub_image',
			[
				'label' 		=> __( 'Subtitle Shape', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition'	=> [
					'layout_style' => ['1', '3'],
				]
			]
		);  

		$this->add_control(
			'section_subtitle',
			[
				'label' 	=> __( 'Section Subtitle', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Subtitle', 'logistik' ),
                'rows' => '2',
				'condition'	=> [
					'layout_style' => ['1', '3'],
				]
			]
        );

		$this->add_control(
			'section_title',
			[
				'label' 	=> __( 'Section Title', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Title', 'logistik' ),
				'condition'	=> [
					'layout_style' => ['1', '3'],
				]
			]
        );

        $this->add_control(
            'video_image',
            [
                'label'     => __( 'Video Image', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
                'condition'	=> [
					'layout_style' => ['1', '3'],
				]
            ]
        );

		$this->add_control(
			'video_link',
			[
				'label' 		=> esc_html__( 'Video URL', 'acadu' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'acadu' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
                'condition'	=> [
					'layout_style' => ['1', '3'],
				]
			]
		);

        
        $this->add_control(
            'section_bg',
            [
                'label'     => __( 'Background Shape', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition'	=> [
					'layout_style!' => ['4'],
				]
            ]
        );
        $this->add_control(
            'shape',
            [
                'label'     => __( 'Shape', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
                'condition'	=> [
					'layout_style' => ['3'],
				]
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
			'tab_title',
            [
				'label'         => __( 'Tab Title', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Request a quote' , 'logistik' ),
				'label_block'   => true,
				'rows' => '2'
			]
		);

        $repeater->add_control(
            'logistik_select_contact_form',
            [
                'label'   => esc_html__( 'Select Form', 'logistik' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '0',
                'options' => $this->get_as_contact_form(),
            ]
        );

        $this->add_control(
			'request_quote_list',
			[
				'label' 		=> __( 'Request Quote Lists', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'tab_title'	=> __( 'Request a quote', 'logistik' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1', '4']
				]
			]
		);

        $repeater2 = new Repeater();

        $repeater2->add_control(
			'tab_title',
            [
				'label'         => __( 'Tab Title', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Request a quote' , 'logistik' ),
				'label_block'   => true,
				'rows' => '2'
			]
		);

        $repeater2->add_control(
            'logistik_select_contact_form',
            [
                'label'   => esc_html__( 'Select Form', 'logistik' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '0',
                'options' => $this->get_as_contact_form(),
            ]
        );

        $repeater2->add_control(
			'tab_img',
			[
				'label'     => __( 'Image', 'logistik' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
			]
		);

        $repeater2->add_control(
			'title',
            [
				'label'         => __( 'Title', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Title' , 'logistik' ),
				'label_block'   => true,
				'rows' => '2'
			]
		);

        $repeater2->add_control(
			'phone_number',
            [
				'label'         => __( 'Phone Number', 'logistik' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( '+11 (456) 568 65' , 'logistik' ),
				'label_block'   => true,

			]
		);

        $repeater2->add_control(
			'email_address',
            [
				'label'         => __( 'Email Address', 'logistik' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'info.support@gmail.com' , 'logistik' ),
				'label_block'   => true,

			]
		);

        $repeater2->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'logistik' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block' => true,
                'default'  	=> __( 'Read More', 'logistik' )
			]
        );

        $repeater2->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

        $this->add_control(
			'request_quote_list2',
			[
				'label' 		=> __( 'Request Quote Lists', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater2->get_controls(),
				'default' 		=> [
					[
						'tab_title'	=> __( 'Request a quote', 'logistik' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);

        $this->add_control(
            'logistik_select_contact_form',
            [
                'label'   => esc_html__( 'Select Form', 'logistik' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '0',
                'options' => $this->get_as_contact_form(),
                'condition'	=> [
					'layout_style' => ['3']
				]
            ]
        );



        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------------------------------------General styling-------------------------------------//
        $this->start_controls_section(
			'general_style',
			[
				'label' => __( 'General Style', 'logistik' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'bg_color',
			[
				'label' 		=> __( 'Background Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-bg' => 'background-color: {{VALUE}}!important',
                ],
			]
        );

       $this->add_responsive_control(
			'general_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-bg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );
		
        $this->end_controls_section();

         //---------------------------------------Subtitle Style---------------------------------------//
		$this->start_controls_section(
			'subtitle_style',
			[
				'label' 	=> __( 'Subtitle Style', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
                'condition'	=> [
					'layout_style' => ['1', '3'],
				]
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'color: {{VALUE}}',
                ],
			]
        );	

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'subtitle_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .th-sub',
			]
        );

        $this->add_responsive_control(
			'subtitle_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'subtitle_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

		$this->end_controls_section();

		//---------------------------------------Title Style---------------------------------------//
		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'tayde' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
                'condition'	=> [
					'layout_style' => ['1', '3'],
				]
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Color', 'tayde' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'color: {{VALUE}} !important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Typography', 'tayde' ),
                'selector' 	=> '{{WRAPPER}} .th-title',
			]
        );
        $this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Margin', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Padding', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();

	}

	protected function render() {

	    $settings = $this->get_settings_for_display();
        ?>

        <?php if( $settings['layout_style'] == '2' ): ?>
        <div class="request-quote-wrapper  th-bg style2" data-bg-src="<?php echo esc_url( $settings['section_bg']['url'] ); ?>">
            <div class="nav nav-tabs request-quote-tabs style2" id="nav-tab" role="tablist">
                <?php 
                    $x = 0;
                    foreach( $settings['request_quote_list2'] as $data ): 
                    $x++;
                    $active = $x == '1' ? 'active':'';
                ?>
                <button class="nav-link  <?php echo $active; ?>" id="nav-step<?php echo $x; ?>-tab" data-bs-toggle="tab" data-bs-target="#nav-step<?php echo $x; ?>" type="button"><?php echo esc_html( $data['tab_title'] ); ?></button>
                <?php endforeach; ?>
            </div>
            <div class="tab-content" id="nav-tabContent">
                <?php 
                    $x = 0;
                    foreach( $settings['request_quote_list2'] as $data ): 
                    $x++;
                    $active = $x == '1' ? 'active show':'';
                ?>
                <div class="tab-pane fade <?php echo $active; ?>" id="nav-step<?php echo $x; ?>" role="tabpanel">
                    <div class="request-wrapper">
                        <div class="themeholy-request-form style2 ">
                            <?php 
                                if( !empty($data['logistik_select_contact_form']) ){
                                    echo do_shortcode( '[contact-form-7  id="'.$data['logistik_select_contact_form'].'"]' ); 
                                }else{
                                    echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'logistik' ). '</p></div>';
                                }
                            ?>
                        </div>
                        <div class="widget widget_banner  " data-bg-src="<?php echo esc_url( $data['tab_img']['url']  ); ?>">
                            <?php 
                                $email	= $data['email_address'];
                                $phone   = $data['phone_number']; 

                                $email          = is_email( $email );
                                $replace        = array(' ','-',' - ');
                                $replace_phone        = array(' ','-',' - ', '(', ')');
                                $with           = array('','','');

                                $emailurl       = str_replace( $replace, $with, $email );
                                $phoneurl       = str_replace( $replace_phone, $with, $phone );	
                            ?>
                            <h4 class="widget_title"><?php echo esc_html( $data['title'] ); ?></h4>
                            <div class="widget-banner text-center">
                                <a class="banner-link" href="<?php echo esc_attr( 'mailto:'.$emailurl); ?>"><?php echo esc_html($email); ?></a>
                                <a class="banner-link" href="<?php echo esc_attr( 'tel:'.$phoneurl); ?>"><?php echo esc_html($phone); ?></a>
                            </div>
                            <div class="btn-group justify-content-center">
                                <a href="<?php echo esc_url( $data['button_link']['url'] ); ?>" class="themeholy-btn blue-btn2"><?php echo wp_kses_post($data['button_text']); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; ?>
            </div>
        </div>

        <?php elseif( $settings['layout_style'] == '3' ): ?>
        <div class="request-sec  th-bg"  data-bg-src="<?php echo esc_url( $settings['section_bg']['url'] ); ?>">
            <div class="container">
                <div class="title-area mt-n1">
                    <span class="sub-title th-sub">
                        <?php 
							if(!empty($settings['sub_image']['url'])){
								echo logistik_img_tag( array(
									'url'   => esc_url( $settings['sub_image']['url']  ),
								));
							} 
							echo wp_kses_post( $settings['section_subtitle' ] ); 
						?>
                    </span>
                    <h2 class="sec-title th-title"><?php echo wp_kses_post( $settings['section_title' ] ); ?></h2>
                </div>
                <div class="request-form-wrapper">
                    <div class="request-quote-form">
                        <?php 
                            if( !empty($settings['logistik_select_contact_form']) ){
                                echo do_shortcode( '[contact-form-7  id="'.$settings['logistik_select_contact_form'].'"]' ); 
                            }else{
                                echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'logistik' ). '</p></div>';
                            }
                        ?>
                        <div class="video-button">
                            <a href="<?php echo esc_url( $settings['video_link']['url'] ); ?>" class="white-play-btn popup-video mb-40"><i class="fa-sharp fa-solid fa-play"></i></a>
                        </div>
                    </div>
                    <div class="video-content-wrapp">
                        <div class="request-quote-image">
                            <?php echo logistik_img_tag( array(
                                'url'   => esc_url( $settings['video_image']['url']  ),
                            )); ?>
                        </div>

                    </div>
                </div>

            </div>
            <div class="shape-mockup" data-bottom="0%" data-right="0%">
                <?php echo logistik_img_tag( array(
                    'url'   => esc_url( $settings['shape']['url']  ),
                )); ?>
            </div>
        </div>

		<?php elseif( $settings['layout_style'] == '4' ): ?>
		<div class="nav nav-tabs request-quote-tabs style3" id="nav-tab" role="tablist">
			<?php 
				$x = 0;
				foreach( $settings['request_quote_list'] as $data ): 
				$x++;
				$active = $x == '1' ? 'active':'';
			?>
			<button class="nav-link <?php echo $active; ?>" id="nav-step<?php echo $x; ?>-tab" data-bs-toggle="tab" data-bs-target="#nav-step<?php echo $x; ?>" type="button"><?php echo esc_html( $data['tab_title'] ); ?></button>
			<?php endforeach; ?>
		</div>
		<div class="tab-content" id="nav-tabContent">
			<?php 
				$x = 0;
				foreach( $settings['request_quote_list'] as $data ): 
				$x++;
				$active = $x == '1' ? 'active show':'';
			?>
			<div class="tab-pane fade  <?php echo $active; ?>" id="nav-step<?php echo $x; ?>" role="tabpanel">
				<div class="themeholy-request-form ">
					<?php 
						if( !empty($data['logistik_select_contact_form']) ){
							echo do_shortcode( '[contact-form-7  id="'.$data['logistik_select_contact_form'].'"]' ); 
						}else{
							echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'logistik' ). '</p></div>';
						}
					?>
				</div>
			</div>
			<?php endforeach; ?>
		</div>

        <?php else: ?>
	    <div class="video-area th-bg bg-title space-top" data-bg-src="<?php echo esc_url( $settings['section_bg']['url'] ); ?>">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="title-area">
                            <span class="sub-title th-sub">
                            <?php 
                                if(!empty($settings['sub_image']['url'])){
                                    echo logistik_img_tag( array(
                                        'url'   => esc_url( $settings['sub_image']['url']  ),
                                    ));
                                } 
                                echo wp_kses_post( $settings['section_subtitle' ] ); 
                            ?>
                            </span>
                            <h2 class="sec-title text-white th-title"><?php echo wp_kses_post( $settings['section_title' ] ); ?></h2>
                        </div>
                        <div class="request-quote-wrapper">
                            <div class="nav nav-tabs request-quote-tabs" id="nav-tab" role="tablist">
                                <?php 
                                    $x = 0;
                                    foreach( $settings['request_quote_list'] as $data ): 
                                    $x++;
                                    $active = $x == '1' ? 'active':'';
                                ?>
                                <button class="nav-link <?php echo $active; ?>" id="nav-step<?php echo $x; ?>-tab" data-bs-toggle="tab" data-bs-target="#nav-step<?php echo $x; ?>" type="button"><?php echo esc_html( $data['tab_title'] ); ?></button>
                                <?php endforeach; ?>
                            </div>
                            <div class="tab-content" id="nav-tabContent">
                                <?php 
                                    $x = 0;
                                    foreach( $settings['request_quote_list'] as $data ): 
                                    $x++;
                                    $active = $x == '1' ? 'active show':'';
                                ?>
                                <div class="tab-pane fade  <?php echo $active; ?>" id="nav-step<?php echo $x; ?>" role="tabpanel">
                                    <div class="themeholy-request-form ">
                                    <?php 
                                        if( !empty($data['logistik_select_contact_form']) ){
                                            echo do_shortcode( '[contact-form-7  id="'.$data['logistik_select_contact_form'].'"]' ); 
                                        }else{
                                            echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'logistik' ). '</p></div>';
                                        }
                                    ?>
                                    </div>
                                </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <div class="video-box1" data-bg-src="<?php echo esc_url( $settings['video_image']['url'] ); ?>">
                            <?php echo logistik_img_tag( array(
                                'url'   => esc_url( $settings['video_image']['url']  ),
                            )); ?>
                            <a href="<?php echo esc_url( $settings['video_link']['url'] ); ?>" class="video-play-btn popup-video">
                                <i class="fa-sharp fa-solid fa-play"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
	    <?php endif;

	}

}