<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
/**
 *
 * Portfolio Info Widget
 *
 */
class logistik_Portfolio_Info extends Widget_Base{

	public function get_name() {
		return 'logistikeportfolioinfo';
	}

	public function get_title() {
		return esc_html__( 'Portfolio Info', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik' ];
	}

	public function get_script_depends() {
		return [ 'logistik-frontend-script' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'portfolio_content',
			[
				'label'		=> esc_html__( 'Portfolio Info','logistik' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);

        $this->add_control(
            'image',
            [
                'label'     => __( 'Image', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
                'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );


		$this->add_control(
			'title',
			[
				'label' 	=> esc_html__( 'Title', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> esc_html__( 'portfolio Information', 'logistik' ),
                'rows' => '2'
			]
        );
 
        $repeater = new Repeater();

        $repeater->add_control(
			'label',
			[
				'label' 	=> __( 'List Title', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( '', 'logistik' )
			]
        );

        $repeater->add_control(
			'content',
			[
				'label' 	=> __( 'List Content', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( '', 'logistik' )
			]
        );

		$this->add_control(
			'portfolio_lists',
			[
				'label' 		=> __( 'Portfolio Info List', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title'    => __( 'Clients :', 'logistik' ),
						'content'    => __( 'Ronald Richards', 'logistik' ),
					],
				],
			]
		);
     
		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

        //-------------------------------------General styling-------------------------------------//
        $this->start_controls_section(
			'general_style',
			[
				'label' => __( 'General Style', 'logistik' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'bg_color',
			[
				'label' 		=> __( 'Background Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-bg' => 'background-color: {{VALUE}}!important',
                ],
			]
        );

       $this->add_responsive_control(
			'contact_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-bg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' 		=> 'general_border',
                'label' 	=> __( 'Border', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .th-bg',
            ]
        );
		
        $this->end_controls_section();

       	//---------------------------------------Title Style---------------------------------------//
		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'tayde' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Color', 'tayde' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'color: {{VALUE}} !important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Typography', 'tayde' ),
                'selector' 	=> '{{WRAPPER}} .th-title',
			]
        );

        $this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Margin', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Padding', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

		$this->end_controls_section();

        /*-----------------------------------------Content styling------------------------------------*/
        $this->start_controls_section(
            'overview_con_styling',
            [
                'label' 	=> __( 'Content Styling', 'logistik' ),
                'tab' 		=> Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'style_tabs2'
        );

            $this->start_controls_tab(
                'style_normal_tab2',
                [
                    'label' => esc_html__( 'Title', 'logistik' ),
                ]
            );

            $this->add_control(
                'overview_title_color',
                [
                    'label' 		=> __( 'Color', 'logistik' ),
                    'type' 			=> Controls_Manager::COLOR,
                    'selectors' 	=> [
                        '{{WRAPPER}} .info-list .title'	=> 'color: {{VALUE}}!important;'
                    ],
                ]
            );

            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'name' 			=> 'overview_title_typography',
                    'label' 		=> __( 'Typography', 'logistik' ),
                    'selector' 	=> '{{WRAPPER}} .info-list .title',
                ]
            );

            $this->add_responsive_control(
                'overview_title_margin',
                [
                    'label' 		=> __( 'Margin', 'logistik' ),
                    'type' 			=> Controls_Manager::DIMENSIONS,
                    'size_units' 	=> [ 'px', '%', 'em' ],
                    'selectors' 	=> [
                        '{{WRAPPER}} .info-list .title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->end_controls_tab();

            //--------------------secound--------------------//
            $this->start_controls_tab(
                'style_hover_tab2',
                [
                    'label' => esc_html__( 'Content', 'logistik' ),
                ]
            );

            $this->add_control(
                'overview_content_color',
                [
                    'label' 		=> __( 'Color', 'logistik' ),
                    'type' 			=> Controls_Manager::COLOR,
                    'selectors' 	=> [
                        '{{WRAPPER}} .info-list .text'	=> 'color: {{VALUE}}!important;',
                    ],
                ]
            );

            $this->add_group_control(
            Group_Control_Typography::get_type(),
                [
                    'name' 			=> 'overview_content_typography',
                    'label' 		=> __( 'Typography', 'logistik' ),
                    'selector' 	=> '{{WRAPPER}} .info-list .text',
                ]
            );

            $this->add_responsive_control(
                'overview_content_margin',
                [
                    'label' 		=> __( 'Margin', 'logistik' ),
                    'type' 			=> Controls_Manager::DIMENSIONS,
                    'size_units' 	=> [ 'px', '%', 'em' ],
                    'selectors' 	=> [
                        '{{WRAPPER}} .info-list .text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    ],
                ]
            );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();


	}

	protected function render() {

		$settings = $this->get_settings_for_display(); 
    	?>

        <div class="page-img portfolio-img">
            <?php 
                echo logistik_img_tag( array(
                    'url'   => esc_url( $settings['image']['url']  ),
                ));
            ?>
            <div class="widget widget_info th-bg">
                <h3 class="widget_title th-title"><?php echo esc_html( $settings['title'] ); ?><span class="shape"></span></h3>
                <div class="info-list">
                    <ul>
                        <?php  foreach( $settings['portfolio_lists'] as $data ): ?>
                        <li>
                            <span class="title"><?php echo esc_html( $data['label'] ); ?></span>
                            <span class="text"><?php echo esc_html( $data['content'] ); ?></span>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>

    	<?php
		
	}
}