<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Info Box Widget .
 *
 */
class logistik_Info_Box extends Widget_Base {

	public function get_name() {
		return 'logistikinfobox';
	}

	public function get_title() {
		return __( 'Info Box', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik' ];
	}


	protected function register_controls() {


		 $this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'Info Box', 'logistik' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
				
			]
        );

		$this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Layout Style', 'logistik' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2'  		=> __( 'Style Two', 'logistik' ),					
					'3'  		=> __( 'Style Three', 'logistik' ),						
					'4'  		=> __( 'Style Four', 'logistik' ),						
					'5'  		=> __( 'Style Five', 'logistik' ),						
					'6'  		=> __( 'Style Six', 'logistik' ),						
					'7'  		=> __( 'Style Seven', 'logistik' ),						
					'8'  		=> __( 'Style Eight', 'logistik' ),						
				],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
            'image',
            [
                'label'     => __( 'Image / Icon', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
            ]
        );

		$repeater->add_control(
			'title',
			[
				'label' 	=> __( 'Title', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( '', 'logistik' )
			]
        );

		$repeater->add_control(
			'desc',
			[
				'label' 	=> __( 'Description', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 4,
                'default'  	=> __( 'Description here', 'logistik' )
			]
        );

		$this->add_control(
			'info_lists',
			[
				'label' 		=> __( 'Info Lists', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'title'    => __( 'Preparation For Competitions', 'logistik' ),
					],
				],
				'condition'	=> [
					'layout_style' => ['1', '2', '3', '4'],
				]
			]
		);

		$this->add_control(
            'image',
            [
                'label'     => __( 'Image', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition'	=> [
					'layout_style' => ['5', '6', '7', '8'],
				]
            ]
        );

		$this->add_control(
			'title',
			[
				'label' 	=> __( 'Title', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 2,
                'default'  	=> __( 'Title here', 'logistik' ),
				'condition'	=> [
					'layout_style' => ['5', '6', '7', '8'],
				]
			]
        );

		$this->add_control(
			'desc',
			[
				'label' 	=> __( 'Description', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 4,
                'default'  	=> __( 'Description here', 'logistik' ),
				'condition'	=> [
					'layout_style' => ['5', '6', '7', '8'],
				]
			]
        );

		$this->add_control(
			'phone',
			[
				'label' 	=> __( 'Phone', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'rows' 		=> 4,
                'default'  	=> __( '', 'logistik' ),
				'condition'	=> [
					'layout_style' => ['6'],
				]
			]
        );

		$this->add_control(
			'features',
			[
				'label' 	=> __( 'Feature Lists', 'logistik' ),
                'type' 		=> Controls_Manager::WYSIWYG,
                'default'  	=> __( 'Morbi condimentum congue dui', 'logistik' ),
				'condition'	=> [
					'layout_style' => ['5'],
				]
			]
        );

		$this->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'logistik' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block' => true,
                'default'  	=> __( 'Button Text', 'logistik' ),
				'condition'	=> [
					'layout_style' => ['7'],
				]
			]
        );

        $this->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'	=> [
					'layout_style' => ['7'],
				]
			]
		);

        $this->end_controls_section();


        //---------------------------------------
			//Style Section Start
		//---------------------------------------
		
		//---------------------------------------Title Style---------------------------------------//
		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'tayde' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Color', 'tayde' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'color: {{VALUE}} !important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Typography', 'tayde' ),
                'selector' 	=> '{{WRAPPER}} .th-title',
			]
        );
        $this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Margin', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Padding', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();

		//---------------------------------------Description Style---------------------------------------//
		$this->start_controls_section(
			'desc_style',
			[
				'label' 	=> __( 'Description Style', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'desc_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
				'selector' 	=> '{{WRAPPER}} .th-desc',
			]
		);

		$this->add_responsive_control(
			'desc_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'desc_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();


	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        ?>

        <?php if( $settings['layout_style'] == '2' ): ?>
			<div class="about-wrap">
				<?php  foreach( $settings['info_lists'] as $data ): ?>
					<div class="about-content">
						<?php if(!empty($data['image']['url']  )) :?>
						<div class="about_icon">
							<?php 
								echo logistik_img_tag( array(
									'url'   => esc_url( $data['image']['url']  ),
								));
							?>
						</div>
						<?php endif; ?>
						<div class="media-body">
							<h3 class="about_title th-title"><?php echo esc_html($data['title']) ?></h3>
							<p class="about_text th-desc"><?php echo esc_html($data['desc']) ?></p>
						</div>
					</div>
				<?php endforeach; ?>
			</div>

		<?php elseif( $settings['layout_style'] == '3' ): ?>
			<div class="choose-about-wra">
				<?php  foreach( $settings['info_lists'] as $data ): ?>
				<div class="choose-about">
					<?php if(!empty($data['image']['url']  )) :?>
					<div class="choose-about_icon">
						<?php echo logistik_img_tag( array(
									'url'   => esc_url( $data['image']['url']  ),
								));?>
					</div>
					<?php endif; ?>
					<div class="media-body">
						<h3 class="choose-about_title th-title"><?php echo esc_html($data['title']) ?></h3>
						<p class="choose-about_text th-desc"><?php echo esc_html($data['desc']) ?></p>
					</div>
				</div>
				<?php endforeach; ?>
			</div>

		<?php elseif( $settings['layout_style'] == '4' ): ?>
			<div class="feature-grid-wrap style2">
				<?php  foreach( $settings['info_lists'] as $data ): ?>
                <div class="feature-grid style2">
					<?php if(!empty($data['image']['url']  )) :?>
                    <div class="feature-grid_icon">
						<?php 
							echo logistik_img_tag( array(
								'url'   => esc_url( $data['image']['url']  ),
							));
						?>
                    </div>
					<?php endif; ?>
                    <div>
                        <h3 class="feature-grid_title th-title"><?php echo esc_html($data['title']) ?></h3>
                        <p class="feature-grid_text th-desc"><?php echo esc_html($data['desc']) ?></p>
                    </div>
                </div>
				<?php endforeach; ?>
            </div>

		<?php elseif( $settings['layout_style'] == '5' ): ?>
			<div class="row">
				<div class="feature-tab-wrapper">
					<div class="feature-content">
						<h4 class="h5 mb-3 mt-n2"><?php echo esc_html($settings['title']) ?></h4>
						<p><?php echo esc_html($settings['desc']) ?></p>
						<div class="feature-icon-list">
							<?php echo wp_kses_post($settings['features']) ?>
						</div>
					</div>
					<div class="feature-image">
						<?php 
							echo logistik_img_tag( array(
								'url'   => esc_url( $settings['image']['url']  ),
							));
						?>
					</div>
				</div>
			</div>

		<?php elseif( $settings['layout_style'] == '6' ): 
			$phone    	= $settings['phone'];        

			$replace        = array(' ','-',' - ');
			$replace_phone        = array(' ','-',' - ', '(', ')');
			$with           = array('','','');

			$phoneurl       = str_replace( $replace_phone, $with, $phone );		
		?>
			<div class="widget widget_banner style2 ">
				<div class="banner-image">
					<?php 
						echo logistik_img_tag( array(
							'url'   => esc_url( $settings['image']['url']  ),
						));
					?>
				</div>
				<h4 class="widget_title  th-title"><?php echo esc_html($settings['title']) ?></h4>
				<div class="widget-banner text-center">
					<span class="widget_desc  th-desc"><?php echo esc_html($settings['desc']) ?></span>
					<a href="<?php echo esc_attr( 'tel:'.$phoneurl); ?>" class="banner-link"><?php echo esc_html($phone); ?></a>
				</div>
			</div>

		<?php elseif( $settings['layout_style'] == '7' ): ?>
			<div class="widget widget_banner-two  " data-bg-src="<?php echo esc_url( $settings['image']['url'] ); ?>">
				<h4 class="widget_title text-white th-title"><?php echo esc_html($settings['title']) ?></h4>
				<p class="text-white th-desc"><?php echo esc_html($settings['desc']) ?></p>
				<div class="btn-group mt-30">
					<a href="<?php echo esc_url( $settings['button_link']['url'] ); ?>" class="themeholy-btn white-btn"><?php echo wp_kses_post( $settings['button_text'] ); ?></a>
				</div>
			</div>

		<?php elseif( $settings['layout_style'] == '8' ): ?>
			<div class="testi-client-box">
				<div class="thumb">
					<?php echo logistik_img_tag( array(
							'url'   => esc_url( $settings['image']['url']  ),
						));?>
				</div>
				<div class="client-counter">
					<h4 class="cilent-box_counter"><?php echo wp_kses_post($settings['title']) ?></h4>
					<span class="cilent-box_title"><?php echo esc_html($settings['desc']) ?></span>
				</div>
			</div>

    	<?php else: ?>
			<div class="achive-about-wrap">
				<?php  foreach( $settings['info_lists'] as $data ): ?>
				<div class="achive-about">
					<?php if(!empty($data['image']['url']  )) :?>
					<div class="achive-about_icon">
						<?php 
							echo logistik_img_tag( array(
								'url'   => esc_url( $data['image']['url']  ),
							));
						?>
					</div>
					<?php endif; ?>
					<div class="media-body">
						<h3 class="achive-about_title th-title"><?php echo esc_html($data['title']) ?></h3>
						<p class="achive-about_text th-desc"><?php echo esc_html($data['desc']) ?></p>
					</div>
				</div>
				<?php endforeach; ?>
            </div>

		<?php endif;

	}

}