<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
/**
 *
 * Image Widget .
 *
 */
class logistik_Image extends Widget_Base {

	public function get_name() {
		return 'logistikimage';
	}

	public function get_title() {
		return __( 'Image', 'logistik' );
	}


	public function get_icon() {
		return 'themeholy-icon';
    }


	public function get_categories() {
		return [ 'logistik' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'image_section',
			[
				'label' 	=> __( 'Image', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Layout Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2' 		=> __( 'Style Two', 'logistik' ),
					'3' 		=> __( 'Style Three', 'logistik' ),
					'4' 		=> __( 'Style Four', 'logistik' ),
					'5' 		=> __( 'Style Five', 'logistik' ),
					'6' 		=> __( 'Style Six', 'logistik' ),
				],
			]
		);

        $this->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);   

        $this->add_control(
			'image2',
			[
				'label' 		=> __( 'Choose Image', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'layout_style' => ['5', '6']
				]
			]
		);   

        $this->add_control(
			'image3',
			[
				'label' 		=> __( 'Choose Image', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'layout_style' => ['5']
				]
			]
		);   

		$this->add_control(
			'video_link',
			[
				'label' 		=> esc_html__( 'Video URL', 'acadu' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'acadu' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition' => [
					'layout_style' => ['6']
				]
			]
		);
		
		$this->add_control(
			'year',
            [
				'label'         => __( 'Number of Year', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( '25' , 'logistik' ),
				'label_block'   => true,
				'rows' 		=> 2,
			]
		);

		$this->add_control(
			'after_text',
            [
				'label'         => __( 'After Text', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( '+' , 'logistik' ),
				'label_block'   => true,
				'rows' 		=> 2,
			]
		);

		$this->add_control(
			'desc',
            [
				'label'         => __( 'Description', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Description' , 'logistik' ),
				'label_block'   => true,
				'rows' 		=> 3,
			]
		);

       $this->end_controls_section();

      	//---------------------------------------
			//Style Section Start
		//---------------------------------------

        $this->start_controls_section(
			'image_style_section',
			[
				'label' 	=> __( 'Image Style', 'logistik' ),
                'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_responsive_control(
			'width',
			[
				'label' 	=> __( 'Width', 'logistik' ),
				'type' 		=> Controls_Manager::SLIDER,
				'default' 	=> [
					'unit' 		=> '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => [ '%', 'px', 'vw' ],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'vw' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .th-img img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'space',
			[
				'label' 	=> __( 'Max Width', 'logistik' ) . ' (%)',
				'type' 		=> Controls_Manager::SLIDER,
				'default' 	=> [
					'unit' 		=> '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => [ '%' ],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .th-img img' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'height',
			[
				'label' 	=> __( 'Height', 'logistik' ),
				'type' 		=> Controls_Manager::SLIDER,
				'default' 	=> [
					'unit' 		=> '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => [ '%', 'px', 'vw' ],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'vw' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .th-img img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'separator_panel_style',
			[
				'type' 	=> Controls_Manager::DIVIDER,
				'style' => 'thick',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'image_border',
				'selector' 	=> '{{WRAPPER}} .th-img img',
			]
		);

		$this->add_responsive_control(
			'image_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-img img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' 		=> 'image_box_shadow',
				'exclude' 	=> [
					'box_shadow_position',
				],
				'selector' => '{{WRAPPER}} .th-img img',
			]
		);

		$this->end_controls_section();

		//---------------------------------------Title Style---------------------------------------//
		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'tayde' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' 		=> __( ' Color', 'tayde' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( ' Typography', 'tayde' ),
				'selector' 	=> '{{WRAPPER}} .th-title',
			]
		);
		$this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( ' Margin', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( ' Padding', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->end_controls_section();

		//---------------------------------------Description Style---------------------------------------//
		$this->start_controls_section(
			'desc_style',
			[
				'label' 	=> __( 'Description Style', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'desc_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
				'selector' 	=> '{{WRAPPER}} .th-desc',
			]
		);

		$this->add_responsive_control(
			'desc_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'desc_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        ?>

		<?php if( $settings['layout_style'] == '2' ): ?>
			<div class="img-box3 style2 ">
				<div class="img1 th-img">
					<?php echo logistik_img_tag( array(
							'url'   => esc_url( $settings['image']['url'] ),
						)); ?>
				</div>
				<div class="about-counter1">
					<h3 class="counter-title th-title"><span class="counter-number"><?php echo esc_html($settings['year']); ?></span><?php echo esc_html($settings['after_text']); ?></h3>
					<span class="counter-text th-desc"><?php echo esc_html($settings['desc']); ?></span>
				</div>
			</div>

		<?php elseif( $settings['layout_style'] == '3' ): ?>
			<div class="img-box4">
				<div class="img4 th-img">
					<?php echo logistik_img_tag( array(
							'url'   => esc_url( $settings['image']['url'] ),
						)); ?>
				</div>
				<div class="about-counter bounce-slide">
					<h2 class="counter-card_number th-title"><span class="counter-number"><?php echo esc_html($settings['year']); ?></span><?php echo esc_html($settings['after_text']); ?></h2>
					<p class="counter-card_text th-desc"><?php echo esc_html($settings['desc']); ?></p>
				</div>
			</div>

		<?php elseif( $settings['layout_style'] == '4' ): ?>
			<div class="choose-image">
				<div class="img1">
					<?php echo logistik_img_tag( array(
							'url'   => esc_url( $settings['image']['url'] ),
						)); ?>
				</div>
				<div class="choose-counter1">
					<span class="counter-text"><?php echo esc_html($settings['desc']); ?></span>
					<h3 class="counter-title"><span class="counter-number"><?php echo esc_html($settings['year']); ?></span><?php echo esc_html($settings['after_text']); ?></h3>
				</div>
			</div>

		<?php elseif( $settings['layout_style'] == '5' ): ?>
			<div class="img-box1 pe-xl-5">
				<div class="img5">
					<?php echo logistik_img_tag( array(
							'url'   => esc_url( $settings['image']['url'] ),
						)); ?>
				</div>
				<div class="img6">
					<?php echo logistik_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						)); ?>
				</div>
				<div class="shape3">
					<?php echo logistik_img_tag( array(
							'url'   => esc_url( $settings['image3']['url'] ),
						)); ?>
				</div>
				<div class="about-counter-wrapp">
					<div class="about-counter">
						<h2 class="counter-card_number"><span class="counter-number"><?php echo esc_html($settings['year']); ?></span><?php echo esc_html($settings['after_text']); ?></h2>
						<p class="counter-card_text"><?php echo esc_html($settings['desc']); ?></p>
					</div>
				</div>
			</div>

		<?php elseif( $settings['layout_style'] == '6' ): ?>
			<div class="img-box5 pe-xl-5">
				<div class="img7">
					<div class="about-image">
						<?php echo logistik_img_tag( array(
							'url'   => esc_url( $settings['image']['url'] ),
						)); ?>
						<div class="about-video">
							<a href="<?php echo esc_url( $settings['video_link']['url'] ); ?>" class="white-play-btn popup-video mb-40"><i class="fa-sharp fa-solid fa-play"></i></a>

						</div>
					</div>
				</div>
				<div class="img8">
					<?php echo logistik_img_tag( array(
							'url'   => esc_url( $settings['image2']['url'] ),
						)); ?>
				</div>
				<div class="shape4">
				</div>
				<div class="about-counter-5">
					<div class="about-counter">
						<h2 class="counter-card_number"><span class="counter-number"><?php echo esc_html($settings['year']); ?></span><?php echo esc_html($settings['after_text']); ?></h2>
						<p class="counter-card_text"><?php echo esc_html($settings['desc']); ?></p>
					</div>
				</div>
			</div>

		<?php else: ?>
			<div class="img-box1 pe-xl-5">
				<div class="img1 th-img">
					<?php echo logistik_img_tag( array(
							'url'   => esc_url( $settings['image']['url'] ),
						)); ?>
				</div>
				<div class="about-counter-wrapper">
					<div class="about-content-3">
						<div class="about-counter">
							<h2 class="counter-card_number th-title"><span class="counter-number"><?php echo esc_html($settings['year']); ?></span><?php echo esc_html($settings['after_text']); ?></h2>
							<p class="counter-card_text th-desc"><?php echo esc_html($settings['desc']); ?></p>
						</div>
					</div>
				</div>
			</div>
      
      <?php endif;
	}

}