<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * CTA Widget .
 *
 */
class logistik_Cta extends Widget_Base {

	public function get_name() {
		return 'logistikcta';
	}

	public function get_title() {
		return __( 'CTA', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik' ];
	}


	protected function register_controls() {


		 $this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'CTA', 'logistik' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
				
			]
        );

		$this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Layout Style', 'logistik' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2'  		=> __( 'Style Two', 'logistik' ),					
					'3'  		=> __( 'Style Three', 'logistik' ),					
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label'     => __( 'Image', 'logistik' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
			]
		);

        $this->add_control(
			'image2',
			[
				'label'     => __( 'Image 2', 'logistik' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'condition' => [
					'layout_style' => ['2', '3']
				]
			]
		);

        $this->add_control(
			'video_link',
			[
				'label' 		=> __( 'Video Link', 'tayde' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'tayde' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
                'condition' => [
					'layout_style' => ['3']
				]
			]
		); 

        $this->add_control(
			'subtitle',
            [
				'label'         => __( 'Subtitle', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Subtitle here' , 'logistik' ),
				'label_block'   => true,
				'rows' => '2',
                'condition' => [
					'layout_style' => ['3']
				]
			]
		);

		$this->add_control(
			'title',
            [
				'label'         => __( 'Title', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'title here' , 'logistik' ),
				'label_block'   => true,
				'rows' => '2',
			]
		);
        
		$this->add_control(
			'content',
            [
				'label'         => __( 'Content', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Content here' , 'logistik' ),
				'label_block'   => true,
				'rows' => '4',
			]
		);
    
		$this->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'tayde' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block' => true,
                'default'  	=> __( 'Button Text', 'tayde' ),
			]
        );

        $this->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'tayde' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'tayde' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		); 

        $this->add_control(
			'button_text2',
			[
				'label' 	=> __( 'Button Text 2', 'tayde' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block' => true,
                'default'  	=> __( 'Button Text', 'tayde' ),
			]
        );

        $this->add_control(
			'button_link2',
			[
				'label' 		=> __( 'Link 2', 'tayde' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'tayde' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		); 

        $this->end_controls_section();


        //---------------------------------------
			//Style Section Start
		//---------------------------------------

        //-------------------------------------Subtitle styling-------------------------------------//
        $this->start_controls_section(
            'section_subtitle_style_section',
            [
                'label' => __( 'Subtitle Style', 'logistik' ),
                'tab' 	=> Controls_Manager::TAB_STYLE,
                'condition' => [
					'layout_style' => ['3']
				]
            ]
        );

        $this->add_control(
            'section_subtitle_color',
            [
                'label' 	=> __( 'Color', 'logistik' ),
                'type' 		=> Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .e-subtitle' => 'color: {{VALUE}}!important;',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' 		=> 'section_subtitle_typography',
                'label' 	=> __( 'Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}}  .e-subtitle',
            ]
        );

        $this->add_responsive_control(
            'section_subtitle_margin',
            [
                'label' 		=> __( 'Margin', 'logistik' ),
                'type' 			=> Controls_Manager::DIMENSIONS,
                'size_units' 	=> [ 'px', '%', 'em' ],
                'selectors' 	=> [
                    '{{WRAPPER}}  .e-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'section_subtitle_padding',
            [
                'label' 		=> __( 'Padding', 'logistik' ),
                'type' 			=> Controls_Manager::DIMENSIONS,
                'size_units' 	=> [ 'px', '%', 'em' ],
                'selectors' 	=> [
                    '{{WRAPPER}}  .e-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

		//-------------------------------------Content styling-------------------------------------//
        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Title Style', 'logistik' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'section_title_color',
			[
				'label' 	=> __( 'Color', 'logistik' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .e-title' => 'color: {{VALUE}}!important;',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_title_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}}  .e-title',
			]
		);

        $this->add_responsive_control(
			'section_title_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}}  .e-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'section_title_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}}  .e-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);

        $this->end_controls_section();

        //-------------------------------------Content styling-------------------------------------//
        $this->start_controls_section(
			'section_desc_style_section',
			[
				'label' => __( 'Content Style', 'logistik' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'section_desc_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .e-text' => 'color: {{VALUE}}!important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_desc_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .e-text',
			]
        );

        $this->add_responsive_control(
			'section_desc_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .e-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'section_desc_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .e-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->end_controls_section();

        //-------------------------------------Button styling-------------------------------------//
        $this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Button Style', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn.btn1' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_color_hover',
			[
				'label' 		=> __( 'Hover Color ', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn.btn1:hover' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_color',
			[
				'label' 		=> __( ' Background Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn.btn1' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button_bg_hover_color',
			[
				'label' 		=> __( ' Background Hover Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn.btn1::before, {{WRAPPER}} .as-btn.btn1:after' => 'background-color:{{VALUE}}',
                ],
			]
        );      

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( ' Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .as-btn.btn1',
			]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border',
				'label' 	=> __( 'Border', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .as-btn.btn1',
			]
		);

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border_hover',
				'label' 	=> __( 'Hover Border ', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .as-btn.btn1:hover',
			]
		);

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( ' Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn.btn1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( ' Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn.btn1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( ' Border Radius', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn.btn1' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();

		//---------------------------------------Button Style 2---------------------------------------//
		$this->start_controls_section(
			'button2_style_section',
			[
				'label' 	=> __( 'Button Style 2', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'button2_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn.btn2' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button2_color_hover',
			[
				'label' 		=> __( 'Hover Color ', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn.btn2:hover' => 'color: {{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button2_bg_color',
			[
				'label' 		=> __( ' Background Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn.btn2' => 'background-color:{{VALUE}}',
                ],
			]
        );

        $this->add_control(
			'button2_bg_hover_color',
			[
				'label' 		=> __( ' Background Hover Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn.btn2::before, {{WRAPPER}} .as-btn.btn2:after' => 'background-color:{{VALUE}}',
                ],
			]
        );        
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button2_typography',
				'label' 	=> __( ' Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .as-btn.btn2',
			]
        );

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border2',
				'label' 	=> __( 'Border', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .as-btn.btn2',
			]
		);

        $this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'border2_hover',
				'label' 	=> __( 'Hover Border ', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .as-btn.btn2:hover',
			]
		);

        $this->add_responsive_control(
			'button2_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn.btn2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button2_padding',
			[
				'label' 		=> __( ' Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn.btn2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->add_responsive_control(
			'button2_border_radius',
			[
				'label' 		=> __( ' Border Radius', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .as-btn.btn2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->end_controls_section();
        

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        ?>

        <?php if( $settings['layout_style'] == '2' ): ?>
            <div class="cta-area-three" data-bg-src="<?php echo esc_url( $settings['image']['url']); ?>">
                <div class="row justify-content-between">
                    <div class="col-md-6 col-lg-6">
                        <div class="cta-content">
                            <h2 class="sec-title e-title text-white mt-n2"><?php echo esc_html( $settings['title'] ); ?></h2>
                            <p class="cta-text e-text"><?php echo esc_html( $settings['content'] ); ?></p>
                        </div>
                        <div class="cta-btn2">
                            <a href="<?php echo esc_url( $settings['button_link']['url'] ); ?>" class="as-btn btn1 blue-btn"><?php echo esc_html($settings['button_text']); ?></a>
                            <a href="<?php echo esc_url( $settings['button_link2']['url'] ); ?>" class="as-btn btn2 white-btn"><?php echo esc_html($settings['button_text2']); ?></a>
                        </div>
                    </div>
                    <div class="col-md-6 col-lg-6">
                        <div class="cta-image movingX">
                            <?php echo logistik_img_tag( array(
                                'url'   => esc_url( $settings['image2']['url']  ),
                            )); ?>
                        </div>
                    </div>
                </div>
            </div>

        <?php elseif( $settings['layout_style'] == '3' ): ?>
            <div class="video-area-two top-bg-center " data-bg-src="<?php echo esc_url( $settings['image']['url']); ?>">
                <div class="video-wrapper">
                    <div class="video-box1" data-bg-src="<?php echo esc_url( $settings['image2']['url']); ?>">
                        <img src="<?php echo esc_url( $settings['image2']['url']); ?>" alt="video">
                        <a href="<?php echo esc_url( $settings['video_link']['url'] ); ?>" class="video-play-btn popup-video">
                            <i class="fa-light fa-play"></i></a>
                    </div>
                    <div class="video-text">
                        <div class="title-area mb-0 text-center">
                            <span class="sub-title e-subtitle sub-title2 line-border"><?php echo esc_html( $settings['subtitle'] ); ?></span>
                            <h2 class="sec-title e-title text-white"><?php echo esc_html( $settings['title'] ); ?></h2>
                            <p class="sec-desc e-text text-white"><?php echo esc_html( $settings['content'] ); ?></p>
                            <div class="video-group style2 text-center">
                                <a href="<?php echo esc_url( $settings['button_link']['url'] ); ?>" class="as-btn btn1 gold-btn-2"><?php echo esc_html($settings['button_text']); ?></a>
                                <a href="<?php echo esc_url( $settings['button_link2']['url'] ); ?>" class="as-btn btn2 white-btn"><?php echo esc_html($settings['button_text2']); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
			
    	<?php else: ?>
            <div class="cta-area" data-bg-src="<?php echo esc_url( $settings['image']['url']); ?>">
                <div class="row justify-content-between">
                    <div class="col-xl-12">
                        <h2 class="sec-title e-title cta-title mt-n2"><?php echo esc_html( $settings['title'] ); ?></h2>
                        <p class="cta-desc e-text"><?php echo esc_html( $settings['content'] ); ?></p>
                        <div class="cta-btn text-center">
                            <a href="<?php echo esc_url( $settings['button_link']['url'] ); ?>" class="as-btn btn1"><?php echo esc_html($settings['button_text']); ?></a>
                            <a href="<?php echo esc_url( $settings['button_link2']['url'] ); ?>" class="as-btn btn2 white-btn"><?php echo esc_html($settings['button_text2']); ?></a>
                        </div>
                    </div>
                </div>
            </div>

		<?php endif;

	}

}