
<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Contact Info Widget .
 *
 */
class Logistik_Contact_Info extends Widget_Base {

	public function get_name() {
		return 'logistikcontactinfo';
	}

	public function get_title() {
		return __( 'Contact Info', 'logistik' );
	}


	public function get_icon() {
		return 'themeholy-icon';
    }


	public function get_categories() {
		return [ 'logistik' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'title_section',
			[
				'label' 	=> __( 'Contact Info', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Layout Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2' 		=> __( 'Style Two', 'logistik' ),
					'3' 		=> __( 'Style Three', 'logistik' ),
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label' 		=> __( 'Subtitle Shape', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition' => [
				 	'layout_style' => ['2']
				 ]
			]
		);   

        $this->add_control(
			'section_subtitle',
			[
				'label' 	=> __( 'Section Subtitle', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Subtitle', 'logistik' ),
                'rows' => '2',
				'condition' => [
					'layout_style' => ['2']
				]
			]
        );

		
		$this->add_control(
			'section_title',
			[
				'label' 	=> __( 'Section Title', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Section Title', 'logistik' ),
				'rows' => '2',
				'condition' => [
					'layout_style' => ['2']
				]
			]
        );

		$this->add_control(
			'phone_icon',
            [
				'label' 		=> __( 'Phone Icon', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'layout_style' => ['2']
				]
			]
		);

		$this->add_control(
			'phone_title',
            [
				'label'         => __( 'Phone Label', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Phone' , 'logistik' ),
				'label_block'   => true,
				'rows' 		=> 2,
				'condition' => [
					'layout_style' => ['2']
				]
			]
		);		

		$this->add_control(
			'phone_number',
            [
				'label'         => __( 'Phone Number', 'logistik' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( '+11 (456) 568 65' , 'logistik' ),
				'label_block'   => true,
				'separator' => 'after',
				'condition' => [
					'layout_style' => ['1', '2']
				]
			]
		);

		$this->add_control(
			'email_icon',
            [
				'label' 		=> __( 'Email Icon', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'layout_style' => ['2']
				]
			]
		);	

		$this->add_control(
			'email_title',
            [
				'label'         => __( 'Email Label', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Email' , 'logistik' ),
				'label_block'   => true,
				'rows' 		=> 2,
				'condition' => [
					'layout_style' => ['2']
				]
			]
		);		

        $this->add_control(
			'email_address',
            [
				'label'         => __( 'Email Address', 'logistik' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'info.support@gmail.com' , 'logistik' ),
				'label_block'   => true,
				'separator' => 'after',
				'condition' => [
					'layout_style' => ['1', '2']
				]
			]
		);

		$this->add_control(
			'address_icon',
            [
				'label' 		=> __( 'Address Icon', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'layout_style' => ['2']
				]
			]
		);	

		$this->add_control(
			'address_title',
            [
				'label'         => __( 'Address Label', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Address' , 'logistik' ),
				'label_block'   => true,
				'rows' 		=> 2,
				'condition' => [
					'layout_style' => ['2']
				]
			]
		);		

        $this->add_control(
			'address_name',
            [
				'label'         => __( 'Address Name', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( '3891 Ranchview Dr. Richardson, California 62639' , 'logistik' ),
				'rows' 		=> 3,
				'separator' => 'after',
				'condition' => [
					'layout_style' => ['1', '2']
				]
			]
		);

        $this->add_control(
			'office_time',
            [
				'label'         => __( 'Address Name', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Mon-Fri : 09.00 am-05.00 pm' , 'logistik' ),
				'rows' 		=> 3,
				'condition' => [
					'layout_style' => ['1'] 
				]
			]
		);

		$this->add_control(
			'f_address_icon',
			[
				'label' 		=> __( 'Address Icon', 'logistik' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> '<i class="fa-sharp fa-light fa-map-location-dot"></i>',
				'condition'		=> [ 
					'layout_style' => ['3'] 
				],
			]
		);

		$this->add_control(
			'f_address',
            [
				'label'         => __( 'Address', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( '1901 Thornridge Cir. Shiloh, Hawaii 81063' , 'logistik' ),
				'rows' 		=> 4,
				'condition' => [
					'layout_style' => ['3'] 
				]
			]
		);

		$this->add_control(
			'f_phone_icon',
			[
				'label' 		=> __( 'Phone Icon', 'logistik' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> '<i class="fa-regular fa-phone-arrow-up-right"></i>',
				'condition'		=> [ 
					'layout_style' => ['3'] 
				],
			]
		);

		$this->add_control(
			'f_phone',
			[
				'label' 	=> __( 'Phone Number', 'logistik' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( '+(163)-1202-0088', 'logistik' ),
				'label_block' => true,
				'separator'		=> 'after',
				'condition'		=> [ 
					'layout_style' => ['3']
				],
			]
		);

		$this->add_control(
			'f_phone2',
			[
				'label' 	=> __( 'Phone Number', 'logistik' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( '', 'logistik' ),
				'label_block' => true,
				'separator'		=> 'after',
				'condition'		=> [ 
					'layout_style' => ['3']
				],
			]
		);

		$this->add_control(
			'f_work_icon',
			[
				'label' 		=> __( 'Work Icon', 'logistik' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> '<i class="fa-sharp fa-light fa-calendar-clock"></i>',
				'condition'		=> [ 
					'layout_style' => ['3'] 
				],
			]
		);

		$this->add_control(
			'f_work',
            [
				'label'         => __( 'Work Time', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Mon - Fri 05: PM - 06:AM' , 'logistik' ),
				'rows' 		=> 4,
				'condition' => [
					'layout_style' => ['3'] 
				]
			]
		);

        $this->end_controls_section();

		$this->start_controls_section(
			'social_section',
			[
				'label' 	=> __( 'Social Info', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_style' => ['2']
				]
			]
        );

		$this->add_control(
			'social_label',
            [
				'label'         => __( 'Social Label', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Follow Us' , 'logistik' ),
				'rows' 		=> 3,
				'separator' => 'after',
			]
		);

		$this->add_control(
			'fb_link',
			[
				'label' 		=> esc_html__( 'Facebook Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'twitter_link',
			[
				'label' 		=> esc_html__( 'Twitter Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'pinterest_link',
			[
				'label' 		=> esc_html__( 'Pinterest Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
					
				],
			]
		);

		$this->add_control(
			'linkedin_link',
			[
				'label' 		=> esc_html__( 'Linkedin Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'separator' => 'after',
			]
		);

        $this->end_controls_section();



        //---------------------------------------
			//Style Section Start
		//---------------------------------------

      //---------------------------------------Subtitle Style---------------------------------------//
		$this->start_controls_section(
			'subtitle_style',
			[
				'label' 	=> __( 'Subtitle Style', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_style' => ['2']
				]
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'color: {{VALUE}}',
				],
			]
		);	

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'subtitle_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
				'selector' 	=> '{{WRAPPER}} .th-sub',
			]
		);

		$this->add_responsive_control(
			'subtitle_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'subtitle_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

		//---------------------------------------Title Style---------------------------------------//
		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'tayde' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_style' => ['2']
				]
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Color', 'tayde' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Typography', 'tayde' ),
				'selector' 	=> '{{WRAPPER}} .th-title',
			]
		);
		$this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Margin', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Padding', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		
		$this->end_controls_section();

        /*-----------------------------------------Content styling------------------------------------*/
		$this->start_controls_section(
			'overview_con_styling',
			[
				'label' 	=> __( 'Content Styling', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition' => [
					'layout_style' => ['2']
				]
			]
        );

        $this->start_controls_tabs(
			'style_tabs2'
		);

			$this->start_controls_tab(
				'style_normal_tab2',
				[
					'label' => esc_html__( 'Label', 'logistik' ),
				]
			);

	        $this->add_control(
				'overview_title_color',
				[
					'label' 		=> __( 'Color', 'logistik' ),
					'type' 			=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .contact-info_title'	=> 'color: {{VALUE}}!important;'
					],
				]
	        );

	        $this->add_group_control(
			Group_Control_Typography::get_type(),
			 	[
					'name' 			=> 'overview_title_typography',
			 		'label' 		=> __( 'Typography', 'logistik' ),
			 		'selector' 	=> '{{WRAPPER}} .contact-info_title',
				]
			);

	        $this->add_responsive_control(
				'overview_title_margin',
				[
					'label' 		=> __( 'Margin', 'logistik' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', '%', 'em' ],
					'selectors' 	=> [
						'{{WRAPPER}} .contact-info_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
				]
	        );

			$this->end_controls_tab();

			//--------------------secound--------------------//
			$this->start_controls_tab(
				'style_hover_tab2',
				[
					'label' => esc_html__( 'Content', 'logistik' ),
				]
			);

			$this->add_control(
				'overview_content_color',
				[
					'label' 		=> __( 'Color', 'logistik' ),
					'type' 			=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .contact-info_text, {{WRAPPER}} .contact-info_text a'	=> 'color: {{VALUE}}!important;',
					],
				]
	        );

	        $this->add_group_control(
			Group_Control_Typography::get_type(),
			 	[
					'name' 			=> 'overview_content_typography',
			 		'label' 		=> __( 'Typography', 'logistik' ),
			 		'selector' 	=> '{{WRAPPER}} .contact-info_text',
				]
			);

	        $this->add_responsive_control(
				'overview_content_margin',
				[
					'label' 		=> __( 'Margin', 'logistik' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', '%', 'em' ],
					'selectors' 	=> [
						'{{WRAPPER}} .contact-info_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
	                ],
				]
	        );

			$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

        $email    	= $settings['email_address'];
		$phone    	= $settings['phone_number'];        

		$email          = is_email( $email );

		$replace        = array(' ','-',' - ');
		$replace_phone        = array(' ','-',' - ', '(', ')');
		$with           = array('','','');

		$emailurl       = str_replace( $replace, $with, $email );
		$phoneurl       = str_replace( $replace_phone, $with, $phone );		
        ?>
        <?php if( $settings['layout_style'] == '2' ): 
			
	    	$f_target = $settings['fb_link']['is_external'] ? ' target="_blank"' : '';
			$f_nofollow = $settings['fb_link']['nofollow'] ? ' rel="nofollow"' : '';
			$t_target = $settings['twitter_link']['is_external'] ? ' target="_blank"' : '';
			$t_nofollow = $settings['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';
			$p_target = $settings['pinterest_link']['is_external'] ? ' target="_blank"' : '';
			$p_nofollow = $settings['pinterest_link']['nofollow'] ? ' rel="nofollow"' : '';
			$l_target = $settings['linkedin_link']['is_external'] ? ' target="_blank"' : '';
			$l_nofollow = $settings['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';
		?>
			<div class="contact-info-wrap">
				<div class="title-area">
					<span class="sub-title th-sub">
					<?php 
						if(!empty($settings['image']['url'])){
							echo logistik_img_tag( array(
								'url'   => esc_url( $settings['image']['url']  ),
							));
						} 
		 				echo esc_html( $settings['section_subtitle'] ); 
					?>
					</span>
					<h2 class="sec-title mb-0 th-title"><?php echo esc_html( $settings['section_title'] ); ?></h2>
				</div>
				<div class="contact-info">
					<div class="contact-info_icon">
						<i class="">
							<?php echo logistik_img_tag( array(
									'url'   => esc_url( $settings['address_icon']['url'] ),
								)); ?>
						</i>
					</div>
					<div class="media-body">
						<h4 class="contact-info_title"><?php echo esc_html($settings['address_title']); ?></h4>
						<span class="contact-info_text"><?php echo esc_html($settings['address_name']); ?></span>
					</div>
				</div>
				<div class="contact-info">
					<div class="contact-info_icon">
						<i class="">
							<?php echo logistik_img_tag( array(
									'url'   => esc_url( $settings['phone_icon']['url'] ),
								)); ?>
						</i>
					</div>
					<div class="media-body">
						<h4 class="contact-info_title"><?php echo esc_html($settings['phone_title']); ?></h4>
						<span class="contact-info_text">
							<a href="<?php echo esc_attr( 'tel:'.$phoneurl); ?>"><?php echo esc_html($phone); ?></a>
						</span>
					</div>
				</div>
				<div class="contact-info">
					<div class="contact-info_icon">
						<i class="">
							<?php echo logistik_img_tag( array(
									'url'   => esc_url( $settings['email_icon']['url'] ),
								)); ?>
						</i>
					</div>
					<div class="media-body">
						<h4 class="contact-info_title"><?php echo esc_html($settings['email_title']); ?></h4>
						<span class="contact-info_text">
							<a href="<?php echo esc_attr( 'mailto:'.$emailurl); ?>"><?php echo esc_html($email); ?></a>
						</span>
					</div>
				</div>
				<div class="themeholy-social author-social">
					<h4 class="info-title"><?php echo esc_html($settings['social_label']); ?></h4>
					<?php if( ! empty( $settings['fb_link']['url']) ): ?>
						<a <?php echo wp_kses_post( $f_nofollow.$f_target ); ?> href="<?php echo esc_url( $settings['fb_link']['url'] ); ?>"><i class="fab fa-facebook-f"></i></a>
					<?php endif; ?>

					<?php if( ! empty( $settings['twitter_link']['url']) ): ?>
						<a <?php echo wp_kses_post( $t_nofollow.$t_target ); ?>  href="<?php echo esc_url( $settings['twitter_link']['url'] ); ?>"><i class="fab fa-twitter"></i></a>
					<?php endif; ?>

					<?php if( ! empty( $settings['pinterest_link']['url']) ): ?>
						<a <?php echo wp_kses_post( $p_nofollow.$p_target ); ?>  href="<?php echo esc_url( $settings['pinterest_link']['url'] ); ?>"><i class="fab fa-pinterest-p"></i></a>
					<?php endif; ?>

					<?php if( ! empty( $settings['linkedin_link']['url']) ): ?>
						<a <?php echo wp_kses_post( $l_nofollow.$l_target ); ?>  href="<?php echo esc_url( $settings['linkedin_link']['url'] ); ?>"><i class="fab fa-linkedin-in"></i></a>
					<?php endif; ?>
				</div>
			</div>

		<?php elseif( $settings['layout_style'] == '3' ): 
			$f_phone    	= $settings['f_phone'];        
			$f_phone2    	= $settings['f_phone2'];        
			$replace_phone        = array(' ','-',' - ', '(', ')');
			$with           = array('','','');
			$phoneurl1       = str_replace( $replace_phone, $with, $f_phone );	
			$phoneurl2       = str_replace( $replace_phone, $with, $f_phone2 );	
		?>
			<div class="footer-icon-wrapper">
				<div class="footer-info">
					<div class="footer-icon">
						<?php echo wp_kses_post($settings['f_address_icon']); ?>
					</div>
					<div class="media-body">
						<p class="footer-info_link"><?php echo wp_kses_post($settings['f_address']); ?></p>
					</div>
				</div>
				<div class="footer-info">
					<div class="footer-icon">
						<?php echo wp_kses_post($settings['f_phone_icon']); ?>
					</div>
					<div class="media-body">
						<p class="footer-info_link"><a href="<?php echo esc_attr( 'tel:'.$phoneurl1); ?>"><?php echo esc_html($f_phone); ?></a></p>
						<p class="footer-info_link"><a href="<?php echo esc_attr( 'tel:'.$phoneurl2); ?>"><?php echo esc_html($f_phone2); ?></a></p>
					</div>
				</div>
				<div class="footer-info">
					<div class="footer-icon">
						<?php echo wp_kses_post($settings['f_work_icon']); ?>
					</div>
					<div class="media-body">
						<p class="footer-info_link"><?php echo wp_kses_post($settings['f_work']); ?></p>
					</div>
				</div>
			</div>

        <?php else: ?>
            <div class="themeholy-widget-contact">
                <div class="info-box">
                    <p class="info-box_text">
                        <?php echo esc_html($settings['address_name']); ?>
                    </p>
                </div>
                <div class="info-box">
                    <p class="info-box_text">
                        <?php echo esc_html($settings['office_time']); ?>
                    </p>
                </div>
                <div class="info-box">
                    <p class="info-box_text">
                        <a class="info-box_link" href="<?php echo esc_attr( 'tel:'.$phoneurl); ?>"><?php echo esc_html($phone); ?></a>
                    </p>
                </div>
                <div class="info-box">
                    <p class="info-box_text">
                        <a class="info-box_link" href="<?php echo esc_attr( 'mailto:'.$emailurl); ?>"><?php echo esc_html($email); ?></a>
                    </p>
                </div>
            </div>

        <?php  endif;

	}

}
