<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
/**
 *
 * Brand Logo Widget .
 *
 */
class logistik_Brand_Logo extends Widget_Base {

	public function get_name() {
		return 'logistikbrandlogo';
	}

	public function get_title() {
		return __( 'Brand Logo', 'logistik' );
	}


	public function get_icon() {
		return 'themeholy-icon';
    }


	public function get_categories() {
		return [ 'logistik' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'client_logo_section',
			[
				'label' 	=> __( 'Brand Logo', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );


		$this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Layout Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					// '2' 		=> __( 'Style Two', 'logistik' ),
				],
			]
		);

        $repeater = new Repeater();

		$repeater->add_control(
			'client_logo',
			[
				'label' 	=> __( 'Client Logo', 'logistik' ),
				'type' 		=> Controls_Manager::MEDIA,
				'default' => [
					'url' 	=> Utils::get_placeholder_image_src(),
				],
			]
		);		

		$this->add_control(
			'logos',
			[
				'label' 		=> __( 'Client Logos', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
					[
						'client_logo' => Utils::get_placeholder_image_src(),
					],
				]
			]
		);

        $this->end_controls_section();

		  //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------------------------------------Genearl styling-------------------------------------//

        $this->start_controls_section(
			'general_section',
			[
				'label' => __( ' General Style', 'logistik' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			
			]
		);

		 $this->add_control(
			'general_color',
			[
				'label' 	=> __( 'Background', 'logistik' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .e-brand-wrap' => 'background-color: {{VALUE}}!important;',
                ],
			]
        );	

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'general_border',
				'label' 	=> __( 'Border', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .e-brand-wrap',
			]
		);

		 $this->add_responsive_control(
			'general_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .e-brand-wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);

		$this->end_controls_section();

	}

	protected function render() {

	    $settings = $this->get_settings_for_display();
	    ?>
	    
	    <?php if( $settings['layout_style'] == '2' ): ?>


	    <?php else: ?>
			<div class="client-table-wrapper">
				<?php foreach( $settings['logos'] as $data ): ?>
				<div class="client-image">
					<?php echo logistik_img_tag( array(
			                'url'   => esc_url( $data['client_logo']['url'] ),
			            ) ); ?>
				</div>
				<?php endforeach; ?>
			</div>

    <?php endif;

	}
}