<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Utils;
/**
 *
 * Blog Post Widget .
 *
 */
class logistik_Blog extends Widget_Base {

	public function get_name() {
		return 'logistikblog';
	}

	public function get_title() {
		return __( 'Blog Post', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'blog_post_section',
			[
				'label' => __( 'Blog Post', 'logistik' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Layout Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2' 		=> __( 'Style Two', 'logistik' ),
					'3' 		=> __( 'Style Three', 'logistik' ),
					'4' 		=> __( 'Style Four', 'logistik' ),
					'5' 		=> __( 'Style Five', 'logistik' ),
				],
				'separator' => 'after'
			]
		);

        $this->add_control(
			'blog_post_count',
			[
				'label' 	=> __( 'No of Post to show', 'logistik' ),
                'type' 		=> Controls_Manager::NUMBER,
                'min'       => 1,
                'max'       => count( get_posts( array('post_type' => 'post', 'post_status' => 'publish', 'fields' => 'ids', 'posts_per_page' => '-1') ) ),
                'default'  	=> __( '4', 'logistik' )
			]
        );

		$this->add_control(
			'title_count',
			[
				'label' 	=> __( 'Title Length', 'logistik' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __( '5', 'logistik' ),
			]
		);

		$this->add_control(
			'excerpt_count',
			[
				'label' 	=> __( 'Excerpt Length', 'logistik' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> __( '16', 'logistik' ),
			]
		);

        $this->add_control(
			'blog_post_order',
			[
				'label' 	=> __( 'Order', 'logistik' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ASC'   	=> __('ASC','logistik'),
                    'DESC'   	=> __('DESC','logistik'),
                ],
                'default'  	=> 'DESC'
			]
        );

        $this->add_control(
			'blog_post_order_by',
			[
				'label' 	=> __( 'Order By', 'logistik' ),
                'type' 		=> Controls_Manager::SELECT,
                'options'   => [
                    'ID'    	=> __( 'ID', 'logistik' ),
                    'author'    => __( 'Author', 'logistik' ),
                    'title'    	=> __( 'Title', 'logistik' ),
                    'date'    	=> __( 'Date', 'logistik' ),
                    'rand'    	=> __( 'Random', 'logistik' ),
                ],
                'default'  	=> 'ID'
			]
        );

        $this->add_control(
			'exclude_cats',
			[
				'label' 		=> __( 'Exclude Categories', 'logistik' ),
                'type' 			=> Controls_Manager::SELECT2,
                'multiple' 		=> true,
				'options' 		=> $this->logistik_get_categories(),
			]
        );

        $this->add_control(
			'exclude_tags',
			[
				'label' 		=> __( 'Exclude Tags', 'logistik' ),
                'type' 			=> Controls_Manager::SELECT2,
                'multiple' 		=> true,
				'options' 		=> $this->logistik_get_tags(),
			]
        );

        $this->add_control(
			'exclude_post_id',
			[
				'label'         => __( 'Exclude Post', 'logistik' ),
                'type'          => Controls_Manager::SELECT2,
                'multiple'      => true,
				'options'       => $this->logistik_post_id(),
			]
        );

        $this->add_control(
			'read_more',
			[
				'label' 	=> __( 'Read More Text', 'logistik' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> __( 'Read More', 'logistik' ),
			]
        );

        $this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//---------------------------------------

		//---------------------------------------Title Style---------------------------------------//
		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'tayde' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Color', 'tayde' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_control(
			'title_h_color',
			[
				'label' 		=> __( 'Hover Color', 'tayde' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-title a:hover' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Typography', 'tayde' ),
				'selector' 	=> '{{WRAPPER}} .th-title',
			]
		);
		$this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Margin', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Padding', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->end_controls_section();

		//---------------------------------------Description Style---------------------------------------//
		$this->start_controls_section(
			'desc_style',
			[
				'label' 	=> __( 'Description Style', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'desc_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
				'selector' 	=> '{{WRAPPER}} .th-desc',
			]
		);

		$this->add_responsive_control(
			'desc_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'desc_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

		/*-----------------------------------------Button styling------------------------------------*/
		$this->start_controls_section(
			'layout_style_section',
			[
				'label' 	=> __( 'Button Style', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => '--title-color: {{VALUE}}',
				],
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		$this->add_control(
			'button_h_color',
			[
				'label' 		=> __( 'Hover Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:hover' => '--theme-color-2: {{VALUE}}',
				],
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		$this->add_control(
			'button_color2',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => '--theme-color-2: {{VALUE}}',
				],
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);

		$this->add_control(
			'button_h_color2',
			[
				'label' 		=> __( 'Hover Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:hover' => '--title-color: {{VALUE}}',
				],
				'condition'	=> [
					'layout_style' => ['2']
				]
			]
		);

		$this->add_control(
			'button_color3',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => '--white-color: {{VALUE}}',
				],
				'condition'	=> [
					'layout_style' => ['3']
				]
			]
		);

		$this->add_control(
			'button_h_color3',
			[
				'label' 		=> __( 'Hover Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:hover' => '--theme-color: {{VALUE}}',
				],
				'condition'	=> [
					'layout_style' => ['3']
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .th-btn',
			]
        );

		$this->end_controls_section();

    }

    public function logistik_get_categories() {
        $cats = get_terms(array(
            'taxonomy' => 'category',
            'hide_empty' => true,
        ));

        $catarr = [];

        foreach( $cats as $singlecat ) {
            $catarr[$singlecat->term_id] = __($singlecat->name,'logistik');
        }

        return $catarr;
    }

    public function logistik_get_tags() {
        $cats = get_terms(array(
            'taxonomy' => 'post_tag',
            'hide_empty' => true,
        ));

        $catarr = [];

        foreach( $cats as $singlecat ) {
            $catarr[$singlecat->term_id] = __($singlecat->name,'logistik');
        }

        return $catarr;
    }

    // Get Specific Post
    public function logistik_post_id(){
        $args = array(
            'post_type'         => 'post',
            'posts_per_page'    => -1,
        );

        $logistik_post = new WP_Query( $args );

        $postarray = [];

        while( $logistik_post->have_posts() ){
            $logistik_post->the_post();
            $postarray[get_the_Id()] = get_the_title();
        }
        wp_reset_postdata();
        return $postarray;
    }

	protected function render() {

        $settings = $this->get_settings_for_display();
        $exclude_post = $settings['exclude_post_id'];

        if( !empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats']
            );
        } elseif( !empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'tag__not_in'           => $settings['exclude_tags']
            );
        }elseif( !empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'tag__not_in'           => $settings['exclude_tags'],
                'post__not_in'          => $exclude_post
            );
        } elseif( !empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'category__not_in'      => $settings['exclude_cats'],
                'post__not_in'          => $exclude_post
            );
        } elseif( empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'tag__not_in'           => $settings['exclude_tags'],
                'post__not_in'          => $exclude_post
            );
        } elseif( empty( $settings['exclude_cats'] ) && !empty( $settings['exclude_tags'] ) && empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'tag__not_in'           => $settings['exclude_tags'],
            );
        } elseif( empty( $settings['exclude_cats'] ) && empty( $settings['exclude_tags'] ) && !empty( $settings['exclude_post_id'] ) ) {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true,
                'post__not_in'          => $exclude_post
            );
        } else {
            $args = array(
                'post_type'             => 'post',
                'posts_per_page'        => esc_attr( $settings['blog_post_count'] ),
                'order'                 => esc_attr( $settings['blog_post_order'] ),
                'orderby'               => esc_attr( $settings['blog_post_order_by'] ),
                'ignore_sticky_posts'   => true
            );
        }


    $blogpost = new WP_Query( $args );
?>
	<?php if( $settings['layout_style'] == '2' ): ?>
	<div class="row slider-shadow themeholy-carousel arrow-wrap" id="blogSlide1" data-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-arrows="true">
		<?php  
			while( $blogpost->have_posts() ): 
			$blogpost->the_post(); 
			$categories = get_the_category();
		?>
		<div class="col-md-6 col-xl-4">
			<div class="blog-grid">
				<div class="blog-img">
					<?php the_post_thumbnail( 'logistik_414X273' ); ?>
				</div>
				<div class="blog-grid_content">
					<div class="blog-meta">
						<span class="date"><?php echo esc_html( get_the_date( 'd M' ) ) ?></span>
						<a href="<?php echo esc_url( get_permalink() ); ?>"><i class="fa-regular fa-comments"></i>
							<?php 
                                if(get_comments_number() == 1){
                                    echo esc_html__('Comment(', 'logistik'); 
                                }else{
                                    echo esc_html__('Comments(', 'logistik'); 
                                }
                                echo get_comments_number(); ?>)
						</a>
					</div>
					<h3 class="blog-title box-title th-title"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ); ?></a></h3>
					<p class="blog-desc th-desc"><?php echo esc_html( wp_trim_words( get_the_content( ), $settings['excerpt_count'], '' ) ) ?></p>
					<?php  if(!empty($settings['read_more'])): ?>
						<a href="<?php echo esc_url( get_permalink() ); ?>" class="line-btn th-btn"><?php echo esc_html($settings['read_more']); ?><i class="fa-solid fa-arrow-right"></i></a>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<?php endwhile; wp_reset_postdata();  ?>
	</div>

	<?php elseif( $settings['layout_style'] == '3' ): ?>
	<div class="row slider-shadow themeholy-carousel arrow-wrap" id="blogSlide3" data-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-arrows="true">
		<?php  
			while( $blogpost->have_posts() ): 
			$blogpost->the_post(); 
			$categories = get_the_category();
		?>
		<div class="col-md-6 col-xl-4">
			<div class="blog-box">
				<div class="blog-img">
					<?php the_post_thumbnail( 'logistik_414X454' ); ?>
					<div class="blog-meta">
						<span class="date"><?php echo esc_html( get_the_date( 'd F' ) ) ?></span>
					</div>
					<div class="blog-box_content">
						<h3 class="blog-title box-title th-title"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ); ?></a></h3>
						<?php  if(!empty($settings['read_more'])): ?>
							<a href="<?php echo esc_url( get_permalink() ); ?>" class="line-btn th-btn"><?php echo esc_html($settings['read_more']); ?><i class="fa-solid fa-arrow-right"></i></a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
		<?php endwhile; wp_reset_postdata();  ?>
	</div>

	<?php elseif( $settings['layout_style'] == '4' ): ?>
		<div class="row slider-shadow themeholy-carousel arrow-wrap" id="blogSlide3" data-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-arrows="true">
			<?php  
				while( $blogpost->have_posts() ): 
				$blogpost->the_post(); 
				$categories = get_the_category();
			?>
			<div class="col-md-6 col-xl-4">
				<div class="blog-card style2">
					<div class="blog-img">
						<?php the_post_thumbnail( 'logistik_384X303' ); ?>
						<div class="blog-card_wrapper">
							<span class="blog-card_date"><?php echo esc_html( get_the_date( 'd' ) ) ?></span>
							<span class="blog-card_month"><?php echo esc_html( get_the_date( 'M' ) ) ?></span>
						</div>
					</div>
					<div class="blog-card-content">
						<div class="blog-meta">
							<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta('ID') ) ); ?>"><i class="fa-regular fa-user"></i><?php echo esc_html__('By-', 'logistik'); ?><?php echo esc_html( ucwords( get_the_author() ) ); ?></a>
							<a href="<?php echo esc_url( get_permalink() ); ?>"><i class="fa-regular fa-comments"></i>
								<?php 
									if(get_comments_number() == 1){
										echo esc_html__('Comment(', 'logistik'); 
									}else{
										echo esc_html__('Comments(', 'logistik'); 
									}
									echo get_comments_number(); ?>)
							</a>
						</div>
						<h3 class="box-title th-title"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ); ?></a></h3>
						<a href="<?php echo esc_url( get_permalink() ); ?>" class="half-line-btn"><?php echo esc_html($settings['read_more']); ?><i class="fa-solid fa-arrow-right ms-2"></i></a>
					</div>
				</div>
			</div>
			<?php endwhile; wp_reset_postdata();  ?>
		</div>

	<?php elseif( $settings['layout_style'] == '5' ): ?>
	<div class="row slider-shadow themeholy-carousel arrow-wrap" id="blogSlide1" data-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-arrows="true">
		<?php  
			while( $blogpost->have_posts() ): 
			$blogpost->the_post(); 
			$categories = get_the_category();
		?>
		<div class="col-md-6 col-xl-4">
			<div class="blog-grid style2">
				<div class="blog-grid_content">
					<div class="blog-meta">
						<span class="date"><?php echo esc_html( get_the_date( 'd M' ) ) ?></span>
						<a href="<?php echo esc_url( get_permalink() ); ?>"><i class="fa-regular fa-comments"></i>
							<?php 
                                if(get_comments_number() == 1){
                                    echo esc_html__('Comment(', 'logistik'); 
                                }else{
                                    echo esc_html__('Comments(', 'logistik'); 
                                }
                                echo get_comments_number(); ?>)
						</a>
					</div>
					<h3 class="blog-title box-title th-title"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ); ?></a></h3>
					<?php  if(!empty($settings['read_more'])): ?>
						<a href="<?php echo esc_url( get_permalink() ); ?>" class="line-btn th-btn"><?php echo esc_html($settings['read_more']); ?><i class="fa-solid fa-arrow-right"></i></a>
					<?php endif; ?>
				</div>
				<div class="blog-img">
					<?php the_post_thumbnail( 'logistik_414X273' ); ?>
				</div>
			</div>
		</div>
		<?php endwhile; wp_reset_postdata();  ?>
	</div>

		
	<?php else: ?>
	<div class="row slider-shadow themeholy-carousel arrow-wrap" id="blogSlide1" data-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-arrows="true">
		<?php  
			while( $blogpost->have_posts() ): 
			$blogpost->the_post(); 
			$categories = get_the_category();
		?>
		<div class="col-md-6 col-xl-4">
			<div class="blog-card">
				<div class="blog-img">
					<?php the_post_thumbnail( 'logistik_414X273' ); ?>
				</div>
				<div class="blog-card_wrapper">
					<span class="blog-card_date"><?php echo esc_html( get_the_date( 'd' ) ) ?></span>
					<span class="blog-card_month"><?php echo esc_html( get_the_date( 'M' ) ) ?></span>
				</div>
				<div class="blog-card-content">
					<div class="blog-meta">
						<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta('ID') ) ); ?>"><i class="fa-regular fa-user"></i><?php echo esc_html__('By-', 'logistik'); ?><?php echo esc_html( ucwords( get_the_author() ) ); ?></a>
						<a href="<?php echo esc_url( get_permalink() ); ?>"><i class="fa-regular fa-comments"></i>
							<?php 
                                if(get_comments_number() == 1){
                                    echo esc_html__('Comment(', 'logistik'); 
                                }else{
                                    echo esc_html__('Comments(', 'logistik'); 
                                }
                                echo get_comments_number(); ?>)
						</a>
					</div>
					<h3 class="blog-title box-title th-title"><a href="<?php echo esc_url( get_permalink() ); ?>"><?php echo esc_html( wp_trim_words( get_the_title( ), $settings['title_count'], '' ) ); ?></a></h3>
					<?php  if(!empty($settings['read_more'])): ?>
						<a href="<?php echo esc_url( get_permalink() ); ?>" class="line-btn th-btn"><?php echo esc_html($settings['read_more']); ?><i class="fa-solid fa-arrow-right"></i></a>
					<?php endif; ?>
				</div>
			</div>
		</div>
		<?php endwhile; wp_reset_postdata();  ?>
	</div>
	
	<?php endif; 
      
	}
}