<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * About Info Widget .
 *
 */
class Logistik_About_Info extends Widget_Base {

	public function get_name() {
		return 'logistikaboutinfo';
	}

	public function get_title() {
		return __( 'About Info', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik' ];
	}


	protected function register_controls() {


		 $this->start_controls_section(
			'section_title_section',
			[
				'label'		 	=> __( 'About Info', 'logistik' ),
				'tab' 			=> Controls_Manager::TAB_CONTENT,
				
			]
        );

		$this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Layout Style', 'logistik' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'logistik' ),				
					'2'  		=> __( 'Style Two', 'logistik' ),				
					'3'  		=> __( 'Style Three', 'logistik' ),				
					'4'  		=> __( 'Style Four', 'logistik' ),				
					'5'  		=> __( 'Style Five', 'logistik' ),				
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label'     => __( 'Image', 'logistik' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'condition' => [
					'layout_style' => ['1', '2', '3', '4']
				]
			]
		);

		$this->add_control(
			'image2',
			[
				'label'     => __( 'Image 2', 'logistik' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic'   => [
					'active' => true,
				],
				'condition' => [
					'layout_style' => ['2', '4']
				]
			]
		);

		$this->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'logistik' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block' => true,
                'default'  	=> __( 'Button Text', 'logistik' ),
				'condition' => [
					'layout_style' => ['2', '3']
				]
			]
        );

        $this->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition' => [
					'layout_style' => ['2', '3']
				]
			]
		);

		$this->add_control(
			'title',
            [
				'label'         => __( 'Title', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Title here' , 'logistik' ),
				'label_block'   => true,
				'rows' => '4',
				'condition' => [
					'layout_style' => ['3', '4', '5']
				]
			]
		);

		$this->add_control(
			'desc',
            [
				'label'         => __( 'Description', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Description here' , 'logistik' ),
				'label_block'   => true,
				'rows' => '4',
				'condition' => [
					'layout_style' => ['1', '3', '4', '5']
				]
			]
		);

        $repeater = new Repeater();

        $repeater->add_control(
			'social_icon',
            [
				'label'         => __( 'Social Icon', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( '<i class="fab fa-facebook-f"></i>' , 'logistik' ),
				'label_block'   => true,
				'rows' => '4',
			]
		);


        $repeater->add_control(
			'social_link',
			[
				'label' 		=> esc_html__( 'Social Link', 'souler' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'souler' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

        $this->add_control(
			'social_lists',
			[
				'label' 		=> __( 'Social Lists', 'souler' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'condition' => [
					'layout_style' => ['1', '5']
				]
			]
		);


        $this->end_controls_section();


        //---------------------------------------
			//Style Section Start
		//---------------------------------------

        //-------------------------------------Content styling-------------------------------------//
        $this->start_controls_section(
			'section_desc_style_section',
			[
				'label' => __( 'Content Style', 'logistik' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'section_desc_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .about-text' => 'color: {{VALUE}}!important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_desc_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .about-text',
			]
        );

        $this->add_responsive_control(
			'section_desc_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .about-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'section_desc_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .about-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->end_controls_section();

	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        ?>

        <?php if( $settings['layout_style'] == '2' ): ?>
			<div class="btn-group style2">
				<a href="<?php echo esc_url( $settings['button_link']['url'] ); ?>" class="themeholy-btn"><?php echo wp_kses_post($settings['button_text']); ?></a>
				<div class="about-profile">
					<div class="about-avater">
						<?php echo logistik_img_tag( array(
								'url'   => esc_url( $settings['image']['url']  ),
							)); ?>
					</div>
					<div class="media-body">
						<?php echo logistik_img_tag( array(
								'url'   => esc_url( $settings['image2']['url']  ),
							)); ?>
					</div>
				</div>
			</div>

        <?php elseif( $settings['layout_style'] == '3' ): ?>
			<div class="btn-group mt-45">
				<a href="<?php echo esc_url( $settings['button_link']['url'] ); ?>" class="themeholy-btn"><?php echo wp_kses_post($settings['button_text']); ?></a>
				<div class="about-profile">
					<div class="about-avater">
						<?php echo logistik_img_tag( array(
								'url'   => esc_url( $settings['image']['url']  ),
							)); ?>
					</div>
					<div class="media-body">
						<h6 class="title"><?php echo esc_html( $settings['title'] ); ?></h6>
						<span class="desig"><?php echo esc_html( $settings['desc'] ); ?></span>
					</div>
				</div>
            </div>

        <?php elseif( $settings['layout_style'] == '4' ): ?>
			<div class="profile-wrap">
				<div class="about-profile style2">
					<div class="avater">
						<?php echo logistik_img_tag( array(
								'url'   => esc_url( $settings['image']['url']  ),
							)); ?>
					</div>
					<div class="media-body">
						<h6 class="title"><?php echo esc_html( $settings['title'] ); ?></h6>
						<span class="desig"><?php echo esc_html( $settings['desc'] ); ?></span>
					</div>
				</div>
				<div class="signature">
						<?php echo logistik_img_tag( array(
							'url'   => esc_url( $settings['image2']['url']  ),
						)); ?>
				</div>
			</div>

		<?php elseif( $settings['layout_style'] == '5' ): ?>
			<div class="widget footer-widget">
				<h3 class="widget_title"><?php echo esc_html( $settings['title'] ); ?></h3>
				<div class="themeholy-widget-about">
					<p class="about-text"><?php echo esc_html( $settings['desc'] ); ?></p>
					<div class="themeholy-social">
						<?php foreach( $settings['social_lists'] as $data ):?>
                            <a href="<?php echo esc_url( $data['social_link']['url'] ); ?>"><?php echo wp_kses_post($data['social_icon']) ?></a>
                        <?php endforeach; ?>
					</div>
				</div>
			</div>

    	<?php else: ?>
          	<div class="widget footer-widget">
                <div class="themeholy-widget-about">
                    <div class="about-logo">
                        <a href="index.html">
                            <?php echo logistik_img_tag( array(
									'url'   => esc_url( $settings['image']['url']  ),
								)); ?>
                        </a>
                    </div>
                    <p class="about-text"><?php echo esc_html( $settings['desc'] ); ?></p>
                    <div class="themeholy-social">
                        <?php foreach( $settings['social_lists'] as $data ):?>
                            <a href="<?php echo esc_url( $data['social_link']['url'] ); ?>"><?php echo wp_kses_post($data['social_icon']) ?></a>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>

		<?php endif;

	}

}
