<?php
/**
 * @Packge     : Logistik
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeholy.com/
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    if( class_exists( 'ReduxFramework' ) && defined('ELEMENTOR_VERSION') ) {
        if( is_page() || is_page_template('template-builder.php') ) {
            $logistik_post_id = get_the_ID();

            // Get the page settings manager
            $logistik_page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );

            // Get the settings model for current post
            $logistik_page_settings_model = $logistik_page_settings_manager->get_model( $logistik_post_id );

            // Retrieve the color we added before
            $logistik_header_style = $logistik_page_settings_model->get_settings( 'logistik_header_style' );
            $logistik_header_builder_option = $logistik_page_settings_model->get_settings( 'logistik_header_builder_option' );

            if( $logistik_header_style == 'header_builder'  ) {

                if( !empty( $logistik_header_builder_option ) ) {
                    $logistikheader = get_post( $logistik_header_builder_option );
                    echo '<header class="header">';
                        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $logistikheader->ID );
                    echo '</header>';
                }
            } else {
                // global options
                $logistik_header_builder_trigger = logistik_opt('logistik_header_options');
                if( $logistik_header_builder_trigger == '2' ) {
                    echo '<header>';
                    $logistik_global_header_select = get_post( logistik_opt( 'logistik_header_select_options' ) );
                    $header_post = get_post( $logistik_global_header_select );
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $header_post->ID );
                    echo '</header>';
                } else {
                    // wordpress Header
                    logistik_global_header_option();
                }
            }
        } else {
            $logistik_header_options = logistik_opt('logistik_header_options');
            if( $logistik_header_options == '1' ) {
                logistik_global_header_option();
            } else {
                $logistik_header_select_options = logistik_opt('logistik_header_select_options');
                $logistikheader = get_post( $logistik_header_select_options );
                echo '<header class="header">';
                    echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $logistikheader->ID );
                echo '</header>';
            }
        }
    } else {
        logistik_global_header_option();
    }