<?php
/**
 * @Packge     : Logistik
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeholy.com/
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }

    logistik_setPostViews( get_the_ID() );

    ?>
    <div <?php post_class(); ?>>
    <?php
        if( class_exists('ReduxFramework') ) {
            $logistik_post_details_title_position = logistik_opt('logistik_post_details_title_position');
        } else {
            $logistik_post_details_title_position = 'header';
        }

        $allowhtml = array(
            'p'         => array(
                'class'     => array()
            ),
            'span'      => array(),
            'a'         => array(
                'href'      => array(),
                'title'     => array()
            ),
            'br'        => array(),
            'em'        => array(),
            'strong'    => array(),
            'b'         => array(),
        );
        // Blog Post Thumbnail
        do_action( 'logistik_blog_post_thumb' );
        
        echo '<div class="blog-content">';

            // Blog Post Meta
            do_action( 'logistik_blog_post_meta' );

            if( $logistik_post_details_title_position != 'header' ) {
                echo '<h2 class="blog-title">'.wp_kses( get_the_title(), $allowhtml ).'</h2>';
            }

            if( get_the_content() ){

                the_content();
                // Link Pages
                logistik_link_pages();
            }

            if( class_exists('ReduxFramework') ) {
                $logistik_post_details_share_options = logistik_opt('logistik_post_details_share_options');
                $logistik_display_post_tags = logistik_opt('logistik_display_post_tags');
                $logistik_author_options = logistik_opt('logistik_post_details_author_desc_trigger');
            } else {
                $logistik_post_details_share_options = false;
                $logistik_display_post_tags = false;
                $logistik_author_options = false;
            }
            
            $logistik_post_tag = get_the_tags();
            
            if( ! empty( $logistik_display_post_tags ) || ( ! empty($logistik_post_details_share_options )) ){
                echo '<div class="share-links clearfix">';
                    echo '<div class="row justify-content-between">';
                        if( is_array( $logistik_post_tag ) && ! empty( $logistik_post_tag ) ){
                            if( count( $logistik_post_tag ) > 1 ){
                                $tag_text = __( 'Tags:', 'logistik' );
                            }else{
                                $tag_text = __( 'Tag:', 'logistik' );
                            }
                            if($logistik_display_post_tags){
                                echo '<div class="col-sm-auto">';
                                    echo '<span class="share-links-title">'.$tag_text.'</span>';
                                    echo '<div class="tagcloud">';
                                        foreach( $logistik_post_tag as $tags ){
                                            echo '<a href="'.esc_url( get_tag_link( $tags->term_id ) ).'">'.esc_html( $tags->name ).'</a>';
                                        }
                                    echo '</div>';
                                echo '</div>';
                            }
                        }
    
                        /**
                        *
                        * Hook for Blog Details Share Options
                        *
                        * Hook logistik_blog_details_share_options
                        *
                        * @Hooked logistik_blog_details_share_options_cb 10
                        *
                        */
                        do_action( 'logistik_blog_details_share_options' );
                    echo '</div>';
                echo '</div>';
    
            }    

            
        echo '</div>';


    echo '</div>'; 

        /**
        *
        * Hook for Blog Details Comments
        *
        * Hook logistik_blog_details_comments
        *
        * @Hooked logistik_blog_details_comments_cb 10
        *
        */
        do_action( 'logistik_blog_details_comments' );
