<?php
// Block direct access
if( !defined( 'ABSPATH' ) ){
    exit();
}
/**
 * @Packge     : Logistik
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeholy.com/
 *
 */

// enqueue css
function logistik_common_custom_css(){
	wp_enqueue_style( 'logistik-color-schemes', get_template_directory_uri().'/assets/css/color.schemes.css' );

    $CustomCssOpt  = logistik_opt( 'logistik_css_editor' );
	if( $CustomCssOpt ){
		$CustomCssOpt = $CustomCssOpt;
	}else{
		$CustomCssOpt = '';
	}

    $customcss = "";
    
    if( get_header_image() ){
        $logistik_header_bg =  get_header_image();
    }else{
        if( logistik_meta( 'page_breadcrumb_settings' ) == 'page' ){
            if( ! empty( logistik_meta( 'breadcumb_image' ) ) ){
                $logistik_header_bg = logistik_meta( 'breadcumb_image' );
            }
        }
    }
    
    if( !empty( $logistik_header_bg ) ){
        $customcss .= ".breadcumb-wrapper{
            background-image:url('{$logistik_header_bg}')!important;
        }";
    }
    
	// theme color
	$logistikthemecolor = logistik_opt('logistik_theme_color');

    list($r, $g, $b) = sscanf( $logistikthemecolor, "#%02x%02x%02x");

    $logistik_real_color = $r.','.$g.','.$b;
	if( !empty( $logistikthemecolor ) ) {
		$customcss .= ":root {
		  --theme-color: rgb({$logistik_real_color});
		}";
	}

    // theme color 2
	$logistikthemecolor2 = logistik_opt('logistik_theme_color2');

    list($r, $g, $b) = sscanf( $logistikthemecolor2, "#%02x%02x%02x");

    $logistik_real_color2 = $r.','.$g.','.$b;
	if( !empty( $logistikthemecolor2 ) ) {
		$customcss .= ":root {
         --theme-color-2: rgb({$logistik_real_color2});
		}";
	}

	if( !empty( $CustomCssOpt ) ){
		$customcss .= $CustomCssOpt;
	}

    wp_add_inline_style( 'logistik-color-schemes', $customcss );
}
add_action( 'wp_enqueue_scripts', 'logistik_common_custom_css', 100 );