<?php
/**
 * @Packge     : Logistik
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeholy.com/
 *
 */

    // Block direct access
    if( ! defined( 'ABSPATH' ) ){
        exit();
    }


    // preloader hook function
    if( ! function_exists( 'logistik_preloader_wrap_cb' ) ) {
        function logistik_preloader_wrap_cb() {
            $preloader_display              =  logistik_opt('logistik_display_preloader');
            ?>
            <div class="themeholy-cursor"></div>
            <?php
            if( class_exists('ReduxFramework') ){
                if( $preloader_display ){?>
                    <div class="preloader">
                        <button class="themeholy-btn style4 preloaderCls"><?php echo esc_html__( 'Cancel Preloader', 'logistik' ) ?></button>
                        <div class="preloader-inner">
                            <div class="loader">
                                <div class="loader-ring"></div>

                                    <div class="rocket-wrapper">
                                        <div class="trail-wrapper">
                                            <?php echo logistik_img_tag( array(
                                                'url'   => esc_url( logistik_opt( 'logistik_preloader_img','url' ) ),
                                                'class' => 'trail',
                                            ) );   ?>
                                        </div>
                                        <?php echo logistik_img_tag( array(
                                            'url'   => esc_url( logistik_opt( 'logistik_preloader_img2','url' ) ),
                                            'class' => 'rocket',
                                        ) );   ?>
                                    </div>
                            </div>
                        </div>
                    </div>
                <?php }
            }else{ ?>
                <div class="preloader">
                    <button class="themeholy-btn style4 preloaderCls"><?php echo esc_html__( 'Cancel Preloader', 'logistik' ) ?></button>
                    <div class="preloader-inner">
                        <span class="loader"></span>
                    </div>
                </div>
            <?php }
        }
    }

    // Header Hook function
    if( !function_exists('logistik_header_cb') ) {
        function logistik_header_cb( ) {
            get_template_part('templates/header');
            get_template_part('templates/header-menu-bottom');
        }
    }

    // back top top hook function
    if( ! function_exists( 'logistik_back_to_top_cb' ) ) {
        function logistik_back_to_top_cb( ) {
            $backtotop_trigger = logistik_opt('logistik_display_bcktotop');
            $custom_bcktotop   = logistik_opt('logistik_custom_bcktotop');
            $custom_bcktotop_icon   = logistik_opt('logistik_custom_bcktotop_icon');
            if( class_exists( 'ReduxFramework' ) ) {
                if( $backtotop_trigger ) {
                    if( $custom_bcktotop ) { ?>
                        <div class="scroll-top">
                                <i class="<?php echo esc_attr( $custom_bcktotop_icon ); ?>"></i>
                        </div>
                    <?php } else { ?>
                         <div class="scroll-top">
                            <svg class="progress-circle svg-content" width="100%" height="100%" viewBox="-1 -1 102 102">
                                <path d="M50,1 a49,49 0 0,1 0,98 a49,49 0 0,1 0,-98" style="transition: stroke-dashoffset 10ms linear 0s; stroke-dasharray: 307.919, 307.919; stroke-dashoffset: 307.919;">
                                </path>
                            </svg>
                             <!-- <i class="fa-regular fa-arrow-up"></i> -->
                        </div>
                    <?php }
                }
            }

        }
    }

    // Blog Start Wrapper Function
    if( !function_exists('logistik_blog_start_wrap_cb') ) {
        function logistik_blog_start_wrap_cb() { ?>
            <section class="themeholy-blog-wrapper space-top space-extra-bottom arrow-wrap">
                <div class="container">
                    <div class="row">
        <?php }
    }

    // Blog End Wrapper Function
    if( !function_exists('logistik_blog_end_wrap_cb') ) {
        function logistik_blog_end_wrap_cb() {?>
                    </div>
                </div>
            </section>
        <?php }
    }

    // Blog Column Start Wrapper Function
    if( !function_exists('logistik_blog_col_start_wrap_cb') ) {
        function logistik_blog_col_start_wrap_cb() {
            if( class_exists('ReduxFramework') ) {
                $logistik_blog_sidebar = logistik_opt('logistik_blog_sidebar');
                if( $logistik_blog_sidebar == '2' && is_active_sidebar('logistik-blog-sidebar') ) {
                    echo '<div class="col-lg-8 order-lg-last">';
                } elseif( $logistik_blog_sidebar == '3' && is_active_sidebar('logistik-blog-sidebar') ) {
                    echo '<div class="col-xxl-8 col-lg-7">';
                } else {
                    echo '<div class="col-lg-12">';
                }

            } else {
                if( is_active_sidebar('logistik-blog-sidebar') ) {
                    echo '<div class="col-xxl-8 col-lg-7">';
                } else {
                    echo '<div class="col-lg-12">';
                }
            }
        }
    }
    // Blog Column End Wrapper Function
    if( !function_exists('logistik_blog_col_end_wrap_cb') ) {
        function logistik_blog_col_end_wrap_cb() {
            echo '</div>';
        }
    }

    // Blog Sidebar
    if( !function_exists('logistik_blog_sidebar_cb') ) {
        function logistik_blog_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $logistik_blog_sidebar = logistik_opt('logistik_blog_sidebar');
            } else {
                $logistik_blog_sidebar = 2;
                
            }
            if( $logistik_blog_sidebar != 1 && is_active_sidebar('logistik-blog-sidebar') ) {
                // Sidebar
                get_sidebar();
            }
        }
    }


    if( !function_exists('logistik_blog_details_sidebar_cb') ) {
        function logistik_blog_details_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $logistik_blog_single_sidebar = logistik_opt('logistik_blog_single_sidebar');
            } else {
                $logistik_blog_single_sidebar = 4;
            }
            if( $logistik_blog_single_sidebar != 1 ) {
                // Sidebar
                get_sidebar();
            }

        }
    }

    // Blog Pagination Function
    if( !function_exists('logistik_blog_pagination_cb') ) {
        function logistik_blog_pagination_cb( ) {
            get_template_part('templates/pagination');
        }
    }

    // Blog Content Function
    if( !function_exists('logistik_blog_content_cb') ) {
        function logistik_blog_content_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $logistik_blog_grid = logistik_opt('logistik_blog_grid');
            } else {
                $logistik_blog_grid = '1';
            }

            if( $logistik_blog_grid == '1' ) {
                $logistik_blog_grid_class = 'col-lg-12';
            } elseif( $logistik_blog_grid == '2' ) {
                $logistik_blog_grid_class = 'col-sm-6';
            } else {
                $logistik_blog_grid_class = 'col-lg-4 col-sm-6';
            }

            echo '<div class="row">';
                if( have_posts() ) {
                    while( have_posts() ) {
                        the_post();
                        echo '<div class="'.esc_attr($logistik_blog_grid_class).'">';
                            get_template_part('templates/content',get_post_format());
                        echo '</div>';
                    }
                    wp_reset_postdata();
                } else{
                    get_template_part('templates/content','none');
                }
            echo '</div>';
        }
    }

    // footer content Function
    if( !function_exists('logistik_footer_content_cb') ) {
        function logistik_footer_content_cb( ) {

            if( class_exists('ReduxFramework') && did_action( 'elementor/loaded' )  ){
                if( is_page() || is_page_template('template-builder.php') ) {
                    $post_id = get_the_ID();

                    // Get the page settings manager
                    $page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );

                    // Get the settings model for current post
                    $page_settings_model = $page_settings_manager->get_model( $post_id );

                    // Retrieve the Footer Style
                    $footer_settings = $page_settings_model->get_settings( 'logistik_footer_style' );

                    // Footer Local
                    $footer_local = $page_settings_model->get_settings( 'logistik_footer_builder_option' );

                    // Footer Enable Disable
                    $footer_enable_disable = $page_settings_model->get_settings( 'logistik_footer_choice' );

                    if( $footer_enable_disable == 'yes' ){
                        if( $footer_settings == 'footer_builder' ) {
                            // local options
                            $logistik_local_footer = get_post( $footer_local );
                            echo '<footer>';
                            echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $logistik_local_footer->ID );
                            echo '</footer>';
                        } else {
                            // global options
                            $logistik_footer_builder_trigger = logistik_opt('logistik_footer_builder_trigger');
                            if( $logistik_footer_builder_trigger == 'footer_builder' ) {
                                echo '<footer>';
                                $logistik_global_footer_select = get_post( logistik_opt( 'logistik_footer_builder_select' ) );
                                $footer_post = get_post( $logistik_global_footer_select );
                                echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $footer_post->ID );
                                echo '</footer>';
                            } else {
                                // wordpress widgets
                                logistik_footer_global_option();
                            }
                        }
                    }
                } else {
                    // global options
                    $logistik_footer_builder_trigger = logistik_opt('logistik_footer_builder_trigger');
                    if( $logistik_footer_builder_trigger == 'footer_builder' ) {
                        echo '<footer>';
                        $logistik_global_footer_select = get_post( logistik_opt( 'logistik_footer_builder_select' ) );
                        $footer_post = get_post( $logistik_global_footer_select );
                        echo \Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $footer_post->ID );
                        echo '</footer>';
                    } else {
                        // wordpress widgets
                        logistik_footer_global_option();
                    }
                }
            } else { ?>
                <div class="footer-layout4">
                    <div class="copyright-wrap">
                        <div class="container">
                            <p class="copyright-text text-center"><?php echo sprintf( 'Copyright <i class="fal fa-copyright"></i> %s <a href="%s">%s</a> All Rights Reserved by <a href="%s">%s</a>',date('Y'),esc_url('#'),__( 'Logistik.','logistik' ),esc_url('#'),__( 'Themeholy', 'logistik' ) ) ?></p>
                        </div>
                    </div>
                </div>
            <?php }

        }
    }

    // blog details wrapper start hook function
    if( !function_exists('logistik_blog_details_wrapper_start_cb') ) {
        function logistik_blog_details_wrapper_start_cb( ) {
            echo '<section class="themeholy-blog-wrapper blog-details space-top space-extra-bottom">';
                echo '<div class="container">';
                    if( is_active_sidebar( 'logistik-blog-sidebar' ) ){
                        $logistik_gutter_class = 'gx-60';
                    }else{
                        $logistik_gutter_class = '';
                    }
                    // echo '<div class="row './/esc_attr( $logistik_gutter_class ).'">';
                    echo '<div class="row">';
        }
    }

    // blog details column wrapper start hook function
    if( !function_exists('logistik_blog_details_col_start_cb') ) {
        function logistik_blog_details_col_start_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $logistik_blog_single_sidebar = logistik_opt('logistik_blog_single_sidebar');
                if( $logistik_blog_single_sidebar == '2' && is_active_sidebar('logistik-blog-sidebar') ) {
                    echo '<div class="col-xxl-8 col-lg-7 order-last">';
                } elseif( $logistik_blog_single_sidebar == '3' && is_active_sidebar('logistik-blog-sidebar') ) {
                    echo '<div class="col-xxl-8 col-lg-7">';
                } else {
                    echo '<div class="col-lg-12">';
                }

            } else {
                if( is_active_sidebar('logistik-blog-sidebar') ) {
                    echo '<div class="col-xxl-8 col-lg-7">';
                } else {
                    echo '<div class="col-lg-12">';
                }
            }
        }
    }

    // blog details post meta hook function
    if( !function_exists('logistik_blog_post_meta_cb') ) {
        function logistik_blog_post_meta_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $logistik_display_post_author      =  logistik_opt('logistik_display_post_author');
                $logistik_display_post_tag   =  logistik_opt('logistik_display_post_tag');
                $logistik_display_post_date      =  logistik_opt('logistik_display_post_date');
                $logistik_display_post_comments      =  logistik_opt('logistik_display_post_comments');
            } else {
                $logistik_display_post_author      = '1';
                $logistik_display_post_tag   = '1';
                $logistik_display_post_date      = '1';
                $logistik_display_post_comments      = '0';
            }

                echo '<div class="blog-meta">';
                    if( $logistik_display_post_author ){
                        echo '<a href="'.esc_url( get_author_posts_url( get_the_author_meta('ID') ) ).'"><i class="fa-regular fa-user"></i>'.esc_html__('by ','logistik').esc_html( ucwords( get_the_author() ) ).'</a>';
                    }
                    if( $logistik_display_post_date ){
                        echo '<a href="'.esc_url( logistik_blog_date_permalink() ).'"><i class="fa-light fa-calendar-days"></i>';
                            echo '<time datetime="'.esc_attr( get_the_date( DATE_W3C ) ).'">'.esc_html( get_the_date() ).'</time>';
                        echo '</a>';
                    }
                    if( $logistik_display_post_tag ){
                        $categories = get_the_category(); 
                        if(!empty($categories)){
                        echo '<a href="'.esc_url( get_category_link( $categories[0]->term_id ) ).'"><i class="fa-regular fa-tags"></i>'.esc_html( $categories[0]->name ).'</a>';
                        }
                    }
                    if( $logistik_display_post_comments ){
                        ?>
                        <a href="#"><i class="fa-regular fa-comments"></i>
                            <?php 
                                if(get_comments_number() == 1){
                                    echo esc_html__('Comment(', 'logistik'); 
                                }else{
                                    echo esc_html__('Comments(', 'logistik'); 
                                }
                                echo get_comments_number(); ?>)</a>
                        <?php
                    }
                echo '</div>';
        }
    }

    // blog details share options hook function
    if( !function_exists('logistik_blog_details_share_options_cb') ) {
        function logistik_blog_details_share_options_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $logistik_post_details_share_options = logistik_opt('logistik_post_details_share_options');
            } else {
                $logistik_post_details_share_options = false;
            }
            if( function_exists( 'logistik_social_sharing_buttons' ) && $logistik_post_details_share_options ) { ?>
                <div class="col-md-auto text-md-end">
                    <span class="share-links-title"><?php echo __( 'Share:', 'logistik' ); ?></span>
                        <ul class="social-links">
                           <?php echo logistik_social_sharing_buttons(); ?>
                        </ul>
                    <!-- End Social Share -->
                </div>
            <?php }
        }
    }
    
    // blog details author bio hook function
    if( !function_exists('logistik_blog_details_author_bio_cb') ) {
        function logistik_blog_details_author_bio_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $postauthorbox =  logistik_opt( 'logistik_post_details_author_desc_trigger' );
            } else {
                $postauthorbox = '1';
            }
            if(  $postauthorbox == '1' ) {

                echo '<div class="widget widget-author">';
                    echo '<div class="author-widget-wrap style2">';
                        echo '<div class="avater">';
                            echo '<img src="'.esc_url( get_avatar_url( get_the_author_meta('ID') ) ).'" alt="img">';
                        echo '</div>';
                        echo '<div class="author-info">';
                            echo '<h4 class="name"><a class="text-inherit" href="cases.html">'.esc_html( ucwords( get_the_author() )).'</a></h4>';
                            echo '<p class="author-bio">'.get_the_author_meta( 'user_description', get_the_author_meta('ID') ).'</p>';
                            echo '<ul class="social-links"">';
                                    $logistik_social_icons = get_user_meta( get_the_author_meta('ID'), '_logistik_social_profile_group',true );
                                    if(!empty($logistik_social_icons)){
                                        foreach( $logistik_social_icons as $singleicon ) {
                                            if( ! empty( $singleicon['_logistik_social_profile_icon'] ) ) {
                                                echo '<li><a href="'.esc_url( $singleicon['_logistik_lawyer_social_profile_link'] ).'"><i class="'.esc_attr( $singleicon['_logistik_social_profile_icon'] ).'"></i></a></li>';
                                            }
                                        }
                                    }
                            echo '</ul>';
                        echo '</div>';
                    echo '</div>';
             echo '</div>';

               
            }

        }
    }

     // Blog Details Post Navigation hook function
     if( !function_exists( 'logistik_blog_details_post_navigation_cb' ) ) {
        function logistik_blog_details_post_navigation_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $logistik_post_details_post_navigation = logistik_opt('logistik_post_details_post_navigation');
            } else {
                $logistik_post_details_post_navigation = true;
            }

            $prevpost = get_previous_post();
            $nextpost = get_next_post();

            $allowhtml = array(
                'p'         => array(
                    'class'     => array()
                ),
                'span'      => array(),
                'a'         => array(
                    'href'      => array(),
                    'title'     => array()
                ),
                'br'        => array(),
                'em'        => array(),
                'strong'    => array(),
                'b'         => array(),
            );

            if( $logistik_post_details_post_navigation && ! empty( $prevpost ) || !empty( $nextpost ) ) {
                echo '<div class="blog-slide-wrapp">';
                    echo '<div class="blog-post">';
                        if( ! empty( $prevpost ) ) {
                            echo '<div class="blog-slide-img">';
                                echo '<a href="'.esc_url( get_permalink( $prevpost->ID ) ).'" class="nav-btn prev">';
                                if( class_exists('ReduxFramework') ) {
                                    if (has_post_thumbnail( $prevpost->ID )) {
                                        echo get_the_post_thumbnail( $prevpost->ID, 'logistik_80X80' );
                                    };
                                }
                                echo '</a>';
                            echo '</div>';
                            
                            echo '<a href="'.esc_url( get_permalink( $prevpost->ID ) ).'" class="nav-btn prev">';
                                echo '<span class="title">'.esc_html__( ' Previous Post', 'logistik' ).'</span>';
                            echo '</a>';
                        }
                    echo '</div>';

                    echo '<div class="post-icon">';
                        echo '<img src="'.get_template_directory_uri().'/assets/img/box-dot.png" alt="">';
                    echo '</div>';

                    echo '<div class="blog-post">';
                        if( ! empty( $nextpost ) ) {
                            echo '<div class="blog-slide-img">';
                                echo '<a href="'.esc_url( get_permalink( $nextpost->ID ) ).'" class="nav-btn next">';
                                    if( class_exists('ReduxFramework') ) {
                                        if (has_post_thumbnail($nextpost->ID)) {
                                            echo get_the_post_thumbnail( $nextpost->ID, 'logistik_80X80' );
                                        };
                                    }
                                echo '</a>';
                            echo '</div>';

                            echo '<a href="'.esc_url( get_permalink( $nextpost->ID ) ).'" class="nav-btn next">';
                                echo '<span class="title">'.esc_html__( ' Next Post', 'logistik' ).'</span>';
                            echo '</a>';
                        }
                    echo '</div>';
                echo '</div>';
            }
        }
    }

    // Blog Details Comments hook function
    if( !function_exists('logistik_blog_details_comments_cb') ) {
        function logistik_blog_details_comments_cb( ) {
            if ( ! comments_open() ) {
                echo '<div class="blog-comment-area">';
                    echo logistik_heading_tag( array(
                        "tag"   => "h3",
                        "text"  => esc_html__( 'Comments are closed', 'logistik' ),
                        "class" => "inner-title"
                    ) );
                echo '</div>';
            }

            // comment template.
            if ( comments_open() || get_comments_number() ) {
                comments_template();
            }
        }
    }

    // Blog Details Column end hook function
    if( !function_exists('logistik_blog_details_col_end_cb') ) {
        function logistik_blog_details_col_end_cb( ) {
            echo '</div>';
        }
    }

    // Blog Details Wrapper end hook function
    if( !function_exists('logistik_blog_details_wrapper_end_cb') ) {
        function logistik_blog_details_wrapper_end_cb( ) {
                    echo '</div>';
                echo '</div>';
            echo '</section>';
        }
    }

    // page start wrapper hook function
    if( !function_exists('logistik_page_start_wrap_cb') ) {
        function logistik_page_start_wrap_cb( ) {
            
            if( is_page( 'cart' ) ){
                $section_class = "themeholy-cart-wrapper space-top space-extra-bottom";
            }elseif( is_page( 'checkout' ) ){
                $section_class = "themeholy-checkout-wrapper space-top space-extra-bottom";
            }elseif( is_page('wishlist') ){
                $section_class = "wishlist-area space-top space-extra-bottom";
            }else{
                $section_class = "space-top space-extra-bottom";  
            }
            echo '<section class="'.esc_attr( $section_class ).'">';
                echo '<div class="container">';
                    echo '<div class="row">';
        }
    }

    // page wrapper end hook function
    if( !function_exists('logistik_page_end_wrap_cb') ) {
        function logistik_page_end_wrap_cb( ) {
                    echo '</div>';
                echo '</div>';
            echo '</section>';
        }
    }

    // page column wrapper start hook function
    if( !function_exists('logistik_page_col_start_wrap_cb') ) {
        function logistik_page_col_start_wrap_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $logistik_page_sidebar = logistik_opt('logistik_page_sidebar');
            }else {
                $logistik_page_sidebar = '1';
            }
            if( $logistik_page_sidebar == '2' && is_active_sidebar('logistik-page-sidebar') ) {
                echo '<div class="col-lg-8 order-last">';
            } elseif( $logistik_page_sidebar == '3' && is_active_sidebar('logistik-page-sidebar') ) {
                echo '<div class="col-lg-8">';
            } else {
                echo '<div class="col-lg-12">';
            }

        }
    }

    // page column wrapper end hook function
    if( !function_exists('logistik_page_col_end_wrap_cb') ) {
        function logistik_page_col_end_wrap_cb( ) {
            echo '</div>';
        }
    }

    // page sidebar hook function
    if( !function_exists('logistik_page_sidebar_cb') ) {
        function logistik_page_sidebar_cb( ) {
            if( class_exists('ReduxFramework') ) {
                $logistik_page_sidebar = logistik_opt('logistik_page_sidebar');
            }else {
                $logistik_page_sidebar = '1';
            }

            if( class_exists('ReduxFramework') ) {
                $logistik_page_layoutopt = logistik_opt('logistik_page_layoutopt');
            }else {
                $logistik_page_layoutopt = '3';
            }

            if( $logistik_page_layoutopt == '1' && $logistik_page_sidebar != 1 ) {
                get_sidebar('page');
            } elseif( $logistik_page_layoutopt == '2' && $logistik_page_sidebar != 1 ) {
                get_sidebar();
            }
        }
    }

    // page content hook function
    if( !function_exists('logistik_page_content_cb') ) {
        function logistik_page_content_cb( ) {
            if(  class_exists('woocommerce') && ( is_woocommerce() || is_cart() || is_checkout() || is_page('wishlist') || is_account_page() )  ) {
                echo '<div class="woocommerce--content">';
            } else {
                echo '<div class="page--content clearfix">';
            }

                the_content();

                // Link Pages
                logistik_link_pages();

            echo '</div>';
            // comment template.
            if ( comments_open() || get_comments_number() ) {
                comments_template();
            }

        }
    }

    if( !function_exists('logistik_blog_post_thumb_cb') ) {
        function logistik_blog_post_thumb_cb( ) {
            if( get_post_format() ) {
                $format = get_post_format();
            }else{
                $format = 'standard';
            }

            $logistik_post_slider_thumbnail = logistik_meta( 'post_format_slider' );

            if( !empty( $logistik_post_slider_thumbnail ) ){
                echo '<div class="blog-img themeholy-blog-carousel arrow-wrap">';
                    foreach( $logistik_post_slider_thumbnail as $single_image ){
                        echo logistik_img_tag( array(
                            'url'   => esc_url( $single_image )
                        ) );
                    }
                echo '</div>';
            }elseif( has_post_thumbnail() && $format == 'standard' ) {
                echo '<!-- Post Thumbnail -->';
                echo '<div class="blog-img">';
                    if( ! is_single() ){
                        echo '<a href="'.esc_url( get_permalink() ).'" class="post-thumbnail">';
                    }

                    the_post_thumbnail();

                    if( ! is_single() ){
                        echo '</a>';
                    }
                echo '</div>';
                echo '<!-- End Post Thumbnail -->';
            }elseif( $format == 'video' ){
                if( has_post_thumbnail() && ! empty ( logistik_meta( 'post_format_video' ) ) ){
                    echo '<div class="blog-img blog-video">';
                        if( ! is_single() ){
                            echo '<a href="'.esc_url( get_permalink() ).'" class="post-thumbnail">';
                        }
                            the_post_thumbnail();
                        if( ! is_single() ){
                            echo '</a>';
                        }
                        echo '<a href="'.esc_url( logistik_meta( 'post_format_video' ) ).'" class="white-play-btn popup-video">';
                            echo '<i class="fas fa-play"></i>';
                        echo '</a>';
                    echo '</div>';
                }elseif( ! has_post_thumbnail() && ! is_single() ){
                    echo '<div class="blog-video">';
                        if( ! is_single() ){
                            echo '<a href="'.esc_url( get_permalink() ).'" class="post-thumbnail">';
                        }
                            echo logistik_embedded_media( array( 'video', 'iframe' ) );
                        if( ! is_single() ){
                            echo '</a>';
                        }
                    echo '</div>';
                }
            }elseif( $format == 'audio' ){
                $logistik_audio = logistik_meta( 'post_format_audio' );
                if( ! empty( $logistik_audio ) ){
                    echo '<div class="blog-audio">';
                        echo wp_oembed_get( $logistik_audio );
                    echo '</div>';
                }elseif( ! is_single() ){
                    echo '<div class="blog-audio">';
                        echo wp_oembed_get( $logistik_audio );
                    echo '</div>';
                }
            }

        }
    }

    if( !function_exists('logistik_blog_post_content_cb') ) {
        function logistik_blog_post_content_cb( ) {
            $allowhtml = array(
                'p'         => array(
                    'class'     => array()
                ),
                'span'      => array(),
                'a'         => array(
                    'href'      => array(),
                    'title'     => array()
                ),
                'br'        => array(),
                'em'        => array(),
                'strong'    => array(),
                'b'         => array(),
            );
            if( class_exists( 'ReduxFramework' ) ) {
                $logistik_excerpt_length          = logistik_opt( 'logistik_blog_postExcerpt' );
                $logistik_display_post_category   = logistik_opt( 'logistik_display_post_category' );
            } else {
                $logistik_excerpt_length          = '48';
                $logistik_display_post_category   = '1';
            }

            if( class_exists( 'ReduxFramework' ) ) {
                $logistik_blog_admin = logistik_opt( 'logistik_blog_post_author' );
                $logistik_blog_readmore_setting_val = logistik_opt('logistik_blog_readmore_setting');
                if( $logistik_blog_readmore_setting_val == 'custom' ) {
                    $logistik_blog_readmore_setting = logistik_opt('logistik_blog_custom_readmore');
                } else {
                    $logistik_blog_readmore_setting = __( 'Load more', 'logistik' );
                }
            } else {
                $logistik_blog_readmore_setting = __( 'Load more', 'logistik' );
                $logistik_blog_admin = true;
            }
            echo '<!-- blog-content -->';

                do_action( 'logistik_blog_post_thumb' );
                
                echo '<div class="blog-content">';

                    // Blog Post Meta
                    do_action( 'logistik_blog_post_meta' );

                    echo '<!-- Post Title -->';
                    echo '<h2 class="blog-title"><a href="'.esc_url( get_permalink() ).'">'.wp_kses( get_the_title( ), $allowhtml ).'</a></h2>';
                    echo '<!-- End Post Title -->';

                    echo '<!-- Post Summary -->';
                    echo logistik_paragraph_tag( array(
                        "text"  => wp_kses( wp_trim_words( get_the_excerpt(), $logistik_excerpt_length, '' ), $allowhtml ),
                        "class" => 'blog-text',
                    ) );
  
                    if( !empty( $logistik_blog_readmore_setting ) ){
                        echo '<div class="btn-group">';
                            echo '<a href="'.esc_url( get_permalink() ).'" class="themeholy-btn">'.esc_html( $logistik_blog_readmore_setting ).'<span class="icon"><i class="fa-sharp fa-regular fa-paper-plane"></i></span></a>';
                        echo '</div>';
                    }

                    echo '<!-- End Post Summary -->';
                echo '</div>';
            echo '<!-- End Post Content -->';
        }
    }
