<?php
/**
 * @Packge     : Logistik
 * @Version    : 1.0
 * @Author     : Themeholy
 * @Author URI : https://themeholy.com/
 *
 */

    // Block direct access
    if( !defined( 'ABSPATH' ) ){
        exit();
    }

    if( class_exists( 'ReduxFramework' ) ) {
        $logistik404title     = logistik_opt( 'logistik_fof_title' );
        $logistik404description  = logistik_opt( 'logistik_fof_description' );
        $logistik404btntext      = logistik_opt( 'logistik_fof_btn_text' );
    } else {
        $logistik404title     = __( 'Opp’s that page can’t be found', 'logistik' );
        $logistik404description  = __( 'The page you are looking for was moved, removed, renamed or never existed.', 'logistik' );
        $logistik404btntext      = __( ' Back To Home', 'logistik');

    }

    // get header //
    get_header(); ?>

    <section class="space">
        <div class="container">
            <div class="error-img">
            <?php if(!empty(logistik_opt('logistik_for_img', 'url' ) )): ?>
                <img src="<?php echo esc_url( logistik_opt('logistik_for_img', 'url' ) ) ?>" alt="<?php echo esc_attr__('404 image', 'logistik'); ?>">
            <?php else: ?>
                <img src="<?php echo get_template_directory_uri(); ?>/assets/img/error.svg" alt="<?php echo esc_attr__('404 image', 'logistik'); ?>">
            <?php endif; ?>
            </div>
            <div class="error-content">
                <h2 class="error-title"><?php echo esc_html( $logistik404title ); ?></h2>
                <p class="error-text"><?php echo esc_html( $logistik404description ); ?></p>
                <div class="btn-group justify-content-center">
                    <a href="<?php echo esc_url( home_url('/') ); ?>" class="themeholy-btn">
                    <?php echo esc_html( $logistik404btntext ); ?> <span class="icon"><i class="fa-sharp fa-regular fa-paper-plane"></i></span></a>
                </div>
            </div>
        </div>
    </section>

    <?php
    //footer
    get_footer();