<?php
/**
 * @Packge     : Logistik
 * @Version    : 1.0
 * @Author     : Logistik
 * @Author URI : https://www.angfuzsoft.com/
 *
 */


// Blocking direct access
if( ! defined( 'ABSPATH' ) ) {
    exit;
}

function logistik_core_essential_scripts( ) {
    wp_enqueue_script('logistik-ajax',LOGISTIK_PLUGDIRURI.'assets/js/logistik.ajax.js',array( 'jquery' ),'1.0',true);
    wp_localize_script(
    'logistik-ajax',
    'logistikajax',
        array(
            'action_url' => admin_url( 'admin-ajax.php' ),
            'nonce'	     => wp_create_nonce( 'logistik-nonce' ),
        )
    );
}

add_action('wp_enqueue_scripts','logistik_core_essential_scripts');


// logistik Section subscribe ajax callback function
add_action( 'wp_ajax_logistik_subscribe_ajax', 'logistik_subscribe_ajax' );
add_action( 'wp_ajax_nopriv_logistik_subscribe_ajax', 'logistik_subscribe_ajax' );

function logistik_subscribe_ajax( ){
  $apiKey = logistik_opt('logistik_subscribe_apikey');
  $listid = logistik_opt('logistik_subscribe_listid');
   if( ! wp_verify_nonce($_POST['security'], 'logistik-nonce') ) {
    echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('You are not allowed.', 'logistik').'</div>';
   }else{
       if( !empty( $apiKey ) && !empty( $listid )  ){
           $MailChimp = new DrewM\MailChimp\MailChimp( $apiKey );

           $result = $MailChimp->post("lists/{$listid}/members",[
               'email_address'    => esc_attr( $_POST['sectsubscribe_email'] ),
               'status'           => 'subscribed',
           ]);

           if ($MailChimp->success()) {
               if( $result['status'] == 'subscribed' ){
                   echo '<div class="alert alert-success mt-2" role="alert">'.esc_html__('Thank you, you have been added to our mailing list.', 'logistik').'</div>';
               }
           }elseif( $result['status'] == '400' ) {
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('This Email address is already exists.', 'logistik').'</div>';
           }else{
               echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Sorry something went wrong.', 'logistik').'</div>';
           }
        }else{
           echo '<div class="alert alert-danger mt-2" role="alert">'.esc_html__('Apikey Or Listid Missing.', 'logistik').'</div>';
        }
   }

   wp_die();

}

add_action('wp_ajax_logistik_addtocart_notification','logistik_addtocart_notification');
add_action('wp_ajax_nopriv_logistik_addtocart_notification','logistik_addtocart_notification');
function logistik_addtocart_notification(){

    $_product = wc_get_product($_POST['prodid']);
    $response = [
        'img_url'   => esc_url( wp_get_attachment_image_src( $_product->get_image_id(),array('60','60'))[0] ),
        'title'     => wp_kses_post( $_product->get_title() )
    ];
    echo json_encode($response);

    wp_die();
}