<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Image_Size;
/**
 *
 * Team Info Widget
 *
 */
class logistik_Team_info extends Widget_Base{

	public function get_name() {
		return 'logistikteaminfo';
	}

	public function get_title() {
		return esc_html__( 'Team Member Info', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik' ];
	}

	public function get_script_depends() {
		return [ 'logistik-frontend-script' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'team_member_content',
			[
				'label'		=> esc_html__( 'Member Info','logistik' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Layout Style', 'logistik' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options'		=> [
					'1'  			=> __( 'Style One', 'logistik' ),
				],
			]
		);

		$this->add_control(
			'content_name',
			[
				'label' 	=> esc_html__( 'Member Name', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> esc_html__( 'Angela Kwang', 'logistik' ),
                'rows' => '2'
			]
        );

        $this->add_control(
			'content_desig',
			[
				'label' 	=> esc_html__( 'Member Designation', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> esc_html__( 'Teacher', 'logistik' ),
                'rows' => '2'
			]
        ); 

        $this->add_control(
			'description',
			[
				'label' 	=> esc_html__( 'Description', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> esc_html__( 'Synergistically procrastinate technology without inexpensive partnerships. Credibly synergize long-term high-impact infomediaries before covalent solution. ', 'logistik' ),
				'separator' => 'after',
			]
        );  

		$this->add_control(
			'fb_link',
			[
				'label' 		=> esc_html__( 'Facebook Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'twitter_link',
			[
				'label' 		=> esc_html__( 'Twitter Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'pinterest_link',
			[
				'label' 		=> esc_html__( 'Pinterest Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
					
				],
			]
		);

		$this->add_control(
			'linkedin_link',
			[
				'label' 		=> esc_html__( 'Linkedin Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'separator' => 'after',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'team_contact_info',
			[
				'label'		=> esc_html__( 'Contact Info','logistik' ),
				'tab'		=> Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'phone_icon',
            [
				'label' 		=> __( 'Phone Icon', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'phone_title',
            [
				'label'         => __( 'Phone Label', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Phone' , 'logistik' ),
				'label_block'   => true,
				'rows' 		=> 2,
			]
		);		

		$this->add_control(
			'phone_number',
            [
				'label'         => __( 'Phone Number', 'logistik' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( '(+65) - 48596 - 5789' , 'logistik' ),
				'label_block'   => true,
				'separator' => 'after',
			]
		);

		$this->add_control(
			'email_icon',
            [
				'label' 		=> __( 'Email Icon', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);	

		$this->add_control(
			'email_title',
            [
				'label'         => __( 'Email Label', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Email' , 'logistik' ),
				'label_block'   => true,
				'rows' 		=> 2,
			]
		);		

		$this->add_control(
			'email_address',
            [
				'label'         => __( 'Email Address', 'logistik' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'info@logistik.com' , 'logistik' ),
				'label_block'   => true,
				'separator' => 'after',
			]
		);

		$this->add_control(
			'office_icon',
            [
				'label' 		=> __( 'Office Icon', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);	

		$this->add_control(
			'office_title',
            [
				'label'         => __( 'Office Label', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Office :' , 'logistik' ),
				'label_block'   => true,
				'rows' 		=> 2,
			]
		);

		$this->add_control(
			'office_content',
            [
				'label'         => __( 'Office Content', 'logistik' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'Dr. Richardson, California 62639' , 'logistik' ),
				'label_block'   => true,
				'separator' => 'after',
			]
		);

		$this->add_control(
			'office_icon2',
            [
				'label' 		=> __( 'Office Icon 2', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		);	

		$this->add_control(
			'office_title2',
            [
				'label'         => __( 'Office Label 2', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Office Time :' , 'logistik' ),
				'label_block'   => true,
				'rows' 		=> 2,
			]
		);

		$this->add_control(
			'office_content2',
            [
				'label'         => __( 'Office Content 2', 'logistik' ),
				'type'          => Controls_Manager::TEXT,
				'default'       => __( 'Mon-Fri : 09.00 am-05.00 pm' , 'logistik' ),
				'label_block'   => true,
				'separator' => 'after',
			]
		);

		$this->end_controls_section();


        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		/*-----------------------------------------Feedback styling------------------------------------*/

		$this->start_controls_section(
			'overview_con_styling',
			[
				'label' 	=> __( 'Content Styling', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

	        $this->start_controls_tabs(
				'style_tabs2'
			);

				$this->start_controls_tab(
					'style_normal_tab2',
					[
						'label' => esc_html__( 'Name', 'logistik' ),
					]
				);

			    $this->add_control(
						'overview_title_color',
						[
							'label' 		=> __( 'Color', 'logistik' ),
							'type' 			=> Controls_Manager::COLOR,
							'selectors' 	=> [
								'{{WRAPPER}} .about-card_title'	=> 'color: {{VALUE}}!important;',
							],
						]
			    );

			    $this->add_group_control(
					Group_Control_Typography::get_type(),
					 	[
							'name' 			=> 'overview_title_typography',
					 		'label' 		=> __( 'Typography', 'logistik' ),
					 		'selector' 	=> '{{WRAPPER}} .about-card_title',
						]
					);

			    $this->add_responsive_control(
						'overview_title_margin',
						[
							'label' 		=> __( 'Margin', 'logistik' ),
							'type' 			=> Controls_Manager::DIMENSIONS,
							'size_units' 	=> [ 'px', '%', 'em' ],
							'selectors' 	=> [
								'{{WRAPPER}} .about-card_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			                ],
						]
			    );

			    $this->add_responsive_control(
						'overview_title_padding',
						[
							'label' 		=> __( 'Padding', 'logistik' ),
							'type' 			=> Controls_Manager::DIMENSIONS,
							'size_units' 	=> [ 'px', '%', 'em' ],
							'selectors' 	=> [
								'{{WRAPPER}} .about-card_title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			                ],
						]
			    );

				$this->end_controls_tab();

				//--------------------secound--------------------//
				$this->start_controls_tab(
					'style_hover_tab2',
					[
						'label' => esc_html__( 'Designation', 'logistik' ),
					]
				);

				$this->add_control(
					'overview_content_color',
					[
						'label' 		=> __( 'Color', 'logistik' ),
						'type' 			=> Controls_Manager::COLOR,
						'selectors' 	=> [
							'{{WRAPPER}} .about-card_desig'	=> 'color: {{VALUE}}!important;',
						],
					]
		        );

			    $this->add_group_control(
					Group_Control_Typography::get_type(),
					 	[
							'name' 			=> 'overview_content_typography',
					 		'label' 		=> __( 'Typography', 'logistik' ),
					 		'selector' 	=> '{{WRAPPER}} .about-card_desig',
						]
					);

			    $this->add_responsive_control(
						'overview_content_margin',
						[
							'label' 		=> __( 'Margin', 'logistik' ),
							'type' 			=> Controls_Manager::DIMENSIONS,
							'size_units' 	=> [ 'px', '%', 'em' ],
							'selectors' 	=> [
								'{{WRAPPER}} .about-card_desig' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			                ],
						]
			    );

			    $this->add_responsive_control(
						'overview_content_padding',
						[
							'label' 		=> __( 'Padding', 'logistik' ),
							'type' 			=> Controls_Manager::DIMENSIONS,
							'size_units' 	=> [ 'px', '%', 'em' ],
							'selectors' 	=> [
								'{{WRAPPER}} .about-card_desig' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			                ],
						]
			   );

				$this->end_controls_tab();

				//--------------------secound--------------------//
				$this->start_controls_tab(
					'style_hover_tab5',
					[
						'label' => esc_html__( 'Content', 'logistik' ),
					]
				);

				$this->add_control(
					'co_content_color',
					[
						'label' 		=> __( 'Color', 'logistik' ),
						'type' 			=> Controls_Manager::COLOR,
						'selectors' 	=> [
							'{{WRAPPER}} .about-card_text'	=> 'color: {{VALUE}}!important;',
						],
					]
		        );

		        $this->add_group_control(
				Group_Control_Typography::get_type(),
				 	[
						'name' 			=> 'co_content_typography',
				 		'label' 		=> __( 'Typography', 'logistik' ),
				 		'selector' 	=> '{{WRAPPER}} .about-card_text',
					]
				);

		        $this->add_responsive_control(
					'co_content_margin',
					[
						'label' 		=> __( 'Margin', 'logistik' ),
						'type' 			=> Controls_Manager::DIMENSIONS,
						'size_units' 	=> [ 'px', '%', 'em' ],
						'selectors' 	=> [
							'{{WRAPPER}} .about-card_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		                ],
					]
		        );

		        $this->add_responsive_control(
					'co_content_padding',
					[
						'label' 		=> __( 'Padding', 'logistik' ),
						'type' 			=> Controls_Manager::DIMENSIONS,
						'size_units' 	=> [ 'px', '%', 'em' ],
						'selectors' 	=> [
							'{{WRAPPER}} .about-card_text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
		                ],
					]
		        );

				$this->end_controls_tab();

			$this->end_controls_tabs();

		$this->end_controls_section();


		//-------------------------------------Button styling-------------------------------------//
        $this->start_controls_section(
			'layout_style_section',
			[
				'label' 	=> __( 'Button Style', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Button Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .e-btn',
			]
        );

		$this->start_controls_tabs(
			'button_tabs'
		);

			$this->start_controls_tab(
				'normal_tab_label',
				[
					'label' => esc_html__( 'Normal', 'logistik' ),
				]
			);

			$this->add_control(
				'button_color',
				[
					'label' 		=> __( 'Button Color', 'logistik' ),
					'type' 			=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .e-btn' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'button_bg_color',
				[
					'label' 		=> __( 'Button Background Color', 'logistik' ),
					'type' 			=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .e-btn' => 'background-color:{{VALUE}} !important',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' 		=> 'border',
					'label' 	=> __( 'Border', 'logistik' ),
					'selector' 	=> '{{WRAPPER}} .e-btn',
				]
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'hover_tab_label',
				[
					'label' => esc_html__( 'Hover', 'logistik' ),
				]
			);

			$this->add_control(
				'button_color_hover',
				[
					'label' 		=> __( 'Button Color', 'logistik' ),
					'type' 			=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .e-btn:hover' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'button_bg_hover_color',
				[
					'label' 		=> __( 'Button Background Color', 'logistik' ),
					'type' 			=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .e-btn:hover:before, {{WRAPPER}} .e-btn:hover:after' => 'background-color:{{VALUE}} !Important',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' 		=> 'border_hover',
					'label' 	=> __( 'Border', 'logistik' ),
					'selector' 	=> '{{WRAPPER}} .e-btn:hover',
				]
			);

			$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Button Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .e-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Button Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .e-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Button Border Radius', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .e-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => esc_html__( 'Button Shadow', 'logistik' ),
				'selector' => '{{WRAPPER}} .e-btn',
			]
		);

        $this->end_controls_section();

	}

	protected function render() {

		$settings = $this->get_settings_for_display(); 

    	?>
    	<?php if( $settings['layout_style'] == '2' ): ?>

	    <?php else: 
			$email    	= $settings['email_address'];
			$phone    	= $settings['phone_number'];  
			$email          = is_email( $email );

			$replace        = array(' ','-',' - ');
			$replace_phone        = array(' ','-',' - ', '(', ')');
			$with           = array('','','');

			$emailurl       = str_replace( $replace, $with, $email );
			$phoneurl       = str_replace( $replace_phone, $with, $phone );	

	    	$f_target = $settings['fb_link']['is_external'] ? ' target="_blank"' : '';
			$f_nofollow = $settings['fb_link']['nofollow'] ? ' rel="nofollow"' : '';
			$t_target = $settings['twitter_link']['is_external'] ? ' target="_blank"' : '';
			$t_nofollow = $settings['twitter_link']['nofollow'] ? ' rel="nofollow"' : '';
			$p_target = $settings['pinterest_link']['is_external'] ? ' target="_blank"' : '';
			$p_nofollow = $settings['pinterest_link']['nofollow'] ? ' rel="nofollow"' : '';
			$l_target = $settings['linkedin_link']['is_external'] ? ' target="_blank"' : '';
			$l_nofollow = $settings['linkedin_link']['nofollow'] ? ' rel="nofollow"' : '';
	    ?>
		<div class="about-card">
			<div class="about-card_wrapp">
				<div class="about-card_content">
					<h5 class="about-card_title"><?php echo esc_html($settings['content_name']); ?></h5>
					<span class="about-card_desig"><?php echo esc_html($settings['content_desig']); ?></span>
				</div>
				<div class="themeholy-social team-social">
					<?php if( ! empty( $settings['fb_link']['url']) ): ?>
						<a <?php echo wp_kses_post( $f_nofollow.$f_target ); ?> href="<?php echo esc_url( $settings['fb_link']['url'] ); ?>"><i class="fab fa-facebook-f"></i></a>
					<?php endif; ?>

					<?php if( ! empty( $settings['twitter_link']['url']) ): ?>
						<a <?php echo wp_kses_post( $t_nofollow.$t_target ); ?>  href="<?php echo esc_url( $settings['twitter_link']['url'] ); ?>"><i class="fab fa-twitter"></i></a>
					<?php endif; ?>

					<?php if( ! empty( $settings['pinterest_link']['url']) ): ?>
						<a <?php echo wp_kses_post( $p_nofollow.$p_target ); ?>  href="<?php echo esc_url( $settings['pinterest_link']['url'] ); ?>"><i class="fab fa-pinterest-p"></i></a>
					<?php endif; ?>

					<?php if( ! empty( $settings['linkedin_link']['url']) ): ?>
						<a <?php echo wp_kses_post( $l_nofollow.$l_target ); ?>  href="<?php echo esc_url( $settings['linkedin_link']['url'] ); ?>"><i class="fab fa-linkedin-in"></i></a>
					<?php endif; ?>
				</div>
			</div>
			<p class="about-card_text"><?php echo esc_html($settings['description']); ?></p>
			<div class="about-card_box">
				<div class="info-box_wrapper">
					<div class="info-box">
						<div class="info-box_icon">
							<i>
								<?php echo logistik_img_tag( array(
									'url'   => esc_url( $settings['phone_icon']['url'] ),
								)); ?>
							</i>
						</div>
						<div class="media-body">
							<h4 class="info-box_title"><?php echo esc_html($settings['phone_title']); ?></h4>
							<a class="info-box_link" href="<?php echo esc_attr( 'tel:'.$phoneurl); ?>"><?php echo esc_html($phone); ?></a>
						</div>
					</div>
					<div class="info-box">
						<div class="info-box_icon">
							<i>
								<?php echo logistik_img_tag( array(
									'url'   => esc_url( $settings['email_icon']['url'] ),
								)); ?>
							</i>
						</div>
						<div class="media-body">
							<h4 class="info-box_title"><?php echo esc_html($settings['email_title']); ?></h4>
							<a class="info-box_link" href="<?php echo esc_attr( 'mailto:'.$emailurl); ?>"><?php echo esc_html($email); ?></a>
						</div>
					</div>
					<div class="info-box">
						<div class="info-box_icon">
							<i>
								<?php echo logistik_img_tag( array(
									'url'   => esc_url( $settings['office_icon']['url'] ),
								)); ?>
							</i>
						</div>
						<div class="media-body">
							<h4 class="info-box_title"><?php echo esc_html($settings['office_title']); ?></h4>
							<span class="info-box_text"><?php echo esc_html($settings['office_content']); ?></span>
						</div>
					</div>
					<div class="info-box">
						<div class="info-box_icon">
							<i>
								<?php echo logistik_img_tag( array(
									'url'   => esc_url( $settings['office_icon2']['url'] ),
								)); ?>
							</i>
						</div>
						<div class="media-body">
							<h4 class="info-box_title"><?php echo esc_html($settings['office_title2']); ?></h4>
							<span class="info-box_text"><?php echo esc_html($settings['office_content2']); ?></span>
						</div>
					</div>
				</div>
			</div>
		</div>

    	<?php endif;
		
	}
}