<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Portfolio Widget .
 *
 */
class logistik_Portfolio extends Widget_Base {

	public function get_name() {
		return 'logistikportfolio';
	}

	public function get_title() {
		return __( 'Portfolio', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik' ];
	}

	protected function register_controls() {

		 $this->start_controls_section(
			'portfolio_section',
			[
				'label'     => __( 'portfolios', 'logistik' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Layout Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2'  		=> __( 'Style Two', 'logistik' ),
					'3'  		=> __( 'Style Three', 'logistik' ),
					'4'  		=> __( 'Style Four', 'logistik' ),
					'5'  		=> __( 'Style Five', 'logistik' ),
					'6'  		=> __( 'Style Six', 'logistik' ),
				],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'portfolio_img',
			[
				'label' 		=> __( 'Choose Image', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
			]
		); 

		$repeater->add_control(
			'portfolio_cate',
            [
				'label'         => __( 'Category', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'truck Freight' , 'logistik' ),
				'label_block'   => true,
				'rows' => '2'
			]
		);

        $repeater->add_control(
			'portfolio_title',
            [
				'label'         => __( 'Title', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Packaging & Distribution' , 'logistik' ),
				'label_block'   => true,
				'rows' => '3'
			]
		);

        $repeater->add_control(
			'portfolio_link',
			[
				'label' 		=> __( 'Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'portfoliolist',
			[
				'label' 		=> __( 'portfolio List', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'portfolio_cate'	=> __( 'truck Freight', 'logistik' ),
					],
				],
			]
		);
		
        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//---------------------------------------Subtitle Style---------------------------------------//
		$this->start_controls_section(
			'subtitle_style',
			[
				'label' 	=> __( 'Subtitle Style', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'color: {{VALUE}}',
				],
			]
		);	

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'subtitle_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
				'selector' 	=> '{{WRAPPER}} .th-sub',
			]
		);

		$this->add_responsive_control(
			'subtitle_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'subtitle_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

		//---------------------------------------Title Style---------------------------------------//
		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'tayde' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Color', 'tayde' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Typography', 'tayde' ),
				'selector' 	=> '{{WRAPPER}} .th-title',
			]
		);
		$this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Margin', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Padding', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->end_controls_section();
		


	}

	protected function render() {

        $settings = $this->get_settings_for_display();
        ?>

        <?php if( $settings['layout_style'] == '2' ): ?>
		<div class="row projectSlider slider-shadow themeholy-carousel" id="projectSlide1" data-slide-show="4" data-xl-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-autoplay="true">
			<?php foreach( $settings['portfoliolist'] as $data ): ?>
            <div class="col-md-6 col-lg-4 col-xl-4 col-xxl-3">
                <div class="project-card style2">
                    <div class="project-img">
						<?php echo logistik_img_tag( array(
							'url'   => esc_url( $data['portfolio_img']['url']  ),
						)); ?>
                    </div>
                    <div class="project-content">
                        <p class="project-subtitle th-sub"><?php echo esc_html( $data['portfolio_cate'] ); ?></p>
                        <h3 class="project-title th-title"><a href="<?php echo esc_url( $data['portfolio_link']['url'] ); ?>"><?php echo esc_html( $data['portfolio_title'] ); ?></a></h3>
                        <a class="project-btn" href="<?php echo esc_url( $data['portfolio_link']['url'] ); ?>"><i class="fa-regular fa-arrow-up-right"></i></a>
                    </div>
                </div>
            </div>
			<?php endforeach; ?>
        </div>

		<?php elseif( $settings['layout_style'] == '3' ): ?>
 		<div class="row project-slide" id="ProjectSlide2">
		 	<?php foreach( $settings['portfoliolist'] as $data ): ?>
			<div class="col-lg-4 col-md-6">
				<div class="project-card style4">
					<div class="project-img">
						<?php echo logistik_img_tag( array(
							'url'   => esc_url( $data['portfolio_img']['url']  ),
						)); ?>
					</div>
					<div class="project-content">
						<p class="project-subtitle th-sub"><?php echo esc_html( $data['portfolio_cate'] ); ?></p>
						<h3 class="project-title th-title"><a href="<?php echo esc_url( $data['portfolio_link']['url'] ); ?>"><?php echo esc_html( $data['portfolio_title'] ); ?></a>
						</h3>
						<a class="project-btn" href="<?php echo esc_url( $data['portfolio_link']['url'] ); ?>"><i class="fa-regular fa-arrow-right"></i></a>
					</div>
				</div>
			</div>
			<?php endforeach; ?>
		</div>

		<?php elseif( $settings['layout_style'] == '4' ): ?>
		<div class="row gy-4">
			<?php foreach( $settings['portfoliolist'] as $data ): ?>
			<div class="col-md-6 col-lg-6 col-xl-4">
				<div class="project-card style3">
					<div class="project-img">
						<?php echo logistik_img_tag( array(
							'url'   => esc_url( $data['portfolio_img']['url']  ),
						)); ?>
					</div>
					<div class="project-content">
						<p class="project-subtitle th-sub"><?php echo esc_html( $data['portfolio_cate'] ); ?></p>
						<h3 class="project-title th-title"><a href="<?php echo esc_url( $data['portfolio_link']['url'] ); ?>"><?php echo esc_html( $data['portfolio_title'] ); ?></a></h3>
						<a class="project-btn" href="<?php echo esc_url( $data['portfolio_link']['url'] ); ?>"><i class="fa-regular fa-arrow-up-right"></i></a>
					</div>
				</div>
			</div>
			<?php endforeach; ?>
		</div>

		<?php elseif( $settings['layout_style'] == '5' ): ?>
		<div class="row project-slide3" id="ProjectSlide2" data-asnavfor=".project-card">
			<?php foreach( $settings['portfoliolist'] as $data ): ?>
            <div class="col-md-6 col-lg-4 col-xl-3">
                <div class="project-card style2">
                    <div class="project-img">
						<?php echo logistik_img_tag( array(
							'url'   => esc_url( $data['portfolio_img']['url']  ),
						)); ?>
                    </div>
                    <div class="project-content">
                        <p class="project-subtitle th-sub"><?php echo esc_html( $data['portfolio_cate'] ); ?></p>
                        <h3 class="project-title th-title"><a href="<?php echo esc_url( $data['portfolio_link']['url'] ); ?>"><?php echo esc_html( $data['portfolio_title'] ); ?></a></h3>
                        <a class="project-btn" href="<?php echo esc_url( $data['portfolio_link']['url'] ); ?>"><i class="fa-solid fa-arrow-right"></i></a>
                    </div>
                </div>
            </div>
			<?php endforeach; ?>
        </div>

		<?php elseif( $settings['layout_style'] == '6' ): ?>
			<div class="row projectSlider slider-shadow themeholy-carousel" id="projectSlide1" data-slide-show="4" data-xl-slide-show="3" data-lg-slide-show="2" data-md-slide-show="2" data-sm-slide-show="1" data-autoplay="true">
				<?php foreach( $settings['portfoliolist'] as $data ): ?>
				<div class="col-md-6 col-lg-4 col-xl-4 col-xxl-3">
					<div class="project-card style5">
						<div class="project-img">
							<?php echo logistik_img_tag( array(
								'url'   => esc_url( $data['portfolio_img']['url']  ),
							)); ?>
						</div>
						<div class="project-content">
							<p class="project-subtitle th-sub"><?php echo esc_html( $data['portfolio_cate'] ); ?></p>
							<h3 class="project-title th-title"><a href="<?php echo esc_url( $data['portfolio_link']['url'] ); ?>"><?php echo esc_html( $data['portfolio_title'] ); ?></a></h3>
						</div>
						<a class="project-btn" href="<?php echo esc_url( $data['portfolio_link']['url'] ); ?>"><i class="fa-regular fa-arrow-right"></i></a>
					</div>
				</div>
				<?php endforeach; ?>
			</div>

    	<?php else: ?>
		<div class="row slider-shadow themeholy-carousel" id="projectSlide1" data-slide-show="3" data-lg-slide-show="3" data-md-slide-show="2" data-sm-slide-show="1">
			<?php foreach( $settings['portfoliolist'] as $data ): ?>
            <div class="col-md-6 col-lg-4 col-xl-3">
                <div class="project-card">
                    <div class="project-img">
						<?php echo logistik_img_tag( array(
							'url'   => esc_url( $data['portfolio_img']['url']  ),
						)); ?>
                    </div>
                    <div class="project-content">
                        <p class="project-subtitle th-sub"><?php echo esc_html( $data['portfolio_cate'] ); ?></p>
                        <h3 class="project-title th-title"><a href="<?php echo esc_url( $data['portfolio_link']['url'] ); ?>"><?php echo esc_html( $data['portfolio_title'] ); ?></a></h3>
                        <a class="project-btn" href="<?php echo esc_url( $data['portfolio_link']['url'] ); ?>"><i class="fa-regular fa-arrow-up-right"></i></a>
                    </div>
                </div>
            </div>
			<?php endforeach; ?>
        </div>

      <?php endif; 

	}

}