<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Repeater;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Background;
/**
 * 
 * Newsletter Widget .
 *
 */
class Logistik_Newsletter extends Widget_Base {

	public function get_name() {
		return 'logistiknewsletter';
	}

	public function get_title() {
		return __( 'Newsletter', 'logistik' );
	}


	public function get_icon() {
		return 'themeholy-icon';
    }
    

	public function get_categories() {
		return [ 'logistik' ];
	}

	
	protected function register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label'     => __( 'Newsletter Style', 'logistik' ),
				'tab'       => Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Layout Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2' 		=> __( 'Style Two', 'logistik' ),
					'3' 		=> __( 'Style Three', 'logistik' ),
					'4' 		=> __( 'Style Four', 'logistik' ),
				],
			]
		);

		$this->add_control(
            'image',
            [
                'label'     => __( 'Image / Icon', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition' => [
					'layout_style' => ['4']
				]
            ]
        );

		
        $this->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'	=> [
					'layout_style' => ['4'],
				]
			]
		);

        $this->add_control(
			'title',
            [
				'label'         => __( 'Title', 'logistik' ),
				'type'          => Controls_Manager::TEXTAREA,
				'default'       => __( 'Title' , 'logistik' ),
				'label_block'   => true,
				'rows' 		=> 3,
				'condition' => [
					'layout_style' => ['3', '4']
				]
			]
		);

		$this->add_control(
			'newsletter_placeholder',
			[
				'label' 		=> __( 'Newsletter Placeholder Text', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Enter Your Email', 'logistik' ),
			]
		);

		$this->add_control(
			'newsletter_button',
			[
				'label' 		=> __( 'Newsletter Button Text', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'default' 		=> __( 'Subscribe', 'logistik' ),
				'condition' => [
					'layout_style' => ['2', '3','4']
				]
			]
		);

        $this->end_controls_section();

         //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------------------------------------Title styling-------------------------------------//

        $this->start_controls_section(
			'section_title_style_section',
			[
				'label' => __( 'Title Style', 'logistik' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

        $this->add_control(
			'section_title_color',
			[
				'label' 	=> __( 'Color', 'logistik' ),
				'type' 		=> Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .e-title' => 'color: {{VALUE}}!important;',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'section_title_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .e-title',
			]
		);

        $this->add_responsive_control(
			'section_title_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .e-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

        $this->add_responsive_control(
			'section_title_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .e-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
		);

        $this->end_controls_section();


	}

	protected function render() {

        $settings = $this->get_settings_for_display();
?>
        <?php if( $settings['layout_style'] == '2' ): ?>
			<div class="newsletter-wrapp">
				<form class="newsletter-form style3">
					<input class="form-control " type="email" placeholder="<?php echo esc_attr( $settings['newsletter_placeholder'] ); ?>" required="">
					<button type="submit" class="themeholy-btn blue-btn"><?php echo esc_html( $settings['newsletter_button'] ); ?><span class="icon"><i class="fa-sharp fa-regular fa-paper-plane"></i></span></button>
				</form>
			</div>

		<?php elseif( $settings['layout_style'] == '3' ): ?>
			<div class="footer-newsletter">
				<h3 class="h4 newsletter-title text-white"><?php echo esc_html($settings['title']); ?></h3>
				<div class="newletter-wrapper">
					<form class="newsletter-form">
						<input class="form-control" type="email" placeholder="<?php echo esc_attr( $settings['newsletter_placeholder'] ); ?>" required="">
						<button type="submit" class="themeholy-btn white-btn"><?php echo esc_html( $settings['newsletter_button'] ); ?><span class="icon"><i class="fa-sharp fa-regular fa-paper-plane"></i></span></button>
					</form>
				</div>
			</div>

		<?php elseif( $settings['layout_style'] == '4' ): ?>
			<div class="footer-top style2">
                <div class="row gx-0 align-items-center">
                    <div class="col-xl">
						<div class="footer-newsletter">
							<?php if(!empty($settings['image']['url'])): ?>
							<div class="footer-logo">
								<a href="<?php echo esc_url( $settings['button_link']['url'] ); ?>">
									<?php echo logistik_img_tag( array(
										'url'   => esc_url( $settings['image']['url']  ),
									));?>
								</a>
							</div>
							<?php endif; ?>
							<h3 class="h4 newsletter-title text-white"><?php echo esc_html($settings['title']); ?></h3>
							<div class="newletter-wrapper">
								<form class="newsletter-form">
									<input class="form-control" type="email" placeholder="Email Address" required="">
									<button type="submit" class="themeholy-btn blue-btn"><?php echo esc_html( $settings['newsletter_button'] ); ?><span class="icon"><i class="fa-sharp fa-regular fa-paper-plane"></i></span></button>
								</form>
							</div>
						</div>
					</div>
                </div>
            </div>
    	<?php else: ?>
            <div class="form-group newsletter-form style2">
				<input class="form-control" type="email" placeholder="<?php echo esc_attr( $settings['newsletter_placeholder'] ); ?>" required="">
				<button type="submit" class="themeholy-btn white-btn"><i class="fa-sharp fa-regular fa-paper-plane"></i></button>
			</div>
	<?php
	endif;
	}
}
						