<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Counter Up Widget .
 *
 */
class logistik_Counterup extends Widget_Base {

	public function get_name() {
		return 'logistikcounterup';
	}

	public function get_title() {
		return __( 'Counter Up', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'counter_section',
			[
				'label' 	=> __( 'Counter Up', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Layout Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2' 		=> __( 'Style Two', 'logistik' ),
					'3' 		=> __( 'Style Three', 'logistik' ),
				],
			]
		);   

		$repeater = new Repeater();

		$repeater->add_control(
            'image',
            [
                'label'     => __( 'Image/Icon', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
            ]
        );

		$repeater->add_control(
			'counter_number',
			[
				'label'     => __( 'Counter Number', 'logistik' ),
				'type'      => Controls_Manager::TEXTAREA,
				'rows' 		=> 2,
				'default' 	=> __( '25', 'logistik' ),
			]
		);	
		
		$repeater->add_control(
			'counter_number_after',
			[
				'label'     => __( 'Counter Number After', 'logistik' ),
				'type'      => Controls_Manager::TEXTAREA,
				'rows' 		=> 2,
				'default' 	=> __( '', 'logistik' ),
			]
		);	

		$repeater->add_control(
			'counter_text',
			[
				'label'     => __( 'Counter Text', 'logistik' ),
				'type'      => Controls_Manager::TEXTAREA,
				'rows' 		=> 2,
				'default' 	=> __( 'Project Completed', 'logistik' ),
			]
		);

		$this->add_control(
			'counter_list',
			[
				'label' 		=> __( 'Counter', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'counter_text' 		=> __( 'Counter One', 'logistik' ),
					],
				],
			]
		);

		$this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

        /*-----------------------------------------styling------------------------------------*/

		$this->start_controls_section(
			'overview_con_styling',
			[
				'label' 	=> __( 'Content Styling', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

        $this->start_controls_tabs(
			'style_tabs2'
		);

			$this->start_controls_tab(
				'style_normal_tab2',
				[
					'label' => esc_html__( 'Number', 'logistik' ),
				]
			);

			$this->add_control(
				'overview_title_color',
				[
					'label' 		=> __( 'Color', 'logistik' ),
					'type' 			=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .th-num'	=> 'color: {{VALUE}}!important;',
					],
				]
			);

			$this->add_group_control(
			Group_Control_Typography::get_type(),
				[
					'name' 			=> 'overview_title_typography',
					'label' 		=> __( 'Typography', 'logistik' ),
					'selector' 	=> '{{WRAPPER}} .th-num',
				]
			);

			$this->add_responsive_control(
				'overview_title_margin',
				[
					'label' 		=> __( 'Margin', 'logistik' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', '%', 'em' ],
					'selectors' 	=> [
						'{{WRAPPER}} .th-num' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'overview_title_padding',
				[
					'label' 		=> __( 'Padding', 'logistik' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', '%', 'em' ],
					'selectors' 	=> [
						'{{WRAPPER}} .th-num' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->end_controls_tab();

			//--------------------secound--------------------//

			$this->start_controls_tab(
				'style_hover_tab2',
				[
					'label' => esc_html__( 'Title', 'logistik' ),
				]
			);

			$this->add_control(
				'overview_content_color',
				[
					'label' 		=> __( 'Color', 'logistik' ),
					'type' 			=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .th-title'	=> 'color: {{VALUE}}!important;',
					],
				]
			);

			$this->add_group_control(
			Group_Control_Typography::get_type(),
				[
					'name' 			=> 'overview_content_typography',
					'label' 		=> __( 'Typography', 'logistik' ),
					'selector' 	=> '{{WRAPPER}} .th-title',
				]
			);

			$this->add_responsive_control(
				'overview_content_margin',
				[
					'label' 		=> __( 'Margin', 'logistik' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', '%', 'em' ],
					'selectors' 	=> [
						'{{WRAPPER}} .th-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->add_responsive_control(
				'overview_content_padding',
				[
					'label' 		=> __( 'Padding', 'logistik' ),
					'type' 			=> Controls_Manager::DIMENSIONS,
					'size_units' 	=> [ 'px', '%', 'em' ],
					'selectors' 	=> [
						'{{WRAPPER}} .th-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
					],
				]
			);

			$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->end_controls_section();
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		?>
		<?php if( $settings['layout_style'] == '2' ): ?>
			<div class="row gy-40 justify-content-center">
				<?php  foreach( $settings['counter_list'] as $data ): ?>
				<div class="col-sm-6 col-lg-3">
					<div class="counter-card">
						<div class="border-line" data-bg-src="<?php echo LOGISTIK_ASSETS;?>img/line.svg"></div>
						<div class="counter-card_icon">
							<?php echo logistik_img_tag( array(
								'url'   => esc_url( $data['image']['url']  ),
							)); ?>
						</div>
						<h2 class="counter-card_number th-num"><span class="counter-number"><?php echo esc_html( $data['counter_number'] ) ?></span><?php echo esc_html( $data['counter_number_after'] ) ?></h2>
						<p class="counter-card_text th-title"><?php echo wp_kses_post( $data['counter_text'] ) ?></p>
					</div>
				</div>
				<?php endforeach; ?>
			</div>

    	<?php elseif( $settings['layout_style'] == '3' ): ?>
			<div class="counter-sec-space style2 bg-theme2">
				<?php  foreach( $settings['counter_list'] as $data ): ?>
				<div class="counter-card style2">
					<div class="counter-card_wrapper">
						<div class="counter-card_icon">
							<?php echo logistik_img_tag( array(
									'url'   => esc_url( $data['image']['url']  ),
								)); ?>
						</div>
						<div class="counter-card_content">
							<h2 class="counter-card_number"><span class="counter-number"><?php echo esc_html( $data['counter_number'] ) ?></span><?php echo esc_html( $data['counter_number_after'] ) ?> </h2>
							<p class="counter-card_text"><?php echo wp_kses_post( $data['counter_text'] ) ?></p>
						</div>
					</div>
				</div>
				<?php endforeach; ?>
			</div>

		<?php else: ?>
			<div class="about-counter-wrap">
				<?php  foreach( $settings['counter_list'] as $key =>  $data ): ?>
				<div class="about-counter">
					<?php if($key == 0): ?>
					<div class="border-line" data-bg-src="<?php echo LOGISTIK_ASSETS;?>img/line-2.svg"></div>
					<?php endif; ?>
					<div class="achive-about_icon">
						<?php echo logistik_img_tag( array(
							'url'   => esc_url( $data['image']['url']  ),
						)); ?>
					</div>
					<div class="about-counter-content">
						<h2 class="counter-card_number th-num"><span class="counter-number"><?php echo esc_html( $data['counter_number'] ) ?></span><?php echo esc_html( $data['counter_number_after'] ) ?></h2>
						<p class="counter-card_text th-title"><?php echo wp_kses_post( $data['counter_text'] ) ?></p>
					</div>
				</div>
				<?php endforeach; ?>
			</div>

		<?php endif;

	}

}