<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Utils;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Repeater;
/**
 *
 * Contact Form Widget .
 *
 */
class logistik_Contact_Form extends Widget_Base {

	public function get_name() {
		return 'logistikcontactform';
	}

	public function get_title() {
		return __( 'Contact Form', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik' ];
	}

	public function get_as_contact_form(){
        if ( ! class_exists( 'WPCF7' ) ) {
            return;
        }
        $as_cfa         = array();
        $as_cf_args     = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
        $as_forms       = get_posts( $as_cf_args );
        $as_cfa         = ['0' => esc_html__( 'Select Form', 'logistik' ) ];
        if( $as_forms ){
            foreach ( $as_forms as $as_form ){
                $as_cfa[$as_form->ID] = $as_form->post_title;
            }
        }else{
            $as_cfa[ esc_html__( 'No contact form found', 'logistik' ) ] = 0;
        }
        return $as_cfa;
    }

	protected function register_controls() {

		$this->start_controls_section(
			'contact_form_section',
			[
				'label' 	=> __( 'Contact Form', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Layout Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2' 		=> __( 'Style Two', 'logistik' ),
					'3' 		=> __( 'Style Three', 'logistik' ),
					'4' 		=> __( 'Style Four', 'logistik' ),
					'5' 		=> __( 'Style Five', 'logistik' ),
					'6' 		=> __( 'Style Six', 'logistik' ),
				],
			]
		);  
		
		$this->add_control(
			'image',
			[
				'label' 		=> __( 'Choose Image', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 			=> Utils::get_placeholder_image_src(),
				],
				'condition'	=> [
					'layout_style' => ['3'],
				]
			]
		);   

		$this->add_control(
			'image2',
			[
				'label' 		=> __( 'Choose Image 2', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition'	=> [
					'layout_style' => ['3'],
				]
			]
		);   
		
		$this->add_control(
			'title',
			[
				'label' 	=> __( 'Title', 'logistik' ),
                'type' 		=> Controls_Manager::TEXTAREA,
                'default'  	=> __( 'Title', 'logistik' ),
			]
        );

         $this->add_control(
            'logistik_select_contact_form',
            [
                'label'   => esc_html__( 'Select Form', 'logistik' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '0',
                'options' => $this->get_as_contact_form(),
            ]
        );

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------------------------------------General styling-------------------------------------//
        $this->start_controls_section(
			'style',
			[
				'label' => __( 'Style', 'logistik' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'general_bg',
			[
				'label' 		=> __( 'Background Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-bg' => 'background-color: {{VALUE}}!important',
                ],
			]
        );

       $this->add_responsive_control(
			'general_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-bg' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
			]
        );

       	$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'contact_box_shadow',
				'label' => esc_html__( 'Box Shadow', 'logistik' ),
				'selector' => '{{WRAPPER}} .th-bg',
			]
		);
		
        $this->end_controls_section();

		//---------------------------------------Title Style---------------------------------------//
		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'tayde' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Color', 'tayde' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'color: {{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Typography', 'tayde' ),
				'selector' 	=> '{{WRAPPER}} .th-title',
			]
		);
		$this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Margin', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Padding', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

		//---------------------------------------Button Style---------------------------------------//
		$this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Button Style', 'advoker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Color', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_h_color',
			[
				'label' 		=> __( 'Hover Color ', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_bg',
			[
				'label' 		=> __( 'Background Color', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:before' => 'background-color:{{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_h_bg',
			[
				'label' 		=> __( 'Background Hover Color', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'background-color:{{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Typography', 'advoker' ),
				'selector' 	=> '{{WRAPPER}} .th-btn',
			]
		);

		$this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Margin', 'advoker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Padding', 'advoker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'advoker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

	}

	protected function render() {

	    $settings = $this->get_settings_for_display();

	    ?>
		<?php if( $settings['layout_style'] == '2' ): ?>
			<div class="service-form th-bg style2 ajax-contact">
				<h3 class="fs-24 mb-20 mt-n1 text-white th-title"><?php echo esc_html($settings['title']); ?></h3>
				<?php 
					if( !empty($settings['logistik_select_contact_form']) ){
						echo do_shortcode( '[contact-form-7  id="'.$settings['logistik_select_contact_form'].'"]' ); 
					}else{
						echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'logistik' ). '</p></div>';
					}
				?>
			</div>

		<?php elseif( $settings['layout_style'] == '3' ): ?>
		<div class="contact-sec bg-bottom-center bg-smoke  th-bg">
			<div class="container">
				<div class="row align-items-end">
					<div class="col-xl-5 col-lg-5">
						<div class="contact-form-wrapp">
							<div class="service-form style2 ajax-contact">
								<h3 class="fs-24 mb-20 mt-n1 text-white th-title"><?php echo esc_html($settings['title']); ?></h3>
								<?php 
									if( !empty($settings['logistik_select_contact_form']) ){
										echo do_shortcode( '[contact-form-7  id="'.$settings['logistik_select_contact_form'].'"]' ); 
									}else{
										echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'logistik' ). '</p></div>';
									}
								?>
							</div>
						</div>
					</div>
					<div class="col-xl-7 col-lg-7">
						<div class="contact-wrapper">
							<div class="contact-form-image">
								<?php echo logistik_img_tag( array(
									'url'   => esc_url( $settings['image']['url'] ),
								)); ?>
							</div>
							<div class="shape">
								<?php echo logistik_img_tag( array(
									'url'   => esc_url( $settings['image2']['url'] ),
								)); ?>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>

		<?php elseif( $settings['layout_style'] == '4' ): ?>
			<div class="team-contact th-bg">
				<div class="team-form ajax-contact">
					<h3 class="fs-24 mb-20 mt-n1 th-title"><?php echo esc_html($settings['title']); ?></h3>
					<?php 
						if( !empty($settings['logistik_select_contact_form']) ){
							echo do_shortcode( '[contact-form-7  id="'.$settings['logistik_select_contact_form'].'"]' ); 
						}else{
							echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'logistik' ). '</p></div>';
						}
					?>
				</div>
			</div>

		<?php elseif( $settings['layout_style'] == '5' ): ?>
			<div class="contact-form-wrapper th-bg">
				<div class="contact-form ajax-contact">
					<h2 class="form-title th-title"><?php echo esc_html($settings['title']); ?><span class="shape"></span></h2>
					<?php 
						if( !empty($settings['logistik_select_contact_form']) ){
							echo do_shortcode( '[contact-form-7  id="'.$settings['logistik_select_contact_form'].'"]' ); 
						}else{
							echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'logistik' ). '</p></div>';
						}
					?>
				</div>
			</div>

		<?php elseif( $settings['layout_style'] == '6' ): ?>
			<div class="map-form-wrapper">
				<div class="map-form ajax-contact">
					<h3 class="fs-24 mb-20 mt-n1 text-white"><?php echo esc_html($settings['title']); ?></h3>
					<?php 
						if( !empty($settings['logistik_select_contact_form']) ){
							echo do_shortcode( '[contact-form-7  id="'.$settings['logistik_select_contact_form'].'"]' ); 
						}else{
							echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'logistik' ). '</p></div>';
						}
					?>
				</div>
			</div>

		<?php else: ?>
			<div class="service-form-wrap">
				<div class="service-form  th-bg ajax-contact">
					<h3 class="fs-24 mb-30 mt-n1 text-white th-title"><?php echo esc_html($settings['title']); ?></h3>
					<?php 
						if( !empty($settings['logistik_select_contact_form']) ){
							echo do_shortcode( '[contact-form-7  id="'.$settings['logistik_select_contact_form'].'"]' ); 
						}else{
							echo '<div class="alert alert-warning"><p class="m-0">' . __('Please Select contact form.', 'logistik' ). '</p></div>';
						}
					?>
				</div>
			</div>
	    	 
	    <?php endif;

	}

}