<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Button Widget .
 *
 */
class logistik_Button extends Widget_Base {

	public function get_name() {
		return 'logistikbutton';
	}

	public function get_title() {
		return __( 'Button', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik' ];
	}


	protected function register_controls() {

		$this->start_controls_section(
			'button_section',
			[
				'label' 	=> __( 'Button', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );
        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Button Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'default' 	=> '1',
				'options' 	=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					// '2' 		=> __( 'Style Two', 'logistik' ),
					// '3' 		=> __( 'Style Three', 'logistik' ),
				],
			]
		);

        $this->add_control(
			'button_text',
			[
				'label' 	=> __( 'Button Text', 'logistik' ),
                'type' 		=> Controls_Manager::TEXT,
                'label_block' => true,
                'default'  	=> __( 'Button Text', 'logistik' )
			]
        );

        $this->add_control(
			'button_link',
			[
				'label' 		=> __( 'Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

        $this->add_responsive_control(
			'button_align2',
			[
				'label' 		=> __( 'Alignment', 'logistik' ),
				'type' 			=> Controls_Manager::CHOOSE,
				'options' 		=> [
					'left' 	=> [
						'title' 		=> __( 'Left', 'logistik' ),
						'icon' 			=> 'eicon-text-align-left',
					],
					'center' 	=> [
						'title' 		=> __( 'Center', 'logistik' ),
						'icon' 			=> 'eicon-text-align-center',
					],
					'right' 	=> [
						'title' 		=> __( 'Right', 'logistik' ),
						'icon' 			=> 'eicon-text-align-right',
					],
				],
				'default' 		=> 'left',
				'toggle' 		=> true,
				'selectors' 	=> [
					'{{WRAPPER}} .btn-wrapper' => 'justify-content: {{VALUE}}',
                ],
			]
        );

        $this->end_controls_section();

        //---------------------------------------
			//Style Section Start
		//---------------------------------------

        //-------------------------------------Button styling-------------------------------------//
        $this->start_controls_section(
			'layout_style_section',
			[
				'label' 	=> __( 'Button Style', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Button Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .th-btn',
			]
        );

		$this->start_controls_tabs(
			'button_tabs'
		);

			$this->start_controls_tab(
				'normal_tab_label',
				[
					'label' => esc_html__( 'Normal', 'logistik' ),
				]
			);

			$this->add_control(
				'button_color',
				[
					'label' 		=> __( 'Button Color', 'logistik' ),
					'type' 			=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .th-btn' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'button_bg_color',
				[
					'label' 		=> __( 'Button Background Color', 'logistik' ),
					'type' 			=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .th-btn, {{WRAPPER}} .th-btn:before' => 'background-color:{{VALUE}} !important',
					],
				]
			);
			
			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' 		=> 'border',
					'label' 	=> __( 'Border', 'logistik' ),
					'selector' 	=> '{{WRAPPER}} .th-btn',
				]
			);

			$this->end_controls_tab();

			$this->start_controls_tab(
				'hover_tab_label',
				[
					'label' => esc_html__( 'Hover', 'logistik' ),
				]
			);

			$this->add_control(
				'button_color_hover',
				[
					'label' 		=> __( 'Button Color', 'logistik' ),
					'type' 			=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .th-btn:hover' => 'color: {{VALUE}}',
					],
				]
			);

			$this->add_control(
				'button_bg_hover_color',
				[
					'label' 		=> __( 'Button Background Color', 'logistik' ),
					'type' 			=> Controls_Manager::COLOR,
					'selectors' 	=> [
						'{{WRAPPER}} .th-btn:hover' => 'background-color:{{VALUE}} !Important',
					],
				]
			);

			$this->add_group_control(
				Group_Control_Border::get_type(),
				[
					'name' 		=> 'border_hover',
					'label' 	=> __( 'Border', 'logistik' ),
					'selector' 	=> '{{WRAPPER}} .th-btn:hover',
				]
			);

			$this->end_controls_tab();

		$this->end_controls_tabs();

		$this->add_control(
			'hr',
			[
				'type' => \Elementor\Controls_Manager::DIVIDER,
			]
		);

        $this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Button Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Button Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

        $this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Button Border Radius', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'box_shadow',
				'label' => esc_html__( 'Button Shadow', 'logistik' ),
				'selector' => '{{WRAPPER}} .th-btn',
			]
		);

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

        $this->add_render_attribute( 'wrapper', 'class', 'btn-group btn-wrapper');
		
        // $this->add_render_attribute( 'wrapper', 'class', esc_attr(  $settings['button_align'] ) );
        if( $settings['layout_style'] == '2' ){
		    $this->add_render_attribute( 'button', 'class', 'as-btn white-btn e-btn' );
		}else{
			$this->add_render_attribute( 'button', 'class', 'themeholy-btn th-btn' );
		}

        if( ! empty( $settings['button_link']['url'] ) ) {
            $this->add_render_attribute( 'button', 'href', esc_url( $settings['button_link']['url'] ) );
        }
        if( ! empty( $settings['button_link']['nofollow'] ) ) {
            $this->add_render_attribute( 'button', 'rel', 'nofollow' );
        }
        if( ! empty( $settings['button_link']['is_external'] ) ) {
            $this->add_render_attribute( 'button', 'target', '_blank' );
        }

        echo '<div '.$this->get_render_attribute_string('wrapper').'>';
        	if( ! empty( $settings['button_text'] ) ) {
        		echo '<a '.$this->get_render_attribute_string('button').'>'.wp_kses_post( $settings['button_text'] ).'</a>';
        	}
        echo '</div>';

	}

}