<?php
use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Border;
/**
 *
 * Banner Widget.
 *
 */
class logistik_Banner extends Widget_Base {

	public function get_name() {
		return 'logistikbanner';
	}

	public function get_title() {
		return __( 'Banner', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik_header_elements' ];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'Banner_section',
			[
				'label' 	=> __( 'Banner', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

		$this->add_control(
			'layout_style',
			[
				'label' 		=> __( 'Layout Style', 'logistik' ),
				'type' 			=> Controls_Manager::SELECT,
				'default' 		=> '1',
				'options' 		=> [
					'1'  		=> __( 'Style One', 'logistik' ),
					'2' 		=> __( 'Style Two', 'logistik' ),
					'3' 		=> __( 'Style Three', 'logistik' ),
					'4' 		=> __( 'Style Four', 'logistik' ),
					'5' 		=> __( 'Style Five', 'logistik' ),
				],
			]
		);

		//-------------------------------Style 1-------------------------------//
  		$repeater = new Repeater();

        $repeater->add_control(
            'banner_img',
            [
                'label'     => __( 'Banner Image', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );

		$repeater->add_control(
            'subtitle_shape',
            [
                'label'     => __( 'Subtitle Shape', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
            ]
        );

        $repeater->add_control(
			'banner_subtitle', [
				'label' 		=> __( 'Sub Title', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Subtitle here' , 'logistik' ),
				'label_block' 	=> true,
				'separator' => 'before',
			]
        );

        $repeater->add_control(
			'banner_title', [
				'label' 		=> __( 'Title 1', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Title 1 here' , 'logistik' ),
				'label_block' 	=> true,
			]
        );

		$repeater->add_control(
			'banner_desc', [
				'label' 		=> __( 'Description', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 4,
				'default' 		=> __( 'Description here' , 'logistik' ),
				'label_block' 	=> true,
			]
        );
        
        $repeater->add_control(
			'button_text',
			[
				'label' 	=> esc_html__( 'Button Text', 'logistik' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Apply Now', 'logistik' ),
				'label_block' => true,
				'separator' => 'before'
			]
        );

        $repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$repeater->add_control(
			'button_text2',
			[
				'label' 	=> esc_html__( 'Button Text 2', 'logistik' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Learn More', 'logistik' ),
				'label_block' => true,
				'separator' => 'before'
			]
        );

        $repeater->add_control(
			'button_link2',
			[
				'label' 		=> esc_html__( 'Button Link 2', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'banner_slides',
			[
				'label' 		=> __( 'Banners', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'banner_subtitle' 	=> __( 'We’re Provide best services', 'logistik' ),
						'banner_title' 		=> __( 'transport For Everything', 'logistik' ),
					],
				],		
				'condition'	=> [
					'layout_style' => ['1', '3']
				]			
			]
		);

		//-------------------------------Style 2-------------------------------//
		$repeater2 = new Repeater();

        $repeater2->add_control(
            'banner_img',
            [
                'label'     => __( 'Banner Image', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
            ]
        );

        $repeater2->add_control(
            'shape',
            [
                'label'     => __( 'Shape Image', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
            ]
        );

		$repeater2->add_control(
            'subtitle_shape',
            [
                'label'     => __( 'Subtitle Shape', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
            ]
        );

        $repeater2->add_control(
			'banner_subtitle', [
				'label' 		=> __( 'Sub Title', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Subtitle here' , 'logistik' ),
				'label_block' 	=> true,
				'separator' => 'before',
			]
        );

        $repeater2->add_control(
			'banner_title', [
				'label' 		=> __( 'Title 1', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Title 1 here' , 'logistik' ),
				'label_block' 	=> true,
			]
        );
        
        $repeater2->add_control(
			'button_text',
			[
				'label' 	=> esc_html__( 'Button Text', 'logistik' ),
                'type' 		=> Controls_Manager::TEXT,
                'default'  	=> esc_html__( 'Apply Now', 'logistik' ),
				'label_block' => true,
				'separator' => 'before'
			]
        );

        $repeater2->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'banner_slides2',
			[
				'label' 		=> __( 'Banners', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater2->get_controls(),
				'default' 		=> [
					[
						'banner_subtitle' 	=> __( 'We’re Provide best services', 'logistik' ),
						'banner_title' 		=> __( 'transport For Everything', 'logistik' ),
					],
				],		
				'condition'	=> [
					'layout_style' => ['2']
				]			
			]
		);

		//-------------------------------Style 3-------------------------------//
		$repeater3 = new Repeater();

		$repeater3->add_control(
			'banner_img',
			[
				'label'     => __( 'Banner Image', 'logistik' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater3->add_control(
			'subtitle_shape',
			[
				'label'     => __( 'Subtitle Shape', 'logistik' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
			]
		);

		$repeater3->add_control(
			'banner_subtitle', [
				'label' 		=> __( 'Sub Title', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Subtitle here' , 'logistik' ),
				'label_block' 	=> true,
				'separator' => 'before',
			]
		);

		$repeater3->add_control(
			'banner_title', [
				'label' 		=> __( 'Title 1', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Title 1 here' , 'logistik' ),
				'label_block' 	=> true,
			]
		);
		
		$repeater3->add_control(
			'button_text',
			[
				'label' 	=> esc_html__( 'Button Text', 'logistik' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> esc_html__( 'Apply Now', 'logistik' ),
				'label_block' => true,
				'separator' => 'before'
			]
		);

		$repeater3->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$repeater3->add_control(
			'video_link',
			[
				'label' 		=> esc_html__( 'Video Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'banner_slides3',
			[
				'label' 		=> __( 'Banners', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater3->get_controls(),
				'default' 		=> [
					[
						'banner_subtitle' 	=> __( 'We’re Provide best services', 'logistik' ),
						'banner_title' 		=> __( 'Rail Freight and Logistics', 'logistik' ),
					],
				],		
				'condition'	=> [
					'layout_style' => ['4']
				]			
			]
		);

		//-------------------------------Style 5-------------------------------//
		$repeater = new Repeater();

		$repeater->add_control(
			'banner_img',
			[
				'label'     => __( 'Banner Image', 'logistik' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
				'default' 		=> [
					'url' 		=> Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'subtitle_shape',
			[
				'label'     => __( 'Subtitle Shape', 'logistik' ),
				'type'      => Controls_Manager::MEDIA,
				'dynamic' 		=> [
					'active' 		=> true,
				],
			]
		);

		$repeater->add_control(
			'banner_subtitle', [
				'label' 		=> __( 'Sub Title', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Subtitle here' , 'logistik' ),
				'label_block' 	=> true,
				'separator' => 'before',
			]
		);

		$repeater->add_control(
			'banner_title', [
				'label' 		=> __( 'Title 1', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 2,
				'default' 		=> __( 'Title 1 here' , 'logistik' ),
				'label_block' 	=> true,
			]
		);

		$repeater->add_control(
			'banner_desc', [
				'label' 		=> __( 'Description', 'logistik' ),
				'type' 			=> Controls_Manager::TEXTAREA,
				'rows' 			=> 4,
				'default' 		=> __( 'Description here' , 'logistik' ),
				'label_block' 	=> true,
			]
		);
		
		$repeater->add_control(
			'button_text',
			[
				'label' 	=> esc_html__( 'Button Text', 'logistik' ),
				'type' 		=> Controls_Manager::TEXT,
				'default'  	=> esc_html__( 'Apply Now', 'logistik' ),
				'label_block' => true,
				'separator' => 'before'
			]
		);

		$repeater->add_control(
			'button_link',
			[
				'label' 		=> esc_html__( 'Button Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
			]
		);

		$this->add_control(
			'banner_slides4',
			[
				'label' 		=> __( 'Banners', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'banner_subtitle' 	=> __( 'We’re Provide best services', 'logistik' ),
						'banner_title' 		=> __( 'transport For Everything', 'logistik' ),
					],
				],		
				'condition'	=> [
					'layout_style' => ['5']
				]			
			]
		);

		$this->add_control(
            'Shape1',
            [
                'label'     => __( 'Shape 1', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],
				'condition'	=> [
					'layout_style' => ['3']
				]	
            ]
        );
		
		$this->add_control(
            'Shape2',
            [
                'label'     => __( 'Shape 2', 'logistik' ),
                'type'      => Controls_Manager::MEDIA,
                'dynamic' 		=> [
					'active' 		=> true,
				],

				'condition'	=> [
					'layout_style' => ['3']
				]
            ]
        );

		$this->end_controls_section();


        //---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-------------------------------------General styling-------------------------------------//
		$this->start_controls_section(
			'style',
			[
				'label' => __( 'General Style', 'logistik' ),
				'tab' 	=> Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		$this->add_group_control(
			\Elementor\Group_Control_Background::get_type(),
			[
				'name' => 'background',
				'types' => [ 'gradient' ],
				'selector' => '{{WRAPPER}} .hero-1 .themeholy-hero-slide:before',
			]
		);
		
		$this->end_controls_section();

        //---------------------------------------Subtitle Style---------------------------------------//
		$this->start_controls_section(
			'subtitle_style',
			[
				'label' 	=> __( 'Subtitle Style', 'logistik' ), 
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'color: {{VALUE}}',
                ],
			]
        );	

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'subtitle_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .th-sub',
			]
        );

        $this->add_responsive_control(
			'subtitle_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'subtitle_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-sub' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);

		$this->end_controls_section();

		//---------------------------------------Title Style---------------------------------------//
		$this->start_controls_section(
			'title_style',
			[
				'label' 	=> __( 'Title Style', 'tayde' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' 		=> __( 'Color', 'tayde' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'color: {{VALUE}} !important',
                ],
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Typography', 'tayde' ),
                'selector' 	=> '{{WRAPPER}} .th-title',
			]
        );
        $this->add_responsive_control(
			'title_margin',
			[
				'label' 		=> __( 'Margin', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
        );

        $this->add_responsive_control(
			'title_padding',
			[
				'label' 		=> __( 'Padding', 'tayde' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ]
			]
		);
		$this->end_controls_section();

		//---------------------------------------Description Style---------------------------------------//
		$this->start_controls_section(
			'desc_style',
			[
				'label' 	=> __( 'Description Style', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'layout_style' => ['1']
				]
			]
		);

		$this->add_control(
			'desc_color',
			[
				'label' 		=> __( 'Color', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'desc_typography',
				'label' 	=> __( 'Typography', 'logistik' ),
				'selector' 	=> '{{WRAPPER}} .th-desc',
			]
		);

		$this->add_responsive_control(
			'desc_margin',
			[
				'label' 		=> __( 'Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'desc_padding',
			[
				'label' 		=> __( 'Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

		//---------------------------------------Button Style---------------------------------------//
		$this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Button Style', 'advoker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Color', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th_btn' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_h_color',
			[
				'label' 		=> __( 'Hover Color ', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th_btn:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_bg',
			[
				'label' 		=> __( 'Background Color', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th_btn:before' => 'background-color:{{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_h_bg',
			[
				'label' 		=> __( 'Background Hover Color', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th_btn' => 'background-color:{{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Typography', 'advoker' ),
				'selector' 	=> '{{WRAPPER}} .th_btn',
			]
		);

		$this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Margin', 'advoker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th_btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Padding', 'advoker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th_btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'advoker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th_btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

		//---------------------------------------Button 2 Style---------------------------------------//
		$this->start_controls_section(
			'button_style_section2',
			[
				'label' 	=> __( 'Button 2 Style', 'advoker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
				'condition'	=> [
					'layout_style' => ['3']
				]
			]
		);

		$this->add_control(
			'button_color2',
			[
				'label' 		=> __( 'Color', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn2' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_h_color2',
			[
				'label' 		=> __( 'Hover Color ', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn2:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_bg2',
			[
				'label' 		=> __( 'Background Color', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn2:before' => 'background-color:{{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_h_bg2',
			[
				'label' 		=> __( 'Background Hover Color', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn2' => 'background-color:{{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography2',
				'label' 	=> __( 'Typography', 'advoker' ),
				'selector' 	=> '{{WRAPPER}} .th-btn2',
			]
		);

		$this->add_responsive_control(
			'button_margin2',
			[
				'label' 		=> __( 'Margin', 'advoker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn2' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'button_padding2',
			[
				'label' 		=> __( 'Padding', 'advoker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn2' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->add_responsive_control(
			'button_border_radius2',
			[
				'label' 		=> __( 'Border Radius', 'advoker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn2' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings_for_display();

?>
	<?php if( $settings['layout_style'] == '2' ): ?>
	<div class="themeholy-hero-wrapper hero-2" id="hero">
        <div class="hero-slider-wrap-2">
            <div class="hero-slider-2 number-dots themeholy-carousel" id="heroSlide1" data-fade="true" data-slide-show="1" data-md-slide-show="1" data-arrows="true">
				<?php foreach( $settings['banner_slides2'] as $data ): ?>
                <div class="themeholy-hero-slide">
                    <div class="themeholy-hero-bg" data-bg-src="<?php echo esc_url($data['banner_img']['url']); ?>">
                        <div class="hero-shape"> 
							<?php echo logistik_img_tag( array(
								'url'   => esc_url( $data['shape']['url']  ),
							)); ?>
						</div>
                    </div>
                    <div class="container">
                        <div class="hero-style2">
                            <span class="hero-subtitle th-sub">
								<?php echo logistik_img_tag( array(
									'url'   => esc_url( $data['subtitle_shape']['url']  ),
								)); ?>
							<?php echo wp_kses_post($data['banner_subtitle']) ?>
							</span>
                            <h1 class="hero-title th-title"><?php echo wp_kses_post($data['banner_title']) ?></h1>
                            <div class="btn-group mt-30"><a href="<?php echo esc_url( $data['button_link']['url'] ); ?>" class="themeholy-btn blue-btn th_btn"><?php echo wp_kses_post($data['button_text']); ?></a>
                            </div>
                        </div>
                    </div>
                </div>
				<?php endforeach; ?>
            </div>
        </div>
        <div class="hero-indicator-wrapp">
            <div class="hero-indicator" data-asnavfor=".hero-slider-2">
				<?php foreach( $settings['banner_slides2'] as $key => $data ): 
					$active = ($key==0) ? 'active' : ''; ?>
                	<a class="indicatior-btn <?php echo $active; ?>">
						<?php echo logistik_img_tag( array(
								'url'   => esc_url( $data['banner_img']['url']  ),
							)); ?>
					</a>
				<?php endforeach; ?>
            </div>
        </div>
    </div>

	<?php elseif($settings['layout_style'] == '3' ): ?>
	<section class="themeholy-hero-wrapper hero-3" id="hero">
        <div class="hero-slider-3 themeholy-carousel" data-fade="true" data-slide-show="1" data-md-slide-show="1" data-arrows="true" data-xl-arrows="true" data-ml-arrows="true" data-lg-arrows="true">
			<?php foreach( $settings['banner_slides'] as $data ): ?>
            <div class="themeholy-hero-slide">
                <div class="themeholy-hero-bg zoom" data-bg-src="<?php echo esc_url($data['banner_img']['url']); ?>">
                </div>
                <div class="container">
                    <div class="hero-style3">
                        <span class="hero-subtitle th-sub" data-ani="slideindown" data-ani-delay="0.1s">
							<?php echo logistik_img_tag( array(
								'url'   => esc_url( $data['subtitle_shape']['url']  ),
							)); ?>
							<?php echo wp_kses_post($data['banner_subtitle']) ?>
						</span>
                        <h1 class="hero-title th-title" data-ani="slideindown" data-ani-delay="0.0s"><?php echo wp_kses_post($data['banner_title']) ?></h1>
						<p class="hero-text th-desc mx-auto slideinup"><?php echo esc_html($data['banner_desc']); ?></p>
                        <div class="btn-group justify-content-center slideinup" data-ani="slideinleft" data-ani-delay="0.9s">
                            <a href="<?php echo esc_url( $data['button_link']['url'] ); ?>" class="themeholy-btn th_btn blue-btn2"><?php echo wp_kses_post($data['button_text']); ?></a>
                            <a href="<?php echo esc_url( $data['button_link2']['url'] ); ?>" class="themeholy-btn th-btn2 white-btn"><?php echo wp_kses_post($data['button_text2']); ?></a>
                        </div>
                    </div>
                </div>
            </div>
			<?php endforeach; ?>
        </div>
        <div class="shape-mockup movingX d-none d-xxl-block" data-top="25%" data-left="0%">
			<?php echo logistik_img_tag( array(
				'url'   => esc_url( $settings['Shape1']['url']  ),
			)); ?>
		</div>
        <div class="shape-mockup movingX d-none d-xxl-block" data-bottom="0px" data-right="0%">
			<?php echo logistik_img_tag( array(
				'url'   => esc_url( $settings['Shape2']['url']  ),
			)); ?>
		</div>
    </section>

	<?php elseif($settings['layout_style'] == '4' ): ?>
	<div class="themeholy-hero-wrapper hero-4" id="hero">
        <div class="slider-nav">
			<?php foreach( $settings['banner_slides3'] as $data ): ?>
            <div class="themeholy-hero-slide" data-bg-src="<?php echo esc_url($data['banner_img']['url']); ?>">
                <div class="container">
                    <div class="row align-items-center justify-content-center">
                        <div class="col-lg-8 col-md-10">
                            <div class="hero-style4">
                                <span class="hero-subtitle th-sub">
									<?php echo logistik_img_tag( array(
											'url'   => esc_url( $data['subtitle_shape']['url']  ),
										)); ?>
									<?php echo wp_kses_post($data['banner_subtitle']) ?>
								</span>
                                <h1 class="hero-title text-white th-title">
									<?php echo wp_kses_post($data['banner_title']) ?>
								</h1>
                                <div class="btn-group mt-40">
									<a href="<?php echo esc_url( $data['button_link']['url'] ); ?>" class="themeholy-btn blue-btn th_btn"><?php echo wp_kses_post($data['button_text']); ?></a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4 text-lg-end text-center">
							<?php if(!empty($data['video_link']['url'])): ?>
                            <div class="hero-video-1">
                                <a href="<?php echo esc_url( $data['video_link']['url'] ); ?>" class="play-btn style2 popup-video"><i class="fas fa-play"></i></a>
                            </div>
							<?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
			<?php endforeach; ?>
        </div>
        <div class="slider-dots-box">
            <ul class="slider-img">
				<?php foreach( $settings['banner_slides3'] as $data ): ?>
                	<li> <a class="">
						<?php echo logistik_img_tag( array(
							'url'   => esc_url( $data['banner_img']['url']  ),
						)); ?>
					</a></li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>

	<?php elseif($settings['layout_style'] == '5' ): ?>
		<div class="themeholy-hero-wrapper hero-5" id="hero">
       		<div class="heroSlider2 hero-slider-wrap-5">
           		<div class="hero-slider-5 number-dots themeholy-carousel" id="heroSlide1">
					<?php foreach( $settings['banner_slides4'] as $data ): ?>
					<div class="themeholy-hero-slide">
						<div class="themeholy-hero-bg" data-bg-src="<?php echo esc_url($data['banner_img']['url']); ?>">
						</div>
						<div class="container">
							<div class="hero-style5">
								<span class="hero-subtitle th-sub">
									<?php echo logistik_img_tag( array(
											'url'   => esc_url( $data['subtitle_shape']['url']  ),
										)); ?>
									<?php echo wp_kses_post($data['banner_subtitle']) ?>
								</span>
								<h1 class="hero-title th-title"><?php echo wp_kses_post($data['banner_title']) ?></h1>
								<p class="hero-text th-desc"><?php echo esc_html($data['banner_desc']); ?></p>
								<div class="btn-group mt-30">
									<a href="<?php echo esc_url( $data['button_link']['url'] ); ?>" class="themeholy-btn th_btn"><?php echo wp_kses_post($data['button_text']); ?></a>
								</div>
							</div>
						</div>
					</div>
					<?php endforeach; ?>
				</div>
			</div>
			<div class="hero-indicator-area home5-indicator">
				<div class="hero-indicator5 " data-asnavfor=".hero-slider-5">
					<?php foreach( $settings['banner_slides4'] as $key => $data ): 
						$active = ($key == 0) ? 'active':'';
					?>
					<a class="indicatior-btn <?php echo esc_attr($active); ?>">
						<?php echo logistik_img_tag( array(
								'url'   => esc_url( $data['banner_img']['url']  ),
							)); ?>
					</a>
					<?php endforeach; ?>
				</div>
			</div>
			<div class="indicator-number">
				<div class="indicator-wrapper">
					<div class="number-pagination">01<span class="paging1"></span></div>
					<div class="progress-wrapper">
						<div class="progress" role="progressbar" aria-valuemin="0" aria-valuemax="100">
							<span class="slider__line sr-only"></span>
						</div>
					</div>
					<div class="total-pagination">03<span class="paging2"></span></div>
				</div>
			</div>
		</div>

	<?php else: ?>
		<section class="themeholy-hero-wrapper hero-1" id="hero">
			<div class="heroSlider hero-slider-1">
				<?php foreach( $settings['banner_slides'] as $data ): ?>
				<div class="themeholy-hero-slide" data-bg-src="<?php echo esc_url($data['banner_img']['url']); ?>">
					<div class="container">
						<div class="hero-style1">
							<span class="hero-subtitle th-sub">
								<?php echo logistik_img_tag( array(
									'url'   => esc_url( $data['subtitle_shape']['url']  ),
								)); ?>
								<?php echo wp_kses_post($data['banner_subtitle']) ?>
							</span>
							<h1 class="hero-title th-title"><?php echo wp_kses_post($data['banner_title']) ?></h1>
							<p class="hero-text th-desc"><?php echo esc_html($data['banner_desc']); ?></p>

							<div class="btn-group">
							<?php if(!empty($data['button_link']['url'])): ?>	
							<a href="<?php echo esc_url( $data['button_link']['url'] ); ?>" class="themeholy-btn th_btn"><?php echo wp_kses_post($data['button_text']); ?></a>
							<?php endif; ?>
							<?php if(!empty($data['button_link2']['url'])): ?>
								<div class="call-btn">
									<a href="<?php echo esc_url( $data['button_link2']['url'] ); ?>" class="play-btn popup-video"><i class="fas fa-play"></i></a>
									<div class="media-body">
										<a href="<?php echo esc_url( $data['button_link2']['url'] ); ?>" class="btn-title popup-video"><?php echo esc_html($data['button_text2']); ?></a>
									</div>
								</div>
							<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
				<?php endforeach; ?>
			</div>
			<div class="indicator-number">
				<div class="indicator-wrapper">
					<div class="number-pagination">0<span class="pagingInfo1"></span></div>
					<div class="progress-wrapper">
						<div class="progress" role="progressbar" aria-valuemin="0" aria-valuemax="100">
							<span class="slider__label sr-only"></span>
						</div>
					</div>
					<div class="total-pagination">0<span class="pagingInfo2"></span></div>
				</div>
			</div>
		</section>

	<?php endif; 
		
	}

}