<?php

use \Elementor\Widget_Base;
use \Elementor\Controls_Manager;
use \Elementor\Group_Control_Typography;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
/**
 *
 * Header Widget .
 *
 */
class Logistik_Header extends Widget_Base {

	public function get_name() {
		return 'logistikheader';
	}
	public function get_title() {
		return __( 'Header', 'logistik' );
	}

	public function get_icon() {
		return 'themeholy-icon';
    }

	public function get_categories() {
		return [ 'logistik_header_elements' ];
	}
	protected function register_controls() {

		$this->start_controls_section(
			'layout_section',
			[
				'label' 	=> __( 'Header', 'logistik' ),
				'tab' 		=> Controls_Manager::TAB_CONTENT,
			]
        );

        $this->add_control(
			'layout_style',
			[
				'label' 	=> __( 'Layout Style', 'logistik' ),
				'type' 		=> Controls_Manager::SELECT,
				'options' 	=> [
					'1' => __( 'Style One', 'logistik' ),
					'2' => __( 'Style Two', 'logistik' ),
					'3' => __( 'Style Three', 'logistik' ),
					'4' => __( 'Style Four', 'logistik' ),
				],
				'default' => '1',
			]
        );

		$this->add_control(
			'show_top_bar',
			[
				'label' 		=> __( 'Show Top Bar?', 'logistik' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'logistik' ),
				'label_off' 	=> __( 'Hide', 'logistik' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);

		$this->add_control(
			'topbar_phone_icon',
			[
				'label' 		=> __( 'Phone Icon', 'logistik' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> '<i class="fa-solid fa-phone"></i>',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
				],
			]
		);

		$this->add_control(
			'topbar_phone_label',
			[
				'label' 		=> __( 'Phone Label', 'logistik' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> 'Phone',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
				],
			]
		);

		$this->add_control(
			'topbar_phone',
			[
				'label' 	=> __( 'Phone Number', 'logistik' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( '+(163)-1202-0088', 'logistik' ),
				'label_block' => true,
				'separator'		=> 'after',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
				],
			]
		);

		$this->add_control(
			'topbar_email_icon',
			[
				'label' 		=> __( 'Email Icon', 'logistik' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> '<i class="fa-solid fa-envelope"></i>',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
				],
			]
		);

		$this->add_control(
			'topbar_email_label',
			[
				'label' 		=> __( 'Email Label', 'logistik' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> 'Email',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
				],
			]
		);

		$this->add_control(
			'topbar_email',
			[
				'label' 	=> __( 'Email Address', 'logistik' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( 'help24/7@gmail.com', 'logistik' ),
				'label_block' => true,
				'separator'		=> 'after',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
				],
			]
		);

		$this->add_control(
			'topbar_work_icon',
			[
				'label' 		=> __( 'Work Icon', 'logistik' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> '<i class="fa-thin fa-clock"></i>',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['3'],
				],
			]
		);

		$this->add_control(
			'topbar_work_label',
			[
				'label' 		=> __( 'Email Label', 'logistik' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 		=> 'Work Time:',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['3'],
				],
			]
		);

		$this->add_control(
			'topbar_work',
			[
				'label' 	=> __( 'Work Time', 'logistik' ),
				'type' 		=> Controls_Manager::TEXT,
				'default' 	=> __( 'Mon - Fri 09: am- 06 pm', 'logistik' ),
				'label_block' => true,
				'separator'		=> 'after',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['3'],
				],
			]
		);

		$this->add_control(
			'show_lang_btn',
			[
				'label' 		=> __( 'Show Language Button?', 'logistik' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'logistik' ),
				'label_off' 	=> __( 'Hide', 'logistik' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
					'layout_style' => ['1', '2','4']
				],
			]
		);	

		//Social 
		$this->add_control(
			'show_social',
			[
				'label' 		=> __( 'Show Social?', 'logistik' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'logistik' ),
				'label_off' 	=> __( 'Hide', 'logistik' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'separator'		=> 'before',
				'condition'		=> [ 
					'show_top_bar'  => ['yes'],
				],
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'social_icon',
			[
				'label' 	=> __( 'Social Icon', 'logistik' ),
				'type' 		=> Controls_Manager::ICONS,
				'default' 	=> [
					'value' 	=> 'fab fa-facebook-f',
					'library' 	=> 'solid',
				],
			]
		);

		$repeater->add_control(
			'icon_link',
			[
				'label' 		=> __( 'Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> __( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> true,
				],
			]
		);

		$this->add_control(
			'social_icon_list',
			[
				'label' 		=> __( 'Social Icon', 'logistik' ),
				'type' 			=> Controls_Manager::REPEATER,
				'fields' 		=> $repeater->get_controls(),
				'default' 		=> [
					[
						'social_icon' => __( 'Add Social Icon','logistik' ),
					],
				],
				'condition'		=> [ 
					'show_social'  => 'yes',
					'show_top_bar'  => ['yes'],
				],
			]
		);

		$this->add_control(
			'logo_image',

			[
				'label' 		=> __( 'Upload Logo', 'logistik' ),
				'type' 			=> Controls_Manager::MEDIA,
				// 'default' 		=> [
				// 	'url' => Utils::get_placeholder_image_src(),
				// ],
			]
		);		

		$menus = $this->logistik_menu_select();

		if( !empty( $menus ) ){
	        $this->add_control(
				'logistik_menu_select',
				[
					'label'     	=> __( 'Select Logistik Menu', 'logistik' ),
					'type'      	=> Controls_Manager::SELECT,
					'options'   	=> $menus,
					'description' 	=> sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to manage your menus.', 'logistik' ), admin_url( 'nav-menus.php' ) ),
				]
			);
		}else {
			$this->add_control(
				'no_menu',
				[
					'type' 				=> Controls_Manager::RAW_HTML,
					'raw' 				=> '<strong>' . __( 'There are no menus in your site.', 'logistik' ) . '</strong><br>' . sprintf( __( 'Go to the <a href="%s" target="_blank">Menus screen</a> to create one.', 'logistik' ), admin_url( 'nav-menus.php?action=edit&menu=0' ) ),
					'separator' 		=> 'after',
					'content_classes' 	=> 'elementor-panel-alert elementor-panel-alert-info',
				]
			);
		}

		$this->add_control(
			'show_search_btn',
			[
				'label' 		=> __( 'Show Search Button?', 'logistik' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'logistik' ),
				'label_off' 	=> __( 'Hide', 'logistik' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
			]
		);		

		$this->add_control(
			'show_offcanvas_btn',
			[
				'label' 		=> __( 'Show Offcanvas Button?', 'logistik' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'logistik' ),
				'label_off' 	=> __( 'Hide', 'logistik' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'separator'		=> 'before', 
				'condition'	=> [
					'layout_style' => ['1', '2','4']
				]	
			]
		);

		$this->add_control(
			'show_btn',
			[
				'label' 		=> __( 'Show Button?', 'logistik' ),
				'type' 			=> Controls_Manager::SWITCHER,
				'label_on' 		=> __( 'Show', 'logistik' ),
				'label_off' 	=> __( 'Hide', 'logistik' ),
				'return_value' 	=> 'yes',
				'default' 		=> 'yes',
				'condition'	=> [
					'layout_style' => ['1', '2','4']
				]	
			]
		);
		$this->add_control(
			'button_text',
			[
				'label' 		=> __( 'Button Text', 'logistik' ),
				'type' 			=> Controls_Manager::TEXT,
				'label_block' 	=> true,
				'default' 	=> __( 'REGISTER NOW', 'logistik' ),
				'condition'		=> [
					'show_btn' => [ 'yes' ],
					'layout_style' => ['1', '2','4']
				],
			]
		);
		$this->add_control(
			'button_url',
			[
				'label' 		=> esc_html__( 'Button Link', 'logistik' ),
				'type' 			=> Controls_Manager::URL,
				'placeholder' 	=> esc_html__( 'https://your-link.com', 'logistik' ),
				'show_external' => true,
				'default' 		=> [
					'url' 			=> '#',
					'is_external' 	=> false,
					'nofollow' 		=> false,
				],
				'condition'		=> [
					'show_btn' => [ 'yes' ],
					'layout_style' => ['1', '2','4']
				],
			]
		);

        $this->end_controls_section();

		//---------------------------------------
			//Style Section Start
		//---------------------------------------

		//-----------------------------------General BG Styling-------------------------------------//
		 $this->start_controls_section(
			'general_styling',
			[
				'label'     => __( 'Background Styling', 'logistik' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'topbar_background_color',
			[
				'label'     => __( 'TopBar Background', 'logistik' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-top' => 'background-color: {{VALUE}}!important',
                ],
			]
        );

		$this->add_control(
			'logo_color',
			[
				'label' 		=> __( 'Logo Background', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .logo-bg:before, {{WRAPPER}} .logo-bg:after' => 'background-color: {{VALUE}} !important;',
                ],
				'condition'		=> [ 
					'layout_style'  => ['1', '4'],
				],
			]
        ); 

        $this->add_control(
			'header_menu_bg',
			[
				'label' 		=> __( 'Menu Background', 'logistik' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .sticky-wrapper' => 'background-color: {{VALUE}} !important;',
                ],
			]
        );    

		$this->end_controls_section();

       //-----------------------------------Topbar Styling-------------------------------------//
        $this->start_controls_section(
			'content_styling',
			[
				'label'     => __( 'Content Styling', 'logistik' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

		$this->add_control(
			'content_icon_color',
			[

				'label'     => __( 'Content Icon Color', 'logistik' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-links li > i' => 'color: {{VALUE}}!important',
                ],
				
			]
        );	

		$this->add_control(
			'content_icon_font_size',
			[
				'label' => esc_html__( 'Content Icon Font Size', 'logistik' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 40,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .header-links li > i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'content_color2',
			[

				'label'     => __( 'Content Title Color', 'logistik' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-links li' => '--white-color: {{VALUE}}!important',
                ],
				
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'content_typography',
				'label' 	=> __( 'Content Title Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .header-links span',
			]
        );

		$this->add_control(
			'content_color3',
			[

				'label'     => __( 'Content Color', 'logistik' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-links li a' => 'color: {{VALUE}}!important',
                ],
				
			]
        );

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'content_typography2',
				'label' 	=> __( 'Content Typography', 'logistik' ),
                'selector' 	=> '{{WRAPPER}} .header-links a',
			]
        );

        $this->end_controls_section();

        //-----------------------------------Social Styling-------------------------------------//
        $this->start_controls_section(
			'social_styling',
			[
				'label'     => __( 'Social Styling', 'logistik' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );

        $this->add_control(
			'topbar_social_color',
			[

				'label'     => __( 'Social Color', 'logistik' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .header-social a' => 'color: {{VALUE}}!important;',
                ],
			]
        );

        $this->add_control(
			'topbar_social__h_color',
			[

				'label'     => __( 'Social Hover Color', 'logistik' ),
				'type'      => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}}  .header-social a:hover' => 'color: {{VALUE}}!important;',
                ],
				
			]
        );

		$this->add_control(
			'social_font_size',
			[
				'label' => esc_html__( 'Icon Font Size', 'logistik' ),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 40,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .header-social a' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->end_controls_section();

        //-----------------------------------Menubar Styling-------------------------------------//
        $this->start_controls_section(
			'menubar_styling',
			[
				'label'     => __( 'Menu Styling', 'logistik' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
        );
        $this->add_control(
			'menu_etxt_color',
			[
				'label' 			=> __( 'Menu Text Color', 'logistik' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .main-menu>ul>li>a' => 'color: {{VALUE}} !important;',
                ]
			]
        );
        $this->add_control(
			'menu_text_hover_color',
			[
				'label' 			=> __( 'Menu Hover Color', 'logistik' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .main-menu>ul>li>a:hover' => 'color: {{VALUE}} !important;',
                ]
			]
        );
        $this->add_control(
			'dropdown_txt_color',
			[
				'label' 			=> __( 'Dropdown Text Color', 'logistik' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .main-menu ul.sub-menu li a' => 'color: {{VALUE}} !important;',
                ]
			]
        );
        $this->add_control(
			'dropdown_txt_hover_color',
			[
				'label' 			=> __( 'Dropdown Hover Color', 'logistik' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .main-menu ul.sub-menu li a:hover' => 'color: {{VALUE}} !important;',
                ]
			]
        );
		$this->add_control(
			'dropdown_icon_color',
			[
				'label' 			=> __( 'Dropdown Icon Color', 'logistik' ),
				'type' 				=> Controls_Manager::COLOR,
				'selectors' 		=> [
					'{{WRAPPER}} .main-menu ul.sub-menu li a:before' => 'color: {{VALUE}} !important;',
                ]
			]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 			=> 'menu_typography',
				'label' 		=> __( 'Menu Typography', 'logistik' ),
                'selector' 		=> '{{WRAPPER}} .main-menu>ul>li>a, {{WRAPPER}} .main-menu ul.sub-menu li a',
			]
		);

        $this->add_responsive_control(
			'menu_margin',
			[
				'label' 		=> __( 'Menu Margin', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu>ul>li>a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
        );

        $this->add_responsive_control(
			'menu_padding',
			[
				'label' 		=> __( 'Menu Padding', 'logistik' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .main-menu>ul>li>a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
                ]
			]
		);

		$this->end_controls_section();

		//---------------------------------------Button Style---------------------------------------//
		$this->start_controls_section(
			'button_style_section',
			[
				'label' 	=> __( 'Button Style', 'advoker' ),
				'tab' 		=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button_color',
			[
				'label' 		=> __( 'Color', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_h_color',
			[
				'label' 		=> __( 'Hover Color ', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn:hover' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_bg',
			[
				'label' 		=> __( 'Background Color', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .themeholy-btn:before' => 'background-color:{{VALUE}}',
				],
			]
		);

		$this->add_control(
			'button_h_bg',
			[
				'label' 		=> __( 'Background Hover Color', 'advoker' ),
				'type' 			=> Controls_Manager::COLOR,
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'background-color:{{VALUE}} !important',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'button_typography',
				'label' 	=> __( 'Typography', 'advoker' ),
				'selector' 	=> '{{WRAPPER}} .th-btn',
			]
		);

		$this->add_responsive_control(
			'button_margin',
			[
				'label' 		=> __( 'Margin', 'advoker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->add_responsive_control(
			'button_padding',
			[
				'label' 		=> __( 'Padding', 'advoker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);
		$this->add_responsive_control(
			'button_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'advoker' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .th-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				]
			]
		);

		$this->end_controls_section();

    }

    public function logistik_menu_select(){
	    $logistik_menu = wp_get_nav_menus();
	    $menu_array  = array();
		$menu_array[''] = __( 'Select A Menu', 'logistik' );
	    foreach( $logistik_menu as $menu ){
	        $menu_array[ $menu->slug ] = $menu->name;
	    }
	    return $menu_array;
	}

	protected function render() {

        $settings = $this->get_settings_for_display();

		global $woocommerce;

        //Menu by menu select
        $logistik_avaiable_menu   = $this->logistik_menu_select();
		if( ! $logistik_avaiable_menu ){
			return;
		}
		$args = [
			'menu' 			=> $settings['logistik_menu_select'],
			'menu_class' 	=> 'logistik-menu',
			'container' 	=> '',
		];

		 if( class_exists( 'ReduxFramework' ) ){
			 if(logistik_opt('logistik_menu_icon')){
	            $menu_icon = '';
	        }else{
	            $menu_icon = 'hide-icon';
	        }
	    }

		//Mobile menu 
        echo logistik_mobile_menu();

		echo logistik_header_cart_offcanvas();
		echo logistik_header_offcanvas();
		echo logistik_search_box();

		$phone    	= $settings['topbar_phone'];
		$email    	= $settings['topbar_email'];

		$email          = is_email( $email );

		$replace        = array(' ','-',' - ');
		$replace_phoone        = array(' ','-',' - ', '(', ')');
		$with           = array('','','');

		$phoneurl       = str_replace( $replace_phoone, $with, $phone );
		$emailurl       = str_replace( $replace, $with, $email );
		?>

		<?php if( $settings['layout_style'] == '2' ): ?>
		<div class="themeholy-header header-layout3 header-absolute">
			<?php if(!empty( $settings['show_top_bar'])): ?>
			<div class="header-top">
				<div class="container">
					<div class="row justify-content-center justify-content-lg-between align-items-center gy-2">
						<div class="col-auto d-none d-lg-block">
							<div class="header-links">
								<ul>
									<li><?php echo wp_kses_post($settings['topbar_phone_icon']); ?><span class="link-title"><?php echo esc_html($settings['topbar_phone_label']); ?> </span><a href="<?php echo esc_attr('tel:' . $phoneurl); ?>"><?php echo esc_html($phone); ?></a></li>
									<li><?php echo wp_kses_post($settings['topbar_email_icon']); ?><span class="link-title"><?php echo esc_html($settings['topbar_email_label']); ?> </span><a href="<?php echo esc_attr('mailto:' . $emailurl); ?>"><?php echo esc_html($email); ?></a></li>
								</ul>
							</div>
						</div>
						<div class="col-auto">
							<div class="header-right">
								<?php if(!empty( $settings['show_lang_btn'])): ?>
								<div class="langauge lang-dropdown">
                                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink1" data-bs-toggle="dropdown" aria-expanded="false"><?php echo esc_html__( 'Language', 'logistik' );?></a>
				                        <div class="list dropdown-menu" aria-labelledby="dropdownMenuLink1">
				                            <?php  echo do_shortcode('[gtranslate]'); ?>
				                        </div>
                                </div>
								<?php endif; ?>
								<?php if(!empty( $settings['show_social'])): ?>
								<div class="header-social">
									<?php	 
										foreach( $settings['social_icon_list'] as $social_icon ): 
										$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
										$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';
									?>
										<a <?php echo esc_html($social_target) ?> <?php echo esc_html($social_nofollow) ?> href="<?php echo esc_url( $social_icon['icon_link']['url'] ) ?>"> <?php \Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] ); ?></a> 
									<?php endforeach; ?>
								</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php endif; ?>
			<div class="sticky-wrapper">
				<div class="sticky-active">
					<!-- Main Menu Area -->
					<div class="menu-area">
						<div class="container">
							<div class="row align-items-center justify-content-between">
								<div class="col-auto">
									<div class="header-logo style3">
										<a href="<?php echo esc_url( home_url( '/' ) ) ?>">
											<?php echo logistik_img_tag( array(
												'url'   => esc_url( $settings['logo_image']['url']  ),
											)); ?>
										</a>
									</div>
								</div>
								<div class="col-auto">
									<nav class="main-menu <?php echo $menu_icon; ?> d-none d-lg-inline-block">
										<?php if( ! empty( $settings['logistik_menu_select'] ) ){
											wp_nav_menu( $args );
										} ?>
									</nav>
									<button type="button" class="themeholy-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>
								</div>
								<div class="col-auto d-none d-xl-block">
									<div class="header-button">
										<?php if(!empty( $settings['show_search_btn'])): ?>
											<button type="button" class="icon-btn searchBoxToggler"><i class="fal fa-search"></i></button>
										<?php endif; ?>
										<?php if(!empty( $settings['show_offcanvas_btn'])): ?>
											<button type="button" class="icon-btn fs-6 sideMenuToggler">
											<img src="<?php echo LOGISTIK_ASSETS;?>img/grid.svg" alt="<?php echo esc_attr__('Grid', 'logistik'); ?>">
											</button>
										<?php endif; ?>
										<?php if(!empty( $settings['show_btn'])): ?>
											<a href="<?php echo esc_url($settings['button_url']['url']); ?>" class="themeholy-btn th-btn d-none d-xxl-inline-block"><?php echo wp_kses_post($settings['button_text']); ?></a>
										<?php endif; ?>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>
			</div>
			<div class="menu-shape">
				<div class="top-menu-shape" data-bg-src="<?php echo LOGISTIK_ASSETS;?>img/header_bg_3.png"></div>
			</div>
		</div>

		<?php elseif( $settings['layout_style'] == '3' ): ?>
		<div class="themeholy-header header-layout4">
			<div class="header-top position-relative">
				<div class="container">
					<div class="row justify-content-center justify-content-lg-between align-items-center gy-2">
						<div class="col-auto">
							<div class="header-logo">
								<a href="<?php echo esc_url( home_url( '/' ) ) ?>">
										<?php echo logistik_img_tag( array(
											'url'   => esc_url( $settings['logo_image']['url']  ),
										)); ?>
									</a>
							</div>
						</div>
						<div class="col-auto">
							<div class="menu-top">
								<div class="header-info">
									<div class="icon-btn">
										<?php echo wp_kses_post($settings['topbar_work_icon']); ?>
									</div>
									<div class="media-body"><span class="header-info_label"><?php echo esc_html($settings['topbar_work_label']); ?></span>
										<p class="header-info_link"><?php echo esc_html($settings['topbar_work']); ?></p>
									</div>
								</div>
								<div class="header-info">
									<div class="icon-btn">
										<?php echo wp_kses_post($settings['topbar_email_icon']); ?>
									</div>
									<div class="media-body"><span class="header-info_label"><?php echo esc_html($settings['topbar_email_label']); ?></span>
										<p class="header-info_link"><a href="<?php echo esc_attr('mailto:' . $emailurl); ?>"><?php echo esc_html($email); ?></a></p>
									</div>
								</div>
								<div class="header-social">
									<?php	 
										foreach( $settings['social_icon_list'] as $social_icon ): 
										$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
										$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';
									?>
										<a <?php echo esc_html($social_target) ?> <?php echo esc_html($social_nofollow) ?> href="<?php echo esc_url( $social_icon['icon_link']['url'] ) ?>"> <?php \Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] ); ?></a> 
									<?php endforeach; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="logo-bg"></div>
				<div class="logo-shape"><img src="<?php echo LOGISTIK_ASSETS;?>img/logo-shape2.svg" alt=""></div>
			</div>
			<div class="sticky-wrapper">
				<!-- Main Menu Area -->
				<div class="menu-area">
					<div class="container">
						<div class="row align-items-center justify-content-between">
							<div class="col-auto">
								<nav class="main-menu <?php echo $menu_icon; ?> d-none d-lg-inline-block">
									<?php if( ! empty( $settings['logistik_menu_select'] ) ){
										wp_nav_menu( $args );
									} ?>
								</nav>
								<button type="button" class="themeholy-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>
							</div>
							<div class="col-auto">
								<?php if(!empty( $settings['show_search_btn'])): ?>
								<div class="header-button">
									<button type="button" class="icon-btn searchBoxToggler"><i class="fal fa-search"></i></button>
								</div>
								<?php endif; ?>
							</div>
							<div class="col-auto d-none d-xl-block">
								<div class="header-info style1">
									<div class="icon-btn">
										<?php echo wp_kses_post($settings['topbar_phone_icon']); ?>
									</div>
									<div class="media-body">
										<span class="header-info_label"><?php echo esc_html($settings['topbar_phone_label']); ?></span>
										<p class="header-info_link"><a href="<?php echo esc_attr('tel:' . $phoneurl); ?>"><?php echo esc_html($phone); ?></a></p>
									</div>
								</div>
							</div>
						</div>
					</div>
				</div>

			</div>
			<div class="top-menu-shape">
				<div class="top-shape" data-bg-src="<?php echo LOGISTIK_ASSETS;?>img/header_bg_1.png"></div>
			</div>
			<div class="menu-bg"></div>
			<div class="menu-bg2"></div>
		</div>

		<?php elseif( $settings['layout_style'] == '4' ): ?>
		<div class="themeholy-header header-layout5">
			<?php if(!empty( $settings['show_top_bar'])): ?>
			<div class="header-top">
				<div class="container">
					<div class="row justify-content-center justify-content-lg-between align-items-center gy-2">
						<div class="col-auto d-none d-md-block">
							<div class="header-links">
								<ul>
									<li><?php echo wp_kses_post($settings['topbar_phone_icon']); ?><span class="link-title"><?php echo esc_html($settings['topbar_phone_label']); ?> </span><a href="<?php echo esc_attr('tel:' . $phoneurl); ?>"><?php echo esc_html($phone); ?></a></li>
									<li><?php echo wp_kses_post($settings['topbar_email_icon']); ?><span class="link-title"><?php echo esc_html($settings['topbar_email_label']); ?> </span><a href="<?php echo esc_attr('mailto:' . $emailurl); ?>"><?php echo esc_html($email); ?></a></li>
								</ul>
							</div>
						</div>
						<div class="col-auto">
							<div class="header-right">
								<?php if(!empty( $settings['show_lang_btn'])): ?>
								<div class="langauge lang-dropdown">
                                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink1" data-bs-toggle="dropdown" aria-expanded="false"><?php echo esc_html__( 'Language', 'logistik' );?></a>
				                        <div class="list dropdown-menu" aria-labelledby="dropdownMenuLink1">
				                            <?php  echo do_shortcode('[gtranslate]'); ?>
				                        </div>
                                </div>
								<?php endif; ?>
								<?php if(!empty( $settings['show_social'])): ?>
								<div class="header-social">
									<?php	 
										foreach( $settings['social_icon_list'] as $social_icon ): 
										$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
										$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';
									?>
										<a <?php echo esc_html($social_target) ?> <?php echo esc_html($social_nofollow) ?> href="<?php echo esc_url( $social_icon['icon_link']['url'] ) ?>"> <?php \Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] ); ?></a> 
									<?php endforeach; ?>
								</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php endif; ?>
			<div class="sticky-wrapper">
				<!----------------------- Main Menu Area ----------------->
				<div class="menu-area">
					<div class="container">
						<div class="row align-items-center justify-content-between">
							<div class="col-auto">
								<div class="header-logo">
									<a href="<?php echo esc_url( home_url( '/' ) ) ?>">
										<?php echo logistik_img_tag( array(
											'url'   => esc_url( $settings['logo_image']['url']  ),
										)); ?>
									</a>
								</div>
							</div>
							<div class="col-auto">
								<nav class="main-menu <?php echo $menu_icon; ?> d-none d-lg-inline-block">
									<?php if( ! empty( $settings['logistik_menu_select'] ) ){
										wp_nav_menu( $args );
									} ?>
								</nav>
								<button type="button" class="themeholy-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>
							</div>
							<div class="col-auto d-none d-xl-block">
								<div class="header-button">
									<?php if(!empty( $settings['show_search_btn'])): ?>
										<button type="button" class="icon-btn searchBoxToggler"><i class="fal fa-search"></i></button>
									<?php endif; ?>
									<?php if(!empty( $settings['show_offcanvas_btn'])): ?>
										<button type="button" class="icon-btn fs-6 sideMenuToggler">
										<img src="<?php echo LOGISTIK_ASSETS;?>img/grid.svg" alt="<?php echo esc_attr__('Grid', 'logistik'); ?>">
										</button>
									<?php endif; ?>
									<?php if(!empty( $settings['show_btn'])): ?>
                                    	<a href="<?php echo esc_url($settings['button_url']['url']); ?>" class="themeholy-btn th-btn"><?php echo wp_kses_post($settings['button_text']); ?></a>
                                    <?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="logo-bg"></div>
			</div>
			<div class="menu-shape">
				<div class="top-shape" data-bg-src="<?php echo LOGISTIK_ASSETS;?>img/header_bg_1.png"></div>
			</div>
			<div class="logo-bg2"></div>
		</div>

	
		<?php else: ?>
		<div class="themeholy-header header-layout2">
			<?php if(!empty( $settings['show_top_bar'])): ?>
			<div class="header-top">
				<div class="container">
					<div class="row justify-content-center justify-content-lg-between align-items-center gy-2">
						<div class="col-auto d-none d-lg-block">
							<div class="header-links">
								<ul>
									<li><?php echo wp_kses_post($settings['topbar_phone_icon']); ?><span class="link-title"><?php echo esc_html($settings['topbar_phone_label']); ?> </span><a href="<?php echo esc_attr('tel:' . $phoneurl); ?>"><?php echo esc_html($phone); ?></a></li>
									<li><?php echo wp_kses_post($settings['topbar_email_icon']); ?><span class="link-title"><?php echo esc_html($settings['topbar_email_label']); ?> </span><a href="<?php echo esc_attr('mailto:' . $emailurl); ?>"><?php echo esc_html($email); ?></a></li>
								</ul>
							</div>
						</div>
						<div class="col-auto">
							<div class="header-right">
								<?php if(!empty( $settings['show_lang_btn'])): ?>
								<div class="langauge lang-dropdown">
                                    <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink1" data-bs-toggle="dropdown" aria-expanded="false"><?php echo esc_html__( 'Language', 'logistik' );?></a>
				                        <div class="list dropdown-menu" aria-labelledby="dropdownMenuLink1">
				                            <?php  echo do_shortcode('[gtranslate]'); ?>
				                        </div>
                                </div>
								<?php endif; ?>
								<?php if(!empty( $settings['show_social'])): ?>
								<div class="header-social">
									<?php	 
										foreach( $settings['social_icon_list'] as $social_icon ): 
										$social_target    = $social_icon['icon_link']['is_external'] ? ' target="_blank"' : '';
										$social_nofollow  = $social_icon['icon_link']['nofollow'] ? ' rel="nofollow"' : '';
									?>
										<a <?php echo esc_html($social_target) ?> <?php echo esc_html($social_nofollow) ?> href="<?php echo esc_url( $social_icon['icon_link']['url'] ) ?>"> <?php \Elementor\Icons_Manager::render_icon( $social_icon['social_icon'], [ 'aria-hidden' => 'true' ] ); ?></a> 
									<?php endforeach; ?>
								</div>
								<?php endif; ?>
							</div>
						</div>
					</div>
				</div>
			</div>
			<?php endif; ?>
			<div class="sticky-wrapper">
				<!-- Main Menu Area -->
				<div class="menu-area">
					<div class="container">
						<div class="row align-items-center justify-content-between">
							<div class="col-auto">
								<div class="header-logo">
									<a href="<?php echo esc_url( home_url( '/' ) ) ?>">
										<?php echo logistik_img_tag( array(
											'url'   => esc_url( $settings['logo_image']['url']  ),
										)); ?>
									</a>
								</div>
							</div>
							<div class="col-auto">
								<nav class="main-menu <?php echo $menu_icon; ?> d-none d-lg-inline-block">
									<?php if( ! empty( $settings['logistik_menu_select'] ) ){
										wp_nav_menu( $args );
									} ?>
								</nav>
								<button type="button" class="themeholy-menu-toggle d-inline-block d-lg-none"><i class="far fa-bars"></i></button>
							</div>
							<div class="col-auto d-none d-xl-block">
								<div class="header-button">
									<?php if(!empty( $settings['show_search_btn'])): ?>
										<button type="button" class="icon-btn searchBoxToggler"><i class="fal fa-search"></i></button>
									<?php endif; ?>
									<?php if(!empty( $settings['show_offcanvas_btn'])): ?>
										<button type="button" class="icon-btn fs-6 sideMenuToggler">
										<img src="<?php echo LOGISTIK_ASSETS;?>img/grid.svg" alt="<?php echo esc_attr__('Grid', 'logistik'); ?>">
										</button>
									<?php endif; ?>
									<?php if(!empty( $settings['show_btn'])): ?>
                                    	<a href="<?php echo esc_url($settings['button_url']['url']); ?>" class="themeholy-btn th-btn d-none d-xxl-inline-block"><?php echo wp_kses_post($settings['button_text']); ?></a>
                                    <?php endif; ?>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="logo-bg"></div>
			</div>
			<div class="menu-shape">
				<div class="top-shape" data-bg-src="<?php echo LOGISTIK_ASSETS;?>img/header_bg_1.png"></div>
			</div>
		</div>

		<?php endif; 

	}
}