@extends('frontend.layouts.main')
@section('title','Contact Us')
@section('description','About Us')
@section('keywords','About Us')
@section('main-container')

<!-- ======= Page Banner ======= -->
<div class="page_banner">
  <div class="page-inner">
    <div class="page-item">
      <img src="{{url('public/frontend/assets/img/page-banner/about.jpg')}}" alt="Slide1" class="d-block" style="width:100%">
      <div class="page-caption">
 <div class="container"> <h1 class="lh_140 fs_50 text-white fw_7 ff_playfair t_gradient d-inline-block">Contact Us</h1></div>        
      </div>       
      </div>
      </div>
  </div>
  <!-- End Page Banner -->

<main id="main">
  <style>
    .color9 {
      color: #195989;
    }
    .contact-form textarea,
    .contact-form input {
      padding: 10px 12px;
    }
    .ha-infobox-body {
      position: relative;
      background: rgba(25, 89, 137, 0.1);
      padding: 35px 20px 15px;
      margin: 0px 0 20px;
    }
    .ha-infobox-body::before {
      content: '';
      display: block;
      position: absolute;
      top: 0px;
      right: 0px;
      border-left: 35px solid transparent;
      border-right: 0px solid transparent;
      border-top: 35px solid #fff;
    }

    .ha-infobox-body .ha-infobox-title {
        font-weight: 700;
        color: #195989;
    }
    .icon-box {
      position: relative;
      display: flex;
      flex-wrap: wrap;
      justify-content: flex-end;
    }

    .icon-box i::before {
      border: solid 1px #1E3C50;
      color: #1e3c51;
      border-radius: 50%;
      padding: 15px;
      background: #fff;
    }
  </style>
  <section class="inner-page">
    <div class="container mt-5 pt-3 mb-5 pb-3">
      <div class="row mt-3 mb-3 mb-lg-5">
        <div class="col-12">
        <h2 class="fs_35 lh_130 fw_5 ff_playfair color4 pe-lg-5 text-center w__xl_800 me-auto ms-auto">Leave us a line if you have any query or If you wish to discuss a project</h2>
        </div> 
        </div>
      <div class="row">
        <!-- col 1 -->
        <div class="col-md-5 pe-md-4 pe-lg-5 contact_info">
          <div class="container-fulid">
            <div class="row">
              <div class="col-12 pb-2">
                <h2 class="fs_30 lh_115 fw_7 ff_playfair color4">Our Location</h2>
              </div>
              <div class="col-12">
                <div class="ha-infobox-body">
                  <div class="row m-0">
                    <div class="col-2 p-0 icon-box">
                      <i class="bi bi-send-fill"></i>
                    </div>
                    <div class="col-10">
                      <h3 class="lh_115 fs_16 fw_6 ff_poppins color4 mb-2">Email</h3>
                      <div class="ha-infobox-text">
                        <p class="fs_16 lh_115 fw_3 ff_poppins color3 mb-1">sales@proglobaltechnologies.com</p>
                        <p class="fs_16 lh_115 fw_3 ff_poppins color3 mb-1">jobs@proglobaltechnologies.com</p>
                      </div>
                    </div>
                  </div>
                  
                </div>
              </div>
              <div class="col-12">
                <div class="ha-infobox-body">
                  <div class="row m-0">
                    <div class="col-2 p-0 icon-box">
                      <i class="bi bi-telephone-fill"></i>
                    </div>
                    <div class="col-10">
                      <h3 class="lh_115 fs_16 fw_6 ff_poppins color4 mb-2">Phone</h3>
                      <div class="ha-infobox-text">
                        <p class="fs_16 lh_115 fw_3 ff_poppins color3 mb-1">(051) 2877476 </p>
                      </div>
                    </div>
                  </div>
                  
                </div>
              </div>
              <div class="col-12">
                <div class="ha-infobox-body">
                  <div class="row m-0">
                    <div class="col-2 icon-box p-0">
                      <i class="bi bi-pin-map-fill"></i>
                    </div>
                    <div class="col-10">
                      <h3 class="lh_115 fs_16 fw_6 ff_poppins color4 mb-2">Head Office</h3>
                      <div class="ha-infobox-text">
                        <p class="fs_16 lh_115 fw_3 ff_poppins color3">Office 2B ground floor evacuee trust building sector F-5 islamabad</p>
                      </div>
                    </div>
                  </div>
                  
                </div>
              </div>
            </div>
          </div>
        </div>
        <!-- col 2 -->
        <div class="col-md-7 mt-5 mt-md-0">
          <div class="container-fulid contact-form">
            <h2 class="fs_30 lh_115 fw_7 ff_playfair color4">Let's Get In Touch</h2>
            <h3 class="fs_18 lh_115 fw_5 ff_poppins color2">We are available 24/7</h3>    
<!-- Success message -->
<div>
    @if(Session::has('success'))
    <div id="successMessage" class="alert alert-success">
        {{Session::get('success')}}
      
      @php 
        Session::forget('success'); 
    @endphp     
    </div>
  @endif 
</div>           

            <form id="my_captcha_form" class="contact__form" method="POST" action="{{ route('contact-form.store') }}">
              {{ csrf_field() }}                         
           
              <!-- form element -->
              <div class="row">
                  <div class="col-md-6 form-group mt-3">
                    <input type="text" class="form-control {{ $errors->has('name') ? 'error' : '' }}" name="name" id="name" placeholder="Full Name" value="{{ old('name') }}"/>
                      @if ($errors->has('name')) 

                      <span class="text-danger fs_12">{{ $errors->first('name') }}</span> 

                  @endif 
                  </div>
                  <div class="col-md-6 form-group mt-3">
                      <input name="email" type="email" class="form-control {{ $errors->has('email') ? 'error' : '' }}" placeholder="Email Address" value="{{ old('email') }}"/>
                      @if ($errors->has('email')) 

                      <span class="text-danger fs_12">{{ $errors->first('email') }}</span> 

                  @endif 
                    </div>
                  <div class="col-md-6 form-group mt-3">
                      <input name="phone" type="text" class="form-control {{ $errors->has('phone') ? 'error' : '' }}" placeholder="Phone" value="{{ old('phone') }}"/>
                      @if ($errors->has('phone')) 

                      <span class="text-danger fs_12">{{ $errors->first('phone') }}</span> 

                  @endif  
                    </div>
                  <div class="col-md-6 form-group mt-3">
                      <input name="subject" type="text" class="form-control {{ $errors->has('subject') ? 'error' : '' }}" placeholder="Subject" value="{{ old('subject') }}" />
                      @if ($errors->has('subject')) 

                      <span class="text-danger fs_12">{{ $errors->first('subject') }}</span> 

                  @endif 
                    </div>
                  <div class="col-12 form-group mt-3">
                      <textarea name="message" class="form-control" rows="3" placeholder="Message" value="{{ old('message') }}"></textarea>
                      @if ($errors->has('message')) 

                      <span class="text-danger fs_12">{{ $errors->first('message') }}</span> 

                  @endif 
                    </div>
              <div class="col-12 form-group mt-3">
                      <div class="g-recaptcha" data-sitekey="6Lf-jDMeAAAAADM6zYVXDHTlvX_7FupqWQH4Diqf"></div>
                      <div id="capthaError" class="fs_12" style="color:red;"></div>                   
                    </div>
                  <div class="col-12">
                    <button type="submit" class="btn border-0 text-white mt-3 pe-5 ps-5 pt-4 pb-4 fw_4 ff_poppins fs_15 btn_1 btn_rounded bg_color6 d-inline-flex align-items-center justify-content-center align-self-center btn-submit">Submit</button>
                  </div>
              </div>
              <!-- end form element -->
          </form>

          </div>
        </div>
      </div>
    </div>
  </section>


 <script src='https://www.google.com/recaptcha/api.js' async defer></script>
<script type="text/javascript">
  function HideLabel() {
      document.getElementById("successMessage").style.display = "none";
  }
  setTimeout("HideLabel();", 5000);

(function() {
  document.getElementById("capthaError").style.display = "none";
  document.getElementById("my_captcha_form").addEventListener("submit",function(evt)
  {
  
  var response = grecaptcha.getResponse();
  if(response.length == 0) 
  { 
    //reCaptcha not verified
    //alert("please verify you are human!"); 
    document.getElementById("capthaError").style.display = "block";
    document.getElementById("capthaError").innerHTML = "please verify you are human!";
    evt.preventDefault();
    return false;
  }
  //captcha verified
  //do the rest of your validations here
  
});

})();

</script>

  </main><!-- End #main -->
  @endsection