<?php defined('BASEPATH') OR exit('No direct script access allowed'); ?>
<!DOCTYPE html>
<html lang="en">
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->
        <title><?php echo (!empty($setting->title)?$setting->title:null) ?> :: <?php echo (!empty($title)?$title:null) ?></title>

        <!-- Favicon and touch icons -->
        <link rel="shortcut icon" href="<?php echo base_url((!empty($setting->favicon)?$setting->favicon:'assets/img/icons/favicon.png')) ?>" type="image/x-icon">
        
        <!-- Start Global Mandatory Style -->
        <!-- Bootstrap -->
        <link href="<?php echo base_url('assets/css/bootstrap.min.css') ?>" rel="stylesheet" type="text/css"/>
        <!-- Bootstrap rtl -->
        <!-- <link href="<?php echo base_url('assets/css/bootstrap-rtl.min.css') ?>" rel="stylesheet" type="text/css"/> -->
        <!-- Pe-icon -->
        <link href="<?php echo base_url('assets/css/pe-icon-7-stroke.css') ?>" rel="stylesheet" type="text/css"/>
        
        <!-- Theme style -->
        <link href="<?php echo base_url('assets/css/custom.min.css') ?>" rel="stylesheet" type="text/css"/>
        <!-- Theme style rtl -->
        <!-- <link href="<?php echo base_url('assets/css/custom-rtl.min.css') ?>" rel="stylesheet" type="text/css"/> -->
    </head>
    <body>
              <div class="container" style="margin-top : 50px">
                <div class="panel panel-bd">
                     <div class="panel-heading">
                        <div class="view-header">
                            <a href="#" class="logo"> 
                                <span class="logo-lg">
                                    <img src="<?php echo base_url((!empty($setting->logo)?$setting->logo:'assets/img/icons/mini-logo.png')) ?>" alt="">
                                </span>
                            </a>
                        </div>
                        <div class="">
                            <!-- alert message -->
                            <?php if ($this->session->flashdata('message') != null) {  ?>
                            <div class="alert alert-info alert-dismissable">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <?php echo $this->session->flashdata('message'); ?>
                            </div> 
                            <?php } ?>
                            
                            <?php if ($this->session->flashdata('exception') != null) {  ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <?php echo $this->session->flashdata('exception'); ?>
                            </div>
                            <?php } ?>
                            
                            <?php if (validation_errors()) {  ?>
                            <div class="alert alert-danger alert-dismissable">
                                <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                                <?php echo validation_errors(); ?>
                            </div>
                            <?php } ?> 
                        </div>
                    </div>

                    <div class="panel-body">
                        <div>
                            <h2>Career</h2>
                        </div>
                         
                        
                        <div class="row">
                            <div class="col-md-12">
                                <div class="container">
                                    <h2><?php echo $jobs_reads->position_name;?></h2>
                                </div>
                            </div>
                           
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="container">
                                    <p>
                                        <?php foreach ($jobs_reads->locations as $location) { ?>
                                            <?php echo $location->Name. " ,"; ?>
                                        <?php } ?> 
                                    </p>
                                </div>
                            </div>
                           
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="container">
                                    <p>
                                        <a href="<?php echo base_url('recruitment/Careers/caninfo_create_linked_job/'.$jobs_reads->jp_id) ?>" class="btn btn-primary">Apply Now</a> 
                                    </p>
                                </div>
                            </div>
                           
                        </div>
                        <hr style="border : 1px solid black">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="container">
                                    <p>
                                        <h3>Job Description</h3>
                                    </p>
                                </div>
                            </div>
                           
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo $jobs_reads->jp_title_description;?>
                            </div>
                           
                        </div>
                        
                         <div class="row">
                            <div class="col-md-12">
                                <div class="container">
                                    <p>
                                        <h3>Job Skill</h3>
                                    </p>
                                </div>
                            </div>
                           
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="container">
                                    <p>
                                         <?php foreach ($jobs_reads->skills_list as $location) { ?>
                                            <span style='margin-bottom: 10px;background: #eeeeee;padding: 6px 12px;border-radius: 0px;color: #424242;font-weight: 400;'><?php echo $location; ?></span>
                                        <?php } ?> 
                                    </p>
                                </div>
                            </div>
                           
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="container">
                                    <p>
                                         <h3>Job Details</h3>
                                    </p>
                                </div>
                            </div>
                           
                        </div>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="container">
                                    <div class="row">
                                        <div class="col-md-3">
                                             <b>Total Positions:</b>
                                        </div>
                                        <div class="col-md-3">
                                            <?php echo $jobs_reads->jp_career_position;?>
                                        </div>
                                        <div class="col-md-3">
                                           
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-3">
                                             <b>Job Type:</b>
                                        </div>
                                        <div class="col-md-3">
                                            <?php echo $jobs_reads->jp_employment_type;?>
                                        </div>
                                        <div class="col-md-3">
                                           
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div>
                                     <div class="row">
                                        <div class="col-md-3">
                                             <b>Gender:</b>
                                        </div>
                                        <div class="col-md-3">
                                            <?php echo $jobs_reads->jp_preference;?>
                                        </div>
                                        <div class="col-md-3">
                                           
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div>
                                     <div class="row">
                                        <div class="col-md-3">
                                             <b>Minimum Education:</b>
                                        </div>
                                        <div class="col-md-3">
                                            <?php echo $jobs_reads->jp_qualification_level;?>
                                        </div>
                                        <div class="col-md-3">
                                           
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div>
                                     <div class="row">
                                        <div class="col-md-3">
                                             <b>Career Level:</b>
                                        </div>
                                        <div class="col-md-3">
                                            <?php echo $jobs_reads->jp_career_level;?>
                                        </div>
                                        <div class="col-md-3">
                                           
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div>
                                     <div class="row">
                                        <div class="col-md-3">
                                             <b>Experience:</b>
                                        </div>
                                        <div class="col-md-3">
                                            <?php echo $jobs_reads->jp_experience_min;?> - <?php echo $jobs_reads->jp_experience_max;?>
                                        </div>
                                        <div class="col-md-3">
                                           
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div>
                                     <div class="row">
                                        <div class="col-md-3">
                                             <b>Posting Date:</b>
                                        </div>
                                        <div class="col-md-3">
                                            <?= formatted_date($jobs_reads->jp_posted_on)?>
                                        </div>
                                        <div class="col-md-3">
                                           
                                        </div>
                                        <div class="col-md-3">
                                        </div>
                                    </div>
                                </div>
                            </div>
                           
                        </div>
                    </div>

                </div>
        </div>
        <!-- jQuery -->
        <script src="<?php echo base_url('assets/js/jquery-1.12.4.min.js') ?>" type="text/javascript"></script>
        <!-- Bootstrap -->
        <script src="<?php echo base_url('assets/js/bootstrap.min.js') ?>" type="text/javascript"></script>


        <script type="text/javascript">
        $(document).ready(function() {
            var info = $('table tbody tr');
            info.click(function() {
                var email    = $(this).children().first().text(); 
                var password = $(this).children().first().next().text();
                $("input[name=email]").val(email);
                $("input[name=password]").val(password);
            });
        });
        </script>



    </body>
</html> 