<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Job_model extends CI_Model {
    
    public function setting()
	{
		return $this->db->get('setting')->row();
	}

public function viewShortlist()
	{

			 return $this->db->select('count(DISTINCT(stl.can_short_id)) as can_short_id,stl.*,bi.can_id,bi.first_name,bi.last_name,po.position_name')   
            ->from('candidate_shortlist stl')
            ->join('candidate_basic_info bi', 'stl.can_id = bi.can_id', 'left')
            ->join('position po', 'stl.job_adv_id = po.pos_id', 'left')
            ->group_by('stl.can_short_id')
            ->order_by('stl.can_short_id', 'desc')
            ->get()
            ->result();
	}

public function shortlist_create($data = array())
	{
		return $this->db->insert('candidate_shortlist', $data);
	}
	
	public function update_shortlist($data = array())
	{
		return $this->db->where('can_short_id', $data["can_short_id"])
			->update("candidate_shortlist", $data);
	}
	public function shortlist_updateForm($id){
        $this->db->where('can_short_id',$id);
        $query = $this->db->get('candidate_shortlist');
        return $query->row();
    }
    public function delete_shorlist($id = null)
	{
		$this->db->where('can_short_id',$id)
			->delete('candidate_shortlist');

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	} 
	public function dropdownPosition()
	{
		$this->db->select('*');
        $this->db->from('candidate_shortlist');
        $query = $this->db->get();
        $data = $query->result();
       
     $list = array('' => 'Select One...');
       	if (!empty($data) ) {
       		foreach ($data as $value) {
       			$list[$value->job_adv_id] = $value->job_adv_id;
       		} 
       	}
       	return $list;
	}

	public function dropdown()
	{
		$this->db->select('*');
        $this->db->from('position');
        $query = $this->db->get();
        $data = $query->result();
       
        $list = array('' => 'Select One...');
       	if (!empty($data) ) {
       		foreach ($data as $value) {
       			$list[$value->pos_id] = $value->position_name;
       		} 
       	}
       	return $list;
	}

public function dropdowncanid()
	{
		$this->db->select('*');
        $this->db->from('candidate_basic_info');
        $query = $this->db->get();
        $data = $query->result();
       
       $list = array('' => 'Select One...');
       	if (!empty($data) ) {
       		foreach ($data as $value) {
       			$list[$value->can_id] = $value->first_name."(".$value->can_id.")";
       		} 
       	}
       	return $list;
	}
	

/*##########################JobPosting Part ################*/

    public function viewJobPosting()
	{
	    
	    $mrArray = $this->db->select('sel.*,bi.position_name')   
            ->from('job_posting sel')
            ->join('position bi', 'sel.pos_id = bi.pos_id')
            ->get()
            ->result();
            
       foreach($mrArray as &$mr){
          $mr->locations = $this->db->select('bi.*')   
            ->from('job_posting_locations sel')
            ->join('City bi', 'sel.jpl_city_id = bi.ID')
            ->where('sel.jp_id',$mr->jp_id)
            ->get()
            ->result();
       }
       
       return $mrArray;
	}
	
	 public function specificJobPosting($id)
	{
	    
	    $mrArray = $this->db->select('sel.*,bi.position_name')   
            ->from('job_posting sel')
            ->join('position bi', 'sel.pos_id = bi.pos_id')
            ->where('sel.jp_id',$id)
            ->where('sel.jp_status',1)
            ->get()
            ->first_row();
        if($mrArray){
            
          $mrArray->locations = $this->db->select('bi.*')   
            ->from('job_posting_locations sel')
            ->join('City bi', 'sel.jpl_city_id = bi.ID')
            ->where('sel.jp_id',$mrArray->jp_id)
            ->get()
            ->result();
            
             $mrArray->locations = $this->db->select('bi.*')   
            ->from('job_posting_locations sel')
            ->join('City bi', 'sel.jpl_city_id = bi.ID')
            ->where('sel.jp_id',$mrArray->jp_id)
            ->get()
            ->result();
            
            $mrArray->skills = $this->db->select('si.*')   
            ->from('job_posting_skills si')
            ->where('si.jp_id',$mrArray->jp_id)
            ->get()
            ->result();
            
            $array = array();

            foreach($mrArray->skills as $row)
            {
                $array[] = $row->jps_name; // add each user id to the array
            }
        
            $mrArray->skills_list = $array;
        }   
        
       
       return $mrArray;
	}
	
	public function interview_create($data = array())
	{
		return $this->db->insert('candidate_interview', $data);
	}

	public function delete_interview($id = null)
	{
		$this->db->where('can_int_id',$id)
			->delete('candidate_interview');

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	} 
	public function update_interview($data = array())
	{
		return $this->db->where('can_int_id', $data["can_int_id"])
			->update("candidate_interview", $data);
	}
	public function interview_updateForm($id){
        return $caninterviewInfo = $this->db->select('a.*,b.position_name')->from('candidate_interview a')->join('position b','a.job_adv_id=b.pos_id')->where('a.can_int_id',$id)->get()->row();
    }

    /* #################### Selection Part  #######################*/
    public function viewSelection()
	{
		
			return $this->db->select('count(DISTINCT(sel.can_sel_id)) as can_sel_id,sel.*,bi.can_id,bi.first_name,bi.last_name')   
            ->from('candidate_selection sel')
            ->join('candidate_basic_info bi', 'sel.can_id = bi.can_id', 'left')
            ->group_by('sel.can_sel_id')
            ->order_by('sel.can_sel_id', 'desc')
            ->get()
            ->result();
	}
	public function selection_create($data = array())
	{
		return $this->db->insert('candidate_selection', $data);
	}

	public function selection_delete($id = null)
	{
		$this->db->where('can_sel_id',$id)
			->delete('candidate_selection');

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	} 

	public function update_selection($data = array())
	{
		return $this->db->where('can_sel_id', $data["can_sel_id"])
			->update("candidate_selection", $data);
	}
	public function selection_updateForm($id){
        $this->db->where('can_sel_id',$id);
        return $query = $this->db->select('a.*,b.position_name')->from('candidate_selection a')->join('position b','a.pos_id=b.pos_id')->where('a.can_sel_id',$id)->get()->row();
    }

    public function dropdowninterview()
	{
		$this->db->select('a.*,b.first_name,b.last_name');
        $this->db->from('candidate_shortlist a');
        $this->db->join('candidate_basic_info b','a.can_id=b.can_id');
        $query = $this->db->get();
        $data = $query->result();
       $list = array('' => 'Select One...');
       	if (!empty($data) ) {
       		foreach ($data as $value) {
       			$list[$value->can_id] = $value->first_name.' '.$value->last_name;
       		} 
       	}
       	return $list;
	}

	public function dropdownselection()
	{
        $data = $this->db->select('a.*,b.first_name,b.last_name')->from('candidate_interview a')->join('candidate_basic_info b','a.can_id=b.can_id')->where('a.selection','ok')->get()->result();
       
        $list = array('' => 'Select One...');
       	if (!empty($data) ) {
       		foreach ($data as $value) {
       			$list[$value->can_id] = $value->first_name.' '.$value->last_name;
       		} 
       	}
       	return $list;
	}



	/* selected dropdown position */
	public function selected()
	{
        $query = $this->db->get_where('candidate_interview',array('selection'=>"ok"));
        
        $data = $query->result();
       
       $list = array('' => 'Select One...');
       	if (!empty($data) ) {
       		foreach ($data as $value) {
       			$list[$value->job_adv_id] = $value->job_adv_id;
       		} 
       	}
       	return $list;
	}

/*  ################ selected auto ######################  */

public function insert_employee($data = array())
	{
		return $this->db->insert('employee_history', $data);//
	}

	public function Canlist(){
		$this->db->select("can_id,CONCAT_WS(' ',first_name,last_name) AS name");
        $this->db->from('candidate_basic_info');
        $query = $this->db->get();
        $data = $query->result();
       
     $list = array('' => 'Select One...');
       	if (!empty($data) ) {
       		foreach ($data as $value) {
       			$list[$value->can_id] = $value->name;
       		} 
       	}
       	return $list;

	}
    public function headcode(){
        $query=$this->db->query("SELECT MAX(HeadCode) as HeadCode FROM acc_coa WHERE HeadLevel='2' And HeadCode LIKE '502020000%'");
        return $query->row();

    }
     public function create_coa($data = [])
    {
        $this->db->insert('acc_coa',$data);
        return true;
    }
    
    public function cities(){
        $query=$this->db->query("SELECT City.* FROM City WHERE CountryCode='PAK' ");
        return $query->result();

    }
     
   public function getPositions($search){

          if($search == ''){
             $postions =  $this->db->query("SELECT position.* FROM position ")->result();
          }else{
             $postions = $this->db->query("SELECT position.* FROM position where position_name LIKE '%".$search."%'")->result();
          }
    
          $response = array();
          foreach($postions as $postion){
             $response[] = array("value"=>$postion->pos_id,"label"=>ucfirst($postion->position_name));
          }
         return $response;
       
    }
    
    public function create_job($post_data,$params)
	{    
	    $this->db->insert('job_posting', $post_data);
        $insert_id = $this->db->insert_id();
		if($insert_id){
		    foreach($params['job_location'] as $location){
		        $this->db->insert('job_posting_locations', array('jpl_city_id'=>$location,'jp_id'=>$insert_id));
		    }
		    foreach($params['skills'] as $skill){
		        $this->db->insert('job_posting_skills', array('jps_name'=>$skill,'jps_must_or_nice'=>$params['skill_must_or_nice'][$skill],'jp_id'=>$insert_id));
		    } 
		    
		    return true;
		}else{
		    return false;
		}
	}
	public function selectiveJobPosting($id)
	{
	    
	    $mr = $this->db->select('sel.*,bi.position_name')   
            ->from('job_posting sel')
            ->join('position bi', 'sel.pos_id = bi.pos_id')
            ->where('sel.jp_id',$id)
            ->get()
            ->first_row();
            
        if($mr){
            $mr->locations = $this->db->select('ci.*')   
            ->from('job_posting_locations ci')
            ->where('ci.jp_id',$mr->jp_id)
            ->get()
            ->result();
            
            $locations_array = array();

            foreach($mr->locations as $row)
            {
                $locations_array[] = $row->jpl_city_id; // add each user id to the array
            }
        
            $mr->locations_list = $locations_array;
            
            $mr->skills = $this->db->select('si.*')   
            ->from('job_posting_skills si')
            ->where('si.jp_id',$mr->jp_id)
            ->get()
            ->result();
            
            $array = array();

            foreach($mr->skills as $row)
            {
                $array[] = $row->jps_name; // add each user id to the array
            }
        
            $mr->skills_list = $array;
            
        }else{
            $mr = array();
        }
            
       
       
       return $mr;
	}
	public function update_job($post_data,$params)
	{    
	    $this->db->where('job_posting.jp_id',$params['jp_id']);
	    $data = $this->db->update('job_posting', $post_data);
		if($data){
		    
		    $this->db->where('job_posting_locations.jp_id',$params['jp_id']);
		    $this->db->delete('job_posting_locations');
		    
		    foreach($params['job_location'] as $location){
		        $this->db->insert('job_posting_locations', array('jpl_city_id'=>$location,'jp_id'=>$params['jp_id']));
		    }
		    
		    $this->db->where('job_posting_skills.jp_id',$params['jp_id']);
		    $this->db->delete('job_posting_skills');
		    
		    foreach($params['skills'] as $skill){
		        $this->db->insert('job_posting_skills', array('jps_name'=>$skill,'jps_must_or_nice'=>$params['skill_must_or_nice'][$skill],'jp_id'=>$params['jp_id']));
		    } 
		    
		    return true;
		}else{
		    return false;
		}
	}
	
	
	public function updateJobStatus($post_data,$jp_id)
	{    
	    $this->db->where('job_posting.jp_id',$jp_id);
	    $data = $this->db->update('job_posting', $post_data);
		if($data){
		    
		    return true;
		}else{
		    return false;
		}
	}
	public function updateSitePublishStatus($post_data,$jp_id)
	{    
	    $this->db->where('job_posting.jp_id',$jp_id);
	    $data = $this->db->update('job_posting', $post_data);
		if($data){
		    
		    return true;
		}else{
		    return false;
		}
	}
	
	public function deleteJobPosting($jp_id)
	{    
	    $this->db->where('job_posting.jp_id',$jp_id);
	    $data = $this->db->delete('job_posting');
		if($data){
		    
		    return true;
		}else{
		    return false;
		}
	}
}
