<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Job_posting extends MX_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->db->query('SET SESSION sql_mode = ""');
		
		$this->load->model(array(
			'Selection_model',
			'Job_model',
		));	
		if (! $this->session->userdata('isLogIn'))
			redirect('login?rback=' . uri_string());	 
	}

	
		/*######################## Job posting Part ######################*/
public function manage_job_posting()
	{   
        $data['title'] = display('manage_job_posting');
		$data['module'] = "recruitment";
		$data['page']   = "job_posting_listing"; 
		$data['dropdowninterview'] = $this->Selection_model->dropdowninterview(); 
		$data['job_posting'] = $this->Job_model->viewJobPosting();
		$data['cities'] = $this->Job_model->cities();
		//$data['dropdown'] = $this->Selection_model->dropdownPosition();
		echo Modules::run('template/layout', $data); 
	} 

	public function select_joblist($id){

	$data = $this->db->select('a.*,b.position_name')->from('candidate_shortlist a')->join('position b','a.job_adv_id=b.pos_id')->where('a.can_id',$id)->get()->row();

	echo json_encode($data);
}

    public function positionselect(){

    	$data = $this->Job_model->getPositions($_POST['search']);
    
    	echo json_encode($data);
    }
    
     public function generateShortURlCode() { 

		   // The length we want the unique reference number to be  
			$unique_ref_length = 7;  
			  
			// A true/false variable that lets us know if we've  
			// found a unique reference number or not  
			$unique_ref_found = false;  
			  
			// Define possible characters.  
			// Notice how characters that may be confused such  
			// as the letter 'O' and the number zero don't exist  
			$possible_chars = "abcdefghijklmnopqrstuvwxyz1234567890";  
			  
			// Until we find a unique reference, keep generating new ones  
			while (!$unique_ref_found) {  
			  
				// Start with a blank reference number  
				$unique_ref = "";  
				  
				// Set up a counter to keep track of how many characters have   
				// currently been added  
				$i = 0;  
				  
				// Add random characters from $possible_chars to $unique_ref   
				// until $unique_ref_length is reached  
				while ($i < $unique_ref_length) {  
				  
					// Pick a random character from the $possible_chars list  
					$char = substr($possible_chars, mt_rand(0, strlen($possible_chars)-1), 1);  
					  
					$unique_ref .= $char;  
					  
					$i++;  
				  
				}  
				  
				// Our new unique reference number is generated.  
				// Lets check if it exists or not  
				$query = $this->db->get_where('job_posting',array( 'jp_short_url' => $unique_ref));
				if ($query->num_rows()==0) {  
				  
					// We've found a unique number. Lets set the $unique_ref_found  
					// variable to true and exit the while loop  
					$unique_ref_found = true;  
				  
				}  
			  
			}

			if($unique_ref_found){
			  return $unique_ref;
			}

	}

public function job_posting_form()
	{ 
	   // echo "<pre>";
	   // print_r($_POST['skill_must_or_nice']['ab']);die;
		$data['title'] = display('interview_list');
		#-------------------------------#
		$this->form_validation->set_rules(
                'job_title', display('job_title'),
                'required',
                array(
                        'required'      => 'Please select a '.display('job_title').' from suggestions'
                )
        );
        $this->form_validation->set_rules(
                'job_description', display('job_description'),
                'required',
                array(
                        'required'      => display('job_description').' is required'
                )
        );
        $this->form_validation->set_rules(
                'job_skill', display('job_skill'),
                'required',
                array(
                        'required'      => display('job_skill').' is required'
                )
        );
        $this->form_validation->set_rules(
                'career_level', display('career_level'),
                'required',
                array(
                        'required'      => display('career_level').' is required'
                )
        );
        $this->form_validation->set_rules(
                'no_of_position', display('no_of_position'),
                'required',
                array(
                        'required'      => display('no_of_position').' is required'
                )
        );
        $this->form_validation->set_rules(
                'job_location[]', display('job_location'),
                'required',
                array(
                        'required'      => display('job_location').' is required'
                )
        );
        $this->form_validation->set_rules(
                'qualification', display('qualification'),
                'required',
                array(
                        'required'      => display('qualification').' is required'
                )
        );
        $this->form_validation->set_rules(
                'higher_exactly', display('higher_exactly'),
                'required',
                array(
                        'required'      => display('higher_exactly').' is required'
                )
        );
        $this->form_validation->set_rules(
                'min_experience', display('min_experience'),
                'required',
                array(
                        'required'      => display('min_experience').' is required'
                )
        );
        $this->form_validation->set_rules(
                'max_experience', display('max_experience'),
                'required',
                array(
                        'required'      => display('max_experience').' is required'
                )
        );
        $this->form_validation->set_rules(
                'from_salary', display('from_salary'),
                'required',
                array(
                        'required'      => display('from_salary').' is required'
                )
        );
        $this->form_validation->set_rules(
                'to_salary', display('to_salary'),
                'required',
                array(
                        'required'      => display('to_salary').' is required'
                )
        );
        $this->form_validation->set_rules(
                'employment_type', display('employment_type'),
                'required',
                array(
                        'required'      => display('employment_type').' is required'
                )
        );
        $this->form_validation->set_rules(
                'gender_preference', display('gender_preference'),
                'required',
                array(
                        'required'      => display('gender_preference').' is required'
                )
        );
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
				'pos_id' 	         => $this->input->post('job_title',true),
				'jp_title_description' 	     => $this->input->post('job_description',true),
				'jp_career_level' 	 => $this->input->post('career_level',true),
				'jp_career_position' 	 => $this->input->post('no_of_position',true),
				'jp_qualification_level' 	 => $this->input->post('qualification',true),
				'jp_qualification_must'=> $this->input->post('higher_exactly',true),
				'jp_experience_min' 	 => $this->input->post('min_experience',true),
				'jp_experience_max' 	     => $this->input->post('max_experience',true),
				'jp_salary_min' 	 => $this->input->post('from_salary',true),
				'jp_salary_max' 	     => $this->input->post('to_salary',true),
				'jp_employment_type' 	         => $this->input->post('employment_type',true),
				'jp_preference' 	         => $this->input->post('gender_preference',true),
				'jp_short_url' => $this->generateShortURlCode()
			];   

			if ($this->Job_model->create_job($postData,$_POST)) { 
				$this->session->set_flashdata('message', display('successfully_saved'));
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
			}
			redirect("recruitment/Job_posting/job_posting_form");
		   } else {
			$data['title'] = display('create');
			$data['module'] = "recruitment";
			$data['page']   = "job_posting_form"; 
			$data['job_posting'] = $this->Job_model->viewJobPosting();
			$data['cities'] = $this->Job_model->cities();
			//$data['dropdown'] = $this->Selection_model->dropdownPosition();
			echo Modules::run('template/layout', $data);   
			
		}   
	}


	public function job_posting_update_form($id = null){
			$data['title'] = display('interview_list');
		#-------------------------------#
		$this->form_validation->set_rules(
                'job_title', display('job_title'),
                'required',
                array(
                        'required'      => 'Please select a '.display('job_title').' from suggestions'
                )
        );
        $this->form_validation->set_rules(
                'job_description', display('job_description'),
                'required',
                array(
                        'required'      => display('job_description').' is required'
                )
        );
        $this->form_validation->set_rules(
                'job_skill', display('job_skill'),
                'required',
                array(
                        'required'      => display('job_skill').' is required'
                )
        );
        $this->form_validation->set_rules(
                'career_level', display('career_level'),
                'required',
                array(
                        'required'      => display('career_level').' is required'
                )
        );
        $this->form_validation->set_rules(
                'no_of_position', display('no_of_position'),
                'required',
                array(
                        'required'      => display('no_of_position').' is required'
                )
        );
        $this->form_validation->set_rules(
                'job_location[]', display('job_location'),
                'required',
                array(
                        'required'      => display('job_location').' is required'
                )
        );
        $this->form_validation->set_rules(
                'qualification', display('qualification'),
                'required',
                array(
                        'required'      => display('qualification').' is required'
                )
        );
        $this->form_validation->set_rules(
                'higher_exactly', display('higher_exactly'),
                'required',
                array(
                        'required'      => display('higher_exactly').' is required'
                )
        );
        $this->form_validation->set_rules(
                'min_experience', display('min_experience'),
                'required',
                array(
                        'required'      => display('min_experience').' is required'
                )
        );
        $this->form_validation->set_rules(
                'max_experience', display('max_experience'),
                'required',
                array(
                        'required'      => display('max_experience').' is required'
                )
        );
        $this->form_validation->set_rules(
                'from_salary', display('from_salary'),
                'required',
                array(
                        'required'      => display('from_salary').' is required'
                )
        );
        $this->form_validation->set_rules(
                'to_salary', display('to_salary'),
                'required',
                array(
                        'required'      => display('to_salary').' is required'
                )
        );
        $this->form_validation->set_rules(
                'employment_type', display('employment_type'),
                'required',
                array(
                        'required'      => display('employment_type').' is required'
                )
        );
        $this->form_validation->set_rules(
                'gender_preference', display('gender_preference'),
                'required',
                array(
                        'required'      => display('gender_preference').' is required'
                )
        );
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
				'pos_id' 	         => $this->input->post('job_title',true),
				'jp_title_description' 	     => $this->input->post('job_description',true),
				'jp_career_level' 	 => $this->input->post('career_level',true),
				'jp_career_position' 	 => $this->input->post('no_of_position',true),
				'jp_qualification_level' 	 => $this->input->post('qualification',true),
				'jp_qualification_must'=> $this->input->post('higher_exactly',true),
				'jp_experience_min' 	 => $this->input->post('min_experience',true),
				'jp_experience_max' 	     => $this->input->post('max_experience',true),
				'jp_salary_min' 	 => $this->input->post('from_salary',true),
				'jp_salary_max' 	     => $this->input->post('to_salary',true),
				'jp_employment_type' 	         => $this->input->post('employment_type',true),
				'jp_preference' 	         => $this->input->post('gender_preference',true),
				'jp_updated_on' => date('Y-m-d h:i:s')
			];   

			if ($this->Job_model->update_job($postData,$_POST)) { 
				$this->session->set_flashdata('message', display('update_successfully'));
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
			}
			redirect("recruitment/Job_posting/job_posting_update_form/".$id);
		   } else {
			$data['title'] = display('update');
			$data['module'] = "recruitment";
			$data['page']   = "job_posting_update_form"; 
			$data['job_posting'] = $this->Job_model->selectiveJobPosting($id);
			$data['cities'] = $this->Job_model->cities();
			//$data['dropdown'] = $this->Selection_model->dropdownPosition();
			echo Modules::run('template/layout', $data);   
			
		}   
	}
	
	public function updateJobStatus(){
        
   
        if(isset($_POST['job_now_status']) && $_POST['job_now_status'] == 1 || isset($_POST['job_now_status']) && $_POST['job_now_status'] == 2){
            $postData = [
                'jp_status'=>$_POST['job_now_status'],
				'jp_updated_on' => date('Y-m-d h:i:s')
			];   
        	$data = $this->Job_model->updateJobStatus($postData,$_POST['job_id']);
        	$this->session->set_flashdata('message', display('update_successfully'));
        }else{
            $this->session->set_flashdata('exception',  display('please_try_again'));
        }
        
    
    	return true;
    }
    
    public function updateSitePublishStatus(){
        
   
        if(isset($_POST['job_site']) && $_POST['job_site'] == 'linkedin' || isset($_POST['job_site']) && $_POST['job_site'] == 'rozee'|| isset($_POST['job_site']) && $_POST['job_site'] == 'appedology'){
            if($_POST['job_site'] == 'linkedin'){
                $postData = [
                    'jp_linkedin_publish'=>0,
    				'jp_updated_on' => date('Y-m-d h:i:s')
    			];  
    			$data = $this->Job_model->updateSitePublishStatus($postData,$_POST['job_id']);
            	$this->session->set_flashdata('message', display('publishing_on_linkedin'));
            }else if($_POST['job_site'] == 'rozee'){
                $postData = [
                    'jp_rozee_publish'=>0,
    				'jp_updated_on' => date('Y-m-d h:i:s')
    			];
    			$data = $this->Job_model->updateSitePublishStatus($postData,$_POST['job_id']);
        	    $this->session->set_flashdata('message', display('publishing_on_rozee'));
            }else{
                $postData = [
                    'jp_appedology_publish'=>0,
    				'jp_updated_on' => date('Y-m-d h:i:s')
    			];
    			$data = $this->Job_model->updateSitePublishStatus($postData,$_POST['job_id']);
        	    $this->session->set_flashdata('message', display('publishing_on_appedology'));
            }
            
        	
        }else{
            $this->session->set_flashdata('exception',  display('please_try_again'));
        }
        
    
    	return true;
    }
	
	public function deleteJobPosting(){
        
    	$data = $this->Job_model->deleteJobPosting($_POST['job_id']);
    	if($data){
    	  $this->session->set_flashdata('message', display('delete_successfully'));  
    	}else{
    	  $this->session->set_flashdata('exception',  display('please_try_again'));

    	}
    	return true;
    }


	   public function randID()
    {
        $result = ""; 
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

        $charArray = str_split($chars);
        for($i = 0; $i < 7; $i++) {
                $randItem = array_rand($charArray);
                $result .="".$charArray[$randItem];
        }
        return "E".$result;
    }
    
   


}
