<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Careers extends MX_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->db->query('SET SESSION sql_mode = ""');
		
		$this->load->model(array(
			'Selection_model',
			'Job_model',
			'Candidate_model'
		));		 
	}
    
    public function caninfo_create_linked_job($job_id)
	{ 
	    
	    
	    if(!empty($job_id)){
	        $job_data = $this->Job_model->specificJobPosting($job_id);
	       if(!empty($job_data)){
	          
    	        $data['title'] = display('career');
    			$data['module'] = "recruitment";
    			$data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
    			$data['jobs_reads'] = $job_data;
    				$data['setting'] = $this->Job_model->setting();
        		$this->load->view('caninfo_apply', $data);
    	    }else{
    	        
    	        $this->session->set_flashdata('exception', display('job_data_not_found'));
    	    	redirect("recruitment/Careers/open_positions");
    	    }
	    }else{
	        
	        $this->session->set_flashdata('exception', display('job_data_not_found'));
	    	redirect("recruitment/Careers/open_positions");
	    }
		   
	}
	
	public function can_info_create(){
	    
	    $data['title'] = display('write_y_p_info');
		#-------------------------------#
		
		 $this->form_validation->set_rules(
                'job_id', display('job_id'),
                'required',
                array(
                        'required'      => display('job_id').' is required'
                )
        );
        
		$this->form_validation->set_rules(
                'first_name', display('first_name'),
                'required',
                array(
                        'required'      => display('first_name').' is required'
                )
        );
        $this->form_validation->set_rules(
                'last_name', display('last_name'),
                'required',
                array(
                        'required'      => display('last_name').' is required'
                )
        );
        $this->form_validation->set_rules(
                'email', display('email'),
                'required',
                array(
                        'required'      => display('email').' is required'
                )
        );
        $this->form_validation->set_rules(
                'phone', display('phone'),
                'required',
                array(
                        'required'      => display('phone').' is required'
                )
        );
        $this->form_validation->set_rules(
                'alter_phone', display('alter_phone'),
                'required',
                array(
                        'required'      => display('alter_phone').' is required'
                )
        );
        $this->form_validation->set_rules(
                'address', display('address'),
                'required',
                array(
                        'required'      => display('address').' is required'
                )
        );
        $this->form_validation->set_rules(
                'last_employer', display('last_employer'),
                'required',
                array(
                        'required'      => display('last_employer').' is required'
                )
        );
        $this->form_validation->set_rules(
                'total_years_of_experience', display('total_years_of_experience'),
                'required',
                array(
                        'required'      => display('total_years_of_experience').' is required'
                )
        );
        
		#-------------------------------#
		if ($this->form_validation->run() === true) {
			
			if (isset($_FILES) && $_FILES['resume_uploads']['name'] !="" ) {
			    $this->load->library('myupload');
			    
            	$id = $this->generate->id();
            	$file = $this->myupload->do_upload(
            	    	'./application/modules/recruitment/assets/candidates_resume/','resume_uploads'
            
            	    );
    			$postData1= [
    			'can_id' 	              => $id,
    			'first_name' 	          => $this->input->post('first_name',true),
    			'last_name' 	          => $this->input->post('last_name',true),
    			'email' 	              => $this->input->post('email',true),
    			'phone' 	              => $this->input->post('phone',true),
    			'alter_phone' 	          => $this->input->post('alter_phone',true),
    			'address' 	              => $this->input->post('address',true),
    			'last_employer' 	      => $this->input->post('last_employer',true),
    			'resume' 	              => $file,
    			'total_years_of_experience' => $this->input->post('total_years_of_experience',true),
    			'jp_id'                     => $this->input->post('job_id',true)
    			];   
    			

    			$job_exist = $this->db->get_where('job_posting',array('jp_id'=>$this->input->post('job_id',true)))->result();
                            
                $this->db->select('can_id');
                $this->db->from('candidate_basic_info');
                $this->db->where('email',$this->input->post('email',true));
                $this->db->where('jp_id',$this->input->post('job_id',true));
                $this->db->or_where('phone',$this->input->post('phone',true));
                $this->db->where('jp_id',$this->input->post('job_id',true));
                $this->db->or_where('alter_phone', $this->input->post('alter_phone',true));
                $this->db->where('jp_id',$this->input->post('job_id',true));
                $candidate_found = $this->db->get()->result();
                
    			if($job_exist && !$candidate_found){
    			    
    			$this->db->insert('candidate_basic_info', $postData1);
    			
    			$this->session->set_flashdata('message', display('Successfully_applied'));
    			
    			$data['title'] = display('create_details');
    			$data['module'] = "recruitment";
    			$data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
    			$data['jobs_reads'] = $this->Candidate_model->jobs_reads($_POST['job_id']);
        		$data['setting'] = $this->Job_model->setting();
        		$this->load->view('caninfo_apply', $data);
    			
    			}else{
    			    
    			    $this->session->set_flashdata('exception', display('you_already_applied_for_this_job'));
    			    
                    $data['title'] = display('create_details');
        			$data['module'] = "recruitment";
        			$data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
        			$data['jobs_reads'] = $this->Candidate_model->jobs_reads($_POST['job_id']);
            		$data['setting'] = $this->Job_model->setting();
            		$this->load->view('caninfo_apply', $data);
    			}
    			
            }else{
                
                $this->session->set_flashdata('exception', display('file_not_found'));
                
                $data['title'] = display('create_details');
    			$data['module'] = "recruitment";
    			$data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
    			$data['jobs_reads'] = $this->Candidate_model->jobs_reads($_POST['job_id']);
        		$data['setting'] = $this->Job_model->setting();
        		$this->load->view('caninfo_apply', $data);
            }
			



		}else{
		    
		    $data['title'] = display('create_details');
			$data['module'] = "recruitment";
			$data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
			$data['jobs_reads'] = $this->Candidate_model->jobs_reads($_POST['job_id']);
    		$data['setting'] = $this->Job_model->setting();
    		$this->load->view('caninfo_apply', $data);
		}
	}
    
	public function open_positions()
	{ 
	   	$data['title'] = display('career');
		$data['module'] = "recruitment";
		$data['job_posting'] = $this->Job_model->viewJobPosting();
		$data['cities'] = $this->Job_model->cities();
		$data['setting'] = $this->Job_model->setting();
		//$data['dropdown'] = $this->Selection_model->dropdownPosition();
		$this->load->view('job_listing', $data);
	}
	
	public function job_details($id)
	{ 
	    $job_data = $this->Job_model->specificJobPosting($id);
		    
	    if(!empty($job_data)){
	        
	        $data['title'] = display('career');
			$data['module'] = "recruitment";
			$data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
			$data['jobs_reads'] = $job_data;
			$data['setting'] = $this->Job_model->setting();
    		$this->load->view('job_details', $data);
	    }else{
	        
	        $this->session->set_flashdata('exception', display('job_data_not_found'));
	    	redirect("recruitment/Careers/open_positions");
	    }
	}



	   public function randID()
    {
        $result = ""; 
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

        $charArray = str_split($chars);
        for($i = 0; $i < 7; $i++) {
                $randItem = array_rand($charArray);
                $result .="".$charArray[$randItem];
        }
        return "E".$result;
    }


}
