<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Candidate_select extends MX_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->db->query('SET SESSION sql_mode = ""');
		
		$this->load->model(array(
			'Selection_model',
			'Job_model',
		));	
		$this->load->library("PHPMailer_Library");
        $this->load->library('pdf');
		if (! $this->session->userdata('isLogIn'))
			redirect('login?rback=' . uri_string());	 
	}

    public function candidate_shortlist_view(){   
        $this->permission->module('recruitment','read')->redirect();
		$data['title']         = display('shortlist');  ;
		$data['shortlist']     = $this->Selection_model->viewShortlist();
		$data['dropdowncanid'] = $this->Selection_model->dropdowncanid(); 
		$data['dropdown']      = $this->Selection_model->dropdown(); 
		$data['module']        = "recruitment";
		$data['page']          = "shortlist_view";  
		echo Modules::run('template/layout', $data); 
	} 

public function create_shortlist()
	{ 
		$data['title'] = display('candidateshortlist');
		#-------------------------------#
		$this->form_validation->set_rules('can_id',display('can_id'),'required|is_unique[candidate_shortlist.can_id]|max_length[50]');
		$this->form_validation->set_rules('job_adv_id',display('job_adv_id')  ,'required|max_length[100]');
		$this->form_validation->set_rules('date_of_shortlist',display('date_of_shortlist'),'required|max_length[50]');
		$this->form_validation->set_rules('interview_date',display('interview_date')  ,'required|max_length[100]');
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
				'can_id' 	       => $this->input->post('can_id',true),
				'job_adv_id' 	   => $this->input->post('job_adv_id',true),
				'date_of_shortlist'=> $this->input->post('date_of_shortlist',true),
				'interview_date'   => $this->input->post('interview_date',true),
			];   

			if ($this->Selection_model->shortlist_create($postData)) { 
				$this->session->set_flashdata('message', display('successfully_saved'));
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
			}
			redirect("recruitment/Candidate_select/create_shortlist");

		} else {
			$data['title'] = display('create');
			$data['module'] = "recruitment";
			$data['page']   = "shortlist_form"; 
			$data['dropdowncanid'] = []; 
			$data['dropdown'] = $this->Selection_model->dropdown(); 
			$data['shortlist'] = $this->Selection_model->viewShortlist();
			echo Modules::run('template/layout', $data);   
			
		}   
	}
	
	public function dropdowncanid($id){

		$this->db->select('*');
        $this->db->from('candidate_basic_info');
        $this->db->where('jp_id',$id);
        $query = $this->db->get();
        $data = $query->result();
       
        $list = array('' => 'Select One...');
        $html = "";
       	if (!empty($data) ) {
       	    $html .= "<option value=''>Select One...</option>";
       		foreach ($data as $value) {
       		    $html .= "<option value='".$value->can_id."'>".$value->first_name."(".$value->can_id.").</option>";
       		} 
       	}
    	echo $html;
    }
    
    public function dropdowncanidby_can_id($id){

		$this->db->select('*');
        $this->db->from('candidate_basic_info');
        $this->db->where('can_id',$id);
        $query = $this->db->get();
        $data = $query->first_row();
       
        echo json_encode($data);
    }
    
    

	public function delete_shortlist($id = null) 
	{ 
        $this->permission->module('recruitment','delete')->redirect();

		if ($this->Selection_model->delete_shorlist($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect('recruitment/Candidate_select/candidate_shortlist_view');
	}

public function update_shortlist_form($id = null){
 		$this->form_validation->set_rules('can_short_id',null,'required|max_length[11]');
 		$this->form_validation->set_rules('can_id',display('can_id'),'required|max_length[50]');
		$this->form_validation->set_rules('job_adv_id',display('job_adv_id')  ,'required|max_length[100]');
		$this->form_validation->set_rules('date_of_shortlist',display('date_of_shortlist'),'required|max_length[50]');
		$this->form_validation->set_rules('interview_date',display('interview_date')  ,'required|max_length[100]');
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
			    'can_short_id' 	             => $this->input->post('can_short_id',true),
				'can_id' 	                 => $this->input->post('can_id',true),
				'job_adv_id' 	             => $this->input->post('job_adv_id',true),
				'date_of_shortlist' 		 => $this->input->post('date_of_shortlist',true),
				'interview_date' 		     => $this->input->post('interview_date',true),
			]; 
			
			if ($this->Selection_model->update_shortlist($postData)) { 
				$this->session->set_flashdata('message', display('successfully_updated'));
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
			}
			redirect("recruitment/Candidate_select/update_shortlist_form/". $id);

		} else {
			$data['title']   = display('update');
		    $data['data']    =$this->Selection_model->shortlist_updateForm($id);
		    $data['canlist'] =$this->Selection_model->Canlist();
			$data['module']  = "recruitment";
			$data['dropdown']= $this->Selection_model->dropdown(); 
			$data['page']    = "update_short_form";   
			echo Modules::run('template/layout', $data); 
		}
 
	}


	/*######################## Interview Part ######################*/
public function candidate_interview_view()
	{   
        $this->permission->module('recruitment','read')->redirect();

		$data['title']    = display('interview');  ;
		$data['interview'] = $this->Selection_model->viewInterview();
		$data['module'] = "recruitment";
		$data['page']   = "interview_view";   
		echo Modules::run('template/layout', $data); 
	} 

	public function select_interviewlist($id){

    	$data = $this->db->select('a.*,b.position_name')->from('candidate_shortlist a')->join('position b','a.job_adv_id=b.pos_id')->where('a.can_id',$id)->get()->row();
    
    	echo json_encode($data);
    }
    


public function create_interview()
	{ 
		$data['title'] = display('interview_list');
		#-------------------------------#
		$this->form_validation->set_rules('can_id',display('can_id'),'required|is_unique[candidate_interview.can_id]|max_length[50]');
		$this->form_validation->set_rules('job_adv_id',display('job_adv_id')  ,'required|max_length[100]');
		$this->form_validation->set_rules('interview_date',display('interview_date')  ,'required|max_length[100]');

		$this->form_validation->set_rules('interviewer_id',display('interviewer_id'),'required|max_length[50]');
		$this->form_validation->set_rules('interview_marks',display('interview_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('written_total_marks',display('written_total_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('mcq_total_marks',display('mcq_total_marks'),'required|max_length[50]');
		$this->form_validation->set_rules('total_marks',display('total_marks'),'required|max_length[50]');
		$this->form_validation->set_rules('recommandation',display('recommandation')  ,'max_length[100]');
		$this->form_validation->set_rules('selection',display('selection')  ,'required|max_length[30]');
		$this->form_validation->set_rules('details',display('details')  ,'max_length[100]');
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
				'can_id' 	         => $this->input->post('can_id',true),
				'job_adv_id' 	     => $this->input->post('job_adv_id',true),
				'interview_date' 	 => $this->input->post('interview_date',true),
				'interviewer_id' 	 => $this->input->post('interviewer_id',true),
				'interview_marks' 	 => $this->input->post('interview_marks',true),
				'written_total_marks'=> $this->input->post('written_total_marks',true),
				'mcq_total_marks' 	 => $this->input->post('mcq_total_marks',true),
				'total_marks' 	     => $this->input->post('total_marks',true),
				'recommandation' 	 => $this->input->post('recommandation',true),
				'selection' 	     => $this->input->post('selection',true),
				'details' 	         => $this->input->post('details',true),
			];   

			if ($this->Selection_model->interview_create($postData)) { 
				$this->session->set_flashdata('message', display('successfully_saved'));
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
			}
			redirect("recruitment/Candidate_select/create_interview");
		   } else {
			$data['title'] = display('create');
			$data['module'] = "recruitment";
			$data['page']   = "interview_form"; 
			$data['dropdowninterview'] = $this->Selection_model->dropdowninterview(); 
			$data['interview'] = $this->Selection_model->viewInterview();
			//$data['dropdown'] = $this->Selection_model->dropdownPosition();
			echo Modules::run('template/layout', $data);   
			
		}   
	}


  public function delete_interview($id = null){ 
     $this->permission->module('recruitment','delete')->redirect();
		if ($this->Selection_model->delete_interview($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect("recruitment/Candidate_select/candidate_interview_view");
	}

	public function interview_update_form($id = null){
		$this->form_validation->set_rules('can_int_id',null,'required|max_length[11]');
 		$this->form_validation->set_rules('can_id',display('can_id'),'required|max_length[50]');
		$this->form_validation->set_rules('job_adv_id',display('job_adv_id')  ,'required|max_length[100]');
		$this->form_validation->set_rules('interview_date',display('interview_date')  ,'required|max_length[100]');
		$this->form_validation->set_rules('interviewer_id',display('interviewer_id'),'required|max_length[50]');
		$this->form_validation->set_rules('interview_marks',display('interview_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('written_total_marks',display('written_total_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('mcq_total_marks',display('mcq_total_marks'),'required|max_length[50]');
		$this->form_validation->set_rules('recommandation',display('recommandation')  ,'required|max_length[100]');
		$this->form_validation->set_rules('selection',display('selection')  ,'required|max_length[30]');
		$this->form_validation->set_rules('details',display('details')  ,'required|max_length[100]');
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
			    'can_int_id' 	     => $this->input->post('can_int_id',true),
				'can_id' 	         => $this->input->post('can_id',true),
				'job_adv_id' 	     => $this->input->post('job_adv_id',true),
				'interview_date' 	 => $this->input->post('interview_date',true),
				'interviewer_id' 	 => $this->input->post('interviewer_id',true),
				'interview_marks' 	 => $this->input->post('interview_marks',true),
				'written_total_marks'=> $this->input->post('written_total_marks',true),
				'mcq_total_marks' 	 => $this->input->post('mcq_total_marks',true),
				'recommandation' 	 => $this->input->post('recommandation',true),
				'selection' 	     => $this->input->post('selection',true),
				'details' 	         => $this->input->post('details',true),
			]; 
			
			if ($this->Selection_model->update_interview($postData)) { 
				$this->session->set_flashdata('message', display('successfully_updated'));
				redirect("recruitment/Candidate_select/create_interview");
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
				redirect("recruitment/Candidate_select/interview_update_form/". $id);
			}	

	     	} else {
			$data['title']  = display('update');
		    $data['data']   =$this->Selection_model->interview_updateForm($id);
			$data['module'] = "recruitment";
			$data['dropdowninterview'] = $this->Selection_model->dropdowninterview(); 
			$data['page']   = "update_interview_form";   
			echo Modules::run('template/layout', $data); 
		}
 
	}
	
		/*######################## Job posting Part ######################*/
public function job_posting_view()
	{   
        $this->permission->module('recruitment','read')->redirect();

		$data['title']    = display('interview');  ;
		$data['interview'] = $this->Selection_model->viewInterview();
		$data['module'] = "recruitment";
		$data['page']   = "interview_view";   
		echo Modules::run('template/layout', $data); 
	} 

	public function select_joblist($id){

	$data = $this->db->select('a.*,b.position_name')->from('candidate_shortlist a')->join('position b','a.job_adv_id=b.pos_id')->where('a.can_id',$id)->get()->row();

	echo json_encode($data);
}

    public function positionselect(){

    	$data = $this->Job_model->getPositions($_POST['search']);
    
    	echo json_encode($data);
    }

public function job_posting_form()
	{ 
	   // echo "<pre>";
	   // print_r($this->Job_model->viewJobPosting());die;
		$data['title'] = display('interview_list');
		#-------------------------------#
		$this->form_validation->set_rules('can_id',display('can_id'),'required|is_unique[candidate_interview.can_id]|max_length[50]');
		$this->form_validation->set_rules('job_adv_id',display('job_adv_id')  ,'required|max_length[100]');
		$this->form_validation->set_rules('interview_date',display('interview_date')  ,'required|max_length[100]');

		$this->form_validation->set_rules('interviewer_id',display('interviewer_id'),'required|max_length[50]');
		$this->form_validation->set_rules('interview_marks',display('interview_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('written_total_marks',display('written_total_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('mcq_total_marks',display('mcq_total_marks'),'required|max_length[50]');
		$this->form_validation->set_rules('total_marks',display('total_marks'),'required|max_length[50]');
		$this->form_validation->set_rules('recommandation',display('recommandation')  ,'max_length[100]');
		$this->form_validation->set_rules('selection',display('selection')  ,'required|max_length[30]');
		$this->form_validation->set_rules('details',display('details')  ,'max_length[100]');
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
				'can_id' 	         => $this->input->post('can_id',true),
				'job_adv_id' 	     => $this->input->post('job_adv_id',true),
				'interview_date' 	 => $this->input->post('interview_date',true),
				'interviewer_id' 	 => $this->input->post('interviewer_id',true),
				'interview_marks' 	 => $this->input->post('interview_marks',true),
				'written_total_marks'=> $this->input->post('written_total_marks',true),
				'mcq_total_marks' 	 => $this->input->post('mcq_total_marks',true),
				'total_marks' 	     => $this->input->post('total_marks',true),
				'recommandation' 	 => $this->input->post('recommandation',true),
				'selection' 	     => $this->input->post('selection',true),
				'details' 	         => $this->input->post('details',true),
			];   

			if ($this->Selection_model->interview_create($postData)) { 
				$this->session->set_flashdata('message', display('successfully_saved'));
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
			}
			redirect("recruitment/Candidate_select/create_interview");
		   } else {
			$data['title'] = display('create');
			$data['module'] = "recruitment";
			$data['page']   = "job_posting_form"; 
			$data['dropdowninterview'] = $this->Selection_model->dropdowninterview(); 
			$data['job_posting'] = $this->Job_model->viewJobPosting();
			$data['cities'] = $this->Job_model->cities();
			//$data['dropdown'] = $this->Selection_model->dropdownPosition();
			echo Modules::run('template/layout', $data);   
			
		}   
	}


  public function job_posting_interview($id = null){ 
     $this->permission->module('recruitment','delete')->redirect();
		if ($this->Selection_model->delete_interview($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect("recruitment/Candidate_select/candidate_interview_view");
	}

	public function job_posting_update_form($id = null){
		$this->form_validation->set_rules('can_int_id',null,'required|max_length[11]');
 		$this->form_validation->set_rules('can_id',display('can_id'),'required|max_length[50]');
		$this->form_validation->set_rules('job_adv_id',display('job_adv_id')  ,'required|max_length[100]');
		$this->form_validation->set_rules('interview_date',display('interview_date')  ,'required|max_length[100]');
		$this->form_validation->set_rules('interviewer_id',display('interviewer_id'),'required|max_length[50]');
		$this->form_validation->set_rules('interview_marks',display('interview_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('written_total_marks',display('written_total_marks')  ,'required|max_length[100]');
		$this->form_validation->set_rules('mcq_total_marks',display('mcq_total_marks'),'required|max_length[50]');
		$this->form_validation->set_rules('recommandation',display('recommandation')  ,'required|max_length[100]');
		$this->form_validation->set_rules('selection',display('selection')  ,'required|max_length[30]');
		$this->form_validation->set_rules('details',display('details')  ,'required|max_length[100]');
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
			    'can_int_id' 	     => $this->input->post('can_int_id',true),
				'can_id' 	         => $this->input->post('can_id',true),
				'job_adv_id' 	     => $this->input->post('job_adv_id',true),
				'interview_date' 	 => $this->input->post('interview_date',true),
				'interviewer_id' 	 => $this->input->post('interviewer_id',true),
				'interview_marks' 	 => $this->input->post('interview_marks',true),
				'written_total_marks'=> $this->input->post('written_total_marks',true),
				'mcq_total_marks' 	 => $this->input->post('mcq_total_marks',true),
				'recommandation' 	 => $this->input->post('recommandation',true),
				'selection' 	     => $this->input->post('selection',true),
				'details' 	         => $this->input->post('details',true),
			]; 
			
			if ($this->Selection_model->update_interview($postData)) { 
				$this->session->set_flashdata('message', display('successfully_updated'));
				redirect("recruitment/Candidate_select/create_interview");
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
				redirect("recruitment/Candidate_select/interview_update_form/". $id);
			}	

	     	} else {
			$data['title']  = display('update');
		    $data['data']   =$this->Selection_model->interview_updateForm($id);
			$data['module'] = "recruitment";
			$data['dropdowninterview'] = $this->Selection_model->dropdowninterview(); 
			$data['page']   = "update_interview_form";   
			echo Modules::run('template/layout', $data); 
		}
 
	}
/* ##################### selection part ###########################*/
/* ##################### selection part ###########################*/



public function candidate_selection_view()
	{   
        $this->permission->module('recruitment','read')->redirect();

		$data['title']    = display('selection');  ;
		$data['selection'] = $this->Selection_model->viewSelection();
		$data['dropdownselection'] = $this->Selection_model->dropdownselection(); 
		$data['module'] = "recruitment";
		$data['page']   = "selection_view";   
		echo Modules::run('template/layout', $data); 
	} 


public function select_to_load($id){

	$data = $this->db->select('*')->from('candidate_interview')->where('can_id',$id)->get()->row();

	echo json_encode($data);
}

public function select_to_load_background_data($id){

	$data = $this->db->select('*')->from('candidate_background_check')->where('can_id',$id)->get()->row();

	echo json_encode($data);
}
public function sendingEmail($sendToEmail = null, $name = null, $subject = null, $templatePath = null, $data = array()){
	    if($sendToEmail != null && $subject != null && $templatePath != null && !empty($data)){
	        $mail = $this->phpmailer_library->load();
    		$mail->SMTPDebug =0;                                 // Enable verbose debug output
    		$mail->SMTPOptions = array(
    			'ssl' => array(
    				'verify_peer' => false,
    				'verify_peer_name' => false,
    				'allow_self_signed' => true
    			)
    		);
    		$mail->Host = $this->config->item('smtp_host');  // Specify main and backup SMTP servers
    		$mail->isSMTP();
    		$mail->Port = $this->config->item('smtp_port');
    		$mail->SMTPAuth = true;
    		$mail->SMTPSecure = $this->config->item('smtp_crypto'); // Enable SMTP authentication
    		$mail->Username = $this->config->item('smtp_user'); // SMTP username
            $mail->Password = $this->config->item('smtp_pass');  // TCP port to connect to
    		$mail->setFrom($this->config->item('admin_info'), $this->config->item('mail_subject'));
    		$mail->addAddress($sendToEmail, $name);
    		$mail->isHTML(true);  // Set email format to HTML
    		$mail->Subject = $subject;
    		$mail->Body = $this->load->view($templatePath, $data, TRUE);   
    		if($mail->send()){
    		    return true;
    		}
        }
	}

public function create_selection()
	{ 
		$data['title'] = display('selectionlist');
		#-------------------------------#
		$this->form_validation->set_rules('can_id',display('can_id'),'required|is_unique[candidate_selection.can_id]|max_length[50]');
		$this->form_validation->set_rules('pos_id',display('pos_id'),'required|max_length[50]');
		$this->form_validation->set_rules('selection_terms',display('selection_terms')  ,'required|max_length[100]');
		$id=$this->input->post('can_id');
		$employee = $this->db->select('*')->from('candidate_basic_info')->where('can_id',$id)->get()->row();
	   //  $zk = new ZKLibrary('192.168.1.201', 4370);
	   //     // echo 'welcome';exit();
	   //         $zk->connect();
	   //         $zk->disableDevice();
    //             $user = $zk->getUser();
    //             $max = max($user);
    //             $max_id = $max[0];
	   //         $zk->enableDevice();
    //             $zk->disconnect();
		
		if(!empty($max_id)){
		$employee_id = $max_id+1;	
		}else{
			$employee_id=1;
		}

		#-------------------------------#
		if ($this->form_validation->run() === true) {
		    
		    if(isset($_POST['sent_job_letter']) && $_POST['sent_job_letter'] !=''){
		        $data = array();
    		    $chapterList = $this->load->view('email/job_offer_pdf.php', $data, TRUE);
    
    
                $filename = "Job_Offer_".$employee->first_name.'_'.$employee->last_name."_".date("Y_m_d_h_i_s").".pdf";
                
                $pdfFilePath = "./assets/$filename";
                ini_set('memory_limit','128M');
                $this->pdf->loadHtml($chapterList);
                $this->pdf->render();
                $output = $this->pdf->output();
                file_put_contents($pdfFilePath, $output);
                $mail = $this->phpmailer_library->load();
                //Server settings
                $mail->SMTPDebug =0;                                 // Enable verbose debug output
                $mail->SMTPOptions = array(
                    'ssl' => array(
                        'verify_peer' => false,
                        'verify_peer_name' => false,
                        'allow_self_signed' => true
                    )
                );
                $mail->isSMTP();    
                                                  // Set mailer to use SMTP
                $mail->Host = 'smtp.gmail.com';  // Specify main and backup SMTP servers
                $mail->isSMTP();
                $mail->Port = 587;
                $mail->SMTPAuth = true;
                $mail->SMTPSecure = 'tls';                            // Enable SMTP authentication
                $mail->Username = "protegeglobal93@gmail.com";                 // SMTP username
                $mail->Password = "global93protege321";                                  // TCP port to connect to
                //Recipients
                $mail->setFrom('info@appedology.com', 'Appedology');
                $mail->addAddress($employee->email,$employee->first_name.' '.$employee->last_name);
                $mail->isHTML(true);                                  // Set email format to HTML
                $mail->Subject = 'Job Offer Letter';
                $mail->Body = "Dear ".$employee->first_name.' '.$employee->last_name.", <br>Please find attachment<br> Thanks";   
                $mail->AddAttachment($pdfFilePath); 
                $sendStatus =$mail->send();
                if(file_exists($pdfFilePath))
                {
                    unlink($pdfFilePath);
                }
		    }
		    
			$postData = [
				'can_id' 	     => $this->input->post('can_id',true),
				'employee_id' 	 => $employee_id,
				'pos_id' 	     => $this->input->post('pos_id',true),
				'selection_terms'=> $this->input->post('selection_terms',true),
			];   

				$coa = $this->Selection_model->headcode();
			if($coa->HeadCode!=NULL){
				$headcode=$coa->HeadCode+1;
			}else{
				$headcode="502020000001";
			}

			$c_code = $employee_id;
			$c_name = $employee->first_name.$employee->last_name;
			$c_acc=$c_code.'-'.$c_name;
			$createby = $this->session->userdata('fullname');
			$createdate = date('Y-m-d H:i:s');
			$data['aco']  = (Object) $coaData = [
				'HeadCode'         => $headcode,
				'HeadName'         => $c_acc,
				'PHeadName'        => 'Account Payable',
				'HeadLevel'        => '2',
				'IsActive'         => '1',
				'IsTransaction'    => '1',
				'IsGL'             => '0',
				'HeadType'         => 'L',
				'IsBudget'         => '0',
				'IsDepreciation'   => '0',
				'DepreciationRate' => '0',
				'CreateBy'         => $createby,
				'CreateDate'       => $createdate,
			];
			$Data1 = [
				'employee_id'                => $employee_id,
				'pos_id' 	                 => $this->input->post('pos_id',true),
				'first_name' 	             => $employee->first_name,
				'last_name' 	             => $employee->last_name,
				'email'                      => $employee->email,
				'phone'                      => $employee->phone,
				'alter_phone' 	             => $employee->alter_phone,
				'present_address' 	         => $employee->present_address,
				'parmanent_address' 	     => $employee->parmanent_address,
				'picture'                    => $employee->picture,
				'state'                      => $employee->state,
			    'city'                       => $employee->city,
			     'zip'                       => $employee->zip
			];  
           if($this->Selection_model->selection_create($postData)){
			    $this->Selection_model->insert_employee($Data1);
			    $this->Selection_model->create_coa($coaData);
				$this->session->set_flashdata('message', display('successfully_saved'));
			
			redirect("recruitment/Candidate_select/create_selection");
		}else{
		   $this->session->set_flashdata('exception', display('please_try_again'));
			redirect("recruitment/Candidate_select/create_selection");	
		}
		} else {
			$data['title'] = display('create');
			$data['module'] = "recruitment";
			$data['page']   = "selection_form"; 
			$data['dropdownselection'] = $this->Selection_model->dropdownselection(); 
			$data['selected'] = $this->Selection_model->selected(); 
			$data['selection'] = $this->Selection_model->viewSelection();
			echo Modules::run('template/layout', $data);   
			
		}   
	}
	public function delete_selection($id = null) 
	{ 
        $this->permission->module('recruitment','delete')->redirect();

		if ($this->Selection_model->selection_delete($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect("recruitment/Candidate_select/candidate_selection_view");
	}

       public function update_selection_form($id = null){
 		$this->form_validation->set_rules('can_id',display('can_id'),'required|max_length[50]');
		$this->form_validation->set_rules('pos_id',display('pos_id')  ,'required|max_length[100]');
		$this->form_validation->set_rules('selection_terms',display('selection_terms'),'max_length[100]');
		$employee = $this->db->select('*')->from('candidate_basic_info')->where('can_id',$id)->get()->row();
		$employee_id = $this->input->post('employee_id',true);
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
			    'can_sel_id' 	             => $this->input->post('can_sel_id',true),
				'can_id' 	                 => $this->input->post('can_id',true),
				'employee_id' 	             => $employee_id,
				'pos_id' 		             => $this->input->post('pos_id',true),
				'selection_terms' 		     => $this->input->post('selection_terms',true),
			]; 

			$Data1 = [
				'employee_id'                => $employee_id,
				'pos_id' 	                 => $this->input->post('pos_id',true),
				'first_name' 	             => $employee->first_name,
				'last_name' 	             => $employee->last_name,
				'email'                      => $employee->email,
				'phone'                      => $employee->phone,
				'alter_phone' 	             => $employee->alter_phone,
				'present_address' 	         => $employee->present_address,
				'parmanent_address' 	     => $employee->parmanent_address,
				'picture'                    => $employee->picture,
				'state'                      => $employee->state,
			    'city'                       => $employee->city,
			     'zip'                       => $employee->zip
			];  
			// print_r($Data1);
			// exit; 
			
			
			if ($this->Selection_model->update_selection($postData)) { 
				$this->db->where('employee_id', $employee_id)
			  ->update("employee_history", $Data1);
				$this->session->set_flashdata('message', display('successfully_updated'));
				redirect("recruitment/Candidate_select/candidate_selection_view");
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
				redirect("recruitment/Candidate_select/update_selection_form/". $id);
			}
			

		} else {
			$data['title']  = display('update');
		    $data['data']   = $this->Selection_model->selection_updateForm($id);
		    $data['dropdownselection'] = $this->Selection_model->dropdownselection(); 
			$data['module'] = "recruitment";
			$data['page']   = "update_selection_form";   
			echo Modules::run('template/layout', $data); 
		}
 
	}
	
	public function candidate_background_check(){
	    
	    $this->form_validation->set_rules('can_id',display('can_id'),'required|max_length[50]');
	    

		#-------------------------------#
		if ($this->form_validation->run() === true) {
		    
            $employee = $this->db->select('*')->from('candidate_background_check')->where('can_id',$this->input->post('can_id'))->get()->row();
            
           
    		$postData = [
    			'can_id'          => $this->input->post('can_id'),
    			'last_employer' 	  => $this->input->post('last_employer'),
    			'phone' =>       $this->input->post('phone'),
    			'behavior' 	  => $this->input->post('behavior'),
    			'punctuality' 	  => $this->input->post('punctuality'),
    			'performance' 	  => $this->input->post('performance'),
    			'remarks' 	  => $this->input->post('remarks'),
    			'background_status' 	  => $this->input->post('background_status'),
    			'verified_by' 	  => $this->session->userdata('id')
    			
    		]; 
			
			
			if ($employee) { 
			    
				$this->db->where('can_id', $employee->can_id)
			     ->update("candidate_background_check", $postData);
				
			} else {
			    $this->db->insert("candidate_background_check", $postData);
			}
			
            $this->session->set_flashdata('message', display('successfully_updated'));
			redirect("recruitment/Candidate_select/create_selection");
		} else {
			$data['title'] = display('create');
			$data['module'] = "recruitment";
			$data['page']   = "selection_form"; 
			$data['dropdownselection'] = $this->Selection_model->dropdownselection(); 
			$data['selected'] = $this->Selection_model->selected(); 
			$data['selection'] = $this->Selection_model->viewSelection();
			echo Modules::run('template/layout', $data);   
		}
	}


	   public function randID()
    {
        $result = ""; 
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";

        $charArray = str_split($chars);
        for($i = 0; $i < 7; $i++) {
                $randItem = array_rand($charArray);
                $result .="".$charArray[$randItem];
        }
        return "E".$result;
    }


}
