<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Candidate extends MX_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->db->query('SET SESSION sql_mode = ""');
		$this->load->model(array(
			'Candidate_model'
		));	
		     $this->load->library('excel');   
        $this->load->library('zklibrary'); 
		if (! $this->session->userdata('isLogIn'))
			redirect('login?rback=' . uri_string());	 
	}
 
	public function candidateinfo_view()
	{   
        $this->permission->module('recruitment','read')->redirect();

		$data['title']    = display('candidate_list');  ;
		$data['caninfo'] = $this->Candidate_model->viewcanInfo();
		$data['module'] = "recruitment";
		$data['page']   = "canInfoview";   
		echo Modules::run('template/layout', $data); 
	} 
	
	public function bulk_candidate_form()
	{ 
	   //echo "<pre>";
	   // print_r($_POST);die;
		$data['title'] = display('interview_list');
		#-------------------------------#
		$this->form_validation->set_rules(
                'job_title', display('job_title'),
                'required',
                array(
                        'required'      => 'Please select a '.display('job_title').' from suggestions'
                )
        );
        $this->form_validation->set_rules(
                'job_description', display('job_description'),
                'required',
                array(
                        'required'      => display('job_description').' is required'
                )
        );
        $this->form_validation->set_rules(
                'job_skill', display('job_skill'),
                'required',
                array(
                        'required'      => display('job_skill').' is required'
                )
        );
        $this->form_validation->set_rules(
                'career_level', display('career_level'),
                'required',
                array(
                        'required'      => display('career_level').' is required'
                )
        );
        $this->form_validation->set_rules(
                'no_of_position', display('no_of_position'),
                'required',
                array(
                        'required'      => display('no_of_position').' is required'
                )
        );
        $this->form_validation->set_rules(
                'job_location[]', display('job_location'),
                'required',
                array(
                        'required'      => display('job_location').' is required'
                )
        );
        $this->form_validation->set_rules(
                'qualification', display('qualification'),
                'required',
                array(
                        'required'      => display('qualification').' is required'
                )
        );
        $this->form_validation->set_rules(
                'higher_exactly', display('higher_exactly'),
                'required',
                array(
                        'required'      => display('higher_exactly').' is required'
                )
        );
        $this->form_validation->set_rules(
                'min_experience', display('min_experience'),
                'required',
                array(
                        'required'      => display('min_experience').' is required'
                )
        );
        $this->form_validation->set_rules(
                'max_experience', display('max_experience'),
                'required',
                array(
                        'required'      => display('max_experience').' is required'
                )
        );
        $this->form_validation->set_rules(
                'from_salary', display('from_salary'),
                'required',
                array(
                        'required'      => display('from_salary').' is required'
                )
        );
        $this->form_validation->set_rules(
                'to_salary', display('to_salary'),
                'required',
                array(
                        'required'      => display('to_salary').' is required'
                )
        );
        $this->form_validation->set_rules(
                'gender_preference', display('gender_preference'),
                'required',
                array(
                        'required'      => display('gender_preference').' is required'
                )
        );
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
				'pos_id' 	         => $this->input->post('job_title',true),
				'jp_title_description' 	     => $this->input->post('job_description',true),
				'jp_career_level' 	 => $this->input->post('career_level',true),
				'jp_career_position' 	 => $this->input->post('no_of_position',true),
				'jp_qualification_level' 	 => $this->input->post('qualification',true),
				'jp_qualification_must'=> $this->input->post('higher_exactly',true),
				'jp_experience_min' 	 => $this->input->post('min_experience',true),
				'jp_experience_max' 	     => $this->input->post('max_experience',true),
				'jp_salary_min' 	 => $this->input->post('from_salary',true),
				'jp_salary_max' 	     => $this->input->post('to_salary',true),
				'jp_preference' 	         => $this->input->post('gender_preference',true),
			];   

			if ($this->Job_model->create_job($postData,$_POST)) { 
				$this->session->set_flashdata('message', display('successfully_saved'));
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
			}
			redirect("recruitment/Job_posting/job_posting_form");
		   } else {
			$data['title'] = display('create');
			$data['module'] = "recruitment";
			$data['page']   = "bulk_candidates_add_form"; 
			//$data['dropdown'] = $this->Selection_model->dropdownPosition();
			echo Modules::run('template/layout', $data);   
			
		}   
	}
	
	 function bulkcandidateuploadcsv() {
	     
	     if(isset($_FILES["excel_file"]["name"]) && $_FILES["excel_file"]["name"] !="" && isset($_FILES["resume_uploads"]["name"]) &&  count($_FILES['resume_uploads']['name']) > 0 ){
	            
	            $path = $_FILES["excel_file"]["tmp_name"];
                $object = PHPExcel_IOFactory::load($path);
                $wrong_candidates_data = [];
                $candidates_data = [];
                foreach($object->getWorksheetIterator() as $sale)
                        {
                            $highestRow = $sale->getHighestRow();
                            $highestColumn = $sale->getHighestColumn();
                            for($row=2; $row<=$highestRow; $row++)
                            {
            
                            $job_id = $sale->getCellByColumnAndRow(0, $row)->getValue();    
                            $first_name = $sale->getCellByColumnAndRow(1, $row)->getValue();    
                            $last_name = $sale->getCellByColumnAndRow(2, $row)->getValue();    
                            $email = $sale->getCellByColumnAndRow(3, $row)->getValue(); 
                            $phone = $sale->getCellByColumnAndRow(4, $row)->getValue();
                            $alter_phone = $sale->getCellByColumnAndRow(5, $row)->getValue();
                            $address = $sale->getCellByColumnAndRow(6, $row)->getValue();    
                            $resume = trim($sale->getCellByColumnAndRow(7, $row)->getValue());    
                            $last_employer = $sale->getCellByColumnAndRow(8, $row)->getValue();    
                            $total_years_of_experience = $sale->getCellByColumnAndRow(9, $row)->getValue();  
                            
                            $job_exist = $this->db->get_where('job_posting',array('jp_id'=>$job_id))->result();
                            
                            $this->db->select('can_id');
                            $this->db->from('candidate_basic_info');
                            $this->db->where('email',$email);
                            $this->db->where('jp_id',$job_id);
                            $this->db->or_where('phone',$phone);
                            $this->db->where('jp_id',$job_id);
                            $this->db->or_where('alter_phone',$alter_phone);
                            $this->db->where('jp_id',$job_id);
                            $candidate_found = $this->db->get()->result();
                            
                            $can_id = $this->generate->id();
                            $data_insertion= array(
                                'can_id'                            =>$can_id,
                                'jp_id'                             => $job_id,
                                'first_name'                        => $first_name,
                                'last_name'                         => $last_name,
                                'email'                             => $email,
                                'phone'                             => $phone,
                                'alter_phone'                       => $alter_phone,
                                'address'                           => $address,
                                'resume'                            => './application/modules/recruitment/assets/candidates_resume/' . date('Y-m-d') . "/" .$resume,
                                'last_employer'                     => $last_employer,
                                'total_years_of_experience'         => $total_years_of_experience
                            
                            );
                            
                            $file_path =  './application/modules/recruitment/assets/candidates_resume/' . date('Y-m-d') . "/" .$resume;
                            
                            if($job_exist && !$candidate_found && !file_exists($file_path)){
                                
                                 $found_candidate_resume = false;
                                 
                                 for($i=0;$i<count($_FILES['resume_uploads']['name']);$i++){
                                     
                                   $filename = trim($_FILES['resume_uploads']['name'][$i]);
                                   if($filename == $resume){
                                      move_uploaded_file($_FILES['resume_uploads']['tmp_name'][$i],$file_path);
                                      $found_candidate_resume = true; 
                                   }
                                 }
                                 
                                 if($found_candidate_resume){
                                     
                                   
                                   $candidates_data[] = $data_insertion;
                                   
                                   $found_candidate_resume = false;
                                   
                                 }else{
                                     $wrong_candidates_data[] = $data_insertion;
                                 }
                                
                            }else{
                                
                                $wrong_candidates_data[] = $data_insertion;
                            }
               
                    }
                    }
                    if(!$wrong_candidates_data){
                        
                         $this->session->unset_userdata('wrong_list_candidates');
                         
                         if($candidates_data){
                             $this->db->insert_batch('candidate_basic_info', $candidates_data); 
                         }
                         
                         
                         
                         $this->session->set_flashdata('message', display('successfully_uploaded'));
                         redirect('recruitment/Candidate/bulk_candidate_form'); 
                    }else{
                        
                         
                         $this->session->unset_userdata('wrong_list_candidates');
                         
                         if($wrong_candidates_data){
                             $this->session->set_userdata('wrong_list_candidates',$wrong_candidates_data);
                         }
                         
                         
                         if($candidates_data){
                             $this->db->insert_batch('candidate_basic_info', $candidates_data); 
                         }
                         
                         $this->session->set_flashdata('exception',  display('below_list_candidate_data_not_uploaded_due_to_error'));
		            	 redirect('recruitment/Candidate/bulk_candidate_form'); 
                    }
                      
	     }else {
	         
		     $this->session->set_flashdata('exception',  display('select_excel_and_candidate_resume'));
			 redirect('recruitment/Candidate/bulk_candidate_form'); 
		}
          
    } 

 
	
 	public function caninfo_create_linked_job($job_id)
	{ 
	    
		$job_data = $this->Candidate_model->jobs_reads($job_id);
		    
	    
	    if($job_data){
	        
	        $data['title'] = display('create_details');
			$data['module'] = "recruitment";
			$data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
			$data['jobs_reads'] = $job_data;
			
			$data['page']   = "canInfo_form";
		
			echo Modules::run('template/layout', $data); 
	    }else{
	        
	        $this->session->set_flashdata('exception', display('job_data_not_found'));
	    	redirect("recruitment/Job_posting/manage_job_posting");
	    }
		   
	}
	
		public function edit_caninfo($can_id)
	{ 
	    
		$caninfo_data = $this->Candidate_model->specific_caninfo($can_id);
		    
	    
	    if($caninfo_data){
	        
	        $data['title'] = display('edit_candidate_details');
			$data['module'] = "recruitment";
			$data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
			$data['caninfo_data'] = $caninfo_data;
			
			$data['page']   = "caninfo_edit_form";
		
			echo Modules::run('template/layout', $data); 
	    }else{
	        
	        $this->session->set_flashdata('exception', display('candidate_data_not_found'));
	    	redirect("recruitment/Candidate/candidateinfo_view");
	    }
		   
	}
	
	public function can_info_create(){
	    
	    $data['title'] = display('write_y_p_info');
		#-------------------------------#
		
		 $this->form_validation->set_rules(
                'job_id', display('job_id'),
                'required',
                array(
                        'required'      => display('job_id').' is required'
                )
        );
        
		$this->form_validation->set_rules(
                'first_name', display('first_name'),
                'required',
                array(
                        'required'      => display('first_name').' is required'
                )
        );
        $this->form_validation->set_rules(
                'last_name', display('last_name'),
                'required',
                array(
                        'required'      => display('last_name').' is required'
                )
        );
        $this->form_validation->set_rules(
                'email', display('email'),
                'required',
                array(
                        'required'      => display('email').' is required'
                )
        );
        $this->form_validation->set_rules(
                'phone', display('phone'),
                'required',
                array(
                        'required'      => display('phone').' is required'
                )
        );
        $this->form_validation->set_rules(
                'alter_phone', display('alter_phone'),
                'required',
                array(
                        'required'      => display('alter_phone').' is required'
                )
        );
        $this->form_validation->set_rules(
                'address', display('address'),
                'required',
                array(
                        'required'      => display('address').' is required'
                )
        );
        $this->form_validation->set_rules(
                'last_employer', display('last_employer'),
                'required',
                array(
                        'required'      => display('last_employer').' is required'
                )
        );
        $this->form_validation->set_rules(
                'total_years_of_experience', display('total_years_of_experience'),
                'required',
                array(
                        'required'      => display('total_years_of_experience').' is required'
                )
        );
        
		#-------------------------------#
		if ($this->form_validation->run() === true) {
			
			if (isset($_FILES) && $_FILES['resume_uploads']['name'] !="" ) {
			    $this->load->library('myupload');
			    
            	$id = $this->generate->id();
            	$file = $this->myupload->do_upload(
            	    	'./application/modules/recruitment/assets/candidates_resume/','resume_uploads'
            
            	    );
    			$postData1= [
    			'can_id' 	              => $id,
    			'first_name' 	          => $this->input->post('first_name',true),
    			'last_name' 	          => $this->input->post('last_name',true),
    			'email' 	              => $this->input->post('email',true),
    			'phone' 	              => $this->input->post('phone',true),
    			'alter_phone' 	          => $this->input->post('alter_phone',true),
    			'address' 	              => $this->input->post('address',true),
    			'last_employer' 	      => $this->input->post('last_employer',true),
    			'resume' 	              => $file,
    			'total_years_of_experience' => $this->input->post('total_years_of_experience',true),
    			'jp_id'                     => $this->input->post('job_id',true)
    			];   
    			

    			$job_exist = $this->db->get_where('job_posting',array('jp_id'=>$this->input->post('job_id',true)))->result();
                            
                $this->db->select('can_id');
                $this->db->from('candidate_basic_info');
                $this->db->where('email',$this->input->post('email',true));
                $this->db->where('jp_id',$this->input->post('job_id',true));
                $this->db->or_where('phone',$this->input->post('phone',true));
                $this->db->where('jp_id',$this->input->post('job_id',true));
                $this->db->or_where('alter_phone', $this->input->post('alter_phone',true));
                $this->db->where('jp_id',$this->input->post('job_id',true));
                $candidate_found = $this->db->get()->result();
                
    			if($job_exist && !$candidate_found){
    			    
    			$this->db->insert('candidate_basic_info', $postData1);
    			
    			$this->session->set_flashdata('message', display('successfully_saved'));
    			
    			redirect("recruitment/Candidate/candidateinfo_view");  
    			
    			}else{
    			    
    			    $this->session->set_flashdata('exception', display('candidate_data_not_uploaded_due_to_error'));
    			    
                    $data['title'] = display('create_details');
        			$data['module'] = "recruitment";
        			$data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
        			$data['jobs_reads'] = $this->Candidate_model->jobs_reads($_POST['job_id']);
        			
        			$data['page']   = "canInfo_form";
        		
        			echo Modules::run('template/layout', $data); 
    			}
    			
            }else{
                
                $this->session->set_flashdata('exception', display('file_not_found'));
                
                $data['title'] = display('create_details');
    			$data['module'] = "recruitment";
    			$data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
    			$data['jobs_reads'] = $this->Candidate_model->jobs_reads($_POST['job_id']);
    			
    			$data['page']   = "canInfo_form";
    		
    			echo Modules::run('template/layout', $data); 
            }
			



		}else{
		    
		    $data['title'] = display('create_details');
			$data['module'] = "recruitment";
			$data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
			$data['jobs_reads'] = $this->Candidate_model->jobs_reads($_POST['job_id']);
			
			$data['page']   = "canInfo_form";
		
			echo Modules::run('template/layout', $data); 
		}
	}
	
	public function can_info_update(){
	    
	    $data['title'] = display('write_y_p_info');
		#-------------------------------#
		
		$this->form_validation->set_rules(
                'can_id', display('can_id'),
                'required',
                array(
                        'required'      => display('can_id').' is required'
                )
        );
        
        $this->form_validation->set_rules(
                'job_id', display('job_id'),
                'required',
                array(
                        'required'      => display('job_id').' is required'
                )
        );
        
		$this->form_validation->set_rules(
                'first_name', display('first_name'),
                'required',
                array(
                        'required'      => display('first_name').' is required'
                )
        );
        $this->form_validation->set_rules(
                'last_name', display('last_name'),
                'required',
                array(
                        'required'      => display('last_name').' is required'
                )
        );
        $this->form_validation->set_rules(
                'email', display('email'),
                'required',
                array(
                        'required'      => display('email').' is required'
                )
        );
        $this->form_validation->set_rules(
                'phone', display('phone'),
                'required',
                array(
                        'required'      => display('phone').' is required'
                )
        );
        $this->form_validation->set_rules(
                'alter_phone', display('alter_phone'),
                'required',
                array(
                        'required'      => display('alter_phone').' is required'
                )
        );
        $this->form_validation->set_rules(
                'address', display('address'),
                'required',
                array(
                        'required'      => display('address').' is required'
                )
        );
        $this->form_validation->set_rules(
                'last_employer', display('last_employer'),
                'required',
                array(
                        'required'      => display('last_employer').' is required'
                )
        );
        $this->form_validation->set_rules(
                'total_years_of_experience', display('total_years_of_experience'),
                'required',
                array(
                        'required'      => display('total_years_of_experience').' is required'
                )
        );
        
		#-------------------------------#
		if ($this->form_validation->run() === true) {
			
			if (isset($_FILES) && $_FILES['resume_uploads']['name'] !="" ) {
			    $this->load->library('myupload');
			    
            	$file = $this->myupload->do_upload(
            	    	'./application/modules/recruitment/assets/candidates_resume/','resume_uploads'
            
            	    );
    			$postData1= [
        			'first_name' 	          => $this->input->post('first_name',true),
        			'last_name' 	          => $this->input->post('last_name',true),
        			'email' 	              => $this->input->post('email',true),
        			'phone' 	              => $this->input->post('phone',true),
        			'alter_phone' 	          => $this->input->post('alter_phone',true),
        			'address' 	              => $this->input->post('address',true),
        			'last_employer' 	      => $this->input->post('last_employer',true),
        			'resume' 	              => $file,
        			'total_years_of_experience' => $this->input->post('total_years_of_experience',true)
    			];   
    			
    			$this->db->where('can_id',$_POST['can_id']);
    			$this->db->update('candidate_basic_info', $postData1);
    		
    
    			
    			$this->session->set_flashdata('message', display('successfully_updated'));
    			
    			redirect("recruitment/Candidate/candidateinfo_view");  
    			
            }else{
                
                $postData1= [
        			'first_name' 	          => $this->input->post('first_name',true),
        			'last_name' 	          => $this->input->post('last_name',true),
        			'email' 	              => $this->input->post('email',true),
        			'phone' 	              => $this->input->post('phone',true),
        			'alter_phone' 	          => $this->input->post('alter_phone',true),
        			'address' 	              => $this->input->post('address',true),
        			'last_employer' 	      => $this->input->post('last_employer',true),
        			'total_years_of_experience' => $this->input->post('total_years_of_experience',true)
    			];   
    			
    			$this->db->where('can_id',$_POST['can_id']);
    			$this->db->update('candidate_basic_info', $postData1);
    		
    
    			
    			$this->session->set_flashdata('message', display('successfully_updated'));
    			
    			redirect("recruitment/Candidate/candidateinfo_view");  
            }
			



		}else{
		    
		    $data['title'] = display('edit_candidate_details');
			$data['module'] = "recruitment";
			$data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
			$data['caninfo_data'] = $this->Candidate_model->specific_caninfo($_POST['can_id']);
			
			$data['page']   = "caninfo_edit_form";
		
			echo Modules::run('template/layout', $data); 
		}
	}
/*  ########################    details save  #######################################  */

	/* ############# For viewing details  #################### */
	public function candatails_view()
	{   
        $this->permission->module('recruitment','read')->redirect();

		$data['title']    = display('view details');  ;
        $data['all_data'] = $this->Candidate_model->retrieve_all_data();
		$data['module']   = "recruitment";
		$data['page']     = "can_details";   
		echo Modules::run('template/layout', $data); 
	} 

public function cv()
	{   
        $this->permission->module('recruitment','read')->redirect();
   
		$data['title']    = display('view details');  
		 $id = $this->uri->segment(4);
        $data['cv'] = $this->Candidate_model->employee_details($id);
        $data['edu'] = $this->Candidate_model->eduInfo($id);
        $data['wrk'] = $this->Candidate_model->workingexp($id);
		$data['module']   = "recruitment";
		$data['page']     = "cv";   
		echo Modules::run('template/layout', $data); 
	} 

	/* ############# For viewing details  #################### */


	public function delete_canInfo($id = null) 
	{ 
        $this->permission->module('recruitment','delete')->redirect();

		if ($this->Candidate_model->delete_cinfo($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect('recruitment/Candidate/candidateinfo_view');
	}
	 
   public function update_canifo_form($id = null){
		
		$data['title'] = display('write_y_p_info');
		#-------------------------------#
		$this->form_validation->set_rules('can_id',null,'required|max_length[20]');
		$this->form_validation->set_rules('first_name',display('first_name'),'required|max_length[50]');
		$this->form_validation->set_rules('last_name',display('last_name')  ,'max_length[100]');
		$this->form_validation->set_rules('email',display('email')  ,'required|max_length[32]');
		$this->form_validation->set_rules('phone',display('phone')  ,'required|max_length[100]');
		$this->form_validation->set_rules('alter_phone',display('alter_phone')  ,'max_length[100]');
		$this->form_validation->set_rules('present_address',display('present_address')  ,'max_length[100]');
		$this->form_validation->set_rules('parmanent_address',display('parmanent_address')  ,'max_length[100]');
		$this->load->library('myupload');
		$img = $this->myupload->do_upload(
	    	'./application/modules/recruitment/assets/images/','picture'

	    );
	
		$this->form_validation->set_rules('degree_name[]',display('degree_name'));
		$this->form_validation->set_rules('university_name[]',display('university_name'));
		$this->form_validation->set_rules('cgp[]',display('cgp'));
		$this->form_validation->set_rules('comments',display('comments'));	
	    $unis = $this->input->post('university_name');
	    $degs = $this->input->post('degree_name');
	    $cgps = $this->input->post('cgp');
		$this->form_validation->set_rules('company_name[]',display('company_name'));
		$this->form_validation->set_rules('working_period[]',display('working_period') );
		$this->form_validation->set_rules('duties[]',display('duties'));
		$this->form_validation->set_rules('supervisor[]',display('supervisor'));
        $comname = $this->input->post('company_name');
	    $wperiod = $this->input->post('working_period');
	    $duties = $this->input->post('duties');
	    $supe = $this->input->post('supervisor');
		
		#-------------------------------#
		if ($this->form_validation->run() === true) {
			
			$postData1= [
			'can_id' 	               =>$this->input->post('can_id',true),
			'first_name' 	          => $this->input->post('first_name',true),
			'last_name' 	          => $this->input->post('last_name',true),
			'email' 	              => $this->input->post('email',true),
			'phone' 	              => $this->input->post('phone',true),
			'alter_phone' 	          => $this->input->post('alter_phone',true),
			'present_address' 	      => $this->input->post('present_address',true),
			'parmanent_address' 	  => $this->input->post('parmanent_address',true),
			'picture' 	              =>(!empty($img) ? $img : $this->input->post('picture')),
			'ssn'                     => $this->input->post('ssn',true),
			'state'                   => $this->input->post('state',true),
			'city'                    => $this->input->post('city',true),
			'zip'                     => $this->input->post('zip_code',true),
			];                 
			$this->Candidate_model->update_canInfo($postData1);
		
$this->db->where('can_id',$this->input->post('can_id'))
 			->delete('candidate_education_info');
			for ($i=0; $i < sizeof($unis); $i++) {
				$postData2= [
					'can_id' 	              => $this->input->post('can_id'),
					'university_name'         => $unis[$i],
					'degree_name' 	          => $degs[$i],
					'cgp' 	                  => $cgps[$i], 
					'comments' 	              => $this->input->post('comments',true),
					
				];  
				if(!empty($unis[$i])){
			$this->db->insert('candidate_education_info', $postData2);
				}
		    }
			
			$this->db->where('can_id',$this->input->post('can_id'))
 			->delete('candidate_workexperience');

			for ($i=0; $i < sizeof($comname); $i++) {
			$postData = [
			'can_id' 	                   => $this->input->post('can_id',true),
			'company_name'                 => $comname[$i],
			'working_period' 	           => $wperiod[$i],
			'duties' 	                   => $duties[$i], 
			'supervisor' 	               => $supe[$i], 
			
			];   
			
				if(!empty($comname[$i])){
		 $this->db->insert('candidate_workexperience', $postData);
				}
		    }
			
				$this->session->set_flashdata('message', display('successfully_updated'));
			
		redirect("recruitment/Candidate/candidateinfo_view");



		} else {
$id= $this->uri->segment(4);
$data['title'] = display('create_details');
$data['module'] = "recruitment";
$data['basinfo']=$this->Candidate_model->canifo_updateForm($id);
$data['edinfo']=$this->Candidate_model->canEdu_updateForm($id);
$data['work']=$this->Candidate_model->work($id);
$data['edu'] = $this->Candidate_model->upcanedu($id);
$data['page']   = "update_canIfo";
$data['country_list']  =  array(

"Alabama" => "Alabama",

"Alaska"  => "Alaska",

"Arizona" => "Arizona",

"Arkansas"=> "Arkansas",

"California" => "California",

"Colorado" => "Colorado",

"Connecticut"=> "Connecticut",

"Delaware" => "Delaware",

"Florida"  => "Florida",

"Georgia"  => "Georgia",

"Hawaii"   => "Hawaii",

"Idaho"    => "Idaho",

"Illinois" => "Illinois",
 
"Indiana"  => "Indiana",

"Iowa"     => "Iowa",

"Kansas"   => "Kansas",

"Kentucky" => "Kentucky",

"Louisiana" =>"Louisiana",

"Maine"    => "Maine",

"Maryland" => "Maryland",

"Massachusetts" => "Massachusetts",

"Michigan" => "Michigan",

"Minnesota" => "Minnesota",

"Mississippi" =>"Mississippi",

"Missouri" => "Missouri",

"Montana" => "Montana",

"Nebraska" => "Nebraska",

"Nevada" => "Nevada",

"New Hampshire" => "New Hampshire",

"New Jersey" => "New Jersey",

"New Mexico" => "New Mexico",

"New York" => "New York",

"North Carolina" => "North Carolina",

"North Dakota" =>"North Dakota",

"Ohio" =>  "Ohio",

"Oklahoma" => "Oklahoma",

"Oregon" => "Oregon",

"Pennsylvania" => "Pennsylvania",

"Rhode Rhode" =>"Rhode Island",

"South Carolina" => "South Carolina",

"sDakota" => "sDakota",

"Tennessee" =>"Tennessee",

"Texas" => "Texas",

"Utah" => "Utah",

"Vermont" => "Vermont",

"Virginia" =>"Virginia",

"Washington" => "Washington",

"West Virginia" => "West Virginia",

"Wisconsin" => "Wisconsin",

"Wyoming" => "Wyoming"
		);
echo Modules::run('template/layout', $data); 
			
		}   
	}

/*##################### ---Advertisement part---####################*/  


public function candidate_edu_info_view()
	{   
        $this->permission->module('recruitment','read')->redirect();

		$data['title']    = display('educationinfo_list');  ;
		$data['edu']      = $this->Candidate_model->viewEduinfo();
		$data['module']   = "recruitment";
		$data['page']     = "canInfoview";   
		echo Modules::run('template/layout', $data); 
	} 

	public function create_can_eduinfo()
	{ 
		/***** file upload code start ***********/ 

		$data['title'] = display('educationinfo_list');

		#-------------------------------#
		$this->form_validation->set_rules('can_id',display('can_id'));
		$this->form_validation->set_rules('degree_name[]',display('degree_name'));
		$this->form_validation->set_rules('university_name[]',display('university_name'));
		$this->form_validation->set_rules('cgp[]',display('cgp'));
		$this->form_validation->set_rules('comments',display('comments')  ,'required');	
	    $unis = $this->input->post('university_name');
	    $degs = $this->input->post('degree_name');
	    $cgps = $this->input->post('cgp');
 
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$id = $this->input->post('can_id');

		    for ($i=0; $i < sizeof($unis); $i++) {
				$postData = [
					'can_id' 	              => $this->input->post('can_id'),
					'university_name'         => $unis[$i],
					'degree_name' 	          => $degs[$i],
					'cgp' 	                  => $cgps[$i], 
					'comments' 	              => $this->input->post('comments',true),
					
				];     
				$this->Candidate_model->caneduinfo_create($postData);
		    }

		    $this->session->set_flashdata('message', display('save_successfully'));
			redirect("recruitment/Candidate/caninfo_create/$id/#tabs-3");



		} else {
			$data['title'] = display('create');
			$data['module'] = "recruitment";
			$data['page']   = "can_edu_form"; 
			$data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
			echo Modules::run('template/layout', $data);   
			
		}   
	}

	public function delete_can_edu_Info($id = null) 
	{ 
        $this->permission->module('recruitment','delete')->redirect();

		if ($this->Candidate_model->delete_canedu_info($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect('recruitment/Candidate/candidateinfo_view');
	}


public function update_can_eduifo_form($id = null){
 		$this->form_validation->set_rules('can_id',display('can_id'));
		$this->form_validation->set_rules('degree_name[]',display('degree_name'));
		$this->form_validation->set_rules('university_name[]',display('university_name'));
		$this->form_validation->set_rules('cgp[]',display('cgp'));
		$this->form_validation->set_rules('comments',display('comments')  ,'required');	
	    $unis = $this->input->post('university_name');
	    $degs = $this->input->post('degree_name');
	    $cgps = $this->input->post('cgp');
		
		#-------------------------------#
		if ($this->form_validation->run() === true) {

		$this->db->where('can_id',$this->input->post('can_id'))
 			->delete('candidate_education_info');
			  

		    for ($i=0; $i < sizeof($unis); $i++) {
				$postData = [
					'can_id' 	              => $this->input->post('can_id'),
					'university_name'         => $unis[$i],
					'degree_name' 	          => $degs[$i],
					'cgp' 	                  => $cgps[$i], 
					'comments' 	              => $this->input->post('comments',true),
					
				];     
				
			
	      $this->db->insert('candidate_education_info', $postData);
		    }
		    
				$this->session->set_flashdata('message', display('successfully_updated'));
			
		
			redirect("recruitment/Candidate/candidateinfo_view/". $id);

		} else {
			$data['title'] = display('update');
			$id= $this->uri->segment(4);
		    $data['data']=$this->Candidate_model->canEdu_updateForm($id);
		    $data['edu'] = $this->Candidate_model->upcanedu($id);
		     $data['work']=$this->Candidate_model->work($id);
		     $data['query']= $this->Candidate_model->get_eduinf_dropdown($id);
			$data['module'] = "recruitment";
			
			$data['page']   = "update_canedu_form";   
			echo Modules::run('template/layout', $data); 
		}
 
	}

/***** workexperience start ***********/


public function workexperience_view()
	{   
        $this->permission->module('recruitment','read')->redirect();

		$data['title']    = display('educationinfo_list');  ;
		$data['exp'] = $this->Candidate_model->viewExperience();
		$data['module'] = "recruitment";
		$data['page']   = "workexperienceView";   
		echo Modules::run('template/layout', $data); 
	} 

	public function create_workexperience()
	{ 

		$data['title'] = display('workexperience_list');

		#-------------------------------#
		$this->form_validation->set_rules('can_id',display('can_id'),'required');
		$this->form_validation->set_rules('company_name[]',display('company_name'));
		$this->form_validation->set_rules('working_period[]',display('working_period') );
		$this->form_validation->set_rules('duties[]',display('duties'));
		$this->form_validation->set_rules('supervisor[]',display('supervisor'));
        $comname = $this->input->post('company_name');
	    $wperiod = $this->input->post('working_period');
	    $duties = $this->input->post('duties');
	    $supe = $this->input->post('supervisor');
	  
		
		#-------------------------------#
		if ($this->form_validation->run() === true) {
 for ($i=0; $i < sizeof($comname); $i++) {
			$postData = [
			'can_id' 	                   => $this->input->post('can_id',true),
			'company_name'                 => $comname[$i],
			'working_period' 	           => $wperiod[$i],
			'duties' 	                   => $duties[$i], 
			'supervisor' 	               => $supe[$i], 
			
			];   
			

			 $this->Candidate_model->canworkexp_create($postData);
		    }

		    $this->session->set_flashdata('message', display('save_successfully'));
			redirect("recruitment/Candidate/candidateinfo_view");



		}  else {
			$data['title'] = display('create');
			$data['module'] = "recruitment";
			$data['page']   = "can_workexperience_form"; 
			$data['dropdown_edu'] = $this->Candidate_model->eduinfo_dropdown();
			echo Modules::run('template/layout', $data);   
			
		}   
	}

	public function update_workexperience_form($id = null){
 		$this->form_validation->set_rules('can_id',display('can_id'),'required');
		$this->form_validation->set_rules('company_name[]',display('company_name'));
		$this->form_validation->set_rules('working_period[]',display('working_period') );
		$this->form_validation->set_rules('duties[]',display('duties'));
		$this->form_validation->set_rules('supervisor[]',display('supervisor'));
        $comname = $this->input->post('company_name');
	    $wperiod = $this->input->post('working_period');
	    $duties = $this->input->post('duties');
	    $supe = $this->input->post('supervisor');
	  	
	   
		#-------------------------------#
		if ($this->form_validation->run() === true) {
		    	$this->db->where('can_id',$this->input->post('can_id'))
 			->delete('candidate_workexperience');
			  

		 for ($i=0; $i < sizeof($comname); $i++) {
			$postData = [
			'can_id' 	                   => $this->input->post('can_id',true),
			'company_name'                 => $comname[$i],
			'working_period' 	           => $wperiod[$i],
			'duties' 	                   => $duties[$i], 
			'supervisor' 	               => $supe[$i], 
			
			];   
			
		
		 $this->db->insert('candidate_workexperience', $postData);
		    }
		    
				$this->session->set_flashdata('message', display('successfully_updated'));
			
		
			redirect("recruitment/Candidate/candidateinfo_view/". $id);

		} 
		
		else {
			$data['title'] = display('update');
		    $data['data']=$this->Candidate_model->workexperience_updateForm($id);
		   $id= $this->uri->segment(4);
		    $data['work']=$this->Candidate_model->work($id);
			$data['module'] = "recruitment";
			
			$data['page']   = "update_workexperience_form";   
			echo Modules::run('template/layout', $data); 
		}
 
	}
	public function delete_workexperience($id = null) 
	{ 
        $this->permission->module('recruitment','delete')->redirect();

		if ($this->Candidate_model->delete_workexp($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect('recruitment/Candidate/candidateinfo_view/#menu1');
	}


public function view_details(){
     $data=array();    
     $data['ab']=$this->Candidate_model->employee_details($id);
     //$data['ab']=$this->Candidate_model->Eduinfo($id);
     $this->load->view('cv',$data);
     


 }




}
