<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Month_deduction_model extends CI_Model {
 
    public function month_deduction_create($data = array())
	{
		return $this->db->insert('monthly_deductions', $data);//
	}
    
    public function setting()
	{
		return $this->db->get('setting')->row();
	}
	
	public function month_deduction_list()
	{
        return 
        $this->db->distinct('ss.gross_salary')
        ->select("
            ss.gross_salary as ss_gross_salary,
            md.id as md_id,
            md.comment_box,
            md.amount as md_amount, md.status as md_status, 
            md.process_type as md_process_type, 
            md.salary_type as md_salary_type,
            p.*
        ")   
        ->from('monthly_deductions md')
        ->join('employee_history p', 'md.employee_id = p.employee_id')
        ->join('employee_salary_setup ss', 'md.employee_id = ss.employee_id', 'left')
        // ->group_by('employee_salary_setup.employee_id')
        ->order_by('p.first_name', 'desc')
        ->get()
        ->result();
    }
    
    public function month_deduction_delete($id = null)
	{
		$this->db->where('id',$id)->delete('monthly_deductions');

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	} 
	
	public function month_deduction_get($id = null)
	{
		$query = $this->db->where('id',$id)->get('monthly_deductions');

		if ($this->db->affected_rows()) {
			return $query->row();
		} else {
			return false;
		}
	}
	
	public function month_deduction_update($data, $id = null)
	{
		$query = $this->db->where('id',$id)->update('monthly_deductions', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}

}
