<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Payroll extends MX_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->db->query('SET SESSION sql_mode = ""');
		$this->load->library("PHPMailer_Library");
		$this->load->model(array(
			'Payroll_model',
			'Month_deduction_model',
			'dashboard/User_model',
			'employee/Employees_model',
			'attendance/Csv_model'
		));	
		$this->load->library('numbertowords');

		if (! $this->session->userdata('isLogIn'))
			redirect('login?rback=' . uri_string());	 
	}

	public function getEmployessByDepartment(){
		$id = $this->input->post('id');
		$date = $this->input->post('date');
		// $changeDate = date('m-Y',strtotime($date));
		// $employees = $this->db->select('eh.*')
		// 					  ->join('emp_salary_setup_details essd','essd.employee_id = eh.employee_id')

		// 					  ->where('eh.dept_id',$id)
		// 					  ->where_not_in('essd.employee_id',("select employee_id from employee_salary_payment where employee_id = essd.employee_id"))
		// 					  ->group_by('essd.employee_id')
		// 					  ->get('employee_history eh');
		// echo $query = "
		// 				SELECT
		// 				  `eh`.*
		// 				FROM
		// 				  `employee_history` `eh`
		// 				  JOIN `emp_salary_setup_details` `essd`
		// 				    ON `essd`.`employee_id` = `eh`.`employee_id`
		// 				WHERE `eh`.`dept_id` = $id
		// 				  AND `essd`.`employee_id` NOT IN (
		// 				    SELECT employee_id FROM employee_salary_payment where salary_name = '$date')
		// 				GROUP BY `essd`.`employee_id`";exit;
		$results = $this->db->query("
						SELECT
						  `eh`.*
						FROM
						  `employee_history` `eh`
						  JOIN `emp_salary_setup_details` `essd`
						    ON `essd`.`employee_id` = `eh`.`employee_id`
						WHERE `eh`.`dept_id` = $id
						  AND `essd`.`employee_id` NOT IN (
						    SELECT employee_id FROM employee_salary_payment where salary_name = '$date')
						GROUP BY `essd`.`employee_id`")->result();
							  // echo $this->db->last_query();
		// $results = $employees->result();


		if($results){
			echo json_encode($results);
		}else{
		    echo json_encode([]);
		}
	}
	public function emp_salary_setup_view(){   
		$this->permission->module('payroll','read')->redirect();
		$data['title']    = display('view_salary_setup');  ;
		$data['emp_sl']   = $this->Payroll_model->salary_setupView();
		$data['module']   = "payroll";
		$data['page']     = "emp_sal_setupview";   
		echo Modules::run('template/layout', $data); 
	} 


	public function create_salary_setup(){ 
		$data['title'] = display('selectionlist');
		#-------------------------------#
		$this->form_validation->set_rules('sal_name',display('sal_name'),'required|max_length[50]');
		$this->form_validation->set_rules('emp_sal_type',display('emp_sal_type'));
		
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
				'sal_name'        => $this->input->post('sal_name',true),
				'emp_sal_type' 	  => $this->input->post('emp_sal_type',true),
				//'default_amount'  => $this->input->post('default_amount',true),
			];   

			if ($this->Payroll_model->emp_salsetup_create($postData)) { 
				$this->session->set_flashdata('message', display('successfully_saved'));
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
			}
			redirect("payroll/Payroll/create_salary_setup");
		} else {
			$data['title']  = display('salary_type');
			$data['module'] = "payroll";
			$data['page']   = "emp_salarysetup_form";
			$data['emp_sl'] = $this->Payroll_model->salary_setupView(); 
			echo Modules::run('template/layout', $data);   
			
		}   
	}
	public function delete_emp_salarysetup($id = null){ 
		$this->permission->module('payroll','delete')->redirect();

		if ($this->Payroll_model->emp_salstup_delete($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect("payroll/Payroll/emp_salary_setup_view");
	}




	public function update_salsetup_form($id = null){
		$this->form_validation->set_rules('salary_type_id',null,'required|max_length[11]');
		$this->form_validation->set_rules('sal_name',display('sal_name'),'required|max_length[50]');
		$this->form_validation->set_rules('emp_sal_type',display('emp_sal_type')  ,'max_length[20]');
		#-------------------------------#
		if ($this->form_validation->run() === true) {

			$postData = [
				'salary_type_id' 	             => $this->input->post('salary_type_id',true),
				'sal_name' 	                     => $this->input->post('sal_name',true),
				'emp_sal_type' 		             => $this->input->post('emp_sal_type',true),
				
			]; 
			
			if ($this->Payroll_model->update_em_salstup($postData)) { 
				$this->session->set_flashdata('message', display('successfully_updated'));
			} else {
				$this->session->set_flashdata('exception',  display('please_try_again'));
			}
			redirect("payroll/Payroll/update_salsetup_form/". $id);

		} else {
			$data['title']  = display('update');
			$data['data']   =$this->Payroll_model->salarysetup_updateForm($id);
			$data['module'] = "payroll";
			$data['page']   = "update_salarysetup_form";   
			echo Modules::run('template/layout', $data); 
		}

	}


	public function salary_setup_view()
	{   
		$this->permission->module('payroll','read')->redirect();
		$data['title']         = display('view_salary_setup');  ;
		$data['emp_sl_setup']  = $this->Payroll_model->salary_setupindex();
		$data['module']        = "payroll";
		$data['page']          = "sal_setupview";   
		echo Modules::run('template/layout', $data); 
	} 


	public function create_s_setup(){ 
		$data['title'] = display('selectionlist');
		#-------------------------------#
		$this->form_validation->set_rules('employee_id',display('employee_id'),'required|max_length[50]');
		$this->form_validation->set_rules('sal_type',display('sal_type'));
		$this->form_validation->set_rules('amount[]',display('amount'));
		$this->form_validation->set_rules('salary_payable',display('salary_payable'));
		$this->form_validation->set_rules('absent_deduct',display('absent_deduct'));
		$this->form_validation->set_rules('tax_manager',display('tax_manager'));
		$amount=$this->input->post('amount');
		
		#-------------------------------#
		if ($this->form_validation->run() === true) {
			$date=date('Y-m-d');

			foreach($amount as $key=>$value)
			{	
				$postData = [
					'employee_id'           => $this->input->post('employee_id',true),
					'sal_type'              => $this->input->post('sal_type',true),
					'salary_type_id' 	    => $key,
					'amount' 	            => (!empty($value)?$value:0),
					'create_date'           => $date,
					'gross_salary'          => $this->input->post('gross_salary',true),
				]; 
			//print_r($postData);exit();
			
					$this->Payroll_model->salary_setup_create($postData);
				
			}

			if($this->input->post('absent_deduct',true)==1)
			{
				$absent_deduct=1;	
			}
			else
			{
				$absent_deduct=0;
			}
			if($this->input->post('tax_manager',true)==1)
			{
				$tax_manager=1;	
			}
			else
			{
				$tax_manager=0;
			}
			$Data1 = [
				'employee_id'                => $this->input->post('employee_id',true),
				'salary_payable' 	         => $this->input->post('salary_payable',true),
				'absent_deduct' 	         => $absent_deduct,
				'tax_manager' 	             => $tax_manager,	
			];   
			$this->Payroll_model->salary_head_create($Data1);
			$this->session->set_flashdata('message', display('successfully_saved_saletup'));
			redirect("payroll/Payroll/create_s_setup");
		} else {
			$data['title']      = display('create');
			$data['module']     = "payroll";
			$data['slname']     = $this->Payroll_model->salary_typeName();
			$data['sldname']    = $this->Payroll_model->salary_typedName();
			$data['employee']   = $this->Payroll_model->empdropdown();
			$data['emp_sl_setup']   = $this->Payroll_model->salary_setupindex();
			$data['page']       = "salarysetup_form"; 
			echo Modules::run('template/layout', $data);   
			
		}   
	}
	public function delete_salsetup($id = null) 
	{ 
		// $this->permission->module('payroll','delete')->redirect();
		if ($this->Payroll_model->emp_salstup_delete($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect("Payroll/emp_salary_setup_view");
	}



	public function salary_generate_view($id = null)
	{   
		$data['title']    = display('view_salary_generate');  
		$config["base_url"] = base_url('payroll/Payroll/salary_generate_view');
        $config["total_rows"]  = $this->db->count_all('salary_sheet_generate');
        $config["per_page"]    = 10;
        $config["uri_segment"] = 4;
        $config["last_link"] = "Last"; 
        $config["first_link"] = "First"; 
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Prev';  
        $config['full_tag_open'] = "<ul class='pagination col-xs pull-right'>";
        $config['full_tag_close'] = "</ul>";
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
        $config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
        $config['next_tag_open'] = "<li>";
        $config['next_tag_close'] = "</li>";
        $config['prev_tag_open'] = "<li>";
        $config['prev_tagl_close'] = "</li>";
        $config['first_tag_open'] = "<li>";
        $config['first_tagl_close'] = "</li>";
        $config['last_tag_open'] = "<li>";
        $config['last_tagl_close'] = "</li>";
        /* ends of bootstrap */
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        $data["links"] = $this->pagination->create_links();
		$data['salgen']   = $this->Payroll_model->salary_generateView($config["per_page"], $page);
		$data['module']   = "payroll";
		$data['page']     = "sal_genview";   
		echo Modules::run('template/layout', $data); 
	} 

	public function create_salary_generate()
	{ 
		$data['title'] = display('selectionlist'); 
		#-------------------------------# 
		$this->form_validation->set_rules('name',display('salar_month'),'required|max_length[50]');
		#-------------------------------#

		if ($this->form_validation->run() === true) {

			   list($month,$year) = explode(' ',$this->input->post('name'));
        // $query =$this->db->select('*')->from('salary_sheet_generate')->where('name',$this->input->post('name'))->get()->num_rows();
                // $query =$this->db->select('*')->from('employee_salary_payment')->where('salary_name',$this->input->post('name'))->get()->num_rows();
        // if ($query > 0) {
        //     $this->session->set_userdata(array('exception' => display('the_salary_of').$month. display('already_generated')));
        //     $this->session->set_flashdata('exception','Salary of '.$this->input->post('name').' Already Generated');
        //     redirect(base_url('payroll/Payroll/create_salary_generate'));
        // }
           
        switch ($month)
        {
            case "January":
                $month = '1';
                break;
            case "February":
                $month = '2';
                break;
            case "March":
                $month = '3';
                break;
            case "April":
                $month = '4';
                break;
            case "May":
                $month = '5';
                break;
            case "June":
                $month = '6';
                break;
            case "July":
                $month = '7';
                break;
            case "August":
                $month = '8';
                break;
            case "September":
                $month = '9';
                break;
            case "October":
                $month = '10';
                break;
            case "November":
                $month = '11';
                break;
            case "December":
                $month = '12';
                break;
        }
        $fdate = $year.'-'.$month.'-'.'1';
        $lastday = date('t',strtotime($fdate));
        $edate = $year.'-'.$month.'-'.$lastday;
            $startd    = $fdate;

// 			$employee = $this->db->select('employee_id')->from('employee_salary_setup')->group_by('employee_id')->get()->result();
            // $employee = $this->db->select('employee_id')->from('emp_salary_setup_details')->group_by('employee_id')->get()->result();
            $employee = $this->input->post('employee_id');
// 			echo "<pre>";
// 			echo "<pre>"; print_r($employee); die;
			$ab=date('Y-m-d');
				$postData = [
				'name'                =>  $this->input->post('name',true),
				'gdate'               =>  $ab,
				'start_date' 	      =>  $startd, 
				'end_date' 	          =>  $edate, 
				'generate_by' 	      =>  $this->session->userdata('fullname'), 
			]; 

			$debit_amount = 0;
			   $foundPayroll = $this->db->where('name',$this->input->post('name',true))->get('salary_sheet_generate')->first_row();
			   if(!$foundPayroll){
			       $this->db->insert('salary_sheet_generate', $postData);
			   }
			 //  else{
			       
			 //  }
		      //  
    			if (sizeof($employee) > 0)
    			$lastid = [];
    			$k  = 0;
    			$EmployeeCounts = count($employee);
				foreach($employee as $key=>$value)
				{
				   $k++;
				    // $monthly_deductions   = $this->db->select('*')->from('monthly_deductions')->where(array('employee_id'=>$value->employee_id, 'process_type'=>1, 'salary_type'=>1))->get()->row();
				    // if($monthly_deductions == true){
				    //     $salary_object   = $this->db->select('*')->from('employee_salary_setup')->where(array('employee_id'=>$value->employee_id))->get()->row();
    				//     $datas['gross_salary'] = $salary_object->gross_salary - $monthly_deductions->amount;
    				//     $datas['update_date'] =  date("Y-m-d H:i:s", strtotime("now"));
    				//     $this->db->where(array('employee_id'=>$value->employee_id))->update("employee_salary_setup", $datas);
    				//     $this->db->where(array('employee_id'=>$value->employee_id, 'salary_type'=>1))->update("monthly_deductions", array('process_type'=>0, 'updated_at'=>date("Y-m-d H:i:s", strtotime("now"))));
				    // }
				    
				    // $monthly_bonus   = $this->db->select('*')->from('monthly_deductions')->where(array('employee_id'=>$value->employee_id, 'process_type'=>1, 'salary_type'=>2))->get()->row();
				    // if($monthly_bonus == true){
				    //     $salary_objects   = $this->db->select('*')->from('employee_salary_setup')->where(array('employee_id'=>$value->employee_id))->get()->row();
    				//     $data_b['gross_salary'] = $salary_objects->gross_salary + $monthly_bonus->amount;
    				//     $data_b['update_date'] =  date("Y-m-d H:i:s", strtotime("now"));
    				//     $this->db->where(array('employee_id'=>$value->employee_id))->update("employee_salary_setup", $data_b);
    				//     $this->db->where(array('employee_id'=>$value->employee_id, 'salary_type'=>2))->update("monthly_deductions", array('process_type'=>0, 'updated_at'=>date("Y-m-d H:i:s", strtotime("now"))));
				    // }
		
// 		$aAmount   = $this->db->select('a.gross_salary,a.sal_type,a.employee_id,b.first_name,b.last_name')->from('employee_salary_setup a')->join('employee_history b','b.employee_id=a.employee_id')->where('a.employee_id', $value->employee_id)->get()->row();
 
        $aAmount   = $this->db->select('b.rate as gross_salary,b.rate_type as sal_type,b.employee_id,b.first_name,b.last_name')->from('employee_history b')->where('b.employee_id', $value)->get()->row();
        // $allDeduction = $this->db->select('sum(value) as deduction_amount')->from('emp_salary_setup_details')->where('employee_id',$value)->where('deduction_id is not null')->get()->result();           
        $allDeduction = $this->db->select('emp_salary_setup_details.value as amount,sd.type as type')
                                 ->from('emp_salary_setup_details')->join('salary_deduction sd','sd.id = emp_salary_setup_details.deduction_id')
                                 ->where('emp_salary_setup_details.employee_id',$value)
                                 ->where('emp_salary_setup_details.deduction_id is not null')
                                 ->get()->result();           
                                //  echo 'here';exit;
        $damount= 0;        
        foreach($allDeduction as $sd_key=>$sd_value){
            if($sd_value->type == 'percent'){
               $damount+= $aAmount->gross_salary * ($sd_value->amount/100);
            }
            if($sd_value->type == 'amount'){
               $damount+= $sd_value->amount;
            }
        }                
       
        // $allAddition  = $this->db->select('sum(value) as addition_amount')->from('emp_salary_setup_details')->where('employee_id',$value)->where('addition_id is not null')->get()->result();        
        $allAddition  = $this->db->select('emp_salary_setup_details.value as amount,sd.type as type')
                                 ->from('emp_salary_setup_details')
                                 ->join('salary_addition sd','sd.id = emp_salary_setup_details.addition_id')
                                 ->where('emp_salary_setup_details.employee_id',$value)->where('emp_salary_setup_details.addition_id is not null')->get()->result();        
        
        $aamount= 0;        
        foreach($allAddition as $ad_key=>$sa_value){
            if($sa_value->type == 'percent'){
               $aamount+= $aAmount->gross_salary * ($sa_value->amount/100);
            }
            if($sa_value->type == 'amount'){
               $aamount+= $sa_value->amount;
            }
        }                
    
        $allAdhoc     = $this->db->select('*')->from('adhoc')->where('employee_id',$value)->where('applied','0')->get()->result();                    
        $adhoc_add  =      0;
        $adhoc_dedu =      0;
        foreach($allAdhoc as $keey=>$vaalue){
            if($vaalue->type==1){
                $adhoc_add += $vaalue->amount;
            }
            if($vaalue->type==2){
                $adhoc_dedu += $vaalue->amount;
            }
        }
     
		$grossSalary =  (((($aAmount->gross_salary - $damount) + $aamount)-$adhoc_dedu)+$adhoc_add);
		$Amount    = $grossSalary;
		$startd    = $startd;
		$end       = $edate;
// 		echo "<pre>"; print_r($aAmount); die;
    	$att_in = $this->db->select('a.time,
      							   MIN(a.time) as intime,
      							   MAX(a.time) as outtime,
      							   a.uid, DATE(time) as mydate')
                    ->from('attendance_history a')
                    ->where('a.uid',$value)
                    ->where('DATE(a.time) >=',date('Y-m-d', strtotime($startd)))
                    ->where('DATE(a.time) <=',date('Y-m-d', strtotime($end)))
                    ->group_by('DATE(a.time)')
                    ->get()
                    ->result();
      $idx=1;
            $totalhour=[];
            $totalday = [];
           foreach ($att_in as $attendancedata) { 
           	   $date_a = new DateTime($attendancedata->outtime);
                $date_b = new DateTime($attendancedata->intime);
                $interval = date_diff($date_a,$date_b);

             $totalwhour = $interval->format('%h:%i:%s');
              $totalhour[$idx] = $totalwhour;
              $totalday[$idx] = $attendancedata->mydate;
$idx++;
           }
           $seconds = 0;
foreach($totalhour as $t)
{
$timeArr = array_reverse(explode(":", $t));

foreach ($timeArr as $key => $tv)
{
    if ($key > 2) break;
    $seconds += pow(60, $key) * $tv;
}

}

$hours = floor($seconds / 3600);
$mins = floor(($seconds - ($hours*3600)) / 60);
$secs = floor($seconds % 60);
//echo $h = $hours.':'.$mins.':'.$secs;
 $times = $hours * 3600 + $mins * 60 + $secs;;
// exit();

// end new salary generate		
		$wormin = ($times/60);
		$worhour = number_format($wormin/60,2);
		if($aAmount->sal_type == 1){
		$dStart = new DateTime($startd);
        $dEnd  = new DateTime($end);
        $dDiff = $dStart->diff($dEnd);
         $numberofdays =  $dDiff->days+1;
			$totamount = $Amount*$worhour;
			$PYI = ($totamount/$numberofdays)*365;
			$PossibleYearlyIncome = round($PYI);
		$this->db->select('*');
		$this->db->from('payroll_tax_setup');
		$this->db->where("start_amount <",$PossibleYearlyIncome);
		$query = $this->db->get();
		$taxrate = $query->result_array();
		$TotalTax = 0;
	    foreach($taxrate as $row){
                    // "Inside tax calculation";
	    	    if($PossibleYearlyIncome > $row['start_amount'] && $PossibleYearlyIncome > $row['end_amount']){
                   $diff=$row['end_amount']-$row['start_amount'];
                    }
                     if($PossibleYearlyIncome > $row['start_amount'] && $PossibleYearlyIncome < $row['end_amount']){
                    $diff=$PossibleYearlyIncome-$row['start_amount'];
                    }
                    $tax=(($row['rate']/100)*$diff);
                    $TotalTax += $tax;	
                } 
              $TaxAmount = ($TotalTax/365)*$numberofdays;
             //  echo $totamount.'<br>';
              //print_r($PossibleYearlyIncome);
             // echo '<br>';

        $netAmount = number_format(($totamount-$TaxAmount),2);
        // echo $netAmount;
        // exit();
		}else if($aAmount->sal_type == 2){
			$netAmount = $Amount;
		}
			$workingper   = count($totalday);
			$paymentData = array(
				'employee_id'           => $value,
				'total_salary'          => $netAmount,
				'total_working_minutes' => $worhour,
				'salary_name'           => $this->input->post('name',true),
				'working_period'        => $workingper,
				'payment_due'			=> 'paid',
				'payment_date'			=> date('Y-m-d'),
				'paid_by'				=> 'HR Admin',
				'payment_type'			=> '1'
			);

			if(!empty($aAmount->employee_id)){
				$update_adhoc     = $this->db->where('employee_id',$value)
			    							 ->update('adhoc',['applied'=>'1','applied_on'=>date('Y-m-d')]);
				$this->db->insert('employee_salary_payment', $paymentData);
				$employeeForTransacitons = $this->db->insert_id();


				$lastid[] = $employeeForTransacitons;
				$transactionsArray['type'] = 'debit';
				
				$transactionsArray['relation_name'] = 'salary';
				//$transactionsArray['internal_account'] = $this->input->post('internal_accounts');
				$transactionsArray['payment_amount'] = $netAmount;
				$transactionsArray['description'] = 'Salary Transactions';
				$transactionsArray['employee_pay_id'] = $employeeForTransacitons;		
				// balance = inital_balance - debit + credit
				
				$debit_amount += $netAmount;

				if($employeeForTransacitons){
					$insertTransactions = $this->db->insert('transactions',$transactionsArray);
				}

			    
				$c_code = $aAmount->employee_id;
				$c_name = $aAmount->first_name.$aAmount->last_name;
				$c_acc=$c_code.'-'.$c_name;
				$headcode = $this->db->select('HeadCode')
									 ->from('acc_coa')->where('HeadName',$c_acc)
									 ->get()->row()->HeadCode;
				$createby = $this->session->userdata('fullname');
				$createdate = date('Y-m-d H:i:s');

				$accpayable = array(
                  'VNo'            => $this->input->post('name',true),
                  'Vtype'          => 'Generated Salary',
                  'VDate'          => date('Y-m-d'),
                  'COAID'          => $headcode,
                  'Narration'      => 'Salary For Employee Id'.$aAmount->employee_id,
                  'Debit'          => 0,
                  'Credit'         => intval(str_replace(',', '', $netAmount)),
                  'IsPosted'       => 1,
                  'CreateBy'       => $this->session->userdata('id'),
                  'CreateDate'     => date('Y-m-d H:i:s'),
                  'IsAppove'       => 1
                ); 

			$this->db->insert('acc_transaction', $accpayable);
			
			
			
			
			}
		}
		
		
// 		print_r($lastid);
		
//     		echo	$k.'<br>';
    // 			echo count($employee);


    			if($k == count($employee)){
//     				$this->input->post('internal_accounts');
// $debit_amoun
    				// balance = inital_balance - debit + credit
    				// $accountUpdate = $this->db->update
    				//$internal_account = $this->db->where('id',$this->input->post('internal_accounts'))->get('internal_account')->first_row();

    				//$balance = $internal_account->current_balance - $debit_amount + 0;

    				// $this->db->update('id',$this->input->post('internal_accounts'))->;
    				// update


				    //$this->db->where('id',$this->input->post('internal_accounts'))->update('internal_account',['current_balance'=>$balance]); 

    			    foreach($lastid as $empkey=>$empValue){
    			     //   echo $empValue;
    			       $this->bulk_mailing_send($empValue);    
    			    }
    			    $this->session->set_flashdata('message', display('successfully_saved_saletup'));
			    	redirect("payroll/Payroll/create_salary_generate");
    			}
    			
			} else {
					$data['title']  = display('create');
					$config["base_url"] = base_url('payroll/Payroll/create_salary_generate');
			        $config["total_rows"]  = $this->db->count_all('salary_sheet_generate');
			        $config["per_page"]    = 3;
			        $config["uri_segment"] = 4;
			        $config["last_link"] = "Last"; 
			        $config["first_link"] = "First"; 
			        $config['next_link'] = 'Next';
			        $config['prev_link'] = 'Prev';  
			        $config['full_tag_open'] = "<ul class='pagination col-xs pull-right'>";
			        $config['full_tag_close'] = "</ul>";
			        $config['num_tag_open'] = '<li>';
			        $config['num_tag_close'] = '</li>';
			        $config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
			        $config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
			        $config['next_tag_open'] = "<li>";
			        $config['next_tag_close'] = "</li>";
			        $config['prev_tag_open'] = "<li>";
			        $config['prev_tagl_close'] = "</li>";
			        $config['first_tag_open'] = "<li>";
			        $config['first_tagl_close'] = "</li>";
			        $config['last_tag_open'] = "<li>";
			        $config['last_tagl_close'] = "</li>";
			        /* ends of bootstrap */
			        $this->pagination->initialize($config);
			        $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
			        $data["links"] = $this->pagination->create_links();
					$data['module'] = "payroll";
					$data['page']   = "salary_generate_form"; 
					$data['userlist'] =$this->Csv_model->userlist();
					$data['departments'] = $this->db->get('department')->result();
					//$data['internal_accounts'] = $this->db->get('internal_account')->result();
					$data['salgen'] = $this->Payroll_model->salary_generateView($config["per_page"], $page);
					echo Modules::run('template/layout', $data);   

			}   
		}
		public function delete_sal_gen($id = null) 
		{ 
			$sal_name = $this->db->select('name')->from('salary_sheet_generate')->where('ssg_id',$id)->get()->row()->name;

			if ($this->Payroll_model->salary_gen_delete($id,$sal_name)) {
			#set success message
				$this->session->set_flashdata('message',display('delete_successfully'));
			} else {
			#set exception message
				$this->session->set_flashdata('exception',display('please_try_again'));
			}
			redirect("payroll/Payroll/create_salary_generate");
		}

		public function update_salgen_form($id = null){
			$this->form_validation->set_rules('ssg_id',null,'max_length[11]');
			$this->form_validation->set_rules('name',display('name'),'max_length[50]');

			$this->form_validation->set_rules('start_date',display('start_date'));
			$this->form_validation->set_rules('end_date',display('end_date'));
		#-------------------------------#
			if ($this->form_validation->run() === true) {
				$postData = [
					'ssg_id' 	             => $this->input->post('ssg_id',true),
					'name'                   => $this->input->post('name',true),
					'start_date' 	         => $this->input->post('start_date',true),
					'end_date' 	             => $this->input->post('end_date',true),
				]; 
				if ($this->Payroll_model->update_sal_gen($postData)) { 
					$this->session->set_flashdata('message', display('successfully_updated'));
				} else {
					$this->session->set_flashdata('exception',  display('please_try_again'));
				}
				redirect("payroll/Payroll/salary_generate_view");
			} else {
				$data['title']  = display('update');
				$data['data']   =$this->Payroll_model->salargen_updateForm($id);
				$data['module'] = "payroll";
				$data['page']   = "update_salarygenerate_form";   
				echo Modules::run('template/layout', $data); 
			}

		}
		/* salary setup update form  start*/
		public function updates_salstup_form($id = null){

 		#-------------------------------#
			$this->form_validation->set_rules('employee_id',display('employee_id'),'required|max_length[50]');
			$this->form_validation->set_rules('sal_type',display('sal_type'));
			$this->form_validation->set_rules('amount[]',display('amount'));
			$this->form_validation->set_rules('salary_payable',display('salary_payable'));
			$this->form_validation->set_rules('absent_deduct',display('absent_deduct'));
			$this->form_validation->set_rules('tax_manager',display('tax_manager'));
			$amount=$this->input->post('amount');

		#-------------------------------#
			if ($this->form_validation->run() === true) {


				foreach($amount as $key=>$value)
				{

					$postData = array(
						'employee_id'        => $this->input->post('employee_id',true),
						'sal_type'           => $this->input->post('sal_type',true),
						'salary_type_id' 	 => $key,
						'amount' 	         => $value,
						'gross_salary'          => $this->input->post('gross_salary',true),
					);

					$this->Payroll_model->update_sal_stup($postData);

				}


				if($this->input->post('absent_deduct',true)==1)
				{
					$absent_deduct=1;	
				}
				else
				{
					$absent_deduct=0;
				}


				if($this->input->post('tax_manager',true)==1)
				{
					$tax_manager=1;	
				}
				else
				{
					$tax_manager=0;
				}


				$Data = [
					'employee_id'                => $this->input->post('employee_id',true),
					'salary_payable' 	         => $this->input->post('salary_payable',true),
					'absent_deduct' 	         => $absent_deduct,
					'tax_manager' 	             => $tax_manager,


				];   


				$this->Payroll_model->update_sal_head($Data);



				$this->session->set_flashdata('message', display('successfully_saved_saletup'));
				redirect("payroll/Payroll/updates_salstup_form/". $id);
//
			} else {

			$data['title']       = display('update');//
			$data['data']        = $this->Payroll_model->salary_s_updateForm($id);
			$data['samlft']      = $this->Payroll_model->salary_amountlft($id);
			$data['amo']         = $this->Payroll_model->salary_amount($id);
			$data['bb']          = $this->Payroll_model->get_empid($id);
			$data['gt']          = $this->Payroll_model->get_type($id);
			$data['employee']    = $this->Payroll_model->empdropdown();
			$data['type']        = $this->Payroll_model->type();
			$data['payable']     = $this->Payroll_model->payable();
			$data['gt_pay']      = $this->Payroll_model->get_payable($id);
			$data['EmpRate']     = $this->Payroll_model->employee_informationId($id);
			$data['module']      = "payroll";
			$data['page']        = "update_sal_setup_form";   
			echo Modules::run('template/layout', $data); 
		}

	}
// salary with tax calculation
	public function salarywithtax(){
		$tamount =$this->input->post('amount');
		//$tax = (!empty($this->input->post('tax',true))?$this->input->post('tax',true):0);
		$amount = $tamount*12;
       $this->db->select('*');
		$this->db->from('payroll_tax_setup');
		$this->db->where("start_amount <",$amount);
		$query = $this->db->get();
		$taxrate = $query->result_array();
		$TotalTax = 0;
	    foreach($taxrate as $row){
                    // "Inside tax calculation";
	    	    if($amount > $row['start_amount'] && $amount > $row['end_amount']){
                   $diff=$row['end_amount']-$row['start_amount'];
                    }
                     if($amount > $row['start_amount'] && $amount < $row['end_amount']){
                    $diff=$amount-$row['start_amount'];
                    }
                    $tax=(($row['rate']/100)*$diff);
                    $TotalTax += $tax;	
                } 
		$salary = $TotalTax/12;
		echo json_encode(round($salary));
	}

//employee Basic Salary get
	public function employeebasic(){
		$id = $this->input->post('employee_id');
		$data = $this->db->select('rate,rate_type')->from('employee_history')->where('employee_id',$id)->get()->row();
		$basic = $data->rate;
		if($data->rate_type ==1){
			$type = 'Hourly';
		}else{
			$type = 'Salary';	
		}
		$sent = array(
			'rate'      =>  $data->rate,
			'rate_type' =>$data->rate_type,
			'stype'     => $type
		);
		echo json_encode($sent);
	}
	
	public function emp_payment_view()
{   
        $data['title']         = display('view_employee_payment'); 
		$config["base_url"]    = base_url('payroll/Payroll/emp_payment_view');
        $config["total_rows"]  = $this->db->count_all('employee_salary_payment');
        $config["per_page"]    = 25;
        $config["uri_segment"] = 4;
        $config["last_link"] = "Last"; 
        $config["first_link"] = "First"; 
        $config['next_link'] = 'Next';
        $config['prev_link'] = 'Prev';  
        $config['full_tag_open'] = "<ul class='pagination col-xs pull-right'>";
        $config['full_tag_close'] = "</ul>";
        $config['num_tag_open'] = '<li>';
        $config['num_tag_close'] = '</li>';
        $config['cur_tag_open'] = "<li class='disabled'><li class='active'><a href='#'>";
        $config['cur_tag_close'] = "<span class='sr-only'></span></a></li>";
        $config['next_tag_open'] = "<li>";
        $config['next_tag_close'] = "</li>";
        $config['prev_tag_open'] = "<li>";
        $config['prev_tagl_close'] = "</li>";
        $config['first_tag_open'] = "<li>";
        $config['first_tagl_close'] = "</li>";
        $config['last_tag_open'] = "<li>";
        $config['last_tagl_close'] = "</li>";
        /* ends of bootstrap */
        $this->pagination->initialize($config);
        $page = ($this->uri->segment(4)) ? $this->uri->segment(4) : 0;
        $data["links"]     = $this->pagination->create_links();
		$data['module']    = "payroll"; 
		$data['emp_pay']   = $this->Employees_model->emp_paymentView($config["per_page"], $page);
		$data['bank_list'] = $this->Employees_model->bank_list();
// 		echo "<pre>"; print_r($data['emp_pay']);die;
		$data['module']    = "payroll";
		$data['page']      = "paymentview";   
	echo Modules::run('template/layout', $data); 
} 


public function payslip($id = null){
        $total_salary = 0;
		$data['title']         = display('salary_slip');
		$data['paymentdata']   = $this->Payroll_model->salary_paymentinfo($id);  
// 		$data['addition']      = $this->Payroll_model->salary_addition_fields($data['paymentdata'][0]['employee_id']);
// 		$data['deduction']     = $this->Payroll_model->salary_deduction_fields($data['paymentdata'][0]['employee_id']);
        $data['deduction']     = $this->Payroll_model->employee_salary_addition_deductions_details($data['paymentdata'][0]['employee_id'],'deduction');
        $data['addition']     = $this->Payroll_model->employee_salary_addition_deductions_details($data['paymentdata'][0]['employee_id'],'addition');
	
		$data['setting']     = $this->Payroll_model->setting();
		$data['module']      = "payroll";
		list($month,$year) = explode(" ",$salname);
		$adhoc_amount = $this->db->where(array('employee_id'=>$data['paymentdata'][0]['employee_id']))->where('MONTHNAME(applied_on)',$month)->where('year(applied_on)',$year)->get('adhoc')->result();
        $adhoc_amount_payment = 0 ;
        if($adhoc_amount){
            $total_salary =  $adhoc_amount_payment = $adhoc_amount[0]->amount;
        }
        $data['amountinword'] = $this->numbertowords->convert_number(intval(str_replace(',', '', $total_salary+ $data['paymentdata'][0]['total_salary']))) . " Rupees";
// 		echo '<pre>';
// 		print_r($data);exit();
		$data['page']          = "payslip";   
		echo Modules::run('template/layout', $data); 

}

    public function month_deduction_form(){   
// 		$this->permission->module('payroll','read')->redirect();

        /*-----------------------------------*/
		$this->form_validation->set_rules('employee_id', display('employee_id'),'required|max_length[50]');
		$this->form_validation->set_rules('amount', display('amount'),'required|max_length[50]');
		#------------------------#
		
		$data['user'] = (object)$userLevelData = array(
			'employee_id'   => $this->input->post('employee_id'),
			'amount' 	  => $this->input->post('amount'),
			'salary_type' 	  => $this->input->post('salary_type'),
			'comment_box' 	  => $this->input->post('comment_box'),
			'process_type' 	  => 1,
			'created_at'  => date("Y-m-d H:i:s", strtotime("now")),
			'created_by' => 1,
			'status'      => $this->input->post('status'),
		);
		
		if ($this->form_validation->run()) {
		    
		  //  echo "Obaidrehman07 <pre>"; 
		  //  print_r($data);
		  //  die;
		    
		    if ($this->Month_deduction_model->month_deduction_create($userLevelData)) {
				$this->session->set_flashdata('message', display('save_successfully'));
			} else {
				$this->session->set_flashdata('exception', display('please_try_again'));
			}
			redirect("payroll/payroll/manage_month_deduction/");
		}else{
		    $data['title']    = display('view_salary_setup');  ;
    		$data['emp_sl']   = $this->Payroll_model->salary_setupView();
    		$data['empl']   = $this->User_model->employee();
    		$data['module']   = "payroll";
    		$data['page']     = "month_deduction_add";   
    		echo Modules::run('template/layout', $data); 
		}
		
	}
	
	public function manage_month_deduction(){ 
		$data['title'] = display('selectionlist');
		#-------------------------------#
		$data['title']  = display('salary_type');
		$data['module'] = "payroll";
		$data['page']   = "month_deduction_manage";
		$data['emp_sl'] = $this->Month_deduction_model->month_deduction_list(); 
		echo Modules::run('template/layout', $data); 
	}
	
	public function delete_month_deduction($id = null){ 
		$this->permission->module('payroll','delete')->redirect();

		if ($this->Month_deduction_model->month_deduction_delete($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect("payroll/payroll/manage_month_deduction/");
	}
	
	public function edit_month_deduction($id = null){   
// 		$this->permission->module('payroll','read')->redirect();

        /*-----------------------------------*/
		$this->form_validation->set_rules('employee_id', display('employee_id'),'required|max_length[50]');
		$this->form_validation->set_rules('amount', display('amount'),'required|max_length[50]');
		#------------------------#
		
		$data['user'] = (object)$userLevelData = array(
			'employee_id'   => $this->input->post('employee_id'),
			'amount' 	  => $this->input->post('amount'),
			'salary_type' 	  => $this->input->post('salary_type'),
			'comment_box' 	  => $this->input->post('comment_box'),
			'process_type' 	  => 1,
			'created_at'  => date("Y-m-d H:i:s", strtotime("now")),
			'created_by' => 1,
			'status'      => $this->input->post('status'),
		);
		
		if ($this->form_validation->run()) {
		   
		    if ($this->Month_deduction_model->month_deduction_update($userLevelData, $id)) {
				$this->session->set_flashdata('message', display('save_successfully'));
			} else {
				$this->session->set_flashdata('exception', display('please_try_again'));
			}
			redirect("payroll/payroll/manage_month_deduction/");
		}else{
		  
		    $data['title']    = display('view_salary_setup');  ;
    		$data['deduction_get']   = $this->Month_deduction_model->month_deduction_get($id);
    		$data['empl']   = $this->User_model->employee();
    		$data['module']   = "payroll";
    		$data['page']     = "month_deduction_edit";   
    		echo Modules::run('template/layout', $data); 
		}
	}
	
	
	public function bulk_mailing_send($id){
	   // echo 'here';exit;
// 		foreach($_POST['getemployers'] as $key => $value){
		  //  $id = $value;
		    $employee_details = $this->db->select('eh.first_name fname,eh.last_name lname, eh.employee_id employee_id,eh.email email,esp.total_salary total_salary')->from('employee_history eh')->join('employee_salary_payment esp','esp.employee_id=eh.employee_id')->where('esp.emp_sal_pay_id',$id)->get()->result_array();
      
    		$data['title']         = display('salary_slip');
    		$data['paymentdata']   = $this->Payroll_model->salary_paymentinfo($id);  
    // 		$data['addition']      = $this->Payroll_model->salary_addition_fields($employee_details[0]['employee_id']);
            $data['deduction']      =$this->Payroll_model->employee_salary_addition_deductions_details($employee_details[0]['employee_id'],'deduction');
    // 		$data['deduction']     = $this->Payroll_model->salary_deduction_fields($employee_details[0]['employee_id']);
            $data['addition']      =$this->Payroll_model->employee_salary_addition_deductions_details($employee_details[0]['employee_id'],'addition');
    		$data['amountinword'] = $this->numbertowords->convert_number(intval(str_replace(',', '', $data['paymentdata'][0]['total_salary'])));
    		
    		
    		$this->sendingEmail($employee_details[0]['email'], $employee_details[0]['fname'].' '.$employee_details[0]['lname'], "Appedology Salary Slip: " . date("Y-m-d", strtotime("now")), 'email/salary_slip_template.php', $data);
    		$this->db->where('emp_sal_pay_id',$id)->update('employee_salary_payment', array("salary_slip_mail_status"=>1));
// 		}
		$this->session->set_flashdata('message', display('save_successfully'));
// 		redirect("payroll/payroll/emp_payment_view/");
	}
	
	public function mail_salary_slip(){   
// 		$this->permission->module('payroll','read')->redirect();
        //print_r($_POST);die;
		foreach($_POST['getemployers'] as $key => $value){
		    $id = $value;
    		$data['title']         = display('salary_slip');
    		$data['paymentdata']   = $this->Payroll_model->salary_paymentinfo($id);  
    		$data['addition']      = $this->Payroll_model->salary_addition_fields($data['paymentdata'][0]['employee_id']);
    		$data['deduction']     = $this->Payroll_model->salary_deduction_fields($data['paymentdata'][0]['employee_id']);
    		$data['amountinword'] = $this->numbertowords->convert_number(intval(str_replace(',', '', $data['paymentdata'][0]['total_salary'])));
    		$data['setting']     = $this->Payroll_model->setting();
    		$this->sendingEmail($_POST['getemails'][$key], $_POST['fullnames'][$key], "Appedology Salary Slip: " . date("Y-m-d", strtotime("now")), 'email/salary_slip_template.php', $data);
    		$this->db->where('emp_sal_pay_id',$value)->update('employee_salary_payment', array("salary_slip_mail_status"=>1));
		}
		$this->session->set_flashdata('message', display('save_successfully'));
		redirect("payroll/payroll/emp_payment_view/");
// 		echo "Obaidrehman07 <pre>";  print_r($_POST); die;
	}
	
	public function mail_individual(){
        $status_data = array();
	    $data['title']         = display('salary_slip');
		$data['paymentdata']   = $this->Payroll_model->salary_paymentinfo($_POST['ID']);  
		$data['addition']      = $this->Payroll_model->salary_addition_fields($data['paymentdata'][0]['employee_id']);
		$data['deduction']     = $this->Payroll_model->salary_deduction_fields($data['paymentdata'][0]['employee_id']);
		$data['amountinword'] = $this->numbertowords->convert_number(intval(str_replace(',', '', $data['paymentdata'][0]['total_salary'])));
		$data['setting']     = $this->Payroll_model->setting();
		if($this->sendingEmail($_POST['getemails'], $_POST['fullnames'], "Appedology Salary Slip: " . date("Y-m-d", strtotime("now")), 'email/salary_slip_template.php', $data)){
		    $status_data['status'] = true;
		    $status_data['msg'] = "Success";
		}else{
		    $status_data['status'] = false;
		    $status_data['msg'] = "Failed";
		}
        echo json_encode($status_data); die;
	}
	
	public function sendingEmail($sendToEmail = null, $name = null, $subject = null, $templatePath = null, $data = array()){
	    if($sendToEmail != null && $subject != null && $templatePath != null && !empty($data)){
	        $mail = $this->phpmailer_library->load();
    		$mail->SMTPDebug =0;                                 // Enable verbose debug output
    		$mail->SMTPOptions = array(
    			'ssl' => array(
    				'verify_peer' => false,
    				'verify_peer_name' => false,
    				'allow_self_signed' => true
    			)
    		);
    		$mail->Host = $this->config->item('smtp_host');  // Specify main and backup SMTP servers
    		$mail->isSMTP();
    		$mail->Port = $this->config->item('smtp_port');
    		$mail->SMTPAuth = true;
    		$mail->SMTPSecure = $this->config->item('smtp_crypto'); // Enable SMTP authentication
    		$mail->Username = $this->config->item('smtp_user'); // SMTP username
            $mail->Password = $this->config->item('smtp_pass');  // TCP port to connect to
    		$mail->setFrom($this->config->item('admin_info'), $this->config->item('mail_subject'));
    		$mail->addAddress($sendToEmail, $name);
    		$mail->isHTML(true);  // Set email format to HTML
    		$mail->Subject = $subject;
    		$mail->Body = $this->load->view($templatePath, $data, TRUE);   
    		if($mail->send()){
    		    return true;
    		}
        }
	}


	public function addition(){
		 	$data['title']    		 = 'Additions';
    		$data['addition']   	 = $this->Payroll_model->salary_addition_deduction('salary_addition');
    		$data['module']   		 = "payroll";
    		$data['page']     		 = "addition";   
    		echo Modules::run('template/layout', $data); 
	}



	public function deduction(){
		 	$data['title']    		 = 'Deduction';
    		$data['addition']   	 = $this->Payroll_model->salary_addition_deduction('salary_deduction');
    		$data['module']   		 = "payroll";
    		$data['page']     		 = "deduction";   
    		echo Modules::run('template/layout', $data); 
	}


	public function update_salary_addition_deduction($id=null){
		$this->form_validation->set_rules('name','Name'  ,'required');
        $this->form_validation->set_rules('type','Type'  ,'required');
		$post = $this->input->post();
		$table = $post['table'];
		$return = 0;
        if ($this->form_validation->run() === true) {
        		$data['name'] = $post['name'];
        		$data['type'] = $post['type'];
        if(isset($id)){
            $update = $this->Payroll_model->salary_addition_deduction_update('salary_'.$table,$data,$id);
        }else{
            $update = $this->Payroll_model->salary_addition_deduction_update('salary_'.$table,$data);
        }
        		if($update){
        			$this->session->set_flashdata('message', display('save_successfully'));
        		}else{
					$this->session->set_flashdata('exception', display('please_try_again'));
        		}
				redirect("payroll/payroll/".$table);
        }else{
        	$this->$table();
        }
	}

	public function getAdditionDeductionDetails(){
	    
	    $table= $this->input->post('table');
	    $id= $this->input->post('id');
	    if(isset($id)){
	        $result = $this->Payroll_model->salary_addition_deduction('salary_'.$table,$id);    
	    }else{
	        $result = $this->Payroll_model->salary_addition_deduction('salary_'.$table);    
	    }
		
		echo json_encode($result);
	}
	
	public function deleteDetails($table,$id){
	    $this->db->where('id',$id)
			->delete('salary_'.$table);
			$this->session->set_flashdata('message', 'Deleted Successfull');
			redirect("payroll/payroll/".$table);
	}
	
    public function salary_setup_details_list(){
         	$data['title']    		 = 'Employee Salary Setup';
    		                            $this->db->select('eh.first_name as fname,eh.last_name as lname,eh.employee_id as employee_id,ess.id as id');
                                        $this->db->from('emp_salary_setup_details as ess');
                                        $this->db->join('employee_history eh','eh.employee_id = ess.employee_id');
                                        $this->db->group_by('ess.employee_id');
            $data['salary_setup']    =     $this->db->get()->result();
    		$data['module']   		 = "payroll";
    		$data['page']     		 = "salary_setup_details_list";   
    		echo Modules::run('template/layout', $data); 
    }
    	
    public function getEmployees(){
        $post = $_POST['searchTerm'];
                $employee_id = $this->db->select('employee_id')->from('emp_salary_setup_details')->get()->result();
                $employees = [];
                foreach($employee_id as $kkey=>$vvalue){
                    $employees[] = $vvalue->employee_id;
                }
                
                $this->db->select('eh.*')->from('employee_history eh');
    
                $this->db->like(['eh.first_name'=>$post]);
                if($this->session->userdata('isAdmin') ==1){
    
                }else{
                    $userId = $this->session->userdata('employee_id');
                    $this->db->where('eh.employee_id',$userId);
                }
                $this->db->where_not_in('employee_id',$employees);
    
                $e = $this->db->get()->result();
        $data  = array();
        foreach ($e as $key => $value) {
            $data[] =array('id'=>$value->employee_id,'text'=>$value->first_name.' '.$value->last_name);
        }
        echo json_encode($data);
     }
     
	public function salary_setup_details_form($id=null){
	       	$data['title']    		 = 'Employee Salary Setup Details';
    		$data['addition'] = $this->Payroll_model->salary_addition_deduction('salary_addition');              		
    		$data['deduction'] = $this->Payroll_model->salary_addition_deduction('salary_deduction');      
    		
    		if(isset($id)){
    		        	            $this->db->select('ess.*');
                                    $this->db->from('emp_salary_setup_details as ess');
                $addition  =  $this->db->where(['employee_id'=>$id])->where('addition_id is NOT NULL')->order_by('id','asc')->get()->result();
           
                $data['additions'] = $addition;
                   	            $this->db->select('ess.*');
                                    $this->db->from('emp_salary_setup_details as ess');
                $deduction  =  $this->db->where(['employee_id'=>$id])->where('deduction_id is NOT NULL')->order_by('id','asc')->get()->result();
                $data['deductions'] = $deduction;
                $data['id'] = $id;
                $employee = $this->db->select('*')->from('employee_history')->where('employee_id',$id)->get()->first_row();
                $data['fname'] = $employee->first_name;
                $data['lname']= $employee->last_name;
                
    		}
    		
    		$data['module']   		 = "payroll";
    		$data['page']     		 = "salary_setup_details_form";   
    		echo Modules::run('template/layout', $data); 
	}	
	
	public function salary_setup_details_update($id=null){
	    $post = $this->input->post();
	    
	   // echo '<pre>';
	   // print_r($post);
	   // exit;
	    
	    if(isset($id)){
	         $this->db->where('employee_id',$id)->delete('emp_salary_setup_details');
	    }
	    
	    if($post['emp_id']){
            for($i=0;$i<count($post['addition_id']);$i++){
    	        $addition['addition_id'] = $post['addition_id'][$i];
    	        $addition['employee_id'] = $post['emp_id'];
    	        $addition['value'] = $post['addition_value'][$i];
    	        $addition['created_on'] = date('Y-m-d');
    	        if(!empty($post['addition_id'][$i]) && !empty($post['addition_value'][$i])){
    	            $update = $this->db->insert('emp_salary_setup_details',$addition);    
    	        }
    	        
    	    }
	    
	    for($j=0;$j<count($post['deduction_id']);$j++){
	        $deduction['deduction_id'] = $post['deduction_id'][$j];
	        $deduction['employee_id'] = $post['emp_id'];
	        $deduction['value'] = $post['deduction_value'][$j];
	        $deduction['created_on'] = date('Y-m-d');
	        if(!empty($post['deduction_id'][$j]) && !empty($post['deduction_value'][$j])){
	          $update = $this->db->insert('emp_salary_setup_details',$deduction);    
	        }
	        
	    }
	    
	    }else{
	        $this->session->set_flashdata('exception', 'Employee Name Required');
	    }
	  
	   	$this->session->set_flashdata('message', display('save_successfully'));
	   	if(isset($id)){
	   	    redirect("payroll/payroll/salary_setup_details_form/".$id);
	   	}else{
	   	    redirect("payroll/payroll/salary_setup_details_form");    
	   	}
		
				
	}
	
	public function adhoc_addition_deduction(){
    	$data['title']    		 = 'Adhoc Addition/Deduction';
		$this->db->select('ad.*,eh.first_name as fname,eh.last_name as lname');
		   
        $this->db->from('adhoc as ad');
        $this->db->join('employee_history eh','eh.employee_id = ad.employee_id');
          
        $data['adhoc']   	 =     $this->db->order_by("ad.id","desc")->get()->result();
		$data['module']   		 = "payroll";
		$data['page']     		 = "adhoc_list";   
		echo Modules::run('template/layout', $data); 
	}
	
	public function update_salary_adhoc($id=null){
	    $post = $this->input->post();
	    $data['employee_id'] = $post['emp_id'];
	    $data['amount'] = $post['amount'];
	    $data['type'] = $post['type'];
	    $data['comments'] = $post['comments'];
	    $data['created_on'] =  date('Y-m-d');
	    $table = "adhoc";
	    if(isset($id)){
	        $update = $this->Payroll_model->salary_addition_deduction_update($table,$data,$id);
	    }else{
	        $update = $this->Payroll_model->salary_addition_deduction_update($table,$data);    
	    }
	    
	  	if($update){
        	$this->session->set_flashdata('message', display('save_successfully'));
        }else{
			$this->session->set_flashdata('exception', display('please_try_again'));
        }
		redirect("payroll/payroll/adhoc_addition_deduction");
	}
	
	public function adhocDetails(){
	    $id= $this->input->post('id');
        $this->db->select('ad.*,eh.first_name as fname,eh.last_name as lname');
        $this->db->from('adhoc as ad');
        $this->db->join('employee_history eh','eh.employee_id = ad.employee_id');
        $this->db->where('id',$id);
        $result = $this->db->get()->result();
		echo json_encode($result);
	}
	
	public function adhocDelete($id){
	     $this->db->where('id',$id)
			->delete('adhoc');
			$this->session->set_flashdata('message', 'Deleted Successfull');
			redirect("payroll/payroll/adhoc_addition_deduction");
	}
}


