<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Notification_model extends CI_Model
{
    public $hr_id = 10;
    public function notice_view()
    {
        return $this->db->select('*')
            ->from('notice_board')
            ->order_by('notice_id', 'desc')
            ->get()
            ->result();
    }
    public function notification_create($data = array())
    {
        return $this->db->insert('notification', $data);
    }
    public function notifications()
    {
        $user_id = $this->session->userdata('id');
        $this->db->select('notification.*,employee_history.first_name fname,employee_history.last_name lname,user.firstname ufname');
        $this->db->from('notification');
        $this->db->join('employee_history', 'employee_history.employee_id=notification.emp_id');
        $this->db->join('user', 'user.id=notification.created_by');
        if ($this->session->userdata('isAdmin') == 1) {
        } else {
            $this->db->where('notification.emp_id', $id);
        }
        $results = $this->db->get()->result();
        return $results;
    }
    public function notice_delete($id = null)
    {
        $this->db->where('id', $id)
            ->delete('notification');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function notification_update($data, $id)
    {
        return $this->db->where('id', $id)
            ->update("notification", $data);
    }
    public function notice_updateForm($id)
    {
        $this->db->where('notice_id', $id);
        $query = $this->db->get('notice_board');
        return $query->row();
    }
    public function details($id)
    {
        return $this->db->select('*')
            ->from('notice_board')
            ->where('notice_id', $id)
            ->get()
            ->result();
    }
}
