<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Notification extends MX_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'Notification_model',
        ));
        if (!$this->session->userdata('isLogIn')) {
            redirect('login?rback=' . uri_string());
        }

    }
    public function index()
    {
        $data['title'] = 'Notification';
        $data['module'] = "notification";
        $data['page'] = "index";
        $data['results'] = $this->view_details();
        echo Modules::run('template/layout', $data);
    }
    public function view_details($id = null)
    {
        $this->db->select('notification.*,notification.id,COALESCE(employee_history.first_name, department.department_name) fname,employee_history.last_name lname,user.firstname ufname');
        $this->db->from('notification');
        $this->db->join('employee_history', 'employee_history.employee_id=notification.emp_id', 'left');
        $this->db->join('department', 'department.dept_id=notification.dept_id', 'left');
        $this->db->join('user', 'user.id=notification.created_by', 'left');
        $this->db->order_by('notification.id', 'desc');
        if ($this->session->userdata('isAdmin') != 1) {
            $userId = $this->session->userdata('employee_id');
            $this->db->group_start();
            $this->db->or_where('notification.emp_id', $userId);
            $this->db->or_where('notification.dept_id', $this->session->userdata('dept_id'));
            $this->db->group_end();
        }
        if (isset($id)) {
            $this->db->where('notification.id', $id);
            echo json_encode($this->db->get()->result());
        } else {
            return $this->db->get()->result();
        }
    }
    public function statusChange($ele)
    {
        $status = $this->db->where('id', $ele)->update('notification', ['viewed' => '1']);
        if ($status) {
            echo 1;
        } else {
            echo 0;
        }
    }
    public function countNotification()
    {
        $this->db->select('count(*) as noti');
        $this->db->from('notification');
        if ($this->session->userdata('isAdmin') != 1) {
            $userId = $this->session->userdata('employee_id');
            $this->db->group_start();
            $this->db->where('emp_id', $userId);
            $this->db->or_where('notification.dept_id', $this->session->userdata('dept_id'));
            $this->db->group_end();
        }
        $this->db->where('notification.viewed is null');
        $result = $this->db->get()->result();
        if ($result) {
            echo json_encode($result[0]->noti);
        } else {
            echo 0;
        }
    }
    public function editData()
    {
        $id = $this->input->post('id');
        // echo $query = "select * from notification where id= $id";
        $result = $this->db->select('notification.*,employee_history.first_name as fname,employee_history.last_name as lname')->from('notification')
            ->join('employee_history', 'employee_history.employee_id=notification.emp_id')
            ->where('notification.id', $id)->get()->result();
        echo json_encode($result);
    }
    public function create_notification($id = null)
    {
        $this->form_validation->set_rules('text', display('notice_description'), 'required');
        $this->form_validation->set_rules('date', display('notice_date'), 'required');
        $this->form_validation->set_rules('emp_id', 'Employeer Name', 'required|max_length[50]');
        #-------------------------------#
        // print_r($this->input->post());exit;
        if ($this->form_validation->run() === true) {
            $postData = [
                'text' => $this->input->post('text', true),
                'date' => date('Y-m-d', strtotime($this->input->post('date', true))),
                'emp_id' => $this->input->post('emp_id', true),
                'created_by' => $this->session->userdata('id'),
            ];
            if (isset($id)) {
                $edit = $this->Notification_model->notification_update($postData, $id);
            } else {
                $create = $this->Notification_model->notification_create($postData);
            }
            if ($create) {
                $this->session->set_flashdata('message', display('successfully_created'));
            } else if ($edit) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("notification/Notification");
        } else {
            $data['title'] = 'Notification';
            $data['module'] = "notification"; //
            $data['results'] = $this->view_details();
            $data['page'] = "index";
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_notification($id = null)
    {
        $this->permission->method('notification', 'delete')->redirect();
        if ($this->Notification_model->notice_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("notification/Notification");
    }
    public function getEmployees()
    {
        $post = $_POST['searchTerm'];
        $this->db->select('*')->from('employee_history');
        $this->db->like(['first_name' => $post]);
        if ($this->session->userdata('isAdmin') == 1) {
        } else {
            $userId = $this->session->userdata('employee_id');
            $this->db->where('employee_history.employee_id', $userId);
        }
        $e = $this->db->get()->result();
        $data = array();
        foreach ($e as $key => $value) {
            $data[] = array('id' => $value->employee_id, 'text' => $value->first_name . ' ' . $value->last_name);
        }
        echo json_encode($data);
    }
}
