<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Employees_model extends CI_Model
{
	public function get_expiring_probations($days = 5)
	{
		return $this->db->query("SELECT *, DATE_ADD(hire_date, INTERVAL probation_period MONTH) as expires_on FROM employee_history WHERE duty_type = 5 AND probation_notified = 0 AND DATE_ADD(hire_date, INTERVAL probation_period MONTH) <= DATE_ADD(NOW(), INTERVAL $days DAY) AND DATE_ADD(hire_date, INTERVAL probation_period MONTH) >= NOW();")->result();
	}
    public function employee()
    {
        $this->db->select('*');
        $this->db->from('employee_history');
        $query = $this->db->get();
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->employee_id] = $value->first_name . ' ' . $value->last_name;
            }
        }
        return $list;
    }
    public function incident_list($table, $id = null)
    {
        if (isset($id)) {
            $this->db->where('id', $id);
        }
        return $this->db->get($table)->result();
    }
    public function get_dropdown_emp_pos($id)
    {
        $query = $this->db->get_where('employee_history', array('employee_id' => $id));
        return $query->row_array();
    }
    public function get_pos($id)
    {
        $query = $this->db->get_where('employee_history', array('employee_id' => $id));
        return $query->row_array();
    }
/* ###########....Employee Salary Setup Start ....##################################  */
    public function salary_setupView()
    {
        return $this->db->select('*')
            ->from('employee_salary_setup')
            ->order_by('emp_sal_set_id', 'desc')
            ->get()
            ->result();
    }
    public function emp_salsetup_create($data = array())
    {
        return $this->db->insert('employee_salary_setup', $data); //
    }
    public function create_employee($data = array())
    {
        $this->db->insert('employee_history', $data);
        $insert_id = $this->db->insert_id();
        return $insert_id;
    }
    public function emp_salstup_delete($id = null)
    {
        $this->db->where('emp_sal_set_id', $id)
            ->delete('employee_salary_setup');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function update_em_salstup($data = array())
    {
        return $this->db->where('emp_sal_set_id', $data["emp_sal_set_id"])
            ->update("employee_salary_setup", $data);
    }
    public function salarysetup_updateForm($id)
    {
        $this->db->where('emp_sal_set_id', $id);
        $query = $this->db->get('employee_salary_setup');
        return $query->row();
    }
    /* ###########....Employee Salary Setup End ....##################################  */
    /* ###########...Employee Performance Start ....##################################  */
    public function emp_performanceView()
    {
        return $this->db->select('count(DISTINCT(per.emp_per_id)) as emp_per_id,per.*,p.employee_id,p.first_name,p.last_name')
            ->from('employee_performance per')
            ->join('employee_history p', 'per.employee_id = p.employee_id', 'left')
            ->group_by('per.emp_per_id')
            ->order_by('per.emp_per_id', 'desc')
            ->get()
            ->result();
    }
    public function emp_performance_create($data = array())
    {
        return $this->db->insert('employee_performance', $data);
    }
    public function bank_list()
    {
        return $this->db->select('*')
            ->from('bank_information')
            ->get()
            ->result_array();
    }
    public function emp_performance_delete($id = null)
    {
        $this->db->where('emp_per_id', $id)
            ->delete('employee_performance');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function get_performaceempid($id)
    {
        $query = $this->db->get_where('employee_performance', array('emp_per_id' => $id));
        return $query->row_array();
    }
    public function update_em_performance($data = array())
    {
        return $this->db->where('emp_per_id', $data["emp_per_id"])
            ->update("employee_performance", $data);
    }
    public function emp_performance_updateForm($id)
    {
        $result = $this->db->select('a.*,b.first_name,b.last_name')
            ->from('employee_performance a')
            ->join('employee_history b', 'a.employee_id = b.employee_id')
            ->where('emp_per_id', $id)
            ->get()
            ->row();
        return $result;
    }
    /* ###########....Employee Performance End ....##################################  */
    /* ###########...Employee Payment Start ....##################################  */
    public function emp_paymentView($limit = null, $start = null)
    {
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        $employee_id = $this->session->userdata('employee_id');
        $this->db->select('count(DISTINCT(pment.emp_sal_pay_id)) as emp_sal_pay_id,pment.*,p.employee_id,p.first_name,p.last_name, p.email')
            ->from('employee_salary_payment pment')
            ->join('employee_history p', 'pment.employee_id = p.employee_id', 'left');
        if ($admin != 1) {
            if ($is_supervisor == 1) {
                $this->db->where('p.super_visor_id', $employee_id);
                $this->db->or_where('p.employee_id', $employee_id);
                $this->db->or_where('p.indirect_super_visor_id', $employee_id);
            } else {
                $this->db->where('p.employee_id', $employee_id);
            }
        }
        return $this->db->group_by('pment.emp_sal_pay_id')
            ->order_by('pment.emp_sal_pay_id', 'desc')
            ->limit($limit, $start)
            ->get()
            ->result();
    }
    public function create_employee_payment($data = array())
    {
        return $this->db->insert('employee_salary_payment', $data);
    }
    public function emp_payment_delete($id = null)
    {
        $this->db->where('emp_sal_pay_id', $id)
            ->delete('employee_salary_payment');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function update_payment($data = array())
    {
        return $this->db->where('emp_sal_pay_id', $data["emp_sal_pay_id"])
            ->update("employee_salary_payment", $data);
    }
    public function payment_updateForm($id)
    {
        $result = $this->db->select('a.*,b.first_name,b.last_name')
            ->from('employee_salary_payment a')
            ->join('employee_history b', 'a.employee_id=b.employee_id')
            ->where('emp_sal_pay_id', $id)
            ->get()
            ->row();
        return $result;
    }
    /* ###########...Employee Payment End ....##################################  */
    /* ###########...Employee sALARY PayType Start ....##################################  */
    public function emp_salPaytypeView()
    {
        return $this->db->select('*')
            ->from('employee_sal_pay_type')
            ->order_by('emp_sal_pay_type_id', 'desc')
            ->get()
            ->result();
    }
    public function emp_payment_type_delete($id = null)
    {
        $this->db->where('emp_sal_pay_type_id', $id)
            ->delete('employee_sal_pay_type');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
/*------- payment */
    public function employee_details($id)
    {
        return $this->db->select('p.*,d.*,po.position_name, g.gender_name as gender, m.marital_sta as marital_status, dt.type_name as duty_type')
            ->from('employee_history p')
            ->join('department d', 'p.dept_id = d.dept_id', 'left')
            ->join('gender g', 'p.gender = g.id', 'left')
            ->join('marital_info m', 'p.marital_status = m.id', 'left')
            ->join('duty_type dt', 'p.duty_type = dt.id', 'left')
            ->join('position po', 'p.pos_id = po.pos_id', 'left')
            ->where('p.employee_id', $id)
            ->get()
            ->row();
    }
    public function supervisorlist()
    {
        return $this->db->select('*')
            ->from('employee_history')
            ->where('is_super_visor', 1)
            ->order_by('emp_his_id', 'desc')
            ->get()
            ->result();
    }
    public function emp_historyview()
    {
        return $this->db->select('*')
            ->from('employee_history')
            ->group_by('employee_id')
            ->order_by('emp_his_id', 'desc')
            ->get()
            ->result();
    }
    //Employee list
    public function emp_list()
    {
        $this->db->select('p.*,d.department_name,po.position_name,dt.type_name,rt.r_type_name as rd_type,gd.gender_name,ms.marital_sta,pf.frequency_name');
        $this->db->from('employee_history p');
        $this->db->join('department d', 'p.dept_id = d.dept_id', 'left');
        $this->db->join('position po', 'p.pos_id = po.pos_id', 'left');
        $this->db->join('duty_type dt', 'p.duty_type = dt.id', 'left');
        $this->db->join('rate_type rt', 'p.rate_type = rt.id', 'left');
        $this->db->join('gender gd', 'p.gender = gd.id', 'left');
        $this->db->join('marital_info ms', 'p.marital_status = ms.id', 'left');
        $this->db->join('pay_frequency pf', 'p.pay_frequency = pf.id', 'left');
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        // if($admin != 1){
        $employee_id = $this->session->userdata('employee_id');
        if ($admin != 1 && !$this->permission->method('manage_employee', 'read')->access()) {
            if ($is_supervisor == 1) {
                $this->db->where('p.super_visor_id', $employee_id);
                $this->db->or_where('p.employee_id', $employee_id);
                $this->db->or_where('p.indirect_super_visor_id', $employee_id);
            } else {
                $this->db->where('p.employee_id', $employee_id);
            }
        }
        $this->db->order_by('p.emp_his_id', 'desc');
        $query = $this->db->get();
        return $report = $query->result();
    }
    public function insert_employee($data = array())
    {
        return $this->db->insert('employee_history', $data); //
    }
    public function emplyee_history_delete($id = null)
    {
        $this->db->where('employee_id', $id)
            ->delete('employee_history');
        if ($this->db->affected_rows()) {
            $this->db->where('employee_id', $id)
                ->delete('custom_table');
            $this->db->where('employee_id', $id)
                ->delete('employee_benifit');
            return true;
        } else {
            return false;
        }
    }
    public function position_create($data = array())
    {
        return $this->db->insert('position', $data);
    }
    public function viewPosition()
    {
        return $this->db->select('*')
            ->from('position')
            ->order_by('pos_id', 'desc')
            ->get()
            ->result();
    }
    public function update_position($data = array())
    {
        return $this->db->where('pos_id', $data["pos_id"])
            ->update("position", $data);
    }
    public function delete_p($id = null)
    {
        $this->db->where('pos_id', $id)
            ->delete('position');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function pos_updateForm($id)
    {
        $this->db->where('pos_id', $id);
        $query = $this->db->get('position');
        return $query->row();
    }
    //update form employee ----
    public function update_employee($data = array())
    {
        //echo '<pre>';
        // print_r($data);
        // exit;
        return $this->db->where('employee_id', $data["employee_id"])->update("employee_history", $data);
//         echo $this->db->last_query();
    }
    public function employee_updateForm($id)
    {
        $this->db->where('employee_id', $id);
        $query = $this->db->get('employee_history');
        return $query->row();
    }
    public function updateedu($id)
    {
        return $this->db->select('*')
            ->from('employee_history')
            ->where('employee_id', $id)
            ->get()
            ->result();
    }
    public function workupdat($id)
    {
        return $this->db->select('company_name,working_period,duties, 	supervisor')
            ->from('employee_history')
            ->where('employee_id', $id)
            ->get()
            ->result();
    }
    public function dropdown()
    {
        $this->db->select('*');
        $this->db->from('position');
        $query = $this->db->get();
        $data = $query->result();
        $list = array('' => 'Select One...');
        if (!empty($data)) {
            foreach ($data as $value) {
                $list[$value->position_name] = $value->position_name;
            }
        }
        return $list;
    }
    public function dropdowndept()
    {
        $this->db->select('*');
        $this->db->from('department');
        $this->db->where('parent_id', 0);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function dropdowndev()
    {
        $this->db->select('*');
        $this->db->from('devisions');
        // $this->db->where('parent_id',0);
        $query = $this->db->get();
        return $query->result_array();
    }
    public function designation()
    {
        $this->db->select('*');
        $this->db->from('position');
        $query = $this->db->get();
        return $data = $query->result();
    }
    //Emplyee search
    public function employee_search($keyword)
    {
        $this->db->select('p.*,d.department_name,po.position_name,dt.type_name,rt.r_type_name,gd.gender_name,ms.marital_sta');
        $this->db->from('employee_history p');
        $this->db->join('department d', 'p.division_id = d.dept_id', 'left');
        $this->db->join('position po', 'p.pos_id = po.pos_id', 'left');
        $this->db->join('duty_type dt', 'p.duty_type = dt.id', 'left');
        $this->db->join('rate_type rt', 'p.rate_type = rt.id', 'left');
        $this->db->join('gender gd', 'p.gender = gd.id', 'left');
        $this->db->join('marital_info ms', 'p.marital_status = ms.id', 'left');
        $this->db->or_like(
            array(
                'p.employee_id' => $keyword,
                'po.position_name' => $keyword,
                'p.first_name' => $keyword,
                'p.last_name' => $keyword,
                'p.maiden_name' => $keyword,
                'p.email' => $keyword,
                'p.phone' => $keyword,
                'p.alter_phone' => $keyword,
                'p.present_address' => $keyword,
                'p.parmanent_address' => $keyword,
                'd.department_name' => $keyword,
                'p.state' => $keyword,
                'p.city' => $keyword,
                'p.zip' => $keyword,
                'dt.type_name' => $keyword,
                'p.hire_date' => $keyword,
                'p.original_hire_date' => $keyword,
                'p.termination_date' => $keyword,
                'p.termination_reason' => $keyword,
                'p.voluntary_termination' => $keyword,
                'p.rehire_date' => $keyword,
                'rt.r_type_name' => $keyword,
                'p.rate' => $keyword,
                'p.pay_frequency' => $keyword,
                'p.pay_frequency_txt' => $keyword,
                'p.hourly_rate2' => $keyword,
                'p.hourly_rate3' => $keyword,
                'p.home_department' => $keyword,
                'p.department_text' => $keyword,
                'p.super_visor_id' => $keyword,
                'p.supervisor_report' => $keyword,
                'p.dob' => $keyword,
                'gd.gender_name' => $keyword,
                'ms.marital_sta' => $keyword,
                'p.ethnic_group' => $keyword,
                'p.eeo_class_gp' => $keyword,
                'p.ssn' => $keyword,
                'p.work_in_state' => $keyword,
                'p.live_in_state' => $keyword,
                'p.home_email' => $keyword,
                'p.business_email' => $keyword,
                'p.home_phone' => $keyword,
                'p.business_phone' => $keyword,
                'p.cell_phone' => $keyword,
                'p.emerg_contct' => $keyword,
                'p.emrg_h_phone' => $keyword,
                'p.emrg_w_phone' => $keyword,
                'p.emgr_contct_relation' => $keyword,
                'p.alt_em_contct' => $keyword,
                'p.alt_emg_h_phone' => $keyword,
                'p.alt_emg_w_phone' => $keyword,
            ));
        $query = $this->db->get();
        return $report = $query->result();
    }
    public function customifo($id)
    {
        $this->db->select('*');
        $this->db->from('custom_table');
        $this->db->where('employee_id', $id);
        $query = $this->db->get();
        return $query->result();
    }
    public function benifit($id)
    {
        $this->db->select('*');
        $this->db->from('employee_benifit');
        $this->db->where('employee_id', $id);
        $query = $this->db->get();
        return $query->result();
    }
    public function award($id)
    {
        $this->db->select('*');
        $this->db->from('award ');
        $this->db->where('employee_id', $id);
        $query = $this->db->get();
        return $query->result();
    }
    public function performance($id)
    {
        $this->db->select('AVG(number_of_star) as star');
        $this->db->from('employee_performance ');
        $this->db->where('employee_id', $id);
        $query = $this->db->get();
        $result = $query->row();
        return $star = $result->star;
    }
    public function employee_leaves($id)
    {
        $this->db->select('el.leave_qouta leaves,lt.leave_type as ltype');
        $this->db->from('employee_leaves el');
        $this->db->join('leave_type lt', 'lt.leave_type_id=el.leave_type');
        // $this->db->join('employee_history eh','eh.employee_id=el.emp_id');
        $this->db->where('el.emp_id', $id);
        return $this->db->get()->result();
    }
    public function headcode()
    {
        $query = $this->db->query("SELECT MAX(HeadCode) as HeadCode FROM acc_coa WHERE HeadLevel='2' And HeadCode LIKE '502020000%'");
        return $query->row();
    }
    public function create_coa($data = [])
    {
        $this->db->insert('acc_coa', $data);
        return true;
    }
    public function leave_type()
    {
        $this->db->select('*');
        $this->db->from('leave_type');
        return $this->db->get()->result();
    }
    public function save_performance_review($data = array(), $userId = null)
    {
        $this->db->select('*');
        $this->db->from('employee_history');
        $this->db->where(array("emp_his_id" => $data['EmployeeName']));
        $emp = $this->db->get()->row();
        // Insert Object Parent Data...
        $data_boj['employee_name'] = $emp->first_name . ' ' . $emp->last_name;
        $data_boj['employee_id'] = $emp->employee_id;
        $data_boj['job_title'] = $data['JobTitle'];
        $data_boj['midYearAvarage'] = $data['Objectives']['MidYearAvarage'];
        $data_boj['endYearAvarage'] = $data['Objectives']['EndYearAvarage'];
        $data_boj['midYearComments'] = $data['Objectives']['MidYearComments'];
        $data_boj['endYearComments'] = $data['Objectives']['EndYearComments'];
        $data_boj['valueType'] = 0;
        $data_boj['behave_midYearAvarage'] = $data['Behaviors']['MidYearAvarage'];
        $data_boj['behave_endYearAvarage'] = $data['Behaviors']['EndYearAvarage'];
        $data_boj['behave_midYearComments'] = $data['Behaviors']['MidYearComments'];
        $data_boj['behave_endYearComments'] = $data['Behaviors']['EndYearComments'];
        $data_boj['isPublish'] = $data['isPublished'];
        $data_boj['status'] = 1;
        $data_boj['created_by'] = $userId;
        $data_obj['created_at'] = date('Y-m-d H:i:s', strtotime("now"));
        $data_obj['created_date'] = date('Y', strtotime("now"));
        $this->db->insert('employee_behavior_objectives_joined', $data_boj);
        $lastID = $this->db->insert_id();
        // Insert Object Datas
        $obj_counter = 0;
        if (count($data['Obj']) > 0) {
            foreach ($data['Obj'] as $key => $values) {
                $data_obj['eboj_fk_id'] = $lastID;
                $data_obj['name'] = $data['Objectives']['name'][$obj_counter];
                $data_obj['weightage'] = $values['Weightage'];
                $data_obj['midYearRating'] = $values['MidYearRating'];
                $data_obj['yearEndRating'] = $values['YearEndRating'];
                $data_obj['midYearValue'] = $values['MidYearValue'];
                $data_obj['yearEndValue'] = $values['YearEndValue'];
                $data_obj['keyValue'] = $key;
                $data_obj['created_at'] = date('Y-m-d H:i:s', strtotime("now"));
                $data_obj['created_by'] = $userId;
                $this->db->insert('employee_objectives', $data_obj);
                $obj_counter++;
            }
        }
        // Insert Behavior Datas
        $behave_counter = 0;
        if (count($data['Obj']) > 0) {
            foreach ($data['Behave'] as $keys => $value) {
                $data_behave['eboj_fk_id'] = $lastID;
                $data_behave['name'] = $data['Behaviors']['name'][$behave_counter];
                $data_behave['midYearRating'] = $value['MidYearRating'];
                $data_behave['yearEndRating'] = $value['YearEndRating'];
                $data_behave['keyValue'] = $keys;
                $data_behave['created_at'] = date('Y-m-d H:i:s', strtotime("now"));
                $data_behave['created_by'] = $userId;
                $this->db->insert('employee_behaviors', $data_behave);
                $behave_counter++;
            }
        }
//         echo "Obaidrehman07 <pre>";
        //         print_r($data); die;
        return true;
    }
    public function list_performance_reviews($data = array())
    {
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        $employee_id = $this->session->userdata('employee_id');
        $this->db->select('boj.*, u.firstname, u.lastname');
        $this->db->from('employee_behavior_objectives_joined as boj');
        $this->db->join('user u', 'boj.created_by = u.id');
        $this->db->join('employee_history p', 'p.employee_id = boj.employee_id');
        if (isset($data['employee_id']) && isset($data['year']) && !empty($data['employee_id']) && !empty($data['year'])) {
            $this->db->where(array("employee_id" => $data['employee_id'], "created_date" => $data['year']));
        } else {
            if ($admin != 1) {
                if ($is_supervisor == 1) {
                    $this->db->where('p.super_visor_id', $employee_id);
                    $this->db->or_where('p.employee_id', $employee_id);
                    $this->db->or_where('p.indirect_super_visor_id', $employee_id);
                } else {
                    $this->db->where('p.employee_id', $employee_id);
                }
            }
        }
        return $this->db->get()->result();
    }
    public function employeeRecord($id)
    {
        $this->db->select('p.*,po.position_name');
        $this->db->from('employee_history p');
        $this->db->join('position po', 'p.pos_id = po.pos_id');
        $this->db->where('p.emp_his_id', $id);
        $query = $this->db->get();
        return $query->row();
    }
    public function behavior_objectives_joined($id)
    {
        $this->db->select('*');
        $this->db->from('employee_behavior_objectives_joined');
        $this->db->where('id', $id);
        $query = $this->db->get();
//         echo "<pre>"; print_r($query->row()); die;
        return $query->row();
    }
    public function employee_objectives($id)
    {
        $this->db->select('*');
        $this->db->from('employee_objectives');
        $this->db->where('eboj_fk_id', $id);
        $query = $this->db->get();
        return $query->result();
    }
    public function employee_behaviors($id)
    {
        $this->db->select('*');
        $this->db->from('employee_behaviors');
        $this->db->where('eboj_fk_id', $id);
        $query = $this->db->get();
        return $query->result();
    }
    public function save_performance_review_draft($data = array(), $userId = null)
    {
        $this->db->select('*');
        $this->db->from('employee_history');
        $this->db->where(array("emp_his_id" => $data['EmployeeName']));
        $emp = $this->db->get()->row();
        // Insert Object Parent Data...
        $data_boj['employee_name'] = $emp->first_name . ' ' . $emp->last_name;
        $data_boj['employee_id'] = $emp->employee_id;
        $data_boj['job_title'] = $data['JobTitle'];
        $data_boj['midYearAvarage'] = $data['Objectives']['MidYearAvarage'];
        $data_boj['endYearAvarage'] = $data['Objectives']['EndYearAvarage'];
        $data_boj['midYearComments'] = $data['Objectives']['MidYearComments'];
        $data_boj['endYearComments'] = $data['Objectives']['EndYearComments'];
        $data_boj['valueType'] = 0;
        $data_boj['behave_midYearAvarage'] = $data['Behaviors']['MidYearAvarage'];
        $data_boj['behave_endYearAvarage'] = $data['Behaviors']['EndYearAvarage'];
        $data_boj['behave_midYearComments'] = $data['Behaviors']['MidYearComments'];
        $data_boj['behave_endYearComments'] = $data['Behaviors']['EndYearComments'];
        $data_boj['isPublish'] = 1;
        $data_boj['status'] = 1;
        $data_boj['created_by'] = $userId;
        $this->db->where('id', $data['formId']);
        $this->db->update('employee_behavior_objectives_joined', $data_boj);
        $lastID = $data['formId'];
        $this->db->where('eboj_fk_id', $data['formId']);
        $this->db->delete('employee_objectives');
        $this->db->where('eboj_fk_id', $data['formId']);
        $this->db->delete('employee_behaviors');
        // Insert Object Datas
        $obj_counter = 0;
        if (count($data['Obj']) > 0) {
            foreach ($data['Obj'] as $key => $values) {
                $data_obj['eboj_fk_id'] = $lastID;
                $data_obj['name'] = $data['Objectives']['name'][$obj_counter];
                $data_obj['weightage'] = $values['Weightage'];
                $data_obj['midYearRating'] = $values['MidYearRating'];
                $data_obj['yearEndRating'] = $values['YearEndRating'];
                $data_obj['midYearValue'] = $values['MidYearValue'];
                $data_obj['yearEndValue'] = $values['YearEndValue'];
                $data_obj['keyValue'] = $key;
                $data_obj['created_at'] = date('Y-m-d H:i:s', strtotime("now"));
                $data_obj['created_by'] = $userId;
                $this->db->insert('employee_objectives', $data_obj);
                $obj_counter++;
            }
        }
        // Insert Behavior Datas
        $behave_counter = 0;
        if (count($data['Obj']) > 0) {
            foreach ($data['Behave'] as $keys => $value) {
                $data_behave['eboj_fk_id'] = $lastID;
                $data_behave['name'] = $data['Behaviors']['name'][$behave_counter];
                $data_behave['midYearRating'] = $value['MidYearRating'];
                $data_behave['yearEndRating'] = $value['YearEndRating'];
                $data_behave['keyValue'] = $keys;
                $data_behave['created_at'] = date('Y-m-d H:i:s', strtotime("now"));
                $data_behave['created_by'] = $userId;
                $this->db->insert('employee_behaviors', $data_behave);
                $behave_counter++;
            }
        }
//         echo "Obaidrehman07 <pre>";
        //         print_r($data); die;
        return true;
    }
    public function reviews_360_create($data = array())
    {
        return $this->db->insert('employee_360_reviews', $data); //
    }
    public function reviews_360_list($data = array())
    {
        $this->db->select("
            r.*,
            u.firstname as u_firstname,
            u.lastname as u_lastname,
            p.first_name,
            p.last_name
        ")
            ->from('employee_360_reviews r')
            ->join('employee_history p', 'r.reviewed_for = p.employee_id')
            ->join('user u', 'r.reviewed_by = u.id', 'left');
        $this->db->order_by('p.first_name', 'desc');
        // ->get()
        // ->result();
        // echo "obaidrehman07"; die;
        if (isset($data['ReviewedBy']) && isset($data['ReviewedFor']) && !empty($data['ReviewedBy']) && !empty($data['ReviewedFor'])) {
            if (isset($data['date_at']) && !empty($data['date_at'])) {
                $this->db->like('created_at', date('Y-m-d', strtotime($data['date_at'])));
            }
            $this->db->where(array("reviewed_by" => $data['ReviewedBy'], "reviewed_for" => $data['ReviewedFor']));
            return $this->db->get()->result();
        } else {
            if (isset($data['date_at']) && !empty($data['date_at'])) {
                $this->db->like('created_at', date('Y-m-d', strtotime($data['date_at'])));
                return $this->db->get()->result();
            } else {
                return $this->db->get()->result();
            }
        }
    }
    public function reviews_360_delete($id = null)
    {
        $this->db->where('id', $id)->delete('employee_360_reviews');
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function reviews_360_get($id = null)
    {
        $query = $this->db->where('id', $id)->get('employee_360_reviews');
        if ($this->db->affected_rows()) {
            return $query->row();
        } else {
            return false;
        }
    }
    public function reviews_360_update($data, $id = null)
    {
        $query = $this->db->where('id', $id)->update('employee_360_reviews', $data);
        if ($this->db->affected_rows()) {
            return true;
        } else {
            return false;
        }
    }
    public function feedbackSubmitting($data = array(), $userId)
    {
        $query = $this->db->where(array('id' => $data['feedbackId'], 'feedback_created_at' => null))->get('employee_behavior_objectives_joined');
        if ($this->db->affected_rows()) {
            $datas['feedback'] = $data['feedback'];
            $datas['feedback_created_at'] = date("Y-m-d H:i:s", strtotime("now"));
            $datas['feedback_created_by'] = $userId;
            $this->db->where('id', $data['feedbackId'])->update('employee_behavior_objectives_joined', $datas);
            return true;
        } else {
            $data_up['feedback'] = $data['feedback'];
            $data_up['feedback_updated_at'] = date("Y-m-d H:i:s", strtotime("now"));
            $data_up['feedback_updated_by'] = $userId;
            $this->db->where('id', $data['feedbackId'])->update('employee_behavior_objectives_joined', $data_up);
            return true;
        }
    }
    public function get_addtions($emp_id)
    {
        $data = getByWhereAsArray('emp_salary_setup_details', '*', ['employee_id' => $emp_id, 'addition_id !=' => null]);
        $ret = [];
        foreach ($data as $dt) {
            $ret[$dt['addition_id']] = $dt;
        }
        return $ret;
    }
    public function get_deductions($emp_id)
    {
        $data = getByWhereAsArray('emp_salary_setup_details', '*', ['employee_id' => $emp_id, 'deduction_id !=' => null]);
        $ret = [];
        foreach ($data as $dt) {
            $ret[$dt['deduction_id']] = $dt;
        }
        return $ret;
    }
}
