<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Employees_warning extends MX_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->db->query('SET SESSION sql_mode = ""');
		$this->load->model(array(
			'Employees_model',
			'Country_model'	
		));	

			$this->load->library("PHPMailer_Library");
			$this->load->library('zklibrary'); 
//$this->load->library("PHPMailer_Library");
			if (! $this->session->userdata('isLogIn'))
			redirect('login?rback=' . uri_string());
	}

    public function getTemplateCategory(){
           $post = $_POST['searchTerm'];
            $e = $this->db->select('*')->from('template_category')->like(['name'=>$post])->get()->result();
            $data  = array();
            foreach ($e as $key => $value) {
                $data[] =array('id'=>$value->id,'text'=>$value->name);
            }
            echo json_encode($data);
            exit;
    }
    
    public function getTemplateByCategory(){
        $cat = $this->input->post('category_id');
        $result = $this->db->select('*')->from('document_template')->where('category_id',$cat)->get()->result();
        echo json_encode($result);
    }

    public function getTemplateByCategories(){
        $cat = $this->input->post('category_id');
        $result = $this->db->select('*')->from('document_template')->where('category_id',$cat)->get()->result();
        $html = "";
        // $html .= "<option></option>";
        foreach($result as $key=>$value){
                $html .= "<option value=".$value->id." >".$value->name."</option>";
        }
        echo $html;
    }


    public function getTemplateById(){
        $id = $this->input->post('id');
        $result = $this->db->select('*')->from('document_template')->where('id',$id)->get()->result();
        echo json_encode($result);
    }


	public function employeeWarning(){
		$data['title']     = "Employee Warning";
        $data['module']    = "employee";
        $data['page']      = "employee_warning";
        $this->db->select('ew.id as id,eh.first_name emp_name,ew.reason reason,dt.name template_name,ew.created_on date');
        $this->db->from('employee_warning ew');
        $this->db->join('employee_history eh','eh.employee_id=ew.emp_id')->join('document_template dt','ew.template_id=dt.id');

        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        if($admin != 1){
            $employee_id = $this->session->userdata('employee_id');
            if($is_supervisor == 1){
                $this->db->where('super_visor_id',$employee_id);
                $this->db->or_where('employee_id',$employee_id);
                $this->db->or_where('indirect_super_visor_id',$employee_id);
            // $data['emp_history']= $this->Employees_model->emp_list();
            // echo Modules::run('template/layout', $data); 
            }
            else{
                // $id = $this->session->userdata('employee_id');
                $this->db->where('employee_id',$employee_id);
            }
        }
        $result  = $this->db->get()->result();
        $data['warning'] = $result;
        echo modules::run('template/layout', $data);
	}

	public function update_warning($id=null){

		$this->form_validation->set_rules('emp_id','Employeer Name'  ,'required');
        $this->form_validation->set_rules('reason','Reason'  ,'required');
        $this->form_validation->set_rules('category_id','Category'  ,'required');
        $this->form_validation->set_rules('template_name','Template Name'  ,'required');
        $this->form_validation->set_rules('template','Template'  ,'required');

		$post = $this->input->post();
		$return = 0;
        if ($this->form_validation->run() === true) {
        	$return = 1;
        	$data['emp_id'] =  $post['emp_id'];
        	$data['reason'] =  $post['reason'];
        	$data['template_id'] =  $post['template_name'];
        	$data['text'] =  $post['template'];
        	if(isset($id)){
	            $updateData = $this->db->where('id',$id)->update('employee_warning',$data);
        	}else{
        		$data['created_on'] = date('Y-m-d');
	            $data['created_by'] = $this->session->userdata('id');	
        		$updateData = $this->db->insert('employee_warning',$data);
        // 		if($updateData){

		    		// $emp = $this->db->select('*')
		    		// 			->from('employee_history')
		    		// 			->where('employee_id',$data['emp_id'])
		    		// 			->get()->first_row();

		    		// $tmp = $this->db->select('*')
		    		// 			->from('document_template')
		    		// 			->where('id',$data['template_id'])
		    		// 			->get()->first_row();

		    		// // $sentEmail = $this->sendingEmailNew($emp->email,$emp->first_name,'Warning Issued',$tmp->template);
		    		// // if($sentEmail){
		    		// // 	$return = 1;
		    		// // }
        // 		}
        	}
            if($updateData && $return ==1){
                $this->session->set_flashdata('message', "Warning Updated Successfully!");
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("/employee/Employees_warning/employeeWarning");

        }else{
			$this->employeeWarning();
        }
	}

	public function getEmployeeWarnings(){
		$id = $this->input->post('id');
		$result  = $this->db->select('
									ew.id,eh.employee_id as emp_id,
									eh.first_name fname,eh.last_name lname,
                                    eh.email as email,
        							ew.reason reason,
        							dt.name template_name,
        							dt.category_id as category_id,
        							tc.name as category_name,
        							ew.template_id as template_id,
                                    ew.text as text')
        							->from('employee_warning ew')
        							->join('employee_history eh','eh.employee_id=ew.emp_id')
        							->join('document_template dt','ew.template_id=dt.id')
        							->join('template_category tc','tc.id=dt.category_id')
        							->where('ew.id',$id)
        							->get()
        							->result();
       	echo json_encode($result);
	}
	public function deleteWarning($id){
	    $this->db->where('id',$id)->delete('employee_warning');	
        $this->session->set_flashdata('message', "Warning Deleted Successfully!");
        redirect("/employee/Employees_warning/employeeWarning");
	}
	
	
	
	
    public function sendEmail(){
        $sent = 0;
		$id = $this->input->post('id');
        $result  = $this->db->select('
									ew.id,eh.employee_id as emp_id,
									eh.first_name fname,eh.last_name lname,
                                    eh.email as email,
        							ew.reason reason,
        							dt.name template_name,
        							dt.category_id as category_id,
        							tc.name as category_name,
        							ew.template_id as template_id,
                                    ew.text as text')
        							->from('employee_warning ew')
        							->join('employee_history eh','eh.employee_id=ew.emp_id')
        							->join('document_template dt','ew.template_id=dt.id')
        							->join('template_category tc','tc.id=dt.category_id')
        							->where('ew.id',$id)
        							->get()
        							->result();
        foreach($result as $key=>$value){
            $send = $this->sendingEmailNew($value->email,$value->fname.' '.$value->lname,'Important Notification From Admin',$value->text);
        }
        if($send){
         echo 1;   
        }
         
    }

	
    public function sendingEmailNew($sendToEmail=null,$name=null,$subject=null,$templatePath=null){
	    if($sendToEmail != null && $subject != null && $templatePath != null){
	        $mail = $this->phpmailer_library->load();
    		$mail->SMTPDebug = 0;                                 // Enable verbose debug output
    		$mail->SMTPOptions = array(
    			'ssl' => array(
    				'verify_peer' => false,
    				'verify_peer_name' => false,
    				'allow_self_signed' => true
    			)
    		);
    		$mail->Host = $this->config->item('smtp_host');  // Specify main and backup SMTP servers
    		$mail->isSMTP();
    		$mail->Port = $this->config->item('smtp_port');
    		$mail->SMTPAuth = true;
    		$mail->SMTPSecure = $this->config->item('smtp_crypto'); // Enable SMTP authentication
    		$mail->Username = $this->config->item('smtp_user'); // SMTP username
            $mail->Password = $this->config->item('smtp_pass');  // TCP port to connect to
    		$mail->setFrom($this->config->item('admin_info'), $this->config->item('mail_subject'));
    		$mail->addAddress($sendToEmail, $name);
    		$mail->isHTML(true);  // Set email format to HTML
    		$mail->Subject = $subject;
    		$mail->Body = $templatePath;   
    		if($mail->send()){
    		    return true;
    		    exit;
    		}
    		// else{
    		// 	print_r($mail);
    		// 	exit;
    		// }
        }
	}
	
	
}