<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Employees_resignation extends MX_Controller {

    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'Employees_model',
            'Country_model' 
        )); 

            $this->load->library('zklibrary'); 
            $this->load->library("PHPMailer_Library");
            if (! $this->session->userdata('isLogIn'))
            redirect('login?rback=' . uri_string());
    }

    public function employeeResignation(){
        $data['title']     = "Employee Resignation";
        $data['module']    = "employee";
        $data['page']      = "employee_resignations";
        $this->db->select('employee_resignation.*,employee_history.first_name emp_name');
        $this->db->from('employee_resignation');
        $this->db->join('employee_history','employee_resignation.emp_id=employee_history.employee_id');
        $admin = $this->session->userdata('isAdmin');
        $employee_id         = $this->session->userdata('employee_id');
        $is_supervisor       = $this->session->userdata('supervisor');
        $direct_supervisor   = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        if($this->session->userdata('isAdmin') ==1){

        }else{
         // $userId = $this->session->userdata('employee_id');
         // $this->db->where('employee_resignation.emp_id',$userId);


                if($this->input->post()){
                    $post = $this->input->post();
                    $to = $post['to'];
                    $from = $post['from'];
                    if($to && $from){
                        $this->db->where("employee_resignation.created_on BETWEEN '$to' and '$from'");
                    }
                    $employee_id = $post['emp_id'];
                    if($employee_id){
                        $this->db->where("employee_resignation.emp_id",$employee_id);   
                    }
                }

                if($is_supervisor == 1){
                    $this->db->where('employee_history.super_visor_id',$employee_id);
                    $this->db->or_where('employee_history.employee_id',$employee_id);
                    $this->db->or_where('employee_history.indirect_super_visor_id',$employee_id);
                }
                else{
                    $this->db->where('employee_history.employee_id',$employee_id);
                }
        }


        $this->db->order_by('employee_resignation.id','DESC');
        $result =  $this->db->get()->result();
        $data['resignation'] = $result;
        echo modules::run('template/layout', $data);

    }

    public function update_resignation($id=null){

        $this->form_validation->set_rules('emp_id','Employeer Name'  ,'required');
        $this->form_validation->set_rules('cause','Cause'  ,'required');
        $this->form_validation->set_rules('last_work_date','Last Work Date'  ,'required');
        $this->form_validation->set_rules('template','Template'  ,'required');

        $post = $this->input->post();
        $return = 0;
        if ($this->form_validation->run() === true) {
            $return = 1;
            $data['emp_id'] =  $post['emp_id'];
            $data['cause'] =  $post['cause'];
            $data['last_work_date'] =  $post['last_work_date'];
            $data['text'] =  $post['template'];

            if(isset($id)){
                $updateData = $this->db->where('id',$id)->update('employee_resignation',$data);
            }else{
                $data['created_on'] = date('Y-m-d');
                $data['created_by'] = $this->session->userdata('id');   
                $data['status'] = 'pending';   
                $updateData = $this->db->insert('employee_resignation',$data);
            }
            if($updateData && $return ==1){
                $this->session->set_flashdata('message', "Resignation Updated Successfully!");
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("/employee/Employees_resignation/employeeResignation");

        }else{
            $this->employeeResignation();
        }
    }

    public function getEmployeeResignation(){
     $id = $this->input->post('id');
     $this->db->select('employee_resignation.*,employee_history.first_name fname,employee_history.last_name lname');
     $this->db->from('employee_resignation');
     $this->db->join('employee_history','employee_resignation.emp_id=employee_history.employee_id');
     $this->db->where('employee_resignation.id',$id);
     $result = $this->db->get()->result();
     echo json_encode($result);
    }

    public function deleteResignation($id){
        $this->db->where('id',$id)->delete('employee_resignation');   
        $this->session->set_flashdata('message', "Resignation Deleted Successfully!");
        redirect("/employee/Employees_resignation/employeeResignation");
    }

    public function status_resignation(){
        $id = $this->input->post('id');
        $status = $this->input->post('status');
        $updateData = $this->db->where('id',$id)->update('employee_resignation',['status'=>$status]);
        if($status == 'inactive'){
            $emp_email = $this->db->select('employee_history.*')
                                  ->from('employee_history')
                                  ->join('employee_resignation','employee_resignation.emp_id=employee_history.employee_id')
                                  ->where('employee_resignation.id',$id)
                                  ->get()
                                  ->first_row();
            if($emp_email){
               $inactiveUser = $this->db->where('email',$emp_email->email)->update('user',array('status'=>0));
               if($inactiveUser){
                 $this->db->where('employee_id',$emp_email->employee_id)->update('employee_history',
                        array('termination_date'=>date('Y-m-d'),'resignation_date'=>date('Y-m-d')));
               }
            }
        }
        if($updateData){
            echo 1;
        }else{
            echo 0;
        }
    }


    // public function inactive_user(){
    //     $id = $this->input->post('id');
    //     $emp_email = $this->db->select('employee_history.*')->from('employee_history')
    //                           ->join('employee_resignation','employee_resignation.emp_id=employee_history.employee_id')
    //                           ->where('employee_resignation.id',$id)
    //                           ->get()->first_row();
    //     if($emp_email){
    //       $inactiveUser = $this->db->where('email',$emp_email->email)->update('user',array('status'=>0));
    //       if($inactiveUser){
    //         $status = $this->db->where('id',$id)->update('employee_resignation',array('status'=>"inactive"));
    //         if($status){
    //             echo 1;
    //         }
    //       }
    //     }


    // }


}