<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Employees_incident extends MX_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->db->query('SET SESSION sql_mode = ""');
		$this->load->model(array(
			'Employees_model',
			'Country_model'	
		));	

			$this->load->library("PHPMailer_Library");
			$this->load->library('zklibrary'); 
//$this->load->library("PHPMailer_Library");
			if (! $this->session->userdata('isLogIn'))
			redirect('login?rback=' . uri_string());
	}



	public function incident_type($id=null){
    $incident_type = $this->Employees_model->incident_list('incident_type',$id);
        if(isset($id)){
          echo json_encode($incident_type);
        }else{
          $data['title']    = 'Incident Type';
          $data['types']    = $incident_type;
          $data['module']   = "employee";
          $data['page']     = "incident_type";
          echo Modules::run('template/layout', $data); 
        }
	}

 public function update_incident_type($id=null){
    $this->form_validation->set_rules('type','Type'  ,'required');
        $post = $this->input->post();
        $return = 0;
        if ($this->form_validation->run() === true) {
            $return = 1;
          $data['type'] = $post['type'];
            if(isset($id)){
                $updateData = $this->db->where('id',$id)->update('incident_type',$data);
            }else{ 
                $updateData = $this->db->insert('incident_type',$data);
            }
            if($updateData && $return ==1){
                $this->session->set_flashdata('message', "Data Updated Successfully!");
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("/employee/Employees_incident/incident_type");

        }else{
            $this->incident_type();
        }
    }

    public function incident_delete($id){
        $this->db->where('id',$id)->delete('incident_type');   
        $this->session->set_flashdata('message', "Data Deleted Successfully!");
          redirect("/employee/Employees_incident/incident_type");
    }



    public function incidents($id=null){
        if(isset($id)){
            $ids = "and incidents.id = $id";
        }else{
            $ids = "";
        }

        $incidents_list = $this->db->query("SELECT incidents.*,
                                               employee_history.first_name as fname,
                                               employee_history.last_name as lname,
                                               employee_history.employee_id as emp_id,
                                               incident_type.id as incident_id,
                                               incident_type.type as incident_type
                                               FROM `incidents`,employee_history,incident_type 
                                               where 
                                               incidents.employee_id = employee_history.employee_id
                                               and 
                                               incidents.type_id = incident_type.id $ids ")->result();
        if(isset($id)){
          echo json_encode($incidents_list);
        }else{
          $incident_type            = $this->Employees_model->incident_list('incident_type');
          $data['title']            = 'Incidents List';
          $data['incident_type']    = $incident_type;
          $data['incident_list']    = $incidents_list;
          $data['module']           = "employee";
          $data['page']             = "incidents_list";
          echo Modules::run('template/layout', $data); 
        }
    }

 public function update_incident($id=null){
        $this->form_validation->set_rules('type','Type','required');
        $this->form_validation->set_rules('emp_id','Employee','required');
        $this->form_validation->set_rules('date','Date','required');
        $this->form_validation->set_rules('template','template','required');
        $post = $this->input->post();
        $return = 0;
        if ($this->form_validation->run() === true) {
            $return = 1;
            $data['date']           =     $post['date'];
            $data['type_id']        =     $post['type'];
            $data['employee_id']    =   $post['emp_id'];
            $data['text']           = $post['template'];
            if(isset($id)){
                $data['updated_on'] = date('Y-m-d');
                $updateData         = $this->db->where('id',$id)->update('incidents',$data);
            }else{ 
                $data['created_at'] = date('Y-m-d');
                $updateData         = $this->db->insert('incidents',$data);
            }
            if($updateData && $return ==1){
                $this->session->set_flashdata('message', "Data Updated Successfully!");
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("/employee/Employees_incident/incidents");
        }else{
            $this->incidents();
        }
    }
}