<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Employees extends MX_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->db->query('SET SESSION sql_mode = ""');
        $this->load->model(array(
            'Employees_model',
            'dashboard/User_model',
            'Country_model',
        ));
        $this->load->library(['zklibrary', 'excel']);
        if (!$this->session->userdata('isLogIn')) {
            redirect('login?rback=' . uri_string());
        }

    }
    public function cron_probation()
    {
        $recs = $this->Employees_model->get_expiring_probations();
        $this->load->model('notification/notification_model');
        foreach ($recs as $rec) {
            $notif_data = [
                'text' => $rec->hrm_id . '\'s probation is about to end on ' . formatted_date($rec->expires_on),
                'url' => 'employee/Employees/update_employee_form/' . $rec->employee_id,
                'date' => date('Y-m-d'),
                'created_by' => 0,
            ];
            $notif_data['dept_id'] = $this->notification_model->hr_id;
            $res = $this->notification_model->notification_create($notif_data);
            $this->db->where('emp_his_id', $rec->emp_his_id)->update('employee_history', [
                'probation_notified' => 1,
            ]);
        }
    }
    /* ################ Employee Salary Setup Start   #######################....*/
    public function emp_salary_setup_view()
    {
        $this->permission->module('employee', 'read')->redirect();
        $data['title'] = display('view_salary_setup');
        $data['emp_sl'] = $this->Employees_model->salary_setupView();
        $data['module'] = "employee";
        $data['page'] = "emp_sal_setupview";
        echo Modules::run('template/layout', $data);
    }
    public function create_salary_setup()
    {
        $data['title'] = display('selectionlist');
        #-------------------------------#
        $this->form_validation->set_rules('emp_sal_name', display('emp_sal_name'), 'required|max_length[50]');
        $this->form_validation->set_rules('emp_sal_type', display('emp_sal_type'));
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'emp_sal_name' => $this->input->post('emp_sal_name', true),
                'emp_sal_type' => $this->input->post('emp_sal_type', true),
            ];
            if ($this->Employees_model->emp_salsetup_create($postData)) {
                $this->session->set_flashdata('message', display('message_sent'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("employee/Employees/create_salary_setup");
        } else {
            $data['title'] = display('create');
            $data['module'] = "employee";
            $data['page'] = "emp_salarysetup_form";
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_emp_salarysetup($id = null)
    {
        $this->permission->module('employee', 'delete')->redirect();
        if ($this->Employees_model->emp_salstup_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("employee/Employees/emp_salary_setup_view");
    }
    public function update_salsetup_form($id = null)
    {
        $this->form_validation->set_rules('emp_sal_set_id', null, 'required|max_length[11]');
        $this->form_validation->set_rules('emp_sal_name', display('emp_sal_name'), 'required|max_length[50]');
        $this->form_validation->set_rules('emp_sal_type', display('emp_sal_type'), 'required|max_length[20]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'emp_sal_set_id' => $this->input->post('emp_sal_set_id', true),
                'emp_sal_name' => $this->input->post('emp_sal_name', true),
                'emp_sal_type' => $this->input->post('emp_sal_type', true),
            ];
            if ($this->Employees_model->update_em_salstup($postData)) {
                $this->session->set_flashdata('message', display('message_sent'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("employee/Employees/update_salsetup_form/" . $id);
        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Employees_model->salarysetup_updateForm($id);
            $data['module'] = "employee";
            $data['page'] = "update_salarysetup_form";
            echo Modules::run('template/layout', $data);
        }
    }
    /* ################ Employee Salary Setup End   #######################....*/
/* <<<<<<<<<<<<<##############^^^^^^@@@@^^^^^###############>>>>>>>
/* ################ Employee Performance Start   #######################....*/
    public function emp_performance_view()
    {
        $this->permission->module('employee', 'read')->redirect();
        $data['title'] = display('view_employee_performance');
        $data['emp_perform'] = $this->Employees_model->emp_performanceView();
        $data['module'] = "employee";
        $data['page'] = "emp_performanceview";
        echo Modules::run('template/layout', $data);
    }
    public function create_emp_performance()
    {
        $data['title'] = display('performancelist');
        #-------------------------------#
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'required|max_length[50]');
        $this->form_validation->set_rules('note', display('note'));
        $this->form_validation->set_rules('date', display('date'));
        $this->form_validation->set_rules('number_of_star', display('number_of_star'));
        $this->form_validation->set_rules('status', display('status'));
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'employee_id' => $this->input->post('employee_id', true),
                'note' => $this->input->post('note', true),
                'date' => $this->input->post('date', true),
                'note_by' => $this->session->userdata('fullname'),
                'number_of_star' => $this->input->post('number_of_star', true),
                'status' => $this->input->post('status', true),
            ];
            if ($this->Employees_model->emp_performance_create($postData)) {
                $this->session->set_flashdata('message', display('successfully_saved'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("employee/Employees/create_emp_performance");
        } else {
            $data['title'] = display('create');
            $data['module'] = "employee";
            $data['page'] = "emp_performance_form";
            $data['employee'] = $this->Employees_model->employee();
            $data['emp_perform'] = $this->Employees_model->emp_performanceView();
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_emp_performance($id = null)
    {
        $this->permission->module('employee', 'delete')->redirect();
        if ($this->Employees_model->emp_performance_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("employee/Employees/emp_performance_view");
    }
    public function update_emp_performance_form($id = null)
    {
        $this->form_validation->set_rules('emp_per_id', null, 'max_length[11]');
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'max_length[50]');
        $this->form_validation->set_rules('note', display('note'));
        $this->form_validation->set_rules('date', display('date'));
        $this->form_validation->set_rules('note_by', display('note_by'));
        $this->form_validation->set_rules('number_of_star', display('number_of_star'));
        $this->form_validation->set_rules('status', display('status'));
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'emp_per_id' => $this->input->post('emp_per_id', true),
                'employee_id' => $this->input->post('employee_id', true),
                'note' => $this->input->post('note', true),
                'date' => $this->input->post('date', true),
                'note_by' => $this->input->post('note_by', true),
                'number_of_star' => $this->input->post('number_of_star', true),
                'status' => $this->input->post('status', true),
                'updated_by' => $this->session->userdata('fullname'),
            ];
            if ($this->Employees_model->update_em_performance($postData)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("employee/Employees/update_emp_performance_form/" . $id);
        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Employees_model->emp_performance_updateForm($id);
            $data['query'] = $this->Employees_model->get_performaceempid($id);
            $data['employee'] = $this->Employees_model->employee();
            $data['module'] = "employee";
            $data['page'] = "update_performance_form";
            echo Modules::run('template/layout', $data);
        }
    }
/* ################ Employee Performance End   #######################....*/
/* ################ Employee Payment start   #######################....*/
    public function create_payment()
    {
        $data['title'] = display('add_payment');
        #-------------------------------#
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'max_length[50]');
        $this->form_validation->set_rules('total_salary', display('total_salary'));
        $this->form_validation->set_rules('total_working_minutes', display('total_working_minutes'));
        $this->form_validation->set_rules('working_period', display('working_period'));
        $this->form_validation->set_rules('payment_due', display('payment_due'));
        $this->form_validation->set_rules('payment_date', display('payment_date'));
        $this->form_validation->set_rules('paid_by', display('paid_by'));
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'employee_id' => $this->input->post('employee_id', true),
                'total_salary' => $this->input->post('total_salary', true),
                'total_working_minutes' => $this->input->post('total_working_minutes', true),
                'working_period' => $this->input->post('working_period', true),
                'payment_due' => $this->input->post('payment_due', true),
                'payment_date' => $this->input->post('payment_date', true),
                'paid_by' => $this->input->post('paid_by', true),
            ];
            if ($this->Employees_model->create_employee_payment($postData)) {
                $this->session->set_flashdata('message', display('message_sent'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("employee/Employees/create_payment");
        } else {
            $data['title'] = display('create');
            $data['module'] = "employee";
            $data['page'] = "emp_payment_form";
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_payment($id = null)
    {
        $this->permission->module('employee', 'delete')->redirect();
        if ($this->Employees_model->emp_payment_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function update_payment_form($id = null)
    {
        $this->form_validation->set_rules('emp_sal_pay_id', null, 'required|max_length[11]');
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'max_length[50]');
        $this->form_validation->set_rules('total_salary', display('total_salary'));
        $this->form_validation->set_rules('total_working_minutes', display('total_working_minutes'));
        $this->form_validation->set_rules('working_period', display('working_period'));
        $this->form_validation->set_rules('payment_due', display('payment_due'));
        $this->form_validation->set_rules('payment_date', display('payment_date'));
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'emp_sal_pay_id' => $this->input->post('emp_sal_pay_id', true),
                'employee_id' => $this->input->post('employee_id', true),
                'total_salary' => $this->input->post('total_salary', true),
                'total_working_minutes' => $this->input->post('total_working_minutes', true),
                'working_period' => $this->input->post('working_period', true),
                'payment_due' => $this->input->post('payment_due', true),
                'payment_date' => $this->input->post('payment_date', true),
                'paid_by' => $this->session->userdata('fullname'),
            ];
            if ($this->Employees_model->update_payment($postData)) {
                $this->session->set_flashdata('message', display('successfully_paid'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("employee/Employees/emp_payment_view/" . $id);
        } else {
            $data['title'] = display('update');
            $data['data'] = $this->Employees_model->payment_updateForm($id);
            $data['module'] = "employee";
            $data['page'] = "update_payment_form";
            echo Modules::run('template/layout', $data);
        }
    }
/* ################ Employee Payment end   #######################....*/
/* ################ Employee Salary Pay Type Start   #######################....*/
    public function emp_sal_payType_view()
    {
        $this->permission->module('employee', 'read')->redirect();
        $data['title'] = display('view_employee_payment');
        $data['paytype'] = $this->Employees_model->emp_salPaytypeView();
        $data['module'] = "employee";
        $data['page'] = "sal_pay_type_tview";
        echo Modules::run('template/layout', $data);
    }
    public function create_payment_type()
    {
        $data['title'] = display('add_payment_type');
        $this->form_validation->set_rules('payment_period', display('payment_period'), 'required|max_length[50]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'payment_period' => $this->input->post('payment_period', true),
            ];
            if ($this->Employees_model->insert_payment_type($postData)) {
                $this->session->set_flashdata('message', display('message_sent'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("employee/Employees/create_payment_type");
        } else {
            $data['title'] = display('create');
            $data['module'] = "employee";
            $data['page'] = "emp_payment_type_form";
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_payment_type($id = null)
    {
        $this->permission->module('employee', 'delete')->redirect();
        if ($this->Employees_model->emp_payment_type_delete($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("employee/Employees/emp_sal_payType_view");
    }
/* cv    */
    public function cv()
    {
//     $this->permission->module('circularprocess','read')->redirect();
        $data['title'] = display('view details');
        // if($this->session->userdata('isAdmin')==1){
        //     $id = $this->uri->segment(4);
        // }else{
        //     $id = $this->session->userdata('employee_id');
        // }
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        // if(){
        $id = $this->session->userdata('employee_id');
        if ($admin == 1 || $is_supervisor == 1) {
            // $this->db->where('super_visor_id',$employee_id);
            // $this->db->or_where('employee_id',$employee_id);
            // $this->db->or_where('indirect_super_visor_id',$employee_id);
            // $data['emp_history']= $this->Employees_model->emp_list();
            // echo Modules::run('template/layout', $data);
            $id = $this->uri->segment(4);
        } else {
            // $this->db->where('employee_id',$employee_id);
            $id = $this->session->userdata('employee_id');
            // redirect("http://localhost/ourhrm/employee/Employees/cv/$id");
        }
        $data['row'] = $this->Employees_model->employee_details($id);
        $data['edu'] = $this->Employees_model->updateedu($id);
        $data['benifit'] = $this->Employees_model->benifit($id);
        $data['award'] = $this->Employees_model->award($id);
        $data['perform'] = $this->Employees_model->performance($id);
        $data['employee_leaves'] = $this->Employees_model->employee_leaves($id);
        $data['module'] = "employee"; //
        $data['page'] = "resumepdf";
        echo Modules::run('template/layout', $data);
    }
    public function cv_print($id)
    {
//     $this->permission->module('circularprocess','read')->redirect();
        $data['title'] = display('view details');
        // if($this->session->userdata('isAdmin')==1){
        //     $id = $this->uri->segment(4);
        // }else{
        //     $id = $this->session->userdata('employee_id');
        // }
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        // if(){
        if ($admin == 1 || $is_supervisor == 1) {
        } else {
            // $this->db->where('employee_id',$employee_id);
            $id = $this->session->userdata('employee_id');
            // redirect("http://localhost/ourhrm/employee/Employees/cv/$id");
        }
        $data['row'] = $this->Employees_model->employee_details($id);
        $data['edu'] = $this->Employees_model->updateedu($id);
        $data['benifit'] = $this->Employees_model->benifit($id);
        $data['award'] = $this->Employees_model->award($id);
        $data['perform'] = $this->Employees_model->performance($id);
        $data['employee_leaves'] = $this->Employees_model->employee_leaves($id);
        $data['module'] = "employee"; //
        $data['page'] = "resumepdf-print";
        $this->load->view('resumepdf-print', $data);
    }
    public function cv_pdf($id)
    {
//     $this->permission->module('circularprocess','read')->redirect();
        $data['title'] = display('view details');
        // if($this->session->userdata('isAdmin')==1){
        //     $id = $this->uri->segment(4);
        // }else{
        //     $id = $this->session->userdata('employee_id');
        // }
        $admin = $this->session->userdata('isAdmin');
        $is_supervisor = $this->session->userdata('supervisor');
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');
        // if(){
        if ($admin == 1 || $is_supervisor == 1) {
        } else {
            // $this->db->where('employee_id',$employee_id);
            $id = $this->session->userdata('employee_id');
            // redirect("http://localhost/ourhrm/employee/Employees/cv/$id");
        }
        $data['row'] = $this->Employees_model->employee_details($id);
        $data['edu'] = $this->Employees_model->updateedu($id);
        $data['benifit'] = $this->Employees_model->benifit($id);
        $data['award'] = $this->Employees_model->award($id);
        $data['perform'] = $this->Employees_model->performance($id);
        $data['employee_leaves'] = $this->Employees_model->employee_leaves($id);
        $data['module'] = "employee"; //
        $data['page'] = "resumepdf-print";
        $this->load->library('pdfgenerator');
        $this->pdfgenerator->generate($this->load->view('resumepdf-print', $data, true), 'employee-' . $data['row']->hrm_id . '-pdf', true);
    }
    /* ########## NEW EMPLOYEE ADD ################*/
    public function viewEmhistory()
    {
        // if($this->session->userdata('isAdmin')!=1){
        //     // $this->session->set_flashdata('message', display('save_successfully'));
        //     redirect("dashboard/home");
        // }
        $this->permission->method('add_employee', 'create')->redirect();
        // $this->permission->module('employee','read')->redirect();
        $data['title'] = display('view_salary_setup');
        $data['emp_history'] = $this->Employees_model->emp_historyview();
        $data['module'] = "employee";
        $data['designation'] = $this->Employees_model->designation();
        $data['dropdowndept'] = $this->Employees_model->dropdowndept();
        $data['supervisor'] = $this->Employees_model->supervisorlist();
//         $data['country_list'] = $this->Country_model->state('Pakistan');
        $data['country_list'] = array('pakistan' => 'Pakistan');
        $data['leave_type'] = $this->Employees_model->leave_type();
        $data['page'] = "employ_form";
        $data['dropdowndev'] = $this->db->select('*')->from('divisions')->order_by('id', 'desc')->get()->result();
        $data['shift'] = $this->db->get('shift')->result();
        $data['benefits'] = $this->db->select('*')->from('salary_addition')->order_by('id', 'desc')->get()->result();
        $data['document_types'] = getByWhere('upload_documents_type', '*', [], ['title', 'ASC']);
        echo Modules::run('template/layout', $data);
    }
    public function manageemployee()
    {
        $this->permission->module('employee', 'read')->redirect();
        $data['title'] = display('view_salary_setup');
        $data['module'] = "employee";
        $data['page'] = "employee_view";
        if ($this->session->userdata('isAdmin') == 1 || $this->permission->method('manage_employee', 'read')->access()) {
            $data['emp_history'] = $this->Employees_model->emp_list();
            echo Modules::run('template/layout', $data);
        } else {
            // if(){
            // }
            // $id = $this->session->userdata('employee_id');
            $admin = $this->session->userdata('isAdmin');
            $is_supervisor = $this->session->userdata('supervisor');
            $direct_supervisor = $this->session->userdata('direct_supervisor');
            $indirect_supervisor = $this->session->userdata('indirect_supervisor');
            // if($admin != 1){
            $id = $this->session->userdata('employee_id');
            if ($is_supervisor == 1) {
                // $this->db->where('super_visor_id',$employee_id);
                // $this->db->or_where('employee_id',$employee_id);
                // $this->db->or_where('indirect_super_visor_id',$employee_id);
                $data['emp_history'] = $this->Employees_model->emp_list();
                echo Modules::run('template/layout', $data);
            } else {
                // $this->db->where('employee_id',$employee_id);
                //      redirect("http://localhost/ourhrm/employee/Employees/cv/$id");
                redirect("employee/Employees/cv/$id");
            }
            // }
        }
    }
    public function documents_update($id)
    {
        $data['title'] = 'Employee Documents';
        $data['module'] = "employee";
        $data['page'] = "employee_documents";
        $data['id'] = $id;
        $data['document_types'] = getByWhere('upload_documents_type', '*', [], ['title', 'ASC']);
        $documents = $this->db->select('upload_documents.*, edt.title as document_type')
            ->from('upload_documents')
            ->join('upload_documents_type edt', 'edt.id = upload_documents.document_type')
            ->where('upload_documents.employee_id', $id)
            ->get()
            ->result();
        $data['result'] = $documents;
        echo Modules::run('template/layout', $data);
    }
    public function trash_document($id, $emp)
    {
        $where = ['id' => $id, 'employee_id' => $emp];
        $document = $this->db->select('*')->from('upload_documents')->where($where)->get()->first_row()->documents;
        $this->db->where($where);
        if ($this->db->delete('upload_documents')) {
            $file_path = base_url() . '/assets/employee_documents/' . $document;
            if (file_exists($file_path)) {
                unlink($file_path);
            }
            $this->session->set_flashdata('message', 'deleted successfully');
        } else {
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("employee/Employees/documents_update/$emp");
    }
    public function trash_document_ajax()
    {
        $document = $this->db->select('*')->from('upload_documents')->where('id', $_POST['id'])->get()->first_row();
        if ($document) {
            $res = $this->db->where('id', $_POST['id'])->delete('upload_documents');
            if ($res) {
                $file_path = base_url() . '/assets/employee_documents/' . $document->documents;
                @unlink($file_path);
                sendJson(['success' => $document->id]);
            }
        }
        sendJson(['error' => 'Error while deleting file. try again later']);
    }
    public function uploadDocumentsAjax()
    {
        $post = $this->input->post();
        // Set preference
        $config['upload_path'] = 'assets/employee_documents/';
        $config['file_name'] = @pathinfo($_FILES['file']['name'], PATHINFO_FILENAME) . '-' . time();
        $config['allowed_types'] = 'gif|jpg|jpeg|png|iso|dmg|zip|rar|doc|docx|xls|xlsx|ppt|pptx|csv|ods|odt|odp|pdf|rtf|sxc|sxi|txt|exe|avi|mpeg|mp3|mp4|3gp|svg';
        $config['max_size'] = '50000'; // max_size in kb
        //Load upload library
        $this->load->library('upload', $config);
        $this->upload->initialize($config);
        // File upload
        if ($this->upload->do_upload('file')) {
            // Get data about the file
            $uploadData = $this->upload->data();
            $filename = $uploadData['file_name'];
            // Initialize array
            $data['documents'] = $filename;
            $data['document_type'] = $post['document_type'];
            $data['employee_id'] = $post['employee_id'];
            $data['created_date'] = date('Y-m-d');
            $res = $this->db->insert('upload_documents', $data);
            if ($res) {
                $res = $this->db->insert_id();
                sendJson([
                    'success' => @getByWhere(
                        'upload_documents,
						upload_documents_type-upload_documents.document_type=upload_documents_type.id-left',
                        'upload_documents.*, upload_documents_type.title as type_title',
                        ['upload_documents.id' => $res]
                    )[0],
                ]);
            } else {
                sendJson(['error' => 'Error uploading file try again later']);
            }
        } else {
            $error = array('error' => $this->upload->display_errors());
            sendJson($error);
        }
    }
    public function uploadDocuments($id)
    {
        $post = $this->input->post();
        if (isset($post)) {
            $data = array();
            // Count total files
            $countfiles = count($_FILES['files']['name']);
            //  $this->upload_files('assets/employee_documents/', 'images', $_FILES['files[]']);
            // Looping all files
            for ($i = 0; $i < $countfiles; $i++) {
                if (!empty($_FILES['files']['name'][$i])) {
                    // Define new $_FILES array - $_FILES['file']
                    $_FILES['file']['name'] = $_FILES['files']['name'][$i];
                    $_FILES['file']['type'] = $_FILES['files']['type'][$i];
                    $_FILES['file']['tmp_name'] = $_FILES['files']['tmp_name'][$i];
                    $_FILES['file']['error'] = $_FILES['files']['error'][$i];
                    $_FILES['file']['size'] = $_FILES['files']['size'][$i];
                    // Set preference
                    $config['upload_path'] = 'assets/employee_documents/';
                    $config['allowed_types'] = 'gif|jpg|jpeg|png|iso|dmg|zip|rar|doc|docx|xls|xlsx|ppt|pptx|csv|ods|odt|odp|pdf|rtf|sxc|sxi|txt|exe|avi|mpeg|mp3|mp4|3gp|svg';
                    $config['max_size'] = '50000'; // max_size in kb
                    $config['file_name'] = $_FILES['files']['name'][$i];
                    //Load upload library
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);
                    // File upload
                    if ($this->upload->do_upload('file')) {
                        // Get data about the file
                        $uploadData = $this->upload->data();
                        $filename = $uploadData['file_name'];
                        // Initialize array
                        $data['documents'] = $filename;
                        $data['document_type'] = $post['document_type'];
                        $data['employee_id'] = $id;
                        $data['created_date'] = date('Y-m-d');
                        $this->db->insert('upload_documents', $data);
                    } else {
                        $error = array('error' => $this->upload->display_errors());
                        $this->session->set_flashdata('exception', $error['error']);
                        redirect("employee/Employees/documents_update/$id");
                    }
                }
            }
            $this->session->set_flashdata('message', display('successfully_saved'));
            redirect("employee/Employees/documents_update/$id");
        }
    }
    public function create_employee()
    {
        /***** file upload code start ***********/
        $device_ip = $this->deviceData()->device_ip;
        $data['title'] = display('create_employee');
        //   $zk = new ZKLibrary($device_ip, 4370);
        // // echo 'welcome';exit();
        //     $zk->connect();
        //     $zk->disableDevice();
        //        $user = $zk->getUser();
        //        $max = max($user);
        //        $max_id = $max[0];
        //     $zk->enableDevice();
        //        $zk->disconnect();
        #-------------------------------#
        // echo $this->input->post('leave_type',true)[0];exit;
        $this->form_validation->set_rules('first_name', display('first_name'), 'max_length[50]');
        $this->load->library('myupload');
        $img = $this->myupload->do_upload(
            './application/modules/employee/assets/images/',
            'picture'
        );
        $this->form_validation->set_rules('c_f_name[]', 'Custom Field Name');
        $this->form_validation->set_rules('c_f_type[]', 'Custom Field Type');
        $this->form_validation->set_rules('customvalue[]', 'Custom Value');
        $employee_h = $this->db->select('employee_id')
            ->from('employee_history')
            ->order_by('emp_his_id', 'desc')
            ->get()
            ->row();
        if ($employee_h) {
            $max_id = $employee_h->employee_id;
            $employee_id = $max_id + 1;
        } else {
            $employee_id = 1;
        }
        //print_r($employee_id);exit();
        $customr_field = $this->input->post('c_f_name');
        $customr_field_type = $this->input->post('c_f_type');
        $customr_value = $this->input->post('customvalue');
        $benifit_code = $this->input->post('benefit_id', true);
        $benifit_code_desc = $this->input->post('benifit_c_code_d', true);
        $benifit_acc_date = $this->input->post('benifit_acc_date', true);
        //print_r($benifit_acc_date);exit();
        $benift_status = $this->input->post('benifit_sst', true);
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $this->load->library('myupload');
            if ($this->input->post('gender') == 3 && !empty(trim($this->input->post('other_gender')))) {
                $this->db->insert('gender', [
                    'gender_name' => trim($this->input->post('other_gender')),
                ]);
                $_POST['gender'] = $this->db->insert_id();
            }
            if ($this->input->post('marital_status') == 5 && !empty(trim($this->input->post('other_marital')))) {
                $this->db->insert('marital_info', [
                    'marital_sta' => trim($this->input->post('other_marital')),
                ]);
                $_POST['marital_status'] = $this->db->insert_id();
            }
            $postData = [
                'employee_id' => $employee_id,
                'pos_id' => $this->input->post('pos_id', true),
                'hrm_id' => $this->input->post('hrm_id', true),
                'first_name' => $this->input->post('first_name', true),
                'middle_name' => $this->input->post('middle_name', true),
                'last_name' => $this->input->post('last_name', true),
                'maiden_name' => $this->input->post('maiden_name'),
                'father_name' => $this->input->post('father_name'),
                'email' => $this->input->post('email', true),
                'phone' => $this->input->post('phone', true),
                'alter_phone' => $this->input->post('alter_phone', true),
                'present_address' => $this->input->post('present_address', true),
                'parmanent_address' => $this->input->post('parmanent_address', true),
                'picture' => $img,
                'dept_id' => $this->input->post('department', true),
                'division_id' => $this->input->post('division', true),
                'state' => $this->input->post('state', true),
                'city' => $this->input->post('city', true),
                'zip' => $this->input->post('zip_code', true),
                'citizenship' => $this->input->post('citizenship', true),
                'duty_type' => $this->input->post('duty_type', true),
                'hire_date' => date("Y-m-d", strtotime(!empty($this->input->post('hiredate', true)) ? $this->input->post('hiredate', true) : date('Y-m-d'))),
                'original_hire_date' => date("Y-m-d", strtotime(!empty($this->input->post('ohiredate', true)) ? $this->input->post('ohiredate', true) : date('Y-m-d'))),
                'termination_date' => date("Y-m-d", strtotime(!empty($this->input->post('terminatedate', true)) ? $this->input->post('terminatedate', true) : date('Y-m-d'))),
                'termination_reason' => $this->input->post('termreason', true),
                'voluntary_termination' => $this->input->post('volunt_termination', true),
                'rehire_date' => date("Y-m-d", strtotime(!empty($this->input->post('rehiredate', true)) ? $this->input->post('rehiredate', true) : date('Y-m-d'))),
                'rate_type' => $this->input->post('rate_type', true),
                'rate' => $this->input->post('rate', true),
                'current_salary' => $this->input->post('current_salary', true),
                'pay_frequency' => $this->input->post('pay_frequency', true),
                'pay_frequency_txt' => $this->input->post('pay_f_text', true),
                'hourly_rate2' => $this->input->post('h_rate2', true),
                'hourly_rate3' => $this->input->post('h_rate3', true),
                'home_department' => $this->input->post('h_department', true),
                'department_text' => $this->input->post('h_dep_text', true),
                'class_code' => $this->input->post('c_code', true),
                'class_code_desc' => $this->input->post('c_code_d', true),
                'class_acc_date' => date("Y-m-d", strtotime(!empty($this->input->post('class_acc_date', true)) ? $this->input->post('class_acc_date', true) : date('Y-m-d'))),
                'class_status' => $this->input->post('class_sst', true),
                'is_super_visor' => $this->input->post('is_supervisor', true),
                'super_visor_id' => $this->input->post('supervisorname', true),
                'indirect_super_visor_id' => $this->input->post('indirect_supervisorname', true),
                'supervisor_report' => $this->input->post('reports', true),
                'dob' => date("Y-m-d", strtotime(!empty($this->input->post('dob', true)) ? $this->input->post('dob', true) : date('Y-m-d'))),
                'gender' => $this->input->post('gender', true),
                'marital_status' => $this->input->post('marital_status', true),
                'ethnic_group' => $this->input->post('ethnic', true),
                'eeo_class_gp' => $this->input->post('eeo_class', true),
                'cnic' => $this->input->post('cnic', true),
                'eobi_check' => ($this->input->post('eobi_check', true) ? 1 : 0),

                'work_in_state' => $this->input->post('w_s', true),
                'live_in_state' => $this->input->post('l_in_s', true),
                'home_email' => $this->input->post('h_email', true),
                'business_email' => $this->input->post('b_email', true),
                'home_phone' => $this->input->post('h_phone', true),
                'business_phone' => $this->input->post('w_phone', true),
                'cell_phone' => $this->input->post('c_phone', true),
                'emerg_contct' => $this->input->post('em_contact', true),
                'emrg_h_phone' => $this->input->post('e_h_phone', true),
                'emrg_w_phone' => $this->input->post('e_w_phone', true),
                'emgr_contct_relation' => $this->input->post('e_c_relation', true),
                'alt_em_contct' => $this->input->post('alt_em_cont', true),
                'alt_emg_h_phone' => $this->input->post('a_e_h_phone', true),
                'alt_emg_w_phone' => $this->input->post('a_e_w_phone', true),
                'shift' => $this->input->post('shift', true),
                'probation_period' => $this->input->post('probation_period', true),
                'performance_duration' => $this->input->post('performance_duration', true),
                'hired_salary' => $this->input->post('hired_salary', true),
                'first_salary' => $this->input->post('first_salary', true),
                'second_salary' => $this->input->post('second_salary', true),
                'third_salary' => $this->input->post('third_salary', true),
            ];
//print_r($postData);exit();
            $coa = $this->Employees_model->headcode();
            if ($coa->HeadCode != null) {
                $headcode = $coa->HeadCode + 1;
            } else {
                $headcode = "502020000001";
            }
            $c_code = $employee_id;
            $c_name = $this->input->post('first_name') . $this->input->post('last_name');
            $c_acc = $c_code . '-' . $c_name;
            $createby = $this->session->userdata('fullname');
            $createdate = date('Y-m-d H:i:s');
            $data['aco'] = (Object) $coaData = [
                'HeadCode' => $headcode,
                'HeadName' => $c_acc,
                'PHeadName' => 'Account Payable',
                'HeadLevel' => '2',
                'IsActive' => '1',
                'IsTransaction' => '1',
                'IsGL' => '0',
                'HeadType' => 'L',
                'IsBudget' => '0',
                'IsDepreciation' => '0',
                'DepreciationRate' => '0',
                'CreateBy' => $createby,
                'CreateDate' => $createdate,
            ];
            $employee_id = $this->Employees_model->create_employee($postData);
// $employee_id =1;
            if ($employee_id) {
                $this->db->where('employee_id', $employee_id)->delete('emp_salary_setup_details');
                foreach ($_POST['addition'] as $key => $value) {
                    $addition = [];
                    $addition['addition_id'] = $key;
                    $addition['employee_id'] = $employee_id;
                    $addition['value'] = $value;
                    $addition['created_on'] = date('Y-m-d');
                    if (!empty($addition['addition_id']) && !empty($addition['value'])) {
                        $this->db->insert('emp_salary_setup_details', $addition);
                    }
                }
                foreach ($_POST['deduction'] as $key => $value) {
                    $deduction['deduction_id'] = $key;
                    $deduction['employee_id'] = $employee_id;
                    $deduction['value'] = $value;
                    $deduction['created_on'] = date('Y-m-d');
                    if (!empty($deduction['deduction_id']) && !empty($deduction['value'])) {
                        $this->db->insert('emp_salary_setup_details', $deduction);
                    }
                }
                // $insertLeave['emp_id'] = $employee_id;
                $insertLeave['emp_id'] = $this->db->where(array('emp_his_id' => $employee_id))->get('employee_history')->first_row()->employee_id;
                $employeeType = $this->input->post('leave_type', true);
                $employeeQuote = $this->input->post('leave_qouta', true);
                for ($i = 0; $i < count($employeeType); $i++) {
                    $insertLeave['leave_type'] = $employeeType[$i];
                    $insertLeave['leave_qouta'] = $employeeQuote[$i];
                    if (!empty($employeeType[$i]) && !empty($employeeQuote[$i])) {
                        $this->db->insert('employee_leaves', $insertLeave);
                    }
                }
                // $insertLeave['leave_type'] = $this->input->post('leave_type',true);
                // $insertLeave['leave_qouta'] = $this->input->post('leave_qouta',true);
                // $this->db->insert()
                //  $zk = new ZKLibrary($device_ip, 4370);
                //      // echo 'welcome';exit();
                //          $zk->connect();
                //          $zk->disableDevice();
                // $zk->setUser($employee_id, $employee_id, $this->input->post('first_name').' '.$this->input->post('last_name'), '', 0);
                // $zk->enableDevice();
                //             $zk->disconnect();
                $this->Employees_model->create_coa($coaData);
                for ($i = 0; $i < count($customr_field); $i++) {
                    //print_r(count($customr_field));exit();
                    $custom = [
                        'custom_field' => $customr_field[$i],
                        'custom_data_type' => $customr_field_type[$i],
                        'custom_data' => $customr_value[$i],
                        'employee_id' => $employee_id,
                    ];
                    if (!empty($customr_field[$i])) {
                        $this->db->insert('custom_table', $custom);
                    }
                }
                for ($i = 0; $i < count($benifit_code); $i++) {
                    if ($benifit_code[$i] !== 'Select Benefits') {
                        $benifit = [
                            'bnf_cl_code_des' => $benifit_code_desc[$i],
                            'bnff_acural_date' => date("Y-m-d", strtotime(!empty($benifit_acc_date[$i]) ? $benifit_acc_date[$i] : date('Y-m-d'))),
                            'bnf_status' => $benift_status[$i],
                            'employee_id' => $employee_id,
                            'benefit_id' => $benifit_code[$i],
                        ];
                        // print_r($benefit);
                        if (!empty($benifit_code[$i])) {
                            $this->db->insert('employee_benifit', $benifit);
                        }
                    } else {
                    }
                }
// exit;
                $this->session->set_flashdata('message', display('save_successfully'));
                redirect("employee/Employees/viewEmhistory");
            }
        } else {
            $data['title'] = display('create');
            $data['module'] = "employee";
            $data['dropdowndept'] = $this->Employees_model->dropdowndept();
            $data['dropdown'] = $this->Employees_model->dropdown();
            $data['designation'] = $this->Employees_model->designation();
            $data['leave_type'] = $this->Employees_model->leave_type();
            $data['benefits'] = $this->db->select('*')->from('salary_addition')->order_by('id', 'desc')->get()->result();
            $data['page'] = "employ_form";
            echo Modules::run('template/layout', $data);
        }
    }
    public function bulk_import()
    {
        if ($this->input->method() != 'post') {
            $data['title'] = 'Bulk Import Employees';
            $data['module'] = "employee";
            $data['page'] = "bulk_import";
            echo Modules::run('template/layout', $data);return;
        }
        $column_order = [
            'HRM ID',
            'First Name',
            'Middle Name',
            'Last Name',
            'Father Name',
            'HRM Email Address',
            'Phone',
            'Alternative Phone',
            'Country',
            'City',
            'Division',
            'Department',
            'Position',
            'Duty Type',
            'Probation Period (Months)',
            'Shift Type',
            'Hire Date',
            'Original Hire Date',
            'Terminate Date',
            'Termination Reason',
            'Voluntary Resignation',
            'Rehire Date',
            'Salary Type',
            'Performance Review Duration',
            'Hired Salary',
            'Salary 1st Raise',
            'Salary 2nd Raise',
            'Salary 3rd Raise',
            'Basic Salary',
            'Gross Salary',
            'Other Allowances',
            'EOBI',
            'EOBI Amount',
            'Is Supervisor',
            'Direct Reporting',
            'Indirect Reporting',
            'Date of birth',
            'Gender',
            'Marital Status',
            'Religion',
            'CNIC',
            'Personal Email',
            'Business Email',
            'Home Phone',
            'Emergency Contact Number',
            'Cell Phone',
            'Present Address',
            'Permanent Address',
            'Work From Home',
            'Transportation Required',
            'Password',
            'Role',
        ];
        $this->load->library('myupload');
        $file = $this->myupload->do_upload(FCPATH . 'uploads/temp/', 'file', true);
        if (!$file) {
            $this->session->set_flashdata('exception', 'File upload failed, try again later!');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $excel_data = $this->excel->read($file);

        $alpha_header = range('A', 'Z');
        //Generate cross multiplication of columns if data is bigger than 25 columns
        $alp_i = 0;
        while (count($alpha_header) < count($excel_data['1'])) {
            $alphabet = $alpha_header[$alp_i];
            $new_range = range('A', 'Z');
            foreach ($new_range as $alp) {
                $alpha_header[] = $alphabet . $alp;
            }
            $alp_i++;
        }
        $alpha_column_order = [];
        foreach ($column_order as $col_num => $col) {
            $alpha_column_order[$col] = $alpha_header[$col_num];
        }

        $header_row = json_decode('{"A":"HRM ID","B":"First Name","C":"Middle Name","D":"Last Name","E":"Father Name","F":"HRM Email Address","G":"Phone","H":"Alternative Phone","I":"Country","J":"City","K":"Division","L":"Department","M":"Position","N":"Duty Type","O":"Probation Period (Months)","P":"Shift","Q":"Hire Date","R":"Original Hire Date","S":"Termination Date","T":"Termination Reason","U":"Voluntary Resignation","V":"Rehire Date","W":"Salary Type","X":"Performance Review Duration (Months)","Y":"Hired Salary","Z":"Salary 1st Raise","AA":"Salary 2nd Raise","AB":"Salary 3rd Raise","AC":"Basic Salary","AD":"Gross Salary","AE":"Other Allowances","AF":"EOBI","AG":"EOBI Amount","AH":"Is Supervisor","AI":"Direct Reporting To","AJ":"Indirect Reporting To","AK":"Date of Birth","AL":"Gender","AM":"Martial Status","AN":"Religion","AO":"CNIC","AP":"Personal Email","AQ":"Business Email","AR":"Home Phone","AS":"Emergency Contact Number","AT":"Cell Phone","AU":"Present Address","AV":"Permanent Address","AW":"Work From Home","AX":"Transportation Required","AY":"Password","AZ":"Role"}', true);
        $required_cols = [
            'HRM ID' => 'required',
            'First Name' => 'required',
            'Last Name' => 'required',
            'HRM Email Address' => 'required|email',
            'Phone' => 'required',
            'Division' => 'required',
            'Department' => 'required',
            'Position' => 'required',
            'Hire Date' => 'required',
            'Original Hire Date' => 'required',
            'Salary Type' => 'required',
            'Basic Salary' => 'required',
            'Date of birth' => 'required',
            'Gender' => 'required',
            'CNIC' => 'required',
            'Personal Email' => 'email',
            'Business Email' => 'email',
            'Home Phone' => 'required',
            'Cell Phone' => 'required',
            'Password' => 'required',
            'Role' => 'required',
        ];

        $this->db->trans_start();
        foreach ($excel_data as $row_num => $row_data) {
            if (count(array_diff($row_data, $header_row)) <= 10) {
                continue;
            }
            // Generate Employee ID
            $employee_h = $this->db->select('employee_id')
                ->from('employee_history')
                ->order_by('emp_his_id', 'desc')
                ->get()
                ->row();
            if ($employee_h) {
                $max_id = $employee_h->employee_id;
                $employee_id = $max_id + 1;
            } else {
                $employee_id = 1;
            }
            /**
             * Check required columns
             */
            foreach ($required_cols as $col_name => $req_col) {
                $req_col = explode('|', $req_col);
                if (in_array('required', $req_col) && empty($row_data[$alpha_column_order[$col_name]])) {
                    $this->session->set_flashdata('exception', 'Required column "' . $col_name . '" is empty on row# ' . $row_num);
                    redirect($_SERVER['HTTP_REFERER']);return;
                } elseif (!empty($row_data[$alpha_column_order[$col_name]])) {
                    if (in_array('email', $req_col) && !filter_var($row_data[$alpha_column_order[$col_name]], FILTER_VALIDATE_EMAIL)) {
                        $this->session->set_flashdata('exception', 'Invalid Email in "' . $col_name . '" column on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                }
            }
            /**
             * Duplicate Email check
             */
            $employee_email_exist = $this->db->select('employee_id')
                ->where('email', trim($row_data[$alpha_column_order['HRM Email Address']]))
                ->from('employee_history')
                ->get()
                ->row();
            if ($employee_email_exist) {
                $this->session->set_flashdata('exception', 'Email "' . trim($row_data[$alpha_column_order['HRM Email Address']]) . '" already exists from row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            $employee_user_email_exist = $this->db->select('id')
                ->where('email', trim($row_data[$alpha_column_order['HRM Email Address']]))
                ->from('user')
                ->get()
                ->row();
            if ($employee_user_email_exist) {
                $this->session->set_flashdata('exception', 'User with email "' . trim($row_data[$alpha_column_order['HRM Email Address']]) . '" already exists from row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            /**
             * Check gender exists
             */
            $gender = getByWhereAsArray('gender', 'id', ['gender_name' => trim($row_data[$alpha_column_order['Gender']])]);
            if ($gender) {
                $gender = $gender[0]['id'];
            } else {
                $this->db->insert('gender', [
                    'gender_name' => trim($row_data[$alpha_column_order['Gender']]),
                ]);
                $gender = $this->db->insert_id();
            }
            /**
             * Check marital status exists
             */
            $marital_status = getByWhereAsArray('marital_info', 'id', ['marital_sta' => trim($row_data[$alpha_column_order['Marital Status']])]);
            if ($marital_status) {
                $marital_status = $marital_status[0]['id'];
            } else {
                $this->db->insert('marital_info', [
                    'marital_sta' => trim($row_data[$alpha_column_order['Marital Status']]),
                ]);
                $marital_status = $this->db->insert_id();
            }
            /**
             * Check Division exists
             */
            $original_div = $row_data[$alpha_column_order['Division']];
            $row_data[$alpha_column_order['Division']] = str_replace(' ', '_', trim($row_data[$alpha_column_order['Division']]));
            $row_data[$alpha_column_order['Division']] = preg_replace('/[^\w\d]+/', '%', $row_data[$alpha_column_order['Division']]);
            $div_prefix = '';
            $division = getByWhereAsArray('divisions', 'id, prefix', [], [], 0, 0, ['name' => $row_data[$alpha_column_order['Division']]]);
            if ($division) {
                $div_prefix = $division[0]['prefix'];
                $division = $division[0]['id'];
            } else {
                $this->session->set_flashdata('exception', 'Division "' . $original_div . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }

            /**
             * Duplicate HRM ID check
             */
            if (empty($row_data[$alpha_column_order['HRM ID']])) {
                $row_data[$alpha_column_order['HRM ID']] = $div_prefix . '-' . str_pad($employee_id, 4, '0', STR_PAD_LEFT);
            } else {
                $employee_email_exist = $this->db->select('employee_id')
                    ->where('hrm_id', trim($row_data[$alpha_column_order['HRM ID']]))
                    ->from('employee_history')
                    ->get()
                    ->row();
                if ($employee_email_exist) {
                    $this->session->set_flashdata('exception', 'HRM ID "' . trim($row_data[$alpha_column_order['HRM ID']]) . '" already exists from row# ' . $row_num);
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
            }

            /**
             * Check department exists
             */
            $original_deptt = $row_data[$alpha_column_order['Department']];
            $row_data[$alpha_column_order['Department']] = str_replace(' ', '_', trim($row_data[$alpha_column_order['Department']]));
            $row_data[$alpha_column_order['Department']] = preg_replace('/[^\w\d]+/', '%', $row_data[$alpha_column_order['Department']]);
            $department = getByWhereAsArray('department', 'dept_id', [], [], 0, 0, ['department_name' => $row_data[$alpha_column_order['Department']]]);
            if ($department) {
                $department = $department[0]['dept_id'];
            } else {
                $this->session->set_flashdata('exception', 'Department "' . $original_deptt . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            /**
             * Check position exists
             */
            $original_pos = $row_data[$alpha_column_order['Position']];
            $row_data[$alpha_column_order['Position']] = str_replace(' ', '_', trim($row_data[$alpha_column_order['Position']]));
            $row_data[$alpha_column_order['Position']] = preg_replace('/[^\w\d]+/', '%', $row_data[$alpha_column_order['Position']]);
            $position = getByWhereAsArray('position', 'pos_id', [], [], 0, 0, ['position_name' => $row_data[$alpha_column_order['Position']]]);
            if ($position) {
                $position = $position[0]['pos_id'];
            } else {
                $this->session->set_flashdata('exception', 'Position "' . $original_pos . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            /**
             * Check duty type exists
             */
            $original_duty = $row_data[$alpha_column_order['Duty Type']];
            $row_data[$alpha_column_order['Duty Type']] = str_replace(' ', '_', trim($row_data[$alpha_column_order['Duty Type']]));
            $row_data[$alpha_column_order['Duty Type']] = preg_replace('/[^\w\d]+/', '%', $row_data[$alpha_column_order['Duty Type']]);
            $duty_type = getByWhereAsArray('duty_type', 'id', [], [], 0, 0, ['type_name' => $row_data[$alpha_column_order['Duty Type']]]);
            if ($duty_type) {
                $duty_type = $duty_type[0]['id'];
            } else {
                $this->session->set_flashdata('exception', 'Duty Type "' . $original_duty . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            /**
             * Check shift exists
             */
            $original_shift = $row_data[$alpha_column_order['Shift Type']];
            $row_data[$alpha_column_order['Shift Type']] = str_replace(' ', '_', trim($row_data[$alpha_column_order['Shift Type']]));
            $row_data[$alpha_column_order['Shift Type']] = preg_replace('/[^\w\d]+/', '%', $row_data[$alpha_column_order['Shift Type']]);
            $shift_type = getByWhereAsArray('shift', 'id', [], [], 0, 0, ['name' => $row_data[$alpha_column_order['Shift Type']]]);
            if ($shift_type) {
                $shift_type = $shift_type[0]['id'];
            } else {
                $this->session->set_flashdata('exception', 'Shift "' . $original_shift . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            /**
             * Check role exists
             */
            $original_role = $row_data[$alpha_column_order['Role']];
            $row_data[$alpha_column_order['Role']] = str_replace(' ', '_', trim($row_data[$alpha_column_order['Role']]));
            $row_data[$alpha_column_order['Role']] = preg_replace('/[^\w\d]+/', '%', $row_data[$alpha_column_order['Role']]);
            $role_id = getByWhereAsArray('sec_role_tbl, sec_user_access_tbl-sec_user_access_tbl.fk_role_id=sec_role_tbl.role_id-left', 'sec_role_tbl.role_id', [], [], 0, 0, ['sec_role_tbl.role_name' => $row_data[$alpha_column_order['Role']]]);
            if ($role_id) {
                $role_id = $role_id[0]['role_id'];
            } else {
                $this->session->set_flashdata('exception', 'Role "' . $original_role . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            /**
             * Salary Type Check
             */
            $original_salary_type = $row_data[$alpha_column_order['Salary Type']];
            $s_types = [
                'monthly' => 2,
            ];
            $s_type = 0;
            if (@$s_types[trim(strtolower($row_data[$alpha_column_order['Salary Type']]))]) {
                $s_type = $s_types[trim(strtolower($row_data[$alpha_column_order['Salary Type']]))];
            } else {
                $this->session->set_flashdata('exception', 'Salary Type "' . $original_salary_type . '" not found on row# ' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            $postData = [
                'employee_id' => $employee_id,
                'hrm_id' => trim($row_data[$alpha_column_order['HRM ID']]),
                'pos_id' => $position,
                'first_name' => $row_data[$alpha_column_order['First Name']],
                'middle_name' => $row_data[$alpha_column_order['Middle Name']],
                'last_name' => $row_data[$alpha_column_order['Last Name']],
                'father_name' => $row_data[$alpha_column_order['Father Name']],
                'maiden_name' => '',
                'email' => $row_data[$alpha_column_order['HRM Email Address']],
                'phone' => $row_data[$alpha_column_order['Phone']],
                'alter_phone' => $row_data[$alpha_column_order['Alternative Phone']],
                'present_address' => $row_data[$alpha_column_order['Present Address']],
                'parmanent_address' => $row_data[$alpha_column_order['Permanent Address']],
                'picture' => '',
                'dept_id' => $department,
                'division_id' => $division,
                'state' => $row_data[$alpha_column_order['Country']],
                'city' => $row_data[$alpha_column_order['City']],
                'zip' => '',
                'citizenship' => '',
                'duty_type' => $duty_type,
                'hire_date' => convert_excel_date($row_data[$alpha_column_order['Hire Date']]),
                'original_hire_date' => convert_excel_date($row_data[$alpha_column_order['Original Hire Date']]),
                'termination_date' => convert_excel_date($row_data[$alpha_column_order['Terminate Date']]),
                'termination_reason' => $row_data[$alpha_column_order['Terminatation Reason']],
                'voluntary_termination' => strtolower(trim($row_data[$alpha_column_order['Voluntary Resignation']])) == 'yes' ? 1 : 0,
                'rehire_date' => convert_excel_date($row_data[$alpha_column_order['Rehire Date']]),
                'rate_type' => $s_type,
                'rate' => $row_data[$alpha_column_order['Basic Salary']],
                'current_salary' => $row_data[$alpha_column_order['Gross Salary']],
                'pay_frequency' => '',
                'pay_frequency_txt' => '',
                'hourly_rate2' => '',
                'hourly_rate3' => '',
                'home_department' => '',
                'department_text' => '',
                'class_code' => '',
                'class_code_desc' => '',
                'class_acc_date' => date("Y-m-d", strtotime(!empty($this->input->post('class_acc_date', true)) ? $this->input->post('class_acc_date', true) : date('Y-m-d'))),
                'class_status' => '',
                'is_super_visor' => strtolower(trim($row_data[$alpha_column_order['Is Supervisor']])) == 'yes' ? 1 : 0,
                'dob' => convert_excel_date($row_data[$alpha_column_order['Date of birth']]),
                'gender' => $gender,
                'marital_status' => $marital_status,
                'ethnic_group' => $row_data[$alpha_column_order['Religion']],
                'eeo_class_gp' => '',
                'cnic' => preg_replace('@[^\d]@', '', $row_data[$alpha_column_order['CNIC']]),
                'work_in_state' => '',
                'live_in_state' => '',
                'home_email' => $row_data[$alpha_column_order['Personal Email']],
                'business_email' => $row_data[$alpha_column_order['Business Email']],
                'home_phone' => $row_data[$alpha_column_order['Home Phone']],
                'business_phone' => '',
                'cell_phone' => $row_data[$alpha_column_order['Cell Phone']],
                'emerg_contct' => $row_data[$alpha_column_order['Emergency Contact Number']],
                'emrg_h_phone' => '',
                'emrg_w_phone' => '',
                'emgr_contct_relation' => '',
                'alt_em_contct' => '',
                'alt_emg_h_phone' => '',
                'alt_emg_w_phone' => '',
                'shift' => $shift_type,
                'probation_period' => $row_data[$alpha_column_order['Probation Period (Months)']],
                'performance_duration' => $row_data[$alpha_column_order['Performance Review Duration']],
                'hired_salary' => $row_data[$alpha_column_order['Hired Salary']],
                'first_salary' => $row_data[$alpha_column_order['Salary 1st Raise']],
                'second_salary' => $row_data[$alpha_column_order['Salary 2nd Raise']],
                'third_salary' => $row_data[$alpha_column_order['Salary 3rd Raise']],
                'eobi_check' => trim(strtolower($row_data[$alpha_column_order['EOBI']])) == 'yes' ? 1 : 0,
                'eobi' => trim(strtolower($row_data[$alpha_column_order['EOBI Amount']])) == 'yes' ? 1 : 0,
                'work_from_home' => trim(strtolower($row_data[$alpha_column_order['Work From Home']])) == 'yes' ? 1 : 0,
                'transportation_required' => trim(strtolower($row_data[$alpha_column_order['Transportation Required']])) == 'yes' ? 1 : 0,
            ];
            $employee_id = $this->Employees_model->create_employee($postData);
            $this->db->insert('user', [
                'firstname' => trim($row_data[$alpha_column_order['First Name']]),
                'lastname' => trim($row_data[$alpha_column_order['Last Name']]),
                'email' => trim($row_data[$alpha_column_order['HRM Email Address']]),
                'password' => md5($row_data[$alpha_column_order['Password']]),
            ]);
            $this->db->insert('sec_user_access_tbl', [
                'fk_role_id' => $role_id,
                'fk_user_id' => $this->db->insert_id(),
            ]);
            $coa = $this->Employees_model->headcode();
            if ($coa->HeadCode != null) {
                $headcode = $coa->HeadCode + 1;
            } else {
                $headcode = "502020000001";
            }
            $c_code = $employee_id;
            $c_name = $row_data[$alpha_column_order['First Name']] . $row_data[$alpha_column_order['Last Name']];
            $c_acc = $c_code . '-' . $c_name;
            $createby = $this->session->userdata('fullname');
            $createdate = date('Y-m-d H:i:s');
            $data['aco'] = (Object) $coaData = [
                'HeadCode' => $headcode,
                'HeadName' => $c_acc,
                'PHeadName' => 'Account Payable',
                'HeadLevel' => '2',
                'IsActive' => '1',
                'IsTransaction' => '1',
                'IsGL' => '0',
                'HeadType' => 'L',
                'IsBudget' => '0',
                'IsDepreciation' => '0',
                'DepreciationRate' => '0',
                'CreateBy' => $createby,
                'CreateDate' => $createdate,
            ];
            $this->Employees_model->create_coa($coaData);
        }
        foreach ($excel_data as $row_num => $row_data) {
            if (count(array_diff($row_data, $header_row)) <= 10) {
                continue;
            }
            if (empty($row_data[$alpha_column_order['Direct Reporting']]) && empty($row_data[$alpha_column_order['Indirect Reporting']])) {
                continue;
            }
            $emp_rec = $this->db->where(['hrm_id' => trim($row_data[$alpha_column_order['HRM ID']])])->order_by('emp_his_id', 'DESC')->get('employee_history')->row();
            if (!$emp_rec) {
                $this->session->set_flashdata('exception', 'ROW: #' . $row_num . ' - Employee failed to insert. Try again later');
                redirect($_SERVER['HTTP_REFERER']);return;
            }
            $direct_supervisor_id = 0;
            if (!empty($row_data[$alpha_column_order['Direct Reporting']])) {
                $direct_supervisor_id = $this->db->select('employee_id')
                    ->where('hrm_id', trim($row_data[$alpha_column_order['Direct Reporting']]))
                    ->from('employee_history')
                    ->get()
                    ->row();
                if ($direct_supervisor_id) {
                    $direct_supervisor_id = $direct_supervisor_id->employee_id;
                } else {
                    $this->session->set_flashdata('exception', 'ROW: #' . $row_num . ' - Direct Supervisor with ID "' . trim($row_data[$alpha_column_order['Direct Reporting']]) . '" doesn\'t exist.<br>Make sure add all the supervisor before other employees');
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
            }
            /**
             * Get Indirect Supervisor ID
             */
            $indirect_supervisor_id = 0;
            if (!empty($row_data[$alpha_column_order['Indirect Reporting']])) {
                $indirect_supervisor_id = $this->db->select('employee_id')
                    ->where('hrm_id', trim($row_data[$alpha_column_order['Indirect Reporting']]))
                    ->from('employee_history')
                    ->get()
                    ->row();
                if ($indirect_supervisor_id) {
                    $indirect_supervisor_id = $indirect_supervisor_id->employee_id;
                } else {
                    $this->session->set_flashdata('exception', 'ROW: #' . $row_num . ' - Indirect Supervisor with ID "' . trim($row_data[$alpha_column_order['Indirect Reporting']]) . '" doesn\'t exist.<br>Make sure add all the supervisor before other employees');
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
            }
            $this->db->where('emp_his_id', $emp_rec->emp_his_id)->update('employee_history', [
                'super_visor_id' => $direct_supervisor_id,
                'indirect_super_visor_id' => $indirect_supervisor_id,
            ]);
        }
        $this->db->trans_complete();
        if ($this->db->trans_status() === false) {
            $this->session->set_flashdata('exception', 'Error importing data, try again later');
        } else {
            $this->session->set_flashdata('message', 'Data imported successfully');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function bulk_update()
    {
        if ($this->input->method() != 'post') {
            $data['title'] = 'Bulk Update Employees';
            $data['module'] = "employee";
            $data['page'] = "bulk_update";
            echo Modules::run('template/layout', $data);return;
        }
        $this->load->library('myupload');
        $file = $this->myupload->do_upload(FCPATH . 'uploads/temp/', 'file', true);
        if (!$file) {
            $this->session->set_flashdata('exception', 'File upload failed, try again later!');
            redirect($_SERVER['HTTP_REFERER']);
        }
        $excel_data = $this->excel->read($file);
        $heading_row = array_shift($excel_data);
        $hrm_id_key = array_search('HRM ID', $heading_row);
        if ($hrm_id_key === false) {
            $this->session->set_flashdata('exception', 'Required "HRM ID" Column not found in sheet. Make sure first row is heading');
            redirect($_SERVER['HTTP_REFERER']);return;
        }
        $this->db->trans_start();
        foreach ($excel_data as $row_num => $row_data) {
            $row_num++;
            /**
             * Duplicate HRM ID check
             */
            if (empty($row_data[$hrm_id_key])) {
                $this->session->set_flashdata('exception', 'Required "HRM ID" Column empty on row #' . $row_num);
                redirect($_SERVER['HTTP_REFERER']);return;
            } else {
                $employee_rec = $this->db->select('*')
                    ->where('hrm_id', trim($row_data[$hrm_id_key]))
                    ->from('employee_history')
                    ->get()
                    ->row();
                if (!$employee_rec) {
                    $this->session->set_flashdata('exception', 'HRM ID "' . trim($row_data[$hrm_id_key]) . '" doesn\'t exist from row# ' . $row_num);
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
            }
            $employee_history_data = [];
            $user_data = [];
            foreach ($heading_row as $head_key => $head_value) {
                if ($head_key == $hrm_id_key) {
                    continue;
                }
                if (empty(trim($row_data[$head_key]))) {
                    continue;
                }
                $head_value = trim($head_value);
                if (strtolower($head_value) == 'first name') {
                    $employee_history_data['first_name'] = $row_data[$head_key];
                    $user_data['firstname'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'middle name') {
                    $employee_history_data['middle_name'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'last name') {
                    $employee_history_data['last_name'] = $row_data[$head_key];
                    $user_data['lastname'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'father name') {
                    $employee_history_data['father_name'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'phone') {
                    $employee_history_data['phone'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'alternative phone') {
                    $employee_history_data['alter_phone'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'country') {
                    $employee_history_data['state'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'city') {
                    $employee_history_data['city'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'division') {
                    /**
                     * Check Division exists
                     */
                    $original_div = $row_data[$head_key];
                    $row_data[$head_key] = str_replace(' ', '_', trim($row_data[$head_key]));
                    $row_data[$head_key] = preg_replace('/[^\w\d]+/', '%', $row_data[$head_key]);
                    $division = getByWhereAsArray('divisions', 'id, prefix', [], [], 0, 0, ['name' => $row_data[$head_key]]);
                    if ($division) {
                        $division = $division[0]['id'];
                    } else {
                        $this->session->set_flashdata('exception', 'Division "' . $original_div . '" not found on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }

                    $employee_history_data['division_id'] = $division;
                }
                if (strtolower($head_value) == 'department') {
                    /**
                     * Check department exists
                     */
                    $original_deptt = $row_data[$head_key];
                    $row_data[$head_key] = str_replace(' ', '_', trim($row_data[$head_key]));
                    $row_data[$head_key] = preg_replace('/[^\w\d]+/', '%', $row_data[$head_key]);
                    $department = getByWhereAsArray('department', 'dept_id', [], [], 0, 0, ['department_name' => $row_data[$head_key]]);
                    if ($department) {
                        $department = $department[0]['dept_id'];
                    } else {
                        $this->session->set_flashdata('exception', 'Department "' . $original_deptt . '" not found on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_history_data['dept_id'] = $department;
                }
                if (strtolower($head_value) == 'position') {
                    /**
                     * Check position exists
                     */
                    $original_pos = $row_data[$head_key];
                    $row_data[$head_key] = str_replace(' ', '_', trim($row_data[$head_key]));
                    $row_data[$head_key] = preg_replace('/[^\w\d]+/', '%', $row_data[$head_key]);
                    $position = getByWhereAsArray('position', 'pos_id', [], [], 0, 0, ['position_name' => $row_data[$head_key]]);
                    if ($position) {
                        $position = $position[0]['pos_id'];
                    } else {
                        $this->session->set_flashdata('exception', 'Position "' . $original_pos . '" not found on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_history_data['pos_id'] = $position;
                }
                if (strtolower($head_value) == 'duty type') {
                    /**
                     * Check duty type exists
                     */
                    $original_duty = $row_data[$head_key];
                    $row_data[$head_key] = str_replace(' ', '_', trim($row_data[$head_key]));
                    $row_data[$head_key] = preg_replace('/[^\w\d]+/', '%', $row_data[$head_key]);
                    $duty_type = getByWhereAsArray('duty_type', 'id', [], [], 0, 0, ['type_name' => $row_data[$head_key]]);
                    if ($duty_type) {
                        $duty_type = $duty_type[0]['id'];
                    } else {
                        $this->session->set_flashdata('exception', 'Duty Type "' . $original_duty . '" not found on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_history_data['duty_type'] = $duty_type;
                }
                if (strtolower($head_value) == 'probation period (months)') {
                    $employee_history_data['probation_period'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'shift') {
                    /**
                     * Check shift exists
                     */
                    $original_shift = $row_data[$head_key];
                    $row_data[$head_key] = str_replace(' ', '_', trim($row_data[$head_key]));
                    $row_data[$head_key] = preg_replace('/[^\w\d]+/', '%', $row_data[$head_key]);
                    $shift_type = getByWhereAsArray('shift', 'id', [], [], 0, 0, ['name' => $row_data[$head_key]]);
                    if ($shift_type) {
                        $shift_type = $shift_type[0]['id'];
                    } else {
                        $this->session->set_flashdata('exception', 'Shift "' . $original_shift . '" not found on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_history_data['shift'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'hire date') {
                    $employee_history_data['hire_date'] = convert_excel_date($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'original hire date') {
                    $employee_history_data['original_hire_date'] = convert_excel_date($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'termination date') {
                    $employee_history_data['termination_date'] = convert_excel_date($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'termination reason') {
                    $employee_history_data['termination_reason'] = strip_tags($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'voluntary resignation') {
                    $employee_history_data['voluntary_termination'] = strtolower(trim($row_data[$head_key])) == 'yes' ? 1 : 0;
                }
                if (strtolower($head_value) == 'rehire date') {
                    $employee_history_data['rehire_date'] = convert_excel_date($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'salary type') {
                    /**
                     * Salary Type Check
                     */
                    $original_salary_type = $row_data[$head_key];
                    $s_types = [
                        'monthly' => 2,
                    ];
                    $s_type = 0;
                    if (@$s_types[trim(strtolower($row_data[$head_key]))]) {
                        $s_type = $s_types[trim(strtolower($row_data[$head_key]))];
                    } else {
                        $this->session->set_flashdata('exception', 'Salary Type "' . $original_salary_type . '" not found on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_history_data['rate_type'] = $s_type;
                }
                if (strtolower($head_value) == 'performance review duration (months)') {
                    $employee_history_data['performance_duration'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'hired salary') {
                    $employee_history_data['hired_salary'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'salary 1st raise') {
                    $employee_history_data['first_salary'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'salary 2nd raise') {
                    $employee_history_data['second_salary'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'salary 3rd raise') {
                    $employee_history_data['third_salary'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'basic salary') {
                    $employee_history_data['rate'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'gross salary') {
                    $employee_history_data['current_salary'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'eobi') {
                    $employee_history_data['eobi'] = strtolower(trim($row_data[$head_key])) == 'yes' ? 1 : 0;
                }
                if (strtolower($head_value) == 'eobi amount') {
                    $employee_history_data['eobi_amount'] = $row_data[$head_key];
                }
                if (strtolower($head_value) == 'is supervisor') {
                    $employee_history_data['is_super_visor'] = strtolower(trim($row_data[$head_key])) == 'yes' ? 1 : 0;
                }
                if (strtolower($head_value) == 'direct reporting to') {
                    $direct_supervisor_id = $this->db->select('employee_id')
                        ->where('hrm_id', trim($row_data[$head_key]))
                        ->from('employee_history')
                        ->get()
                        ->row();
                    if ($direct_supervisor_id) {
                        $direct_supervisor_id = $direct_supervisor_id->employee_id;
                    } else {
                        $this->session->set_flashdata('exception', 'ROW: #' . $row_num . ' - Direct Supervisor with ID "' . trim($row_data[$head_key]) . '" doesn\'t exist.<br>Make sure add all the supervisor before other employees');
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_history_data['super_visor_id'] = $direct_supervisor_id;
                }
                if (strtolower($head_value) == 'indirect reporting to') {
                    $indirect_supervisor_id = $this->db->select('employee_id')
                        ->where('hrm_id', trim($row_data[$head_key]))
                        ->from('employee_history')
                        ->get()
                        ->row();
                    if ($indirect_supervisor_id) {
                        $indirect_supervisor_id = $indirect_supervisor_id->employee_id;
                    } else {
                        $this->session->set_flashdata('exception', 'ROW: #' . $row_num . ' - Indirect Supervisor with ID "' . trim($row_data[$head_key]) . '" doesn\'t exist.<br>Make sure add all the supervisor before other employees');
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $employee_history_data['indirect_super_visor_id'] = $indirect_supervisor_id;
                }
                if (strtolower($head_value) == 'date of birth') {
                    $employee_history_data['dob'] = convert_excel_date($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'gender') {
                    /**
                     * Check gender exists
                     */
                    $gender = getByWhereAsArray('gender', 'id', ['gender_name' => trim($row_data[$head_key])]);
                    if ($gender) {
                        $gender = $gender[0]['id'];
                    } else {
                        $this->db->insert('gender', [
                            'gender_name' => trim($row_data[$head_key]),
                        ]);
                        $gender = $this->db->insert_id();
                    }
                    $employee_history_data['gender'] = $gender;
                }
                if (strtolower($head_value) == 'martial status') {
                    /**
                     * Check marital status exists
                     */
                    $marital_status = getByWhereAsArray('marital_info', 'id', ['marital_sta' => trim($row_data[$head_key])]);
                    if ($marital_status) {
                        $marital_status = $marital_status[0]['id'];
                    } else {
                        $this->db->insert('marital_info', [
                            'marital_sta' => trim($row_data[$head_key]),
                        ]);
                        $marital_status = $this->db->insert_id();
                    }
                    $employee_history_data['marital_status'] = $marital_status;
                }
                if (strtolower($head_value) == 'religion') {
                    $employee_history_data['ethnic_group'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'cnic') {
                    $employee_history_data['cnic'] = preg_replace('@[^\d]@', '', $row_data[$head_key]);
                }
                if (strtolower($head_value) == 'personal email') {
                    $employee_history_data['home_email'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'business email') {
                    $employee_history_data['business_email'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'home phone') {
                    $employee_history_data['home_phone'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'emergency contact number') {
                    $employee_history_data['emerg_contct'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'cell phone') {
                    $employee_history_data['cell_phone'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'present address') {
                    $employee_history_data['present_address'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'permanent address') {
                    $employee_history_data['parmanent_address'] = trim($row_data[$head_key]);
                }
                if (strtolower($head_value) == 'work from home') {
                    $employee_history_data['work_from_home'] = strtolower(trim($row_data[$head_key])) == 'yes' ? 1 : 0;
                }
                if (strtolower($head_value) == 'transportation required') {
                    $employee_history_data['transportation_required'] = strtolower(trim($row_data[$head_key])) == 'yes' ? 1 : 0;
                }
                $user_rec = $this->db->where('email', $employee_rec->email)->get('user')->row();
                if (!$user_rec) {
                    $this->session->set_flashdata('exception', 'User with email "' . $employee_rec->email . '" not found on row# ' . $row_num);
                    redirect($_SERVER['HTTP_REFERER']);return;
                }
                if (strtolower($head_value) == 'role') {
                    /**
                     * Check role exists
                     */
                    $original_role = $row_data[$head_key];
                    $row_data[$head_key] = str_replace(' ', '_', trim($row_data[$head_key]));
                    $row_data[$head_key] = preg_replace('/[^\w\d]+/', '%', $row_data[$head_key]);
                    $role_id = getByWhereAsArray('sec_role_tbl, sec_user_access_tbl-sec_user_access_tbl.fk_role_id=sec_role_tbl.role_id-left', 'sec_role_tbl.role_id', [], [], 0, 0, ['sec_role_tbl.role_name' => $row_data[$head_key]]);
                    if ($role_id) {
                        $role_id = $role_id[0]['role_id'];
                    } else {
                        $this->session->set_flashdata('exception', 'Role "' . $original_role . '" not found on row# ' . $row_num);
                        redirect($_SERVER['HTTP_REFERER']);return;
                    }
                    $this->db->where('fk_user_id', $user_rec->id)->delete('sec_user_access_tbl');
                    $this->db->insert('sec_user_access_tbl', [
                        'fk_role_id' => $role_id,
                        'fk_user_id' => $user_rec->id,
                    ]);
                }
                if (strtolower($head_value) == 'password') {
                    $user_data['password'] = md5($row_data[$head_key]);
                }
            }
            if ($employee_history_data) {
                $this->db->where('hrm_id', trim($row_data[$hrm_id_key]))->update('employee_history', $employee_history_data);
            }
            if ($user_data) {
                $this->db->where('email', $employee_rec->email)->update('user', $user_data);
            }
        }
        $this->db->trans_complete();
        if ($this->db->trans_status() === false) {
            $this->session->set_flashdata('exception', 'Error importing data, try again later');
        } else {
            $this->session->set_flashdata('message', 'Data updated successfully');
        }
        redirect($_SERVER['HTTP_REFERER']);
    }
    public function delete_employhistory($id = null)
    {
        $this->permission->module('employee', 'delete')->redirect();
        $device_ip = $this->deviceData()->device_ip;
        if ($this->Employees_model->emplyee_history_delete($id)) {
            /* $zk = new ZKLibrary($device_ip, 4370);
            // echo 'welcome';exit();
            $zk->connect();
            $zk->disableDevice();
            $delete = $zk->deleteUser($id);
            $zk->enableDevice();
            $zk->disconnect();
            #set success message */
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect("employee/Employees/manageemployee");
    }
    public function download($id)
    {
        # load download helper
        $this->load->helper('download');
        # search for filename by id
        $id = $this->uri->segment(4);
        $this->db->select('*');
        $this->db->where('employee_id', $id);
        $q = $this->db->get('employee_history');
        # if exists continue
        if ($q->num_rows() > 0) {
            $row = $q->row();
            $file = FCPATH . 'files/' . $row->filename;
            if (file_exists($file)) {
                force_download($file, null);
            }

        } else {
            show_404();
        }

    }
    public function DOWNLOAD_pdf()
    {
        $data = array();
        $data['cv'] = $this->Employees_model->employee_details();
        $html = $this->load->view('cv', $data, true);
        pdf_create($html, 'User List');
    }
    public function position_view()
    {
        $this->permission->module('employee', 'read')->redirect();
        $data['title'] = display('circularprocess_list');
        $data['position'] = $this->Employees_model->viewPosition();
        $data['module'] = "employee";
        $data['page'] = "positionview";
        echo Modules::run('template/layout', $data);
    }
    public function create_position()
    {
        $data['title'] = display('employee');
        #-------------------------------#
        $this->form_validation->set_rules('position_name', display('position_name'), 'required|max_length[50]');
        $this->form_validation->set_rules('position_details', display('position_details'), 'max_length[200]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'position_name' => $this->input->post('position_name', true),
                'position_details' => $this->input->post('position_details', true),
            ];
            if ($this->Employees_model->position_create($postData)) {
                $this->session->set_flashdata('message', display('successfully_saved'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("employee/Employees/create_position");
        } else {
            $data['title'] = display('create');
            $data['module'] = "employee";
            $data['position'] = $this->Employees_model->viewPosition();
            $data['page'] = "position_form";
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_pos($id = null)
    {
        $this->permission->module('employee', 'delete')->redirect();
        if ($this->Employees_model->delete_p($id)) {
            #set success message
            $this->session->set_flashdata('message', display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception', display('please_try_again'));
        }
        redirect('employee/Employees/position_view');
    }
    public function update_form($id = null)
    {
        $this->form_validation->set_rules('pos_id', null, 'required|max_length[11]');
        $this->form_validation->set_rules('position_name', display('position_name'), 'required|max_length[50]');
        $this->form_validation->set_rules('position_details', display('position_details'), 'max_length[30]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $postData = [
                'pos_id' => $this->input->post('pos_id', true),
                'position_name' => $this->input->post('position_name', true),
                'position_details' => $this->input->post('position_details', true),
            ];
            if ($this->Employees_model->update_position($postData)) {
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect('employee/Employees/position_view');
        } else {
            $data['data'] = $this->Employees_model->pos_updateForm($id);
            $data['module'] = "employee";
            $data['page'] = "update_position";
            echo Modules::run('template/layout', $data);
        }
    }
    ////************Employee Update Part***********//
    public function update_employee_form($id = null)
    {
        /***** file upload code start ***********/
        $data['title'] = display('employee_update_form');
        $device_ip = $this->deviceData()->device_ip;
        $this->form_validation->set_rules('first_name', display('first_name'), 'max_length[50]');
        $this->load->library('myupload');
        $img = $this->myupload->do_upload(
            './application/modules/employee/assets/images/',
            'picture'
        );
        $this->form_validation->set_rules('c_f_name[]', 'Custom Field Name');
        $this->form_validation->set_rules('c_f_type[]', 'Custom Field Type');
        $this->form_validation->set_rules('customvalue[]', 'Custom Value');
        $customr_field = $this->input->post('c_f_name');
        $customr_field_type = $this->input->post('c_f_type');
        $customr_value = $this->input->post('customvalue');
        $benifit_code = $this->input->post('benefit_id', true);
        $benifit_code_desc = $this->input->post('benifit_c_code_d', true);
        $benifit_acc_date = $this->input->post('benifit_acc_date', true);
        $benift_status = $this->input->post('benifit_sst', true);
        $c_code = $id;
        $c_name = $this->input->post('first_name') . $this->input->post('last_name');
        $c_acc = $c_code . '-' . $c_name;
        $old_accname = $id . '-' . $this->input->post('oldfirstname') . $this->input->post('oldlastname');
        #-------------------------------#
        if ($this->form_validation->run() === true) {
            $email = $this->input->post('email', true);
            $empOriginal = $this->db->select('*')->from('employee_history')->where('employee_id', $id)->order_by('emp_his_id', 'desc')->limit(1)->get()->result();
            if ($empOriginal) {
                $this->db->where('email', $empOriginal[0]->email)->update('user', ['email' => $email]);
            }
            $data['employee'] = (Object) $postData = [
                'employee_id' => $this->input->post('employee_id', true),
                'pos_id' => $this->input->post('pos_id', true),
                'hrm_id' => $this->input->post('hrm_id', true),
                'first_name' => $this->input->post('first_name', true),
                'maiden_name' => $this->input->post('maiden_name'),
                'middle_name' => $this->input->post('middle_name', true),
                'last_name' => $this->input->post('last_name', true),
                'father_name' => $this->input->post('father_name'),
                'email' => $this->input->post('email', true),
                'phone' => $this->input->post('phone', true),
                'alter_phone' => $this->input->post('alter_phone', true),
                'present_address' => $this->input->post('present_address', true),
                'parmanent_address' => $this->input->post('parmanent_address', true),
                'picture' => (!empty($img) ? $img : $this->input->post('old_image')),
                'dept_id' => $this->input->post('department', true),
                'division_id' => $this->input->post('division', true),
                'state' => $this->input->post('state', true),
                'city' => $this->input->post('city', true),
                'zip' => $this->input->post('zip_code', true),
                'citizenship' => $this->input->post('citizenship', true),
                'duty_type' => $this->input->post('duty_type', true),
                'hire_date' => date("Y-m-d", strtotime(!empty($this->input->post('hiredate', true)) ? $this->input->post('hiredate', true) : date('Y-m-d'))),
                'original_hire_date' => date("Y-m-d", strtotime(!empty($this->input->post('ohiredate', true)) ? $this->input->post('ohiredate', true) : date('Y-m-d'))),
                'termination_date' => date("Y-m-d", strtotime(!empty($this->input->post('terminatedate', true)) ? $this->input->post('terminatedate', true) : date('Y-m-d'))),
                'termination_reason' => $this->input->post('termreason', true),
                'voluntary_termination' => $this->input->post('volunt_termination', true),
                'rehire_date' => date("Y-m-d", strtotime(!empty($this->input->post('rehiredate', true)) ? $this->input->post('rehiredate', true) : date('Y-m-d'))),
                'rate_type' => $this->input->post('rate_type', true),
                'rate' => $this->input->post('rate', true),
                'current_salary' => $this->input->post('current_salary', true),
                'pay_frequency' => $this->input->post('pay_frequency', true),
                'pay_frequency_txt' => $this->input->post('pay_f_text', true),
                'hourly_rate2' => $this->input->post('h_rate2', true),
                'hourly_rate3' => $this->input->post('h_rate3', true),
                'home_department' => $this->input->post('h_department', true),
                'department_text' => $this->input->post('h_dep_text', true),
                'class_code' => $this->input->post('c_code', true),
                'class_code_desc' => $this->input->post('c_code_d', true),
                'class_acc_date' => date("Y-m-d", strtotime(!empty($this->input->post('class_acc_date', true)) ? $this->input->post('class_acc_date', true) : date('Y-m-d'))),
                'class_status' => $this->input->post('class_sst', true),
                'is_super_visor' => $this->input->post('is_supervisor', true),
                'super_visor_id' => $this->input->post('supervisorname', true),
                'indirect_super_visor_id' => $this->input->post('indirect_supervisorname', true),
                'supervisor_report' => $this->input->post('reports', true),
                'dob' => date("Y-m-d", strtotime(!empty($this->input->post('dob', true)) ? $this->input->post('dob', true) : date('Y-m-d'))),
                'gender' => $this->input->post('gender', true),
                'marital_status' => $this->input->post('marital_status', true),
                'ethnic_group' => $this->input->post('ethnic', true),
                'eeo_class_gp' => $this->input->post('eeo_class', true),
                'cnic' => $this->input->post('cnic', true),
                'work_in_state' => $this->input->post('w_s', true),
                'live_in_state' => $this->input->post('l_in_s', true),
                'home_email' => $this->input->post('h_email', true),
                'business_email' => $this->input->post('b_email', true),
                'home_phone' => $this->input->post('h_phone', true),
                'business_phone' => $this->input->post('w_phone', true),
                'cell_phone' => $this->input->post('c_phone', true),
                'emerg_contct' => $this->input->post('em_contact', true),
                'emrg_h_phone' => $this->input->post('e_h_phone', true),
                'emrg_w_phone' => $this->input->post('e_w_phone', true),
                'emgr_contct_relation' => $this->input->post('e_c_relation', true),
                'alt_em_contct' => $this->input->post('alt_em_cont', true),
                'alt_emg_h_phone' => $this->input->post('a_e_h_phone', true),
                'alt_emg_w_phone' => $this->input->post('a_e_w_phone', true),
                'shift' => $this->input->post('shift', true),
                'probation_period' => $this->input->post('probation_period', true),
                'performance_duration' => $this->input->post('performance_duration', true),
                'probation_notified' => 0,
                'hired_salary' => $this->input->post('hired_salary', true),
                'first_salary' => $this->input->post('first_salary', true),
                'second_salary' => $this->input->post('second_salary', true),
                'third_salary' => $this->input->post('third_salary', true),
            ];
            $accHead = [
                'HeadName' => $c_acc,
            ];
            if ($this->Employees_model->update_employee($postData)) {
                $employeeType = $this->input->post('leave_type', true);
                $employeeQuote = $this->input->post('leave_qouta', true);
                $this->db->where('emp_id', $id);
                $del = $this->db->delete('employee_leaves');
                if ($del) {
                    for ($i = 0; $i < count($employeeType); $i++) {
                        $updateLeave['leave_type'] = $employeeType[$i];
                        $updateLeave['leave_qouta'] = $employeeQuote[$i];
                        $updateLeave['emp_id'] = $id;
                        $this->db->insert('employee_leaves', $updateLeave);
                    }
                }
                $this->db->where('HeadName', $old_accname)
                    ->update("acc_coa", $accHead);
                $this->db->where('employee_id', $id)->delete('emp_salary_setup_details');
                foreach ($_POST['addition'] as $key => $value) {
                    $addition = [];
                    $addition['addition_id'] = $key;
                    $addition['employee_id'] = $id;
                    $addition['value'] = $value;
                    $addition['created_on'] = date('Y-m-d');
                    if (!empty($addition['addition_id']) && !empty($addition['value'])) {
                        $this->db->insert('emp_salary_setup_details', $addition);
                    }
                }
                foreach ($_POST['deduction'] as $key => $value) {
                    $deduction['deduction_id'] = $key;
                    $deduction['employee_id'] = $id;
                    $deduction['value'] = $value;
                    $deduction['created_on'] = date('Y-m-d');
                    if (!empty($deduction['deduction_id']) && !empty($deduction['value'])) {
                        $this->db->insert('emp_salary_setup_details', $deduction);
                    }
                }
//                  $zk = new ZKLibrary($device_ip, 4370);
                //                 $zk->connect();
                //             echo 'welcome';exit();
                //                 $zk->disableDevice();
                //             $delete = $zk->deleteUser($id);
                //             $zk->setUser($id, $id, $this->input->post('first_name').' '.$this->input->post('last_name'), '', 0);
                //             $zk->enableDevice();
                //                 $zk->disconnect();
                $this->db->where('employee_id', $this->input->post('employee_id', true))
                    ->delete('custom_table');
                $this->db->where('employee_id', $this->input->post('employee_id', true))
                    ->delete('employee_benifit');
                for ($i = 0; $i < sizeof($customr_field); $i++) {
                    //print_r(count($customr_field));exit();
                    $custom = [
                        'custom_field' => $customr_field[$i],
                        'custom_data_type' => $customr_field_type[$i],
                        'custom_data' => $customr_value[$i],
                        'employee_id' => $this->input->post('employee_id', true),
                    ];
                    if (!empty($customr_field[$i])) {
                        $this->db->insert('custom_table', $custom);
                    }
                }
                for ($i = 0; $i < count($benifit_code); $i++) {
                    if ($benifit_code[$i] != 'Select Benefits') {
                        $benifit = [
                            'bnf_cl_code_des' => $benifit_code_desc[$i],
                            'bnff_acural_date' => date("Y-m-d", strtotime(!empty($benifit_acc_date[$i]) ? $benifit_acc_date[$i] : date('Y-m-d'))),
                            'bnf_status' => $benift_status[$i],
                            'employee_id' => $this->input->post('employee_id', true),
                            'benefit_id' => $benifit_code[$i],
                        ];
                        if (!empty($benifit_code[$i])) {
                            $this->db->insert('employee_benifit', $benifit);
                        }
                    }
                }
                $this->session->set_flashdata('message', display('update_successfully'));
                redirect("employee/Employees/cv/" . $id);
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
        } else {
            $data['additions'] = $this->Employees_model->get_addtions($id);
            $data['deductions'] = $this->Employees_model->get_deductions($id);
            $data['data'] = $this->Employees_model->employee_updateForm($id);
            $data['module'] = "employee";
            $data['page'] = "update_employee_form";
            $data['genders'] = getByWhere('gender', '*', [], ['gender_name', 'ASC']);
            $data['martial_statuses'] = getByWhere('marital_info', '*', [], ['marital_sta', 'ASC']);
            $data['dropdowndept'] = $this->Employees_model->dropdowndept();
//             $data['dropdowndev'] = $this->Employees_model->dropdowndev();
            $data['designation'] = $this->Employees_model->designation();
            $data['supervisor'] = $this->Employees_model->supervisorlist();
            $data['custominfo'] = $this->Employees_model->customifo($id);
            $data['benifit'] = $this->Employees_model->benifit($id);
            $data['bb'] = $this->Employees_model->get_pos($id);
            $data['document_types'] = getByWhere('upload_documents_type', '*', [], ['title', 'ASC']);
            $data['all_documents'] = getByWhere(
                'upload_documents,
				upload_documents_type-upload_documents.document_type=upload_documents_type.id-left',
                'upload_documents.*, upload_documents_type.title as type_title',
                ['upload_documents.employee_id' => $id]
            );
            $data['leave_type'] = $this->Employees_model->leave_type();
            $data['employee_leave'] = $this->db->select('*')->from('employee_leaves')->where('emp_id', $id)->order_by('id', 'desc')->get()->first_row();
            $data['dropdowndev'] = $this->db->select('*')->from('divisions')->order_by('id', 'desc')->get()->result();
            $data['benefitss'] = $this->db->select('*')->from('salary_addition')->get()->result();
//             $data['country_list'] = $this->Country_model->state();
            $data['shift'] = $this->db->get('shift')->result();
            $data['country_list'] = array('pakistan' => 'Pakistan');
            echo Modules::run('template/layout', $data);
        }
    }
    public function randID()
    {
        $result = "";
        $chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        $charArray = str_split($chars);
        for ($i = 0; $i < 7; $i++) {
            $randItem = array_rand($charArray);
            $result .= "" . $charArray[$randItem];
        }
        return "E" . $result;
    }
    // employee search
    public function employee_search()
    {
        $keyword = $this->input->post('what_you_search');
        $search_result = $this->Employees_model->employee_search($keyword);
        $data['emp_history'] = $search_result;
        $data['module'] = "employee";
        $data['page'] = "employee_view";
        echo Modules::run('template/layout', $data);
    }
    // Employee Salary Paid info
    public function EmployeePayment()
    {
        $sal_id = $this->input->post('sal_id');
        $employee_id = $this->input->post('employee_id');
        $emplyeeinfo = $this->db->select('first_name,last_name')->from('employee_history')->where('employee_id', $employee_id)->get()->row();
        $data = array(
            'employee_id' => $employee_id,
            'Ename' => $emplyeeinfo->first_name . $emplyeeinfo->last_name,
            'salP_id' => $sal_id,
        );
        echo json_encode($data);
    }
    // confirm payment
    public function payconfirm($id = null)
    {
        $this->form_validation->set_rules('paytype', display('payment_type'), 'required');
        if ($this->form_validation->run()) {
            $postData = [
                'emp_sal_pay_id' => $this->input->post('emp_sal_pay_id', true),
                'payment_due' => 'paid',
                'payment_date' => date('Y-m-d'),
                'payment_type' => $this->input->post('paytype'),
                'bank_name' => $this->input->post('bank_name'),
                'paid_by' => $this->session->userdata('fullname'),
            ];
            $emp_id = $this->input->post('employee_id', true);
            $c_name = $this->db->select('first_name,last_name')->from('employee_history')->where('employee_id', $emp_id)->get()->row();
            $c_acc = $emp_id . '-' . $c_name->first_name . $c_name->last_name;
            $coatransactionInfo = $this->db->select('HeadCode')->from('acc_coa')->where('HeadName', $c_acc)->get()->row();
            $COAID = $coatransactionInfo->HeadCode;
            $pay_type = $this->input->post('paytype');
            $bankname = $this->input->post('bank_name');
            $bankhead = $this->db->select('HeadCode')->from('acc_coa')->where('HeadName', $bankname)->get()->row()->HeadCode;
            $CashinHandDebit = array(
                'VNo' => $this->input->post('emp_sal_pay_id', true),
                'Vtype' => 'Salary',
                'VDate' => date('Y-m-d'),
                'COAID' => 1020101,
                'Narration' => 'Cash in hand Debit For Employee Id' . $this->input->post('employee_id', true),
                'Debit' => 0,
                'Credit' => intval(str_replace(',', '', $this->input->post('total_salary', true))),
                'IsPosted' => 1,
                'CreateBy' => $this->session->userdata('id'),
                'CreateDate' => date('Y-m-d H:i:s'),
                'IsAppove' => 1,
            );
            // Expense for salary payment
            $expense = array(
                'VNo' => $this->input->post('emp_sal_pay_id', true),
                'Vtype' => 'Salary',
                'VDate' => date('Y-m-d'),
                'COAID' => 401,
                'Narration' => 'salary payment for ' . $this->input->post('employee_id', true),
                'Debit' => intval(str_replace(',', '', $this->input->post('total_salary', true))),
                'Credit' => 0,
                'IsPosted' => 1,
                'CreateBy' => $this->session->userdata('id'),
                'CreateDate' => date('Y-m-d H:i:s'),
                'IsAppove' => 1,
            );
            // print_r($CashinHandDebit);exit();
            //ACC payable  Credit
            $accpayable = array(
                'VNo' => $this->input->post('emp_sal_pay_id', true),
                'Vtype' => 'Salary',
                'VDate' => date('Y-m-d'),
                'COAID' => $COAID,
                'Narration' => 'Salary For Employee Id' . $this->input->post('employee_id', true),
                'Debit' => intval(str_replace(',', '', $this->input->post('total_salary', true))),
                'Credit' => 0,
                'IsPosted' => 1,
                'CreateBy' => $this->session->userdata('id'),
                'CreateDate' => date('Y-m-d H:i:s'),
                'IsAppove' => 1,
            );
            $banktransaction = array(
                'VNo' => $this->input->post('emp_sal_pay_id', true),
                'Vtype' => 'Salary',
                'VDate' => date('Y-m-d'),
                'COAID' => $bankhead,
                'Narration' => 'Employee Salary Payment',
                'Debit' => 0,
                'Credit' => intval(str_replace(',', '', $this->input->post('total_salary', true))),
                'IsPosted' => 1,
                'CreateBy' => $this->session->userdata('id'),
                'CreateDate' => date('Y-m-d H:i:s'),
                'IsAppove' => 1,
            );
            if ($this->Employees_model->update_payment($postData)) {
                $this->db->insert('acc_transaction', $accpayable);
                $this->db->insert('acc_transaction', $expense);
                if ($pay_type == 1) {
                    $this->db->insert('acc_transaction', $CashinHandDebit);
                } else {
                    $this->db->insert('acc_transaction', $banktransaction);
                }
                // $this->session->set_flashdata('message', display('successfully_paid'));
                redirect('payroll/Payroll/payslip/' . $this->input->post('emp_sal_pay_id', true));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            $this->session->set_flashdata('exception', display('please_try_again'));
            redirect($_SERVER['HTTP_REFERER']);
        }
    }
    /*
    |------------------------------------------------------
    | Finger Print Device Information
    |--------------------------------------------------------
     */
    public function device_user()
    {
        $this->permission->module('employee', 'read')->redirect();
        $device_ip = $this->deviceData()->device_ip;
        $zk = new ZKLibrary($device_ip, 4370);
        // echo 'welcome';exit();
        $data['connect'] = $zk->connect();
        $data['disableDevice'] = $zk->disableDevice();
        $data['users'] = $zk->getUser();
        $data['enableDevice'] = $zk->enableDevice();
        $data['disconnect'] = $zk->disconnect();
        $data['module'] = "employee";
        $data['page'] = "device/userlist";
        echo Modules::run('template/layout', $data);
    }
    /*
    |--------------------------------------------------------
    | Finger print Device information
    |--------------------------------------------------------
     */
    public function deviceData()
    {
        return $this->db->select('*')->from('deviceinfo')->get()->row();
    }
    public function payslip()
    {
        $data['title'] = 'payslip';
        $data['module'] = "employee";
        $data['page'] = "payslip";
        echo Modules::run('template/layout', $data);
    }
    public function add_performance_review()
    {
        $this->form_validation->set_rules('EmployeeName', display('employee_id'), 'required|max_length[50]');
        if ($this->form_validation->run()) {
            $this->Employees_model->save_performance_review($_POST);
            //  echo "<pre>"; print_r($_POST); die;
            redirect("employee/Employees/manage_performance_review/");
        } else {
            $data['title'] = 'Add Employee Performance Review';
            $data['module'] = "employee";
            $data['page'] = "performance_review_add";
            $data['empl'] = $this->User_model->employee();
            echo Modules::run('template/layout', $data);
        }
    }
    public function manage_performance_review()
    {
        $data['title'] = 'Manage Employee Performance Review';
        $data['module'] = "employee";
        $data['page'] = "performance_review_manage";
        $data['empl'] = $this->User_model->employee();
        if (isset($_GET['employee_id']) && isset($_GET['year']) && !empty($_GET['employee_id']) && !empty($_GET['year'])) {
            $data['reviews'] = $this->Employees_model->list_performance_reviews($_GET);
        } else {
            $data['reviews'] = $this->Employees_model->list_performance_reviews();
        }
//         echo "<pre>"; print_r($data['reviews']); die;
        echo Modules::run('template/layout', $data);
    }
    public function getEmployeeData()
    {
        $data = array();
        if (!empty($_POST['employee_id'])) {
            $status = $this->Employees_model->employeeRecord($_POST['employee_id']);
            $data['status'] = true;
            $data['data'] = $status;
            $data['msg'] = "Success";
        } else {
            $data['status'] = true;
            $data['data'] = null;
            $data['msg'] = "Error";
        }
        echo json_encode($data);die;
    }
    public function draft_performance_review($id)
    {
        $this->form_validation->set_rules('EmployeeName', display('employee_id'), 'required|max_length[50]');
        if ($this->form_validation->run()) {
            $this->Employees_model->save_performance_review_draft($_POST, $id);
            redirect("employee/Employees/manage_performance_review/");
        } else {
            $data['title'] = 'Draft Employee Performance Review';
            $data['module'] = "employee";
            $data['page'] = "performance_review_draft";
            $data['empl'] = $this->User_model->employee();
            $data['behavior_objectives_joined'] = $this->Employees_model->behavior_objectives_joined($id);
            $data['employee_objectives'] = $this->Employees_model->employee_objectives($id);
            $data['employee_behaviors'] = $this->Employees_model->employee_behaviors($id);
            echo Modules::run('template/layout', $data);
        }
    }
    public function edit_performance_review($id)
    {
        $this->form_validation->set_rules('EmployeeName', display('employee_id'), 'required|max_length[50]');
        if ($this->form_validation->run()) {
            $this->Employees_model->save_performance_review_draft($_POST, $id);
            redirect("employee/Employees/manage_performance_review/");
        } else {
            $data['title'] = 'Edit Employee Performance Review';
            $data['module'] = "employee";
            $data['page'] = "performance_review_edit";
            $data['empl'] = $this->User_model->employee();
            $data['behavior_objectives_joined'] = $this->Employees_model->behavior_objectives_joined($id);
            $data['employee_objectives'] = $this->Employees_model->employee_objectives($id);
            $data['employee_behaviors'] = $this->Employees_model->employee_behaviors($id);
            echo Modules::run('template/layout', $data);
        }
    }
    public function add_360_reviews()
    {
        /*-----------------------------------*/
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'required|max_length[50]');
        $this->form_validation->set_rules('reviews', "Reviews", 'required');
        #------------------------#
        //         echo "<pre>"; print_r($sess); die;
        $sess = $this->session->userdata();
        if ($this->form_validation->run()) {
            $data['user'] = (object) $userLevelData = array(
                'reviews' => $this->input->post('reviews'),
                'reviewed_by' => $sess['id'],
                'reviewed_for' => $this->input->post('employee_id'),
                'created_at' => date("Y-m-d H:i:s", strtotime("now")),
                'created_by' => $sess['id'],
            );
            if ($this->Employees_model->reviews_360_create($userLevelData)) {
                $this->session->set_flashdata('message', display('save_successfully'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("employee/Employees/manage_360_reviews/");
        } else {
            $data['title'] = "Employee 360 Reviews";
            $data['empl'] = $this->User_model->employee();
            $data['module'] = "employee";
            $data['page'] = "reviews_360_add";
            echo Modules::run('template/layout', $data);
        }
    }
    public function manage_360_reviews()
    {
        $sess = $this->session->userdata();
        $data['title'] = 'Manage 360 Reviews';
        $data['userId'] = $sess['id'];
        $data['isAdmin'] = $sess['isAdmin'];
        if (isset($_GET['ReviewedBy']) && isset($_GET['ReviewedFor']) && !empty($_GET['ReviewedBy']) && !empty($_GET['ReviewedFor'])) {
            $data['reviews'] = $this->Employees_model->reviews_360_list($_GET);
        } else {
            if (isset($_GET['date_at']) && !empty($_GET['date_at'])) {
                $data['reviews'] = $this->Employees_model->reviews_360_list($_GET);
            } else {
                $data['reviews'] = $this->Employees_model->reviews_360_list();
            }
        }
//         $data['reviews']   = $this->Employees_model->reviews_360_list();
        $data['emplby'] = $this->User_model->dropdown(true);
        $data['emplfor'] = $this->User_model->employee();
        $data['module'] = "employee";
        $data['page'] = "reviews_360_manage";
        echo Modules::run('template/layout', $data);
    }
    public function edit_360_reviews($id)
    {
        /*-----------------------------------*/
        $this->form_validation->set_rules('employee_id', display('employee_id'), 'required|max_length[50]');
        $this->form_validation->set_rules('reviews', "Reviews", 'required');
        #------------------------#
        $sess = $this->session->userdata();
        if ($this->form_validation->run()) {
            $data['user'] = (object) $userLevelData = array(
                'reviews' => $this->input->post('reviews'),
                'reviewed_by' => $sess['id'],
                'reviewed_for' => $this->input->post('employee_id'),
                'updated_at' => date("Y-m-d H:i:s", strtotime("now")),
                'updated_by' => $sess['id'],
            );
            if ($this->Employees_model->reviews_360_update($userLevelData, $id)) {
                $this->session->set_flashdata('message', display('save_successfully'));
            } else {
                $this->session->set_flashdata('exception', display('please_try_again'));
            }
            redirect("employee/Employees/manage_360_reviews/");
        } else {
            $data['title'] = "Employee 360 Reviews";
            $data['empl'] = $this->User_model->employee();
            $data['detail'] = $this->Employees_model->reviews_360_get($id);
            $data['module'] = "employee";
            $data['page'] = "reviews_360_edit";
            echo Modules::run('template/layout', $data);
        }
    }
    public function delete_360_reviews($id)
    {
        $this->Employees_model->reviews_360_delete($id);
        $this->session->set_flashdata('message', display('save_successfully'));
        redirect("employee/Employees/manage_360_reviews/");
    }
    public function feedbackSubmission()
    {
        $data = array();
        $sess = $this->session->userdata();
        if ($_POST['feedback']) {
            $status = $this->Employees_model->feedbackSubmitting($_POST, $sess['id']);
            $data['status'] = true;
            $data['data'] = $_POST;
            $data['msg'] = "Success";
        } else {
            $data['status'] = true;
            $data['data'] = null;
            $data['msg'] = "Error";
        }
        echo json_encode($data);die;
        // redirect("employee/Employees/manage_performance_review/");
    }
    public function feedbackDetails()
    {
        $data = array();
        $sess = $this->session->userdata();
        if ($_POST['feedbackId']) {
            $status = $this->Employees_model->behavior_objectives_joined($_POST['feedbackId']);
            $data['status'] = true;
            $data['data'] = $status;
            $data['msg'] = "Success";
        } else {
            $data['status'] = true;
            $data['data'] = null;
            $data['msg'] = "Error";
        }
        echo json_encode($data);die;
    }
}
