<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Department_controller extends MX_Controller {

public function __construct()
	{
		parent::__construct();
		$this->db->query('SET SESSION sql_mode = ""');
		$this->load->model(array(
			'Department_model',
		));	
        if (! $this->session->userdata('isLogIn'))
            redirect('login?rback=' . uri_string());	 
	}

public function dept_view()
	{   
        $this->permission->method('department','read')->redirect();

		$data['title']    = display('department');  ;
		$data['mang']   = $this->Department_model->dept_view();
		$data['module']   = "department";
		$data['page']     = "department_view";   
		echo Modules::run('template/layout', $data); 
	}





public function create_dept()
    { 
        $data['title'] = display('department');
        #-------------------------------#
        $this->form_validation->set_rules('department_name',display('department_name'),'required|max_length[150]');
        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $postData = [
            'department_name'      => $this->input->post('department_name',true),                
            ];   

            if ($this->Department_model->dept_create($postData)) { 
                $this->session->set_flashdata('message', display('successfully_saved'));
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("department/Department_controller/create_dept");

        } else {
            $data['title']  = display('department');
            $data['module'] = "department";
            $data['mang'] = $this->Department_model->dept_view();
            $data['page']   = "dept_form";   
          echo Modules::run('template/layout', $data); 
        }   
    }

 public function delete_dept($id=null){
        $this->permission->module('department','delete')->redirect();
        if($this->Department_model->dept_delete($id)) {
            #set success message
            $this->session->set_flashdata('message',display('delete_successfully'));
        } else {
            #set exception message
            $this->session->set_flashdata('exception',display('please_try_again'));
        }
        redirect('department/Department_controller/dept_view');
    }

	public function update_dept_form($id = null)
    { 
       $this->form_validation->set_rules('dept_id',display('dept_id'));
        $this->form_validation->set_rules('department_name',display('department_name'),'required|max_length[150]');
       
        #-------------------------------#
        if ($this->form_validation->run() === true) {

            $Data = [    
            'dept_id'   =>$this->input->post('dept_id',true),
            
            'department_name' => $this->input->post('department_name',true),
            
            ];   

            if ($this->Department_model->update_dept($Data)) { 
                $this->session->set_flashdata('message', display('successfully_updated'));
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("department/Department_controller/dept_view");



        } else {
           $data['title']      = display('update');
            $data['data']      =$this->Department_model->dept_updateForm($id);
            $data['module']    = "department";    
            $data['page']      = "update_dept_form";   
            echo Modules::run('template/layout', $data);  
        }      
    }
  public function shift_management($id=null){
    $shift = $this->Department_model->shift_management_list($id);
    if(isset($id)){
      echo json_encode($shift);
    }else{
      $data['title']    = 'Shift Management';
      $data['shift']    = $shift;
      $data['module']   = "department";
      $data['page']     = "shift_management";
      echo Modules::run('template/layout', $data); 
    }
  }

 public function update_shift_management($id=null){
        $this->form_validation->CI =& $this;
        $this->form_validation->set_message('valid_shift_time', 'Invalid {field} Time');
        $this->form_validation->set_rules('name','Name'  ,'required');
        $this->form_validation->set_rules('flexible_shift','Shift Type'  ,'trim|required|is_natural');
        $post = $this->input->post();
        $post['flexible_shift'] = intval($post['flexible_shift']);
        if($post['flexible_shift'] > 0){
            $this->form_validation->set_rules('flexible_hours','Flexible Hours'  ,'trim|required|is_natural');            
        }else{
            $this->form_validation->set_rules('start','Shift Start'  ,'callback_valid_shift_time');
            $this->form_validation->set_rules('end','Shift End'  ,'callback_valid_shift_time');
        }
        $return = 0;
        if ($this->form_validation->run() === true) {
            $return = 1;
            $data['name'] = $post['name'];
            $post['flexible_shift'] = intval($post['flexible_shift']);
            if($post['flexible_shift'] > 0){
                $data['flexible_shift'] = 1;
                $data['flexible_hours'] = $post['flexible_hours'];
            }else{
                $data['start'] = $post['start'];
                $data['end'] = $post['end'];
            }
            if(isset($id)){
                $updateData = $this->db->where('id',$id)->update('shift',$data);
            }else{ 
                $updateData = $this->db->insert('shift',$data);
            }
            if($updateData && $return ==1){
                $this->session->set_flashdata('message', "Data Updated Successfully!");
            } else {
                $this->session->set_flashdata('exception',  display('please_try_again'));
            }
            redirect("/department/Department_controller/shift_management");

        }else{
            $this->shift_management();
        }
    }
    public function shift_delete($id){
        $this->db->where('id',$id)->delete('shift');   
        $this->session->set_flashdata('message', "Data Deleted Successfully!");
          redirect("/department/Department_controller/shift_management");
    }
    public function valid_shift_time($time)
    {
        if(!preg_match('/^\d{2}:\d{2}$/', $time)){
            return FALSE;
        }else{
            return TRUE;
        }
    }
}
