
<?php defined('BASEPATH') OR exit('No direct script access allowed');
class Evencal_model extends CI_Model {
	// for get all event date in one month
	function getDateEvent($year, $month){
		$year  = ($month < 10 && strlen($month) == 1) ? "$year-0$month" : "$year-$month";
		$query = $this->db->select('date_of_approve,sum(amount) as amount')->from('grand_loan')->like('date_of_approve', $year, 'after')->get();
		if($query->num_rows() > 0){
			$data = array();
			foreach($query->result_array() as $row){
				$ddata = explode('-',$row['date_of_approve']);
				$data[(int) end($ddata)] = [];
			}
			return $data;
		}else{
			return false;
		}
	}
	
	// get Attendance detail for selected date
	function getEvent($year, $month, $day){
		$day   = ($day < 10 && strlen($day) == 1)? "$day" : $day;
		$year  = ($month < 10 && strlen($month) == 1) ? "$year-$month-$day" : "$year-$month-$day";

		$admin = $this->session->userdata('isAdmin');
        
        $is_supervisor = $this->session->userdata('supervisor');
        
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');

		$this->db->select("count(DISTINCT(e.atten_his_id)) as att_id,count(DISTINCT(p.employee_id)) 	as employee_id,d.*");
		$this->db->from('attendance_history e');
		$this->db->join('employee_history p','e.uid = p.employee_id','left')->join('department d','d.dept_id = p.dept_id','left');


		if($admin != 1){
        
		    $employee_id = $this->session->userdata('employee_id');
					        
		    if($is_supervisor == 1){
				        
		        $this->db->where('p.super_visor_id',$employee_id);
					        
		        $this->db->or_where('p.employee_id',$employee_id);
					        
				$this->db->or_where('p.indirect_super_visor_id',$employee_id);
					        
			}else{
					        
				$this->db->where('p.employee_id',$employee_id);
					        
			}
					        
		}
		

		$query = $this->db->where(array("DATE(e.time)" => $year))->group_by('d.dept_id')->get();

		if($query->num_rows() > 0){
			return $query->result_array();
		}else{
			return null;
		}
	}
	//get Notice  detail for selected date
	function getNotice($year, $month, $day){
		$day   = ($day < 10 && strlen($day) == 1)? "0$day" : $day;
		$year  = ($month < 10 && strlen($month) == 1) ? "$year-0$month-$day" : "$year-$month-$day";
		 $this->db->select('notice_id as id,notice_type,notice_by');
				$this->db->from('notice_board');
				
				$this->db->where( array('notice_date' => $year));
		$query =		$this->db->order_by('notice_id')->get();
		if($query->num_rows() > 0){
			return $query->result_array();
		}else{
			return null;
		}
	}
//Leave details
	function getLeave($year, $month, $day){

		$admin = $this->session->userdata('isAdmin');
        
        $is_supervisor = $this->session->userdata('supervisor');
        
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');

		$day   = ($day < 10 && strlen($day) == 1)? "0$day" : $day;
		$year  = ($month < 10 && strlen($month) == 1) ? "$year-0$month-$day" : "$year-$month-$day";
		$this->db->select("count(DISTINCT(lf.leave_appl_id)) as leave_appl_id,lf.num_aprv_day,lf.leave_aprv_end_date,count(DISTINCT(p.employee_id)) as employee_id,p.first_name,p.last_name");
		$this->db->from('leave_apply lf');
		$this->db->join('employee_history p','lf.employee_id = p.employee_id','left');




		if($admin != 1){
        
		    $employee_id = $this->session->userdata('employee_id');
					        
		    if($is_supervisor == 1){
				        
		        $this->db->where('p.super_visor_id',$employee_id);
					        
		        $this->db->or_where('p.employee_id',$employee_id);
					        
				$this->db->or_where('p.indirect_super_visor_id',$employee_id);
					        
			}else{
					        
				$this->db->where('p.employee_id',$employee_id);
					        
			}
					        
		}

		$this->db->where('lf.leave_aprv_strt_date <=',$year);
		$this->db->where('lf.leave_aprv_end_date >=',$year);
		$query =$this->db->group_by('p.employee_id')->get();
		if($query->num_rows() > 0){
			return $query->result_array();
		}else{
			return null;
		}
	}
	//Total leave Today
	function leave_employee(){

		$year  = date('Y-m-d');

		$admin = $this->session->userdata('isAdmin');
        
        $is_supervisor = $this->session->userdata('supervisor');
        
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');

		$this->db->select("count(leave_apply.employee_id) as leave_total");

		$this->db->from('leave_apply')->where('leave_apply.leave_aprv_strt_date <=',$year);

		$this->db->join('employee_history as eh','eh.employee_id = leave_apply.employee_id');

		if($admin != 1){
        
		    $employee_id = $this->session->userdata('employee_id');
					        
		    if($is_supervisor == 1){
				        
		        $this->db->where('eh.super_visor_id',$employee_id);
					        
		        $this->db->or_where('eh.employee_id',$employee_id);
					        
				$this->db->or_where('eh.indirect_super_visor_id',$employee_id);
					        
			}else{
					        
				$this->db->where('eh.employee_id',$employee_id);
					        
			}
					        
		}

		$this->db->where('leave_aprv_end_date >=',$year);

		$query = $this->db->get();

		if($query->num_rows() > 0){

			return $query->row();
		
		}else{
		
			return null;
		
		}
	}
//loan details
	function getLoan($year, $month, $day){
		$day   = ($day < 10 && strlen($day) == 1)? "0$day" : $day;
		$year  = ($month < 10 && strlen($month) == 1) ? "$year-0$month-$day" : "$year-$month-$day";
		

		$admin = $this->session->userdata('isAdmin');
        
        $is_supervisor = $this->session->userdata('supervisor');
        
        $direct_supervisor = $this->session->userdata('direct_supervisor');
        
        $indirect_supervisor = $this->session->userdata('indirect_supervisor');


	$this->db->select("count(DISTINCT(ln.loan_id)) as loan_id,ln.amount,ln.loan_details,count(DISTINCT(p.employee_id)) as employee_id,p.first_name,p.last_name");
		$this->db->from('grand_loan ln');
		
		$this->db->join('employee_history p','ln.employee_id = p.employee_id','left');
		

		if($admin != 1){
        
		    $employee_id = $this->session->userdata('employee_id');
					        
		    if($is_supervisor == 1){
				        
		        $this->db->where('p.super_visor_id',$employee_id);
					        
		        $this->db->or_where('p.employee_id',$employee_id);
					        
				$this->db->or_where('p.indirect_super_visor_id',$employee_id);
					        
			}else{
					        
				$this->db->where('p.employee_id',$employee_id);
					        
			}
					        
		}


		$this->db->where(array("ln.date_of_approve" => $year));

		$query = 	$this->db->group_by('p.employee_id')->get();
		if($query->num_rows() > 0){
			return $query->result_array();
		}else{
			return null;
		}
	}

	 public function details($id)
    {
         return $this->db->select('*')	
			->from('notice_board')
			 ->where('notice_id',$id)
			->get()
			->result();
    }
	
}