<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bank extends MX_Controller {

public function __construct()
	{
		parent::__construct();
		 $this->db->query('SET SESSION sql_mode = ""');
		$this->load->model(array(
			'Bank_model'
		));	
		if (! $this->session->userdata('isLogIn'))
			redirect('login?rback=' . uri_string());	 
	}

public function bank_list(){   
		$data['title']    = display('bank_list');  ;
		$data['banks']     = $this->Bank_model->bank_list();
		$data['module']   = "bank";
		$data['page']     = "bank_list";   
		echo Modules::run('template/layout', $data); 
	} 

public function create_bank($id = null){ 
  $data['title'] = display('add_bank');
  #-------------------------------#
  $this->form_validation->set_rules('bank_name', display('bank_name')  ,'required|max_length[250]');
  $this->form_validation->set_rules('account_number', display('account_number')  ,'required|max_length[100]');
  #-------------------------------#
   $data['bank']   = (Object) $postData = [
   'id'             => $this->input->post('id'), 
   'bank_name'      => $this->input->post('bank_name'),
   'account_name'   => $this->input->post('account_name'),
   'account_number' => $this->input->post('account_number'),
   'branch_name'    => $this->input->post('branch_name'),
  ];


  if ($this->form_validation->run()) { 

   if (empty($postData['id'])) {
    if ($this->Bank_model->create_bank($postData)) { 
     
     $coa = $this->Bank_model->headcode();
			if($coa->HeadCode!=NULL){
				$headcode=$coa->HeadCode+1;
			}else{
				$headcode="10201020001";
			}

			$headname = $this->input->post('bank_name');
			$createby = $this->session->userdata('fullname');
			$createdate = date('Y-m-d H:i:s');
			$data['aco']  = (Object) $coaData = [
				'HeadCode'         => $headcode,
				'HeadName'         => $headname,
				'PHeadName'        => 'Cash At Bank',
				'HeadLevel'        => '4',
				'IsActive'         => '1',
				'IsTransaction'    => '1',
				'IsGL'             => '0',
				'HeadType'         => 'A',
				'IsBudget'         => '0',
				'IsDepreciation'   => '0',
				'DepreciationRate' => '0',
				'CreateBy'         => $createby,
				'CreateDate'       => $createdate,
			];
			$this->Bank_model->create_coa($coaData);

	$this->session->set_flashdata('message', display('save_successfully'));

     redirect('bank/Bank/bank_list');
    } else {
     $this->session->set_flashdata('exception',  display('please_try_again'));
    }
    redirect("bank/Bank/create_bank"); 

   } else {
    if ($this->Bank_model->update($postData)) { 
    	$upcoa = array(
    	'old_head' => $this->input->post('oldname'),
        'HeadName' => $this->input->post('bank_name'),
    	);
    $this->Bank_model->update_coa($upcoa);
     $this->session->set_flashdata('message', display('update_successfully'));
    } else {
     $this->session->set_flashdata('exception',  display('please_try_again'));
    }
    redirect("bank/Bank/create_bank/".$postData['id']);  
   }

  } else { 
   if(!empty($id)) {
    $data['title']    = display('update_bank');
    $data['bankinfo'] = $this->Bank_model->findById($id);
   }
   $data['module'] = "bank";
   $data['page']   = "add_bank"; 
   echo Modules::run('template/layout', $data); 
   }  
}
public function delete_bank($id = null){ 
		if ($this->Bank_model->delete($id)) {
			#set success message
			$this->session->set_flashdata('message',display('delete_successfully'));
		} else {
			#set exception message
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect("bank/Bank/bank_list");
	}


public function bank_deposit(){
		$data['title']     = "Bank Deposit";
        $data['module']    = "bank";
        $data['page']      = "bank_deposit";
        $data['result']    = $this->db->select('bank_deposits.*,
        										bank_information.bank_name name')
        							  ->join('bank_information','bank_information.id=bank_deposits.bank_id')
        							  ->get('bank_deposits')
        							  ->result();
        $data['banks'] = $this->db->get('bank_information')->result();
        echo Modules::run('template/layout',$data);
}

public function update_bank_deposit($id=null){
    $this->form_validation->set_rules('deposit_type', display('deposit_type')  ,'required');
    $this->form_validation->set_rules('bank_id', display('bank_id')  ,'required');
    $this->form_validation->set_rules('amount', display('amount')  ,'required');
    if ($this->form_validation->run()) { 
    	$post = $this->input->post();

    	$data['bank_id'] = $post['bank_id'];
		$data['amount'] = $post['amount'];
		$bank_balance = $this->db->select('bank_deposits.*,bank_information.balance as balance')
								 ->join('bank_deposits','bank_deposits.bank_id=bank_information.id')
								 ->where('bank_information.id',$data['bank_id'])
								 ->get('bank_information')
								 ->first_row();
		if(isset($id)){
			// $current_balance = $current_balance + $old_amount - $new_amount;
			if($bank_balance->transactionType == 'withdraw'){
				$balance = $bank_balance->balance + $post['old_amount'] - $post['amount'];
			}
			elseif($bank_balance->transactionType == 'deposit'){
				$balance = $bank_balance->balance - $post['old_amount'] + $post['amount'];
			}
			$updateBalance = $this->db->where('id',$data['bank_id'])
			->update('bank_information',['balance'=>$balance]);
			$updateData = $this->db->where('id',$id)->update('bank_deposits',$data);
		}
		else
		{
			$data['transactionType'] = $post['deposit_type'];
			$data['created_date']= date('Y-m-d');
			if($data['transactionType'] == 'withdraw'){
				// if($bank_balance->balance <0){
				// 	$balance = $bank_balance->balance - (-$data['amount']);	
				// }else{
					$balance = $bank_balance->balance - $data['amount'];
				// }
			}
			elseif($data['transactionType'] == 'deposit'){
				$balance = $bank_balance->balance + $data['amount'];
			}
			$updateData = $this->db->insert('bank_deposits',$data);
			$updateBalance = $this->db->where('id',$data['bank_id'])
									  ->update('bank_information',['balance'=>$balance]);
		}
		
		if($updateData){
			$this->session->set_flashdata('message','Data Updated Successfully!');
		}else{
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect("bank/Bank/bank_deposit");
	}
}

public function getBankDeposit(){
	$post = $this->input->post();
	$id = $post['id'];

	$result = $this->db->where('id',$id)->get('bank_deposits')->result();
	if($result){
		echo json_encode($result);	
	}else{
		echo json_encode(['error'=>'return 0']);
	}
}

public function delete_bank_deposit($id){
        $internal_account = $this->db->select('bank_deposits.*,bank_information.balance as balance')
								 ->join('bank_deposits','bank_deposits.bank_id=bank_information.id')
								 ->where('bank_deposits.id',$id)
								 ->get('bank_information')
								 ->first_row();

      $update_current_balance = 0;
      $current_balance = $internal_account->balance;
      if($internal_account->transactionType == 'withdraw'){
          if($current_balance < 0){
            $update_current_balance = ( $internal_account->amount - ( - $current_balance ) );  

          }else{
            if($deleteParameter){
              $update_current_balance = $current_balance + $internal_account->amount;  
            }else{
              $update_current_balance = $current_balance - $internal_account->amount;  
            }
            
          }
      }
      if($internal_account->transactionType == 'deposit'){
        if($deleteParameter){
          $update_current_balance = $current_balance - $internal_account->amount;
        }else{
          $update_current_balance = $current_balance + $internal_account->amount;
        }
      }

        $updateBalance = $this->db->where('id',$internal_account->bank_id)
									  	->update('bank_information',['balance'=>$update_current_balance]);

		$updateData = $this->db->where('id',$id)
			->delete('bank_deposits');
		if($updateData){
			$this->session->set_flashdata('message','Data Updated Successfully!');
		}else{
			$this->session->set_flashdata('exception',display('please_try_again'));
		}
		redirect("bank/Bank/bank_deposit");
}

public function bank_transfer(){
		$data['title']     = "Bank Transfer";
        $data['module']    = "bank";
        $data['page']      = "bank_transfer";
        $data['result']    = $this->db->query("SELECT
												bank_transfer.id AS id,
												  (SELECT
												    bank_name
												  FROM
												    bank_information
												  WHERE id = bank_transfer.`from_bank`) AS from_bank,
												   (SELECT
												    bank_name
												  FROM
												    bank_information
												  WHERE id = bank_transfer.`to_bank`) AS to_bank,
												  bank_transfer.amount AS transfer_amount,
												  bank_transfer.created_date as date
												FROM
												  bank_transfer")
        							  ->result();
        $data['banks'] = $this->db->get('bank_information')->result();
        echo Modules::run('template/layout',$data);
}

public function update_bank_transfer(){
	$this->form_validation->set_rules('from_bank', 'From Bank'  ,'required');
    $this->form_validation->set_rules('to_bank', 'To Bank'  ,'required');
    $this->form_validation->set_rules('amount', display('amount')  ,'required');
    if ($this->form_validation->run()) { 
    	$post = $this->input->post();
    	$data['from_bank'] = $post['from_bank'];
    	$data['to_bank']   = $post['to_bank'];
    	$data['amount']    = $post['amount'];
    	$data['created_date']    = date('Y-m-d');
    	$checkAmountAndBankBalance = $this->db->where('id',$post['from_bank'])->get('bank_information')->first_row();
    	if($checkAmountAndBankBalance->balance>=$data['amount']){
    	    $update_balance = $checkAmountAndBankBalance->balance - $data['amount'];
    		$data_insert = $this->db->insert('bank_transfer',$data);
    		$this->db->where('id',$data['from_bank'])->update('bank_information',['balance'=>$update_balance]);
            $checkAmountAndToBankBalance = $this->db->where('id',$post['to_bank'])->get('bank_information')->first_row();
            $update_to_balance = $checkAmountAndToBankBalance->balance + $data['amount'];
            $this->db->where('id',$data['to_bank'])->update('bank_information',['balance'=>$update_to_balance]);
    		$this->session->set_flashdata('message','Data Updated Successfully!');
    	    redirect("bank/Bank/bank_transfer");
    	}else{
    		$this->session->set_flashdata('exception','Amount must be less then or equal to from bank balance');
    	    redirect("bank/Bank/bank_transfer");
    	}
    }	
}

public function getBankBalance(){
    $id = $this->input->post('id');
    $result = $this->db->select('balance')
                   ->from('bank_information')
                   ->where('id',$id)
                   ->get()->first_row();
    echo json_encode($result);
}
}

