<div class="panel panel-default thumbnail">
    <div class="panel-body" id="result_data">
        <table class="table table-striped table-bordered table-hover" width="100%">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Name</th>
                    <th>In Time</th>
                    <th>Out Time</th>
                    <th>Reason</th>
                    <th>Supervisor</th>
                    <th>HR</th>
                    <th>Status</th>
                    <th>Submitted</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($all_requests as $request) :?>
                <?php
                    $status = '';
                    if($request['supervisor'] && $request['hr_status'] == 'pending' && $request['supervisor_status'] == 'pending'){
                        $status = 'Awaiting Supervisor Response';
                    }elseif($request['hr_status'] == 'pending' && $request['supervisor_status'] == 'approved'){
                        $status = 'Approved By Supervisor';
                    }elseif($request['hr_status'] == 'pending' && $request['supervisor_status'] == 'denied'){
                        $status = 'Denied By Supervisor';
                    }elseif($request['hr_status'] == 'pending' && $request['supervisor_status'] == 'approved'){
                        $status = 'Approved By Supervisor';
                    }elseif(!$request['supervisor'] && $request['hr_status'] == 'pending'){
                        $status = 'Awaiting HR Response';
                    }elseif($request['hr_status'] == 'approved'){
                        $status = 'Approved By HR';
                    }elseif($request['hr_status'] == 'denied'){
                        $status = 'Denied By HR';
                    }
                ?>
                    <tr>
                        <td><?= $request['id'] ?></td>
                        <td><?= $request['employee_name'] ?></td>
                        <td><?= formatted_date($request['checkin'], true) ?></td>
                        <td><?= formatted_date($request['checkout'], true) ?></td>
                        <td><?= $request['reason'] ?></td>
                        <td><?= $request['supervisor_name'] ?></td>
                        <td><?= $request['hr_name'] ?></td>
                        <td><?= $status ?></td>
                        <td><?= formatted_date($request['added_at'], true) ?></td>
                        <td>
                            <form method="POST" action="<?= base_url() ?>attendance/timeadjustment/process">                            
                            <input type="hidden" name="id" value="<?= $request['id'] ?>">                            
                            <?php
                                if($this->session->userdata('isAdmin') && $request['hr_status'] == 'pending'){
                                    echo '<button type="submit" class="btn btn-success btn-sm" name="process" value="approve">Approve</button>';
                                    echo '<button type="submit" class="btn btn-danger btn-sm" name="process" value="reject">Reject</button>';
                                }elseif($request['supervisor'] == $this->session->userdata('employee_id') && $request['supervisor_status'] == 'pending' && $request['hr_status'] == 'pending'){                                    
                                    echo '<button type="submit" class="btn btn-success btn-sm" name="process" value="approve">Approve</button>';
                                    echo '<button type="submit" class="btn btn-danger btn-sm" name="process" value="reject">Reject</button>';
                                }elseif($this->permission->method('atn_time_adjustment_list', 'update')->access() && $request['hr_status'] == 'pending' && $request['employee_id'] != $this->session->userdata('employee_id')){
                                    echo '<button type="submit" class="btn btn-success btn-sm" name="process" value="approve">Approve</button>';
                                    echo '<button type="submit" class="btn btn-danger btn-sm" name="process" value="reject">Reject</button>';
                                }
                            ?>
                            </form>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<script>
    $(document).ready(function () {
        $('.table').dataTable({
        "order": [[ 8, "desc" ]]
    });
    });
</script>